--- r.invr.lua
-- ma: generated from json
-- @module func

local func = {}
local script = {}
local Tama_tuote_on_merkitty_kaytosta_poistetuksi = require "Tama_tuote_on_merkitty_kaytosta_poistetuksi"
local Talle_tuotteelle_on_merkitty_erilainen_ARV   = require "Talle_tuotteelle_on_merkitty_erilainen_ARV  "

function func.invr_ALEPROSENTTI(r)
  invr_C_RIVISUMMAT(r.json_data.invr_discount_percentage)
end

function func.invr_sAHINTA(r)
  invr_C_RIVISUMMAT(invr_price_unit())
end

function func.invr_ALEMARKKAA(r)
  if "invr_price_unit" * r.json_data.invr_delivered_quantity ~= 0 then
    r.json_data.invr_discount_percentage = r.invr_discount_amount / "invr_price_unit" * r.json_data.invr_delivered_quantity * "100"
  else
    r.json_data.invr_discount_percentage = 0
  end
  invr_C_RIVISUMMAT(r.invr_discount_amount)
end

function func.invr_sLVV_PROSENTT(r)
  r.json_data.invr_price_total = "invr_price_unit" * r.json_data.invr_delivered_quantity
  if r.invr_product_id ~= "" then
    RELATE_ONE(r.pr_sales_order_code_id)
    if r.json_data.invr_vat_percentage ~= r.ordc_vat_percentage then
      CONFIRM(Talle_tuotteelle_on_merkitty_erilainen_ARV . Halutko_todella_vaihtaa_sen?())
      if "OK" == 1 then
        r.json_data.invr_vat_price = r.json_data.invr_vat_percentage * r.json_data.invr_price_total / "100"
      end
    end
  end
  r.inv_price_with_vat = r.inv_price_with_vat - r.json_data.invr_vat_price - r.json_data.invr_price_total
  in_ALARIVIN_KENT()
end

function func.invr_KPL_MAARA(r)
  if !aaOptionKey() then
    RELATE_ONE(r.invr_product_id)
    if r.json_data.pr_effect_of_fixed_size == 1 then
      r.json_data.invr_delivered_quantity = r.json_data.invr_dimension * r.json_data.invr_unit_total
      invr_sMAARA_YHT ----<>()
    end
  end
end

function func.invr_sMAKSETTAVA_Y(r)
  r.json_data.invr_price_total = _real_TaxRemove(r.json_data.invr_total_amount, r.json_data.invr_vat_percentage)
  if "pr_sales_price_unit" == 0 then
    if r.json_data.invr_delivered_quantity == 0 then
      r.json_data.invr_delivered_quantity = 1
    end
    local invr_price_unit = r.json_data.invr_price_total / r.json_data.invr_delivered_quantity
  end
  if g.so_fAleYksHi then
    if r.json_data.invr_delivered_quantity ~= 0 then
      local invr_price_unit = r.json_data.invr_price_total / r.json_data.invr_delivered_quantity
      r.invr_discount_amount = 0
    else
      local invr_price_unit = 0
      r.invr_discount_amount = 0
    end
  else
    r.invr_discount_amount = invr_price_unit * r.json_data.invr_delivered_quantity - r.json_data.invr_price_total
  end
  if invr_price_unit * r.json_data.invr_delivered_quantity ~= 0 then
    r.json_data.invr_discount_percentage = (r.invr_discount_amount / invr_price_unit * r.json_data.invr_delivered_quantity) * "100"
  else
    r.json_data.invr_discount_percentage = 0
  end
  invr_C_RIVISUMMAT(r.json_data.invr_total_amount)
end

function func.invr_scMYYNTIKOODI(r)
  RELATE_ONE(r.json_data.invr_sales_order_code_id)
  r.json_data.invr_vat_percentage = r.ordc_vat_percentage
  xpRealFile(r.inv)
  invr_C_RIVISUMMAT(r.json_data.invr_sales_order_code_id)
end

function func.invr_sLVV_N_HINTA(r)
  r.json_data.invr_vat_percentage = r.json_data.invr_vat_price * "100" / r.json_data.invr_price_total
end

function func.invr_sTUOTE(r)
  if pr_fValilis() then
    local pr_fValilis = false
    local xpRealFile = r.inv
    r.invr_product_id = pr_tunnus()
    RELATE_ONE(r.invr_product_id)
  end
  if r.json_data.pr_not_in_use then
    xCRY(Tama_tuote_on_merkitty_kaytosta_poistetuksi.())
  end
  r.json_data.invr_no_printing = r.json_data.pr_no_printing
  r.invr_unit = r.pr_unit
  local invr_cost_price_unit = pr_cost_price_unit()
  if r.co_company_id ~= r.inv_company_id then
    RELATE_ONE(r.inv_company_id)
  end
  if r.json_data.pr_no_discount then
    r.json_data.invr_discount_percentage = 0
  else
    r.json_data.invr_discount_percentage = r.json_data.co_row_discount_percentage
  end
  if r.co_sales_order_code_id ~= "" then
    r.json_data.invr_sales_order_code_id = r.co_sales_order_code_id
  elseif r.json_data.co_foreign_company then
    r.json_data.invr_sales_order_code_id = r.pr_foreign_sales_order_code_id
  else
    r.json_data.invr_sales_order_code_id = r.pr_sales_order_code_id
  end
  r.json_data.invr_sales_order_code_id = soc__NewCodeGet(r.json_data.invr_sales_order_code_id, inv_date)
  r.json_data.invr_purchase_order_code_id = poc__NewCodeGet(r.pr_purchase_order_code_id, inv_date)
  if r.ordc_order_code_id ~= r.json_data.invr_sales_order_code_id then
    RELATE_ONE(r.json_data.invr_sales_order_code_id)
  end
  r.json_data.invr_vat_percentage = r.ordc_vat_percentage
  if r.co_language ~= "" and g.gfKielinimi then
    QUERY(r.prla(r.json_data.prna_product_name_id, "=", r.invr_product_id)
    -- *** error in file 'invr.json': funtion call has more parameters than 1 array, '["prna",["prna_product_name_id","=",["invr_product_id"]],"*"]' ***
)
    QUERY(r.prla, "&",     r.prla_language = r.co_language)
    if Records_in_selection(r.prla) > 0 then
      r.json_data.invr_explanation = r.prla_name
      r.invr_unit = r.prla_unit
    else
      QUERY(r.prla(r.json_data.prna_product_name_id, "=", r.invr_product_id)
      -- *** error in file 'invr.json': funtion call has more parameters than 1 array, '["prna",["prna_product_name_id","=",["invr_product_id"]],"*"]' ***
)
      QUERY(r.prla, "&",       r.prla_language = Englanti)
      if Records_in_selection(r.prla) > 0 then
        r.json_data.invr_explanation = r.prla_name
        r.invr_unit = r.prla_unit
      else
        r.json_data.invr_explanation = r.pr_name
      end
    end
  else
    r.json_data.invr_explanation = r.pr_name
  end
  if g.pr_lSeliKopi == 1 then
    if r.json_data.invr_explanation ~= "" then
      r.json_data.invr_explanation = concat(r.json_data.invr_explanation, "\n")
    end
    r.json_data.invr_explanation = concat(r.json_data.invr_explanation, r.json_data.pr_explanation)
  elseif g.pr_lSeliKopi == 2 then
    r.json_data.invr_explanation = r.json_data.pr_explanation
  end
  invr_L_AHINTA(1)
  invr_C_RIVISUMMAT(r.invr_product_id)
end

function func.invr_sHINTA_YHT(r)
  if g.so_fAleYksHi then
    if r.json_data.invr_delivered_quantity ~= 0 then
      local invr_price_unit = r.json_data.invr_price_total / r.json_data.invr_delivered_quantity
      r.invr_discount_amount = 0
    else
      local invr_price_unit = 0
      r.invr_discount_amount = 0
    end
  else
    r.invr_discount_amount = invr_price_unit * r.json_data.invr_delivered_quantity - r.json_data.invr_price_total
  end
  if invr_price_unit * r.json_data.invr_delivered_quantity ~= 0 then
    r.json_data.invr_discount_percentage = (r.invr_discount_amount / invr_price_unit * r.json_data.invr_delivered_quantity) * "100"
  else
    r.json_data.invr_discount_percentage = 0
  end
  invr_C_RIVISUMMAT(r.json_data.invr_price_total)
end

function func.invr_sMAARA_YHT(r)
  invr_L_AHINTA(2)
  invr_C_RIVISUMMAT(r.json_data.invr_delivered_quantity)
  if !aaOptionKey() then
    stpa_S_KPL_MITTA(r.invr_product_id, r.json_data.invr_dimension, r.json_data.invr_unit_total, r.json_data.invr_delivered_quantity, r.json_data.invr_delivered_quantity)
  end
end



function script.r.json_data.invr_dimension(r)
  if "_fi_InFullpage" == true then
    invr_KPL_MAARA()
  end
end

function script.invr_price_unit(r)
  invr_sAHINTA()
end

function script.r.json_data.invr_total_amount(r)
  invr_sMAKSETTAVA_Y()
end

function script.r.json_data.invr_employee_id(r)
  local invr_myyja = r.json_data.invr_employee_id
end

function script.new_record(r)
  r.invr_invoice_id = r.inv_invoice_id
  r.invr_row_number = Max(r.invr_row_number) + 1
  r.json_data.invr_customer_row_number = String(r.invr_row_number, "000")
  r.json_data.invr_employee_id = inv_myyja
  r.json_data.invr_delivered_quantity = 1
  r.json_data.invr_order_amount = r.json_data.invr_delivered_quantity
  r.json_data.invr_delivery_date = Current_date(*())
  local invr_type = inv_type
  r.json_data.invr_delivery_customer = r.inv_delivery_company_id
end

function script.r.json_data.invr_unit_total(r)
  if "_fi_InFullpage" == true then
    invr_KPL_MAARA()
  end
end

function script.r.json_data.invr_vat_percentage(r)
  invr_sLVV_PROSENTT()
end

function script.r.json_data.invr_sales_order_code_id(r)
  invr_scMYYNTIKOODI()
end

function script.r.json_data.invr_price_total(r)
  invr_sHINTA_YHT()
end

function script.r.invr_discount_amount(r)
  invr_ALEMARKKAA()
end

function script.r.json_data.invr_discount_percentage(r)
  invr_ALEPROSENTTI()
end

function script.r.json_data.invr_delivered_quantity(r)
  invr_sMAARA_YHT()
end

function script.r.json_data.invr_vat_price(r)
  invr_sLVV_N_HINTA()
end

function script.r.invr_product_id(r)
  invr_sTUOTE()
end

-- end: r.invr.lua