--- r.invp.lua
-- ma: generated from json
-- @module func

local func = {}
local script = {}
local Viitenumeroa_vastaavaa_laskua_ei_loytynyt = require "Viitenumeroa_vastaavaa_laskua_ei_loytynyt"
local Laskun_tulossa_oleva_summa_on_nolla = require "Laskun_tulossa_oleva_summa_on_nolla"
local Tulopaiva_ei_voi_olla_pienempi_kuin_maksupaiva = require "Tulopaiva_ei_voi_olla_pienempi_kuin_maksupaiva"

function func.inpa_scMAKSUPAIVA(r)
  if r.json_data.inpa_arrival_date < r.invp_payment_date then
    r.json_data.inpa_arrival_date = r.invp_payment_date
  end
  if r.invp_payment_date > r.inv_due_date then
    r.invp_days_late = r.invp_payment_date - r.inv_due_date
    inpa_KORKO_YHT()
  else
    r.invp_days_late = 0
    r.json_data.inpa_interest_total = 0
  end
end

function func.inpa_scLASKU(r)
  r.json_data.inpa_reference_number = r.inv_reference_number
  r.json_data.inpa_customer = r.inv_company_id
  r.invp_currency_id = r.inv_currency_id
  r.json_data.inpa_firm_id = r.json_data.inv_firm_id
  inpa_sYRITYS()
  RELATE_ONE(r.inv_currency_id)
  r.invp_exchange_rate = r.json_data.cur_selling_rate
  RELATE_ONE(r.inv_company_id)
  if r.json_data.inv_coming_total ~= 0 then
    if r.json_data.inpa_payment == 0 then
      r.json_data.inpa_payment = r.json_data.inv_coming_total
      if r.invp_payment_date > r.inv_due_date then
        r.invp_days_late = r.invp_payment_date - r.inv_due_date
        inpa_KORKO_YHT()
      else
        r.invp_days_late = 0
        r.json_data.inpa_interest_total = 0
      end
    end
    local inpa_rSuoritus = r.json_data.inpa_decrement_sum + r.json_data.inpa_payment
    inpa_C_CURRENCY ----<>()
  else
    xCRY(Laskun_tulossa_oleva_summa_on_nolla.())
  end
end

function func.inpa_scMAKSETTU_SU(r)
  inpa_scKURSSI()
  if r.inv_exchange_rate == r.invp_exchange_rate then
    RELATE_ONE(r.inv_terms_of_payment_id)
    if r.top_discount_days > 0 then
      if Round("inpa_rKassaPro", 1) == r.top_discount_percentage then
        local inpa_asVahLyh = Find_in_array("inpa_asVahLyh", "KA")
        local inpa_asVahTek = inpa_asVahLyh
        r.json_data.inpa_decrement_type = KA
      end
    end
  end
  local inpa_rSuoritus = r.json_data.inpa_decrement_sum + r.json_data.inpa_payment
  inpa_C_CURRENCY ----<>()
  inpa_KORKO_YHT()
end

function func.inpa_scKURSSI(r)
  if r.inv_exchange_rate ~= r.invp_exchange_rate then
    if r.invp_exchange_rate ~= 0 then
      local _r = r.json_data.inpa_payment / r.invp_exchange_rate * r.inv_exchange_rate
    else
      local _r = r.json_data.inpa_payment
    end
    r.json_data.inpa_decrement_sum = Round((_r - r.json_data.inpa_payment), 2)
    local inpa_asVahLyh = Find_in_array(inpa_asVahLyh, "KE")
    local inpa_asVahTek = inpa_asVahLyh
    if inpa_asVahLyh > 0 then
      r.json_data.inpa_decrement_type = KE
    end
  else
    if !inpa_is_partial_payment() then
      if r.inv_exchange_rate ~= 0 then
        local _r = cur_C_Currency(true, 1, r.inv_exchange_rate, "cur__DefaultCurre", r.json_data.inv_coming_total, r.inv_currency_id)
        local _r = cur_C_Currency(true, r.invp_exchange_rate, 1, r.inv_currency_id, _r, "cur__DefaultCurre")
        r.json_data.inpa_decrement_sum = _r - r.json_data.inpa_payment
        if false then
          r.json_data.inpa_decrement_sum = Round(((r.json_data.inv_coming_total / r.inv_exchange_rate) * r.invp_exchange_rate - r.json_data.inpa_payment), 2)
        end
else
        r.json_data.inpa_decrement_sum = Round((r.json_data.inv_coming_total - r.json_data.inpa_payment), 2)
      end
    else
      r.json_data.inpa_decrement_sum = 0
    end
  end
  if r.json_data.inpa_decrement_sum + r.json_data.inpa_payment ~= 0 then
    local inpa_rKassaPro = r.json_data.inpa_decrement_sum / (r.json_data.inpa_decrement_sum + r.json_data.inpa_payment) * "100"
  else
    local inpa_rKassaPro = 0
  end
end

function func.inpa_scVIITENUMERO(r)
  if r.inv_reference_number ~= r.json_data.inpa_reference_number then
    QUERY(r.inv(r.inv_reference_number, "=", r.json_data.inpa_reference_number))
    if Records_in_selection(r.inv) > 0 then
      r.invp_invoice_id = r.inv_invoice_id
      inpa_scLASKU()
    else
      r.invp_invoice_id = 
      RELATE_ONE(r.invp_invoice_id)
      RELATE_ONE(r.inv_company_id)
      xCRY(Viitenumeroa_vastaavaa_laskua_ei_loytynyt.())
      GOTO_OBJECT(r.json_data.inpa_reference_number)
    end
  end
end

function func.inpa_scSUORITUSTIL(r)
  local _inpa_lFound = Find_in_array("inpa_asSuorta", r.ac_name)
  if _inpa_lFound > 0 then
    local inpa_asSuorta = _inpa_lFound
    r.json_data.inpa_method_of_payment = Substring(r.ac_name, 1, "25")
  else
    _err_MESSAGE(concat(_lang_Current(Can't_find_value_from_popup()), ":", "ksSpace", _fld_Name(r.json_data.inpa_method_of_payment), "inpa_scSUORITUSTIL", false))
  end
end

function func.inpa_scSUORITUSTAP(r)
  _pop_FLD(0, r.json_data.inpa_method_of_payment, 0)
  local _inpa_lFound = _qry_Fld(0,   r.ac_name = inpa_asSuorta[inpa_asSuorta](), "", false)
  if _inpa_lFound < 1 then
    r.invp_account_id = 
    _err_CRY(concat(_lang_Current(Can't_find_record_from_table()), ":", "ksSpace", +, _tbl_Name(ac_tbl()), "ksSpace", _lang_Current(where_name_is()), "ksSpace", "inpa_asSuorta[inpa_asSuorta]", true))
  elseif _inpa_lFound > 1 then
    r.invp_account_id = 
    _err_CRY(concat(_lang_Current(Found_more_than_one_record_from_table()), ":", "ksSpace", +, _tbl_Name(ac_tbl()), "ksSpace", _lang_Current(where_name_is()), "ksSpace", "inpa_asSuorta[inpa_asSuorta]", true))
  else
    r.invp_account_id = r.ac_account_id
  end
end

function func.inpa_scPAIVIA_MYOH(r)
  inpa_KORKO_YHT()
end

function func.inpa_KORKO_YHT(r)
  if r.invp_days_late > 0 then
    if g.inpa_lInterestDaysPerYear > 0 then
      if r.inv_invoice_id ~= r.invp_invoice_id then
        _sel_RELATE_ONE(r.invp_invoice_id, r.in_invoice_id)
      end
      r.json_data.inpa_interest_total = r.json_data.inpa_payment / "100" * r.json_data.inv_penalty_interest
      r.json_data.inpa_interest_total = Round((r.json_data.inpa_interest_total * r.invp_days_late / g.inpa_lInterestDaysPerYear), 2)
    else
      _err_MESSAGE(_lang_Current(Due_dates_in_year_is_zero()), "inpa_KORKO_YHT", true)
    end
  else
    r.json_data.inpa_interest_total = 0
  end
end

function func.inpa_scKURSSI2(r)
  if r.inv_exchange_rate ~= "inpa_rKurssi" then
    if r.inv_exchange_rate ~= 0 then
      local _r = cur_C_Currency(true, 1, "inpa_rKurssi", "cur__DefaultCurre", "inpa_rTiliSumm", r.inv_currency_id)
      local _r = cur_C_Currency(true, r.inv_exchange_rate, 1, r.inv_currency_id, _r, "cur__DefaultCurre")
      if false then
        local _r = Round(("inpa_rTiliSumm" / "inpa_rKurssi" * r.inv_exchange_rate), 2)
      end
    else
      local _r = inpa_rTiliSumm()
    end
    local inpa_rJamasumm = Round((_r - "inpa_rTiliSumm"), 2)
    local inpa_asVahLyh = Find_in_array(inpa_asVahLyh, "KE")
    local inpa_asVahTek = inpa_asVahLyh
  else
    local inpa_asVahLyh = 1
    local inpa_asVahTek = 1
    if "inpa_rKokonais" == 1 then
      if r.inv_exchange_rate ~= 0 then
        local _r = cur_C_Currency(true, 1, r.inv_exchange_rate, "cur__DefaultCurre", r.json_data.inv_coming_total, r.inv_currency_id)
        local _r = cur_C_Currency(true, "inpa_rKurssi", 1, r.inv_currency_id, _r, "cur__DefaultCurre")
        local inpa_rJamasumm = Round((_r - "inpa_rTiliSumm"), 2)
        if false then
          local inpa_rJamasumm = Round(((r.json_data.inv_coming_total / r.inv_exchange_rate) * "inpa_rKurssi" - "inpa_rTiliSumm"), 2)
        end
      else
        local inpa_rJamasumm = Round((r.json_data.inv_coming_total - "inpa_rTiliSumm"), 2)
      end
    else
      local inpa_rJamasumm = 0
    end
  end
  if inpa_rJamasumm + "inpa_rTiliSumm" ~= 0 then
    local inpa_rKassaPro = inpa_rJamasumm / (inpa_rJamasumm + "inpa_rTiliSumm") * "100"
  else
    local inpa_rKassaPro = 0
  end
end

function func.inpa_C_CURRENCY(r)
  jatka tätä ---->()
end

function func.inpa_sYRITYS(r)
  inpa_NUMBER(g.aalNR_LOFF, "", r.json_data.inpa_firm_id)
  inpa_scTUNNUS_NUM()
end

function func.inpa_scON_OSASUORI(r)
  inpa_scMAKSETTU_S2()
  inpa_KORKO_YHT()
end

function func.inpa_scMAKSETTU_S2(r)
  inpa_scKURSSI2()
  if r.inv_exchange_rate == "inpa_rKurssi" then
    RELATE_ONE(r.inv_terms_of_payment_id)
    if r.top_discount_days > 0 then
      if Round(inpa_rKassaPro, 1) == r.top_discount_percentage then
        local inpa_asVahLyh = Find_in_array(inpa_asVahLyh, "KA")
        local inpa_asVahTek = inpa_asVahLyh
      end
    end
  end
end

function func.inpa_scTUNNUS_NUM(r)
  r.json_data.inpa_invoice_payment_code = aaC_Nro_Tunnus("inpa_sS_MreEtu", "inpa_lTunNro", "inpa_lS_MrePit")
end

function func.inpa_scTULOPAIVA(r)
  if r.json_data.inpa_arrival_date < r.invp_payment_date then
    xCRY(Tulopaiva_ei_voi_olla_pienempi_kuin_maksupaiva.())
    r.json_data.inpa_arrival_date = r.invp_payment_date
  end
end

function func.inpa_scVAHENNYS_SU(r)
  if r.json_data.inpa_decrement_sum + r.json_data.inpa_payment ~= 0 then
    local inpa_rKassaPro = r.json_data.inpa_decrement_sum / (r.json_data.inpa_decrement_sum + r.json_data.inpa_payment) * "100"
    local inpa_rSuoritus = r.json_data.inpa_decrement_sum + r.json_data.inpa_payment
    inpa_C_CURRENCY ----<>()
  else
    local inpa_rKassaPro = 0
  end
end



function script.r.invp_invoice_id(r)
  inpa_scLASKU()
end

function script.r.json_data.inpa_firm_id(r)
  inpa_sYRITYS()
end

function script.r.json_data.inpa_reference_number(r)
  inpa_scVIITENUMERO ----<>()
end

function script.r.invp_days_late(r)
  inpa_scPAIVIA_MYOH()
end

function script.new_record(r)
  r.invp_invoice_id = r.inv_invoice_id
  r.json_data.inpa_invoice_payment_code = r.invp_invoice_id
  r.json_data.inpa_payment_number = Max(r.json_data.inpa_payment_number) + 1
  r.json_data.inpa_arrival_date = _date_Current(true)
  r.invp_payment_date = r.json_data.inpa_arrival_date
end

function script.r.json_data.inpa_payment(r)
  inpa_scMAKSETTU_SU ----<>()
end

function script.r.json_data.inpa_method_of_payment(r)
  inpa_scSUORITUSTAP ----<>()
end

function script.r.invp_account_id(r)
  inpa_scSUORITUSTIL ----<>()
end

function script.r.json_data.inpa_is_partial_payment(r)
  inpa_scON_OSASUORI()
end

function script.r.invp_payment_date(r)
  inpa_scMAKSUPAIVA()
end

function script.r.json_data.inpa_decrement_sum(r)
  inpa_scVAHENNYS_SU ----<>()
end

function script.r.json_data.inpa_arrival_date(r)
  inpa_scTULOPAIVA()
end

-- end: r.invp.lua