/*
	File:		Aliases.h

	Copyright:	 1984-1993 by Apple Computer, Inc., all rights reserved.

	WARNING
	This file was auto generated by the interfacer tool. Modifications
	must be made to the master file.

*/

#ifndef __ALIASES__
#define __ALIASES__

#if PRAGMA_IMPORT
#pragma import on
#endif

#if PRAGMA_STRUCT_ALIGN
	#pragma options align=mac68k
#elif PRAGMA_STRUCT_PACKPUSH
	#pragma pack(push, 2)
#elif PRAGMA_STRUCT_PACK
	#pragma pack(2)
#endif

#ifndef __TYPES__
#include <MacTypes.H>
#endif

#ifndef __APPLETALK__
#if LONG_FILENAMES
#include <AppleTalk.H>
#else
#include <AppleTal.H>
#endif
#endif

#ifndef __FILES__
#include <Files.H>
#endif

#define rAliasType OST_alis

enum  {
/* define alias resolution action rules mask */
	kARMMountVol			= 0x0001,			/* mount the volume automatically */
	kARMNoUI			= 0x0002,			/* no user interface allowed during resolution */
	kARMMultVols			= 0x0008,			/* search on multiple volumes */
	kARMSearch			= 0x0100,			/* search quickly */
	kARMSearchMore			= 0x0200,			/* search further */
	kARMSearchRelFirst			= 0x0400,			/* search target on a relative path first */
/* define alias record information types */
	asiZoneName			= -3,			/* get zone name */
	asiServerName			= -2,			/* get server name */
	asiVolumeName			= -1,			/* get volume name */
	asiAliasName			= 0,			/* get aliased file/folder/volume name */
	asiParentName			= 1			/* get parent folder name */
};


/* define the alias record that will be the blackbox for the caller */

struct AliasRecord {
	OSType			userType;			/* appl stored type like creator type */
	unsigned short			aliasSize;			/* alias record size in bytes, for appl usage */
};
typedef struct AliasRecord AliasRecord;

typedef AliasRecord *AliasPtr, **AliasHandle;


/* alias record information type */

typedef short AliasInfoType;

typedef Boolean (pascal *MatchAliasFilterProcPtr)(CInfoPBPtr cpbPtr, Boolean *quitFlag, Ptr myDataPtr);

enum {
	uppMatchAliasFilterProcInfo = kPascalStackBased
		| RESULT_SIZE(SIZE_CODE(sizeof(Boolean)))
		| STACK_ROUTINE_PARAMETER(1, SIZE_CODE(sizeof(CInfoPBPtr)))
		| STACK_ROUTINE_PARAMETER(2, SIZE_CODE(sizeof(Boolean*)))
		| STACK_ROUTINE_PARAMETER(3, SIZE_CODE(sizeof(Ptr)))
};

#if USESROUTINEDESCRIPTORS
typedef UniversalProcPtr MatchAliasFilterUPP;

#define CallMatchAliasFilterProc(userRoutine, cpbPtr, quitFlag, myDataPtr)		\
		CallUniversalProc((UniversalProcPtr)(userRoutine), uppMatchAliasFilterProcInfo, (cpbPtr), (quitFlag), (myDataPtr))
#define NewMatchAliasFilterProc(userRoutine)		\
		(MatchAliasFilterUPP) NewRoutineDescriptor((ProcPtr)(userRoutine), uppMatchAliasFilterProcInfo, GetCurrentISA())
#else
typedef MatchAliasFilterProcPtr MatchAliasFilterUPP;

#define CallMatchAliasFilterProc(userRoutine, cpbPtr, quitFlag, myDataPtr)		\
		(*(userRoutine))((cpbPtr), (quitFlag), (myDataPtr))
#define NewMatchAliasFilterProc(userRoutine)		\
		(MatchAliasFilterUPP)(userRoutine)
#endif

typedef MatchAliasFilterProcPtr AliasFilterProcPtr;
// DDK 980223: Added for GLI
typedef MatchAliasFilterProcPtr AliasFilterUPP;

// DDK 980223: Added for GLI
#define NewAliasFilterProc(userRoutine) ((AliasFilterUPP) (userRoutine))

#ifdef __cplusplus
extern "C" {
#endif


/*  create a new alias between fromFile-target and return alias record handle  */

EXTERN F_PASCAL(OSErr) NewAlias(const FSSpec *fromFile, const FSSpec *target, AliasHandle *alias);

/* create a minimal new alias for a target and return alias record handle */

EXTERN F_PASCAL(OSErr) NewAliasMinimal(const FSSpec *target, AliasHandle *alias);

/* create a minimal new alias from a target fullpath (optional zone and server name) and return alias record handle  */

EXTERN F_PASCAL(OSErr) NewAliasMinimalFromFullPath(short fullPathLength, const unsigned char *fullPath, ConstStr32Param zoneName, ConstStr31Param serverName, AliasHandle *alias);
#define NewAliasMinimalFromFullpath NewAliasMinimalFromFullPath


/* given an alias handle and fromFile, resolve the alias, update the alias record and return aliased filename and wasChanged flag. */

EXTERN F_PASCAL(OSErr) ResolveAlias(const FSSpec *fromFile, AliasHandle alias, FSSpec *target, Boolean *wasChanged);

/* given an alias handle and an index specifying requested alias information type, return the information from alias record as a string. */

EXTERN F_PASCAL(OSErr) GetAliasInfo(const AliasHandle alias, AliasInfoType index, Str63 theString);

/*
  given a file spec, return target file spec if input file spec is an alias.
  It resolves the entire alias chain or one step of the chain.  It returns
  info about whether the target is a folder or file; and whether the input
  file spec was an alias or not.
*/

EXTERN F_PASCAL(OSErr)ResolveAliasFile(FSSpec *theSpec, Boolean resolveAliasChains, Boolean *targetIsFolder, Boolean *wasAliased);
EXTERN F_PASCAL(OSErr)FollowFinderAlias(const FSSpec *fromFile, AliasHandle alias, Boolean logon, FSSpec *target, Boolean *wasChanged);

/*
   Low Level Routines
 given an alias handle and fromFile, match the alias and return aliased filename(s) and needsUpdate flag
*/

EXTERN F_PASCAL(OSErr)MatchAlias(const FSSpec *fromFile, unsigned long rulesMask, const AliasHandle alias, short *aliasCount, FSSpecArrayPtr aliasList, Boolean *needsUpdate, MatchAliasFilterUPP aliasFilter, void *yourDataPtr);

/* given a fromFile-target pair and an alias handle, update the lias record pointed to by alias handle to represent target as the new alias. */

EXTERN F_PASCAL(OSErr)UpdateAlias(const FSSpec *fromFile, const FSSpec *target, AliasHandle alias, Boolean *wasChanged);
#if PRAGMA_STRUCT_ALIGN
	#pragma options align=reset
#elif PRAGMA_STRUCT_PACKPUSH
	#pragma pack(pop)
#elif PRAGMA_STRUCT_PACK
	#pragma pack()
#endif

#ifdef PRAGMA_IMPORT_OFF
#pragma import off
#elif PRAGMA_IMPORT
#pragma import reset
#endif
#ifdef __cplusplus
}
#endif

#endif


