/*
	File:		Connections.h

	Copyright:	 1984-1993 by Apple Computer, Inc., all rights reserved.

	WARNING
	This file was auto generated by the interfacer tool. Modifications
	must be made to the master file.

*/

#ifndef	__CONNECTIONS__
#define __CONNECTIONS__

#ifndef __DIALOGS__
#include <Dialogs.H>
#endif

#ifndef __CTBUTILITIES__
#ifdef LONG_FILENAMES
#include <CTBUtilities.H>
#else
#include <CTBUtili.H>
#endif
#endif

#if PRAGMA_IMPORT
#pragma import on
#endif

#if PRAGMA_STRUCT_ALIGN
	#pragma options align=mac68k
#elif PRAGMA_STRUCT_PACKPUSH
	#pragma pack(push, 2)
#elif PRAGMA_STRUCT_PACK
	#pragma pack(2)
#endif

enum  {
/*	current Connection Manager version	*/
	curCMVersion			= 2,
/*	current Connection Manager Environment Record version	*/
	curConnEnvRecVers			= 0,
/* CMErr */
	cmGenericError			= -1,
	cmNoErr			= 0,
	cmRejected			= 1,
	cmFailed			= 2,
	cmTimeOut			= 3,
	cmNotOpen			= 4,
	cmNotClosed			= 5,
	cmNoRequestPending			= 6,
	cmNotSupported			= 7,
	cmNoTools			= 8,
	cmUserCancel			= 9,
	cmUnknownError			= 11
};

typedef OSErr CMErr;

enum  {
	cmData			= 1L << 0,
	cmCntl			= 1L << 1,
	cmAttn			= 1L << 2,
	cmDataNoTimeout			= 1L << 4,
	cmCntlNoTimeout			= 1L << 5,
	cmAttnNoTimeout			= 1L << 6,
	cmDataClean			= 1L << 8,
	cmCntlClean			= 1L << 9,
	cmAttnClean			= 1L << 10
/*		Only for CMRecFlags (not CMChannel) in the rest of this enum	*/
#define	cmNoMenus	(1L << 16)
#define	cmQuiet		(1L << 17)
#define	cmConfigChanged	(1L << 18)
};


/* CMRecFlags and CMChannel		*/


/*		Low word of CMRecFlags is same as CMChannel	*/

typedef long CMRecFlags;

typedef short CMChannel;

enum  {
	cmStatusOpening			= 1L << 0,
	cmStatusOpen			= 1L << 1,
	cmStatusClosing			= 1L << 2,
	cmStatusDataAvail		= 1L << 3,
	cmStatusCntlAvail		= 1L << 4,
	cmStatusAttnAvail		= 1L << 5,
	cmStatusDRPend			= 1L << 6,	/* data read pending	*/
	cmStatusDWPend			= 1L << 7,	/* data write pending	*/
	cmStatusCRPend			= 1L << 8,	/* cntl read pending	*/
	cmStatusCWPend			= 1L << 9,	/* cntl write pending	*/
	cmStatusARPend			= 1L << 10,	/* attn read pending	*/
	cmStatusAWPend			= 1L << 11,	/* attn write pending	*/
	cmStatusBreakPend		= 1L << 12,
	cmStatusListenPend		= 1L << 13,
	cmStatusIncomingCallPresent	= 1L << 14,
	cmStatusReserved0		= 0x10000000L	// LOIC: was 1L << 15
};

typedef unsigned long CMStatFlags;

enum  {
	cmDataIn,
	cmDataOut,
	cmCntlIn,
	cmCntlOut,
	cmAttnIn,
	cmAttnOut,
	cmRsrvIn,
	cmRsrvOut
};

typedef unsigned short CMBufFields;

typedef Ptr CMBuffers[8];

typedef long CMBufferSizes[8];

typedef const long *ConstCMBufferSizesParam;

enum  {
	cmSearchSevenBit			= 1L << 0
};

typedef unsigned short CMSearchFlags;

enum  {
	cmFlagsEOM			= 1L << 0
};

typedef unsigned short CMFlags;

struct ConnEnvironRec {
	short			version;
	long			baudRate;
	short			dataBits;
	CMChannel			channels;
	Boolean			swFlowControl;
	Boolean			hwFlowControl;
	CMFlags			flags;
};
typedef struct ConnEnvironRec ConnEnvironRec;

typedef ConnEnvironRec *ConnEnvironRecPtr;

typedef struct ConnRecord ConnRecord, *ConnPtr, **ConnHandle;

typedef long (pascal *ConnectionToolDefProcPtr)(ConnHandle hConn, short msg, long p1, long p2, long p3);

enum {
	uppConnectionToolDefProcInfo = kPascalStackBased
		| RESULT_SIZE(SIZE_CODE(sizeof(long)))
		| STACK_ROUTINE_PARAMETER(1, SIZE_CODE(sizeof(ConnHandle)))
		| STACK_ROUTINE_PARAMETER(2, SIZE_CODE(sizeof(short)))
		| STACK_ROUTINE_PARAMETER(3, SIZE_CODE(sizeof(long)))
		| STACK_ROUTINE_PARAMETER(4, SIZE_CODE(sizeof(long)))
		| STACK_ROUTINE_PARAMETER(5, SIZE_CODE(sizeof(long)))
};

#if USESROUTINEDESCRIPTORS
typedef UniversalProcPtr ConnectionToolDefUPP;

#define CallConnectionToolDefProc(userRoutine, hConn, msg, p1, p2, p3)		\
		CallUniversalProc((UniversalProcPtr)(userRoutine), uppConnectionToolDefProcInfo, (hConn), (msg), (p1), (p2), (p3))
#define NewConnectionToolDefProc(userRoutine)		\
		(ConnectionToolDefUPP) NewRoutineDescriptor((ProcPtr)(userRoutine), uppConnectionToolDefProcInfo, GetCurrentISA())
#else
typedef ConnectionToolDefProcPtr ConnectionToolDefUPP;

#define CallConnectionToolDefProc(userRoutine, hConn, msg, p1, p2, p3)		\
		(*(userRoutine))((hConn), (msg), (p1), (p2), (p3))
#define NewConnectionToolDefProc(userRoutine)		\
		(ConnectionToolDefUPP)(userRoutine)
#endif

struct ConnRecord {
	short			procID;
	CMRecFlags			flags;
	CMErr			errCode;
	long			refCon;
	long			userData;
	ConnectionToolDefUPP		defProc;
	Ptr			config;
	Ptr			oldConfig;
	long			asyncEOM;
	long			reserved1;
	long			reserved2;
	Ptr			cmPrivate;
	CMBuffers			bufferArray;
	CMBufferSizes			bufSizes;
	long			mluField;
	CMBufferSizes			asyncCount;
};
/*	application routines type definitions */

typedef void (pascal *ConnectionSearchCallBackProcPtr)(ConnHandle hConn, Ptr matchPtr, long refNum);

enum {
	uppConnectionSearchCallBackProcInfo = kPascalStackBased
		| STACK_ROUTINE_PARAMETER(1, SIZE_CODE(sizeof(ConnHandle)))
		| STACK_ROUTINE_PARAMETER(2, SIZE_CODE(sizeof(Ptr)))
		| STACK_ROUTINE_PARAMETER(3, SIZE_CODE(sizeof(long)))
};

#if USESROUTINEDESCRIPTORS
typedef UniversalProcPtr ConnectionSearchCallBackUPP;

#define CallConnectionSearchCallBackProc(userRoutine, hConn, matchPtr, refNum)		\
		CallUniversalProc((UniversalProcPtr)(userRoutine), uppConnectionSearchCallBackProcInfo, (hConn), (matchPtr), (refNum))
#define NewConnectionSearchCallBackProc(userRoutine)		\
		(ConnectionSearchCallBackUPP) NewRoutineDescriptor((ProcPtr)(userRoutine), uppConnectionSearchCallBackProcInfo, GetCurrentISA())
#else
typedef ConnectionSearchCallBackProcPtr ConnectionSearchCallBackUPP;

#define CallConnectionSearchCallBackProc(userRoutine, hConn, matchPtr, refNum)		\
		(*(userRoutine))((hConn), (matchPtr), (refNum))
#define NewConnectionSearchCallBackProc(userRoutine)		\
		(ConnectionSearchCallBackUPP)(userRoutine)
#endif

typedef void (pascal *ConnectionCompletionProcPtr)(ConnHandle hConn);

enum {
	uppConnectionCompletionProcInfo = kPascalStackBased
		| STACK_ROUTINE_PARAMETER(1, SIZE_CODE(sizeof(ConnHandle)))
};

#if USESROUTINEDESCRIPTORS
typedef UniversalProcPtr ConnectionCompletionUPP;

#define CallConnectionCompletionProc(userRoutine, hConn)		\
		CallUniversalProc((UniversalProcPtr)(userRoutine), uppConnectionCompletionProcInfo, (hConn))
#define NewConnectionCompletionProc(userRoutine)		\
		(ConnectionCompletionUPP) NewRoutineDescriptor((ProcPtr)(userRoutine), uppConnectionCompletionProcInfo, GetCurrentISA())
#else
typedef ConnectionCompletionProcPtr ConnectionCompletionUPP;

#define CallConnectionCompletionProc(userRoutine, hConn)		\
		(*(userRoutine))((hConn))
#define NewConnectionCompletionProc(userRoutine)		\
		(ConnectionCompletionUPP)(userRoutine)
#endif

typedef void (pascal *ConnectionChooseIdleProcPtr)(void);

enum {
	uppConnectionChooseIdleProcInfo = kPascalStackBased
};

#if USESROUTINEDESCRIPTORS
typedef UniversalProcPtr ConnectionChooseIdleUPP;

#define CallConnectionChooseIdleProc(userRoutine)		\
		CallUniversalProc((UniversalProcPtr)(userRoutine), uppConnectionChooseIdleProcInfo)
#define NewConnectionChooseIdleProc(userRoutine)		\
		(ConnectionChooseIdleUPP) NewRoutineDescriptor((ProcPtr)(userRoutine), uppConnectionChooseIdleProcInfo, GetCurrentISA())
#else
typedef ConnectionChooseIdleProcPtr ConnectionChooseIdleUPP;

#define CallConnectionChooseIdleProc(userRoutine)		\
		(*(userRoutine))()
#define NewConnectionChooseIdleProc(userRoutine)		\
		(ConnectionChooseIdleUPP)(userRoutine)
#endif

enum  {
/* CMIOPB constants and structure */
	cmIOPBQType			= 10,
	cmIOPBversion			= 0
};

struct CMIOPB {
	QElemPtr			qLink;
	short			qType;			/* cmIOPBQType */
	ConnHandle			hConn;
	Ptr			theBuffer;
	long			count;
	CMFlags			flags;
	ConnectionCompletionUPP		userCompletion;
	long			timeout;
	CMErr			errCode;
	CMChannel			channel;
	long			asyncEOM;
	long			reserved1;
	short			reserved2;
	short			version;			/* cmIOPBversion */
	long			refCon;			/* for application */
	long			toolData1;			/* for tool */
	long			toolData2;			/* for tool */
};
typedef struct CMIOPB CMIOPB;

typedef CMIOPB *CMIOPBPtr;

#ifdef __cplusplus
extern "C" {
#endif
extern CMErr pascal InitCM(void);
extern Handle pascal CMGetVersion(ConnHandle hConn);
extern short pascal CMGetCMVersion(void);
extern ConnHandle pascal CMNew(short procID, CMRecFlags flags, ConstCMBufferSizesParam desiredSizes, long refCon, long userData);
extern void pascal CMDispose(ConnHandle hConn);
extern CMErr pascal CMListen(ConnHandle hConn, Boolean async, ConnectionCompletionUPP completor, long timeout);
extern CMErr pascal CMAccept(ConnHandle hConn, Boolean accept);
extern CMErr pascal CMOpen(ConnHandle hConn, Boolean async, ConnectionCompletionUPP completor, long timeout);
extern CMErr pascal CMClose(ConnHandle hConn, Boolean async, ConnectionCompletionUPP completor, long timeout, Boolean now);
extern CMErr pascal CMAbort(ConnHandle hConn);
extern CMErr pascal CMStatus(ConnHandle hConn, CMBufferSizes sizes, CMStatFlags *flags);
extern void pascal CMIdle(ConnHandle hConn);
extern void pascal CMReset(ConnHandle hConn);
extern void pascal CMBreak(ConnHandle hConn, long duration, Boolean async, ConnectionCompletionUPP completor);
extern CMErr pascal CMRead(ConnHandle hConn, void *theBuffer, long *toRead, CMChannel theChannel, Boolean async, ConnectionCompletionUPP completor, long timeout, CMFlags *flags);
extern CMErr pascal CMWrite(ConnHandle hConn, const void *theBuffer, long *toWrite, CMChannel theChannel, Boolean async, ConnectionCompletionUPP completor, long timeout, CMFlags flags);
extern CMErr pascal CMIOKill(ConnHandle hConn, short which);
extern void pascal CMActivate(ConnHandle hConn, Boolean activate);
extern void pascal CMResume(ConnHandle hConn, Boolean resume);
extern Boolean pascal CMMenu(ConnHandle hConn, short menuID, short item);
extern Boolean pascal CMValidate(ConnHandle hConn);
extern void pascal CMDefault(Ptr *theConfig, short procID, Boolean allocate);
extern Handle pascal CMSetupPreflight(short procID, long *magicCookie);
extern Boolean pascal CMSetupFilter(short procID, const void *theConfig, short count, DialogPtr theDialog, EventRecord *theEvent, short *theItem, long *magicCookie);
extern void pascal CMSetupSetup(short procID, const void *theConfig, short count, DialogPtr theDialog, long *magicCookie);
extern void pascal CMSetupItem(short procID, const void *theConfig, short count, DialogPtr theDialog, short *theItem, long *magicCookie);
extern void pascal CMSetupXCleanup(short procID, const void *theConfig, short count, DialogPtr theDialog, Boolean OKed, long *magicCookie);
extern void pascal CMSetupPostflight(short procID);
extern Ptr pascal CMGetConfig(ConnHandle hConn);
extern short pascal CMSetConfig(ConnHandle hConn, const void *thePtr);
extern OSErr pascal CMIntlToEnglish(ConnHandle hConn, const void *inputPtr, Ptr *outputPtr, short language);
extern OSErr pascal CMEnglishToIntl(ConnHandle hConn, const void *inputPtr, Ptr *outputPtr, short language);
extern long pascal CMAddSearch(ConnHandle hConn, ConstStr255Param theString, CMSearchFlags flags, ConnectionSearchCallBackUPP callBack);
extern void pascal CMRemoveSearch(ConnHandle hConn, long refnum);
extern void pascal CMClearSearch(ConnHandle hConn);
extern CMErr pascal CMGetConnEnvirons(ConnHandle hConn, ConnEnvironRec *theEnvirons);
extern short pascal CMChoose(ConnHandle *hConn, Point where, ConnectionChooseIdleUPP idle);
extern void pascal CMEvent(ConnHandle hConn, const EventRecord *theEvent);
extern void pascal CMGetToolName(short procID, Str255 name);
extern short pascal CMGetProcID(ConstStr255Param name);
extern void pascal CMSetRefCon(ConnHandle hConn, long refCon);
extern long pascal CMGetRefCon(ConnHandle hConn);
extern long pascal CMGetUserData(ConnHandle hConn);
extern void pascal CMSetUserData(ConnHandle hConn, long userData);
extern void pascal CMGetErrorString(ConnHandle hConn, short id, Str255 errMsg);
extern CMErr pascal CMNewIOPB(ConnHandle hConn, CMIOPBPtr *theIOPB);
extern CMErr pascal CMDisposeIOPB(ConnHandle hConn, CMIOPBPtr theIOPB);
extern CMErr pascal CMPBRead(ConnHandle hConn, CMIOPBPtr theIOPB, Boolean async);
extern CMErr pascal CMPBWrite(ConnHandle hConn, CMIOPBPtr theIOPB, Boolean async);
extern CMErr pascal CMPBIOKill(ConnHandle hConn, CMIOPBPtr theIOPB);
#if PRAGMA_STRUCT_ALIGN
	#pragma options align=reset
#elif PRAGMA_STRUCT_PACKPUSH
	#pragma pack(pop)
#elif PRAGMA_STRUCT_PACK
	#pragma pack()
#endif

#ifdef PRAGMA_IMPORT_OFF
#pragma import off
#elif PRAGMA_IMPORT
#pragma import reset
#endif
#ifdef __cplusplus
}
#endif

#endif


