/*
	File:		Dictionary.h

	Copyright:	 1984-1993 by Apple Computer, Inc., all rights reserved.

	WARNING
	This file was auto generated by the interfacer tool. Modifications
	must be made to the master file.

*/

#ifndef __DICTIONARY__
#define __DICTIONARY__

#ifndef __TYPES__
#include <MacTypes.H>
#endif

#ifndef __FILES__
#include <Files.H>
#endif


#if PRAGMA_IMPORT
#pragma import on
#endif

#if PRAGMA_STRUCT_ALIGN
	#pragma options align=mac68k
#elif PRAGMA_STRUCT_PACKPUSH
	#pragma pack(push, 2)
#elif PRAGMA_STRUCT_PACK
	#pragma pack(2)
#endif
/*------------------------------------------------------------------------------------------
	Constant definitions.
------------------------------------------------------------------------------------------ */


/* Dictionary data insertion modes. */

enum  {
	kInsert			= 0,			/* Only insert the input entry if there is nothing in the dictionary that matches the key. */
	kReplace			= 1,			/* Only replace the entries which match the key with the input entry. */
	kInsertOrReplace			= 2			/* Insert the entry if there is nothing in the dictionary which matches the key.
			* If there is already matched entries, replace the existing matched entries with the input entry. */
};


/* This Was InsertMode */

typedef short DictionaryDataInsertMode;


/* Key attribute constants.		*/

#define kIsCaseSensitive 0x10

#define kIsNotDiacriticalSensitive 0x20


/* Registered attribute type constants.	*/

enum  {
	kNoun			= -1,
	kVerb			= -2,
	kAdjective			= -3,
	kAdverb			= -4
};


/* This Was AttributeType */

typedef signed char DictionaryEntryAttribute;


/* ------------------------------------------------------------------------------------------

	Type definitions.

------------------------------------------------------------------------------------------ */


/* Dictionary information record.	*/

// WARNING: This struct is larger now on Windows because the FSSpec struct
//  has been grown to handle long file names. Make sure you don't save this
//  struct to disk as it will be different sizes on the 2 platforms.

struct DictionaryInformation {
	FSSpec			dictionaryFSSpec;
	long			numberOfRecords;
	long			currentGarbageSize;
	ScriptCode			script;
	short			maximumKeyLength;
	unsigned char			keyAttributes;
};
typedef struct DictionaryInformation DictionaryInformation;


/* --------------------------------------------------------------------------------------

	Function ProtoTypes.

-------------------------------------------------------------------------------------- */

#ifdef __cplusplus
extern "C" {
#endif

extern OSErr pascal InitializeDictionary(FSSpecPtr theFsspecPtr, short maximumKeyLength, unsigned char keyAttributes, ScriptCode script);
extern OSErr pascal OpenDictionary(FSSpecPtr theFsspecPtr, char accessPermission, long *dictionaryReference);
extern OSErr pascal CloseDictionary(long dictionaryReference);
extern OSErr pascal InsertRecordToDictionary(long dictionaryReference, ConstStr255Param key, Handle recordDataHandle, DictionaryDataInsertMode whichMode);
extern OSErr pascal DeleteRecordFromDictionary(long dictionaryReference, ConstStr255Param key);
extern OSErr pascal FindRecordInDictionary(long dictionaryReference, ConstStr255Param key, Ptr requestedAttributeTablePointer, Handle recordDataHandle);
extern OSErr pascal FindRecordByIndexInDictionary(long dictionaryReference, long recordIndex, Ptr requestedAttributeTablePointer, Str255 recordKey, Handle recordDataHandle);
extern OSErr pascal GetDictionaryInformation(long dictionaryReference, DictionaryInformation *theDictionaryInformation);
extern OSErr pascal CompactDictionary(long dictionaryReference);
#if PRAGMA_STRUCT_ALIGN
	#pragma options align=reset
#elif PRAGMA_STRUCT_PACKPUSH
	#pragma pack(pop)
#elif PRAGMA_STRUCT_PACK
	#pragma pack()
#endif

#ifdef PRAGMA_IMPORT_OFF
#pragma import off
#elif PRAGMA_IMPORT
#pragma import reset
#endif
#ifdef __cplusplus
}
#endif

#endif


