/*
	File:		Events.h

	Copyright:	 1984-1993 by Apple Computer, Inc., all rights reserved.

	WARNING
	This file was auto generated by the interfacer tool. Modifications
	must be made to the master file.

	mod 6 26 95 tsh - fix everyEvent to be a define
	mod 6 21 95 tsh - all integers are unsigned now (Universal Int 2.0)
	fgl 04-jan-96 Modified KeyTranslate() function prototype.
*/

#ifndef __EVENTS__
#define __EVENTS__

#ifndef __TYPES__
#include <MacTypes.H>
#endif

#ifndef __QUICKDRAW__
#if LONG_FILENAMES
#include <Quickdraw.H>
#else
#include <Quickdra.H>
#endif
#endif

#ifndef __OSUTILS__
#include <OSUtils.H>
#endif

#if PRAGMA_IMPORT
#pragma import on
#endif

#if PRAGMA_STRUCT_ALIGN
	#pragma options align=mac68k
#elif PRAGMA_STRUCT_PACKPUSH
	#pragma pack(push, 2)
#elif PRAGMA_STRUCT_PACK
	#pragma pack(2)
#endif
enum  {
	nullEvent			= 0,
	mouseDown			= 1,
	mouseUp				= 2,
	keyDown				= 3,
	keyUp				= 4,
	autoKey				= 5,
	updateEvt			= 6,
	diskEvt				= 7,
	activateEvt			= 8,
	osEvt				= 15
};

//CD 08/11/2000
#define mouseWheel 39

/* event mask equates */  
enum  {
	mDownMask			= 0x0002,
	mUpMask				= 0x0004,
	keyDownMask			= 0x0008,
	keyUpMask			= 0x0010,
	autoKeyMask			= 0x0020,
	updateMask			= 0x0040,
	diskMask			= 0x0080,
	activMask			= 0x0100,
	highLevelEventMask	= 0x0400
};
#define	osMask		(unsigned short)0x8000
#define	everyEvent	(unsigned short)0xFFFF



enum {
/* event message equates */
	charCodeMask				= 0x000000FF,
	keyCodeMask					= 0x0000FF00,
	adbAddrMask					= 0x00FF0000,
	osEvtMessageMask			= 0xFF000000L,
/* OS event messages.  Event (sub)code is in the high byte of the message field. */
	mouseMovedMessage			= 0x00FA,
	suspendResumeMessage		= 0x0001,
	resumeFlag					= 1,							/* Bit 0 of message indicates resume vs suspend */
	convertClipboardFlag		= 2								/* Bit 1 in resume message indicates clipboard change */
};

// typedef UInt16 EventModifiers;
typedef unsigned short EventModifiers;

enum {
/* modifiers */
	activeFlag					= 0x0001,						/* Bit 0 of modifiers for activateEvt and mouseDown events */
	btnState					= 0x0080,						/* Bit 7 of low byte is mouse button state */
	cmdKey						= 0x0100,						/* Bit 0 of high byte */
	shiftKey					= 0x0200,						/* Bit 1 of high byte */
	alphaLock					= 0x0400,						/* Bit 2 of high byte */
	optionKey					= 0x0800,						/* Bit 3 of high byte */
	controlKey					= 0x1000,						/* Bit 4 of high byte */
	rightShiftKey				= 0x2000,						/* Bit 5 of high byte */
	rightOptionKey				= 0x4000,						/* Bit 6 of high byte */
	rightControlKey				= 0x8000,						/* Bit 7 of high byte */
	activeFlagBit				= 0,							/* activate? (activateEvt and mouseDown) */
	btnStateBit					= 7,							/* state of button? */
	cmdKeyBit					= 8,							/* command key down? */
	shiftKeyBit					= 9,							/* shift key down? */
	alphaLockBit				= 10,							/* alpha lock down? */
	optionKeyBit				= 11,							/* option key down? */
	controlKeyBit				= 12,							/* control key down? */
	rightShiftKeyBit			= 13,							/* right shift key down? */
	rightOptionKeyBit			= 14,							/* right Option key down? */
	rightControlKeyBit			= 15							/* right Control key down? */
};

enum  {
/* obsolete equates */
	networkEvt			= 10,
	driverEvt			= 11,
	app1Evt				= 12,
	app2Evt				= 13
};

enum  {
	app3Evt			= 14,
	app4Evt			= 15,
	networkMask			= 1024,
	driverMask			= 2048,
	app1Mask			= 4096,
	app2Mask			= 8192,
	app3Mask			= 16384,
	app4Mask			= -32768
};


#pragma PRAGMA_PACK_1

struct EventRecord {
	unsigned short	what;
	unsigned long	message;
	unsigned long	when;
	Point		where;
	unsigned short	modifiers;
};
typedef struct EventRecord EventRecord;

typedef long KeyMap[4];

struct EvQEl {
	QElemPtr	qLink;
	unsigned short	qType;
	// This part is identical to the EventRecord as
	//   defined in ToolIntf
	unsigned short	evtQWhat;
	unsigned long	evtQMessage;
	unsigned long	evtQWhen;
	Point		evtQWhere;
	unsigned short	evtQModifiers;
};
typedef struct EvQEl EvQEl;

typedef EvQEl *EvQElPtr;

#pragma PRAGMA_PACK_RESET

enum  {
	uppGNEFilterProcInfo		= SPECIAL_CASE_PROCINFO(kSpecialCaseGNEFilterProc)
};

#if USESROUTINEDESCRIPTORS
typedef void (*GetNextEventFilterProcPtr)(EventRecord *theEvent, Boolean *result);

typedef UniversalProcPtr GNEFilterUPP;

#define CallGNEFilterProc(userRoutine, theEvent, result)  \
	CallUniversalProc((UniversalProcPtr)(userRoutine), uppGNEFilterProcInfo, theEvent, result)

#define NewGNEFilterProc(userRoutine)  \
	(GNEFilterUPP) NewRoutineDescriptor((ProcPtr)(userRoutine), uppGNEFilterProcInfo, GetCurrentISA())

#else
typedef ProcPtr GNEFilterUPP;

#define NewGNEFilterProc(userRoutine)  \
	(GNEFilterUPP)(userRoutine)

#endif

#ifdef __cplusplus
extern "C" {
#endif

extern Boolean pascal GetNextEvent(short eventMask, EventRecord *theEvent);
extern Boolean pascal WaitNextEvent(short eventMask, EventRecord *theEvent, unsigned long sleep, RgnHandle mouseRgn);
extern Boolean pascal EventAvail(short eventMask, EventRecord *theEvent);
extern void pascal GetMouse(Point *mouseLoc);
extern Boolean pascal Button(void);
extern Boolean pascal StillDown(void);
extern Boolean pascal WaitMouseUp(void);
extern void pascal GetKeys(KeyMap theKeys);
/* !!!fgl Correcting to bring up to date with the latest apple definition
 * from apple headers with code warrior 10
 */
extern UInt32 pascal KeyTranslate(const void *transData, UInt16 keycode, UInt32 *state);
extern unsigned long pascal TickCount(void);
#if USESCODEFRAGMENTS
extern unsigned long pascal GetDblTime(void);
extern unsigned long pascal GetCaretTime(void);
extern QHdrPtr pascal GetEvQHdr(void);
#else
#define GetEvQHdr() ((QHdrPtr) 0x014A)

#endif


extern OSErr pascal PostEvent(short eventNum, long eventMsg);

extern OSErr pascal PPostEvent(short eventCode, long eventMsg, EvQElPtr *qEl);

extern Boolean pascal OSEventAvail(short mask, EventRecord *theEvent);

extern Boolean pascal GetOSEvent(short mask, EventRecord *theEvent);
extern void pascal FlushEvents(short whichMask, short stopMask);

extern void pascal SetEventMask(short theMask);

EXTERN F_PASCAL( void ) InitEvents(void);
EXTERN F_PASCAL( short ) Slee();   /* NAME CHANGE -- Sleep */

#if OLDROUTINENAMES
#define KeyTrans(transData, keycode, state) KeyTranslate(transData, keycode, state)

#endif

#if PRAGMA_STRUCT_ALIGN
	#pragma options align=reset
#elif PRAGMA_STRUCT_PACKPUSH
	#pragma pack(pop)
#elif PRAGMA_STRUCT_PACK
	#pragma pack()
#endif

#ifdef PRAGMA_IMPORT_OFF
#pragma import off
#elif PRAGMA_IMPORT
#pragma import reset
#endif
#ifdef __cplusplus
}
#endif

#endif


