/*
	File:		FileTransfers.h

	Copyright:	 1984-1993 by Apple Computer, Inc., all rights reserved.

	WARNING
	This file was auto generated by the interfacer tool. Modifications
	must be made to the master file.

*/

#ifndef __FILETRANSFERS__
#define __FILETRANSFERS__

#ifndef __PACKAGES__
#include <Packages.H>
#endif

#ifndef __CTBUTILITIES__
#if LONG_FILENAMES
#include <CTBUtilities.H>
#else
#include <CTBUtili.H>
#endif
#endif

#ifndef __CONNECTIONS__
#if LONG_FILENAMES
#include <Connections.H>
#else
#include <Connecti.H>
#endif
#endif

#ifndef __TERMINALS__
#if LONG_FILENAMES
#include <Terminals.H>
#else
#include <Terminal.H>
#endif
#endif

#if PRAGMA_IMPORT
#pragma import on
#endif

#if PRAGMA_STRUCT_ALIGN
	#pragma options align=mac68k
#elif PRAGMA_STRUCT_PACKPUSH
	#pragma pack(push, 2)
#elif PRAGMA_STRUCT_PACK
	#pragma pack(2)
#endif
enum  {
/* current file transfer manager version	*/
	curFTVersion			= 2,
/* FTErr	*/
	ftGenericError			= -1,
	ftNoErr			= 0,
	ftRejected			= 1,
	ftFailed			= 2,
	ftTimeOut			= 3,
	ftTooManyRetry			= 4,
	ftNotEnoughDSpace			= 5,
	ftRemoteCancel			= 6,
	ftWrongFormat			= 7,
	ftNoTools			= 8,
	ftUserCancel			= 9,
	ftNotSupported			= 10
};

typedef OSErr FTErr;

enum  {
	ftIsFTMode			= 1 << 0,
	ftNoMenus			= 1 << 1,
	ftQuiet			= 1 << 2,
	ftConfigChanged			= 1 << 4,
	ftSucc			= 1 << 7
};

typedef unsigned long FTFlags;

enum  {
	ftSameCircuit			= 1 << 0,
	ftSendDisable			= 1 << 1,
	ftReceiveDisable			= 1 << 2,
	ftTextOnly			= 1 << 3,
	ftNoStdFile			= 1 << 4,
	ftMultipleFileSend			= 1 << 5
};

typedef unsigned short FTAttributes;

enum  {
	ftReceiving,
	ftTransmitting
};

typedef unsigned short FTDirection;

typedef long (pascal *FileTransferDefProcPtr)
	(TermHandle hTerm, short msg, long p1, long p2, long p3);

enum {
	uppFileTransferDefProcInfo = kPascalStackBased
		| RESULT_SIZE(SIZE_CODE(sizeof(long)))
		| STACK_ROUTINE_PARAMETER(1, SIZE_CODE(sizeof(TermHandle)))
		| STACK_ROUTINE_PARAMETER(2, SIZE_CODE(sizeof(short)))
		| STACK_ROUTINE_PARAMETER(3, SIZE_CODE(sizeof(long)))
		| STACK_ROUTINE_PARAMETER(4, SIZE_CODE(sizeof(long)))
		| STACK_ROUTINE_PARAMETER(5, SIZE_CODE(sizeof(long)))
};

#if USESROUTINEDESCRIPTORS
typedef UniversalProcPtr FileTransferDefUPP;

#define CallFileTransferDefProc(userRoutine, hTerm, msg, p1, p2, p3)		\
	CaUniversalProc((UniversalProcPtr)(userRoutine), \
	uppFileTransferDefProcInfo, (hTerm), (msg), (p1), (p2), (p3))
#define NewFileTransferDefProc(userRoutine)		\
	(FileTransferDefUPP) NewRoutineDescriptor((ProcPtr)(userRoutine), \
	uppFileTransferDefProcInfo, GetCurrentISA())
#else
typedef FileTransferDefProcPtr FileTransferDefUPP;

#define CallFileTransferDefProc(userRoutine, hTerm, msg, p1, p2, p3)		\
		(*(userRoutine))((hTerm), (msg), (p1), (p2), (p3))
#define NewFileTransferDefProc(userRoutine)		\
		(FileTransferDefUPP)(userRoutine)
#endif


/*	application routines type definitions */

typedef struct FTRecord FTRecord, *FTPtr, **FTHandle;

typedef OSErr (pascal *FileTransferReadProcPtr)	\
	(unsigned long *count, Ptr pData, long refCon, short fileMsg);

enum {
	uppFileTransferReadProcInfo = kPascalStackBased
		| RESULT_SIZE(SIZE_CODE(sizeof(OSErr)))
		| STACK_ROUTINE_PARAMETER(1, SIZE_CODE(sizeof(unsigned long*)))
		| STACK_ROUTINE_PARAMETER(2, SIZE_CODE(sizeof(Ptr)))
		| STACK_ROUTINE_PARAMETER(3, SIZE_CODE(sizeof(long)))
		| STACK_ROUTINE_PARAMETER(4, SIZE_CODE(sizeof(short)))
};

#if USESROUTINEDESCRIPTORS
typedef UniversalProcPtr FileTransferReadUPP;

#define CallFileTransferReadProc(userRoutine, count, pData, refCon, fileMsg)		\
	CallUniversalProc((UniversalProcPtr)(userRoutine), \
	uppFileTransferReadProcInfo, (count), (pData), (refCon), (fileMsg))
#define NewFileTransferReadProc(userRoutine)		\
	(FileTransferReadUPP) NewRoutineDescriptor((ProcPtr)(userRoutine), \
	uppFileTransferReadProcInfo, GetCurrentISA())
#else
typedef FileTransferReadProcPtr FileTransferReadUPP;

#define CallFileTransferReadProc(userRoutine, count, pData, refCon, fileMsg)		\
		(*(userRoutine))((count), (pData), (refCon), (fileMsg))
#define NewFileTransferReadProc(userRoutine)		\
		(FileTransferReadUPP)(userRoutine)
#endif

typedef OSErr (pascal *FileTransferWriteProcPtr) \
	(unsigned long *count, Ptr pData, long refCon, short fileMsg);

enum {
	uppFileTransferWriteProcInfo = kPascalStackBased
		| RESULT_SIZE(SIZE_CODE(sizeof(OSErr)))
		| STACK_ROUTINE_PARAMETER(1, SIZE_CODE(sizeof(unsigned long*)))
		| STACK_ROUTINE_PARAMETER(2, SIZE_CODE(sizeof(Ptr)))
		| STACK_ROUTINE_PARAMETER(3, SIZE_CODE(sizeof(long)))
		| STACK_ROUTINE_PARAMETER(4, SIZE_CODE(sizeof(short)))
};

#if USESROUTINEDESCRIPTORS
typedef UniversalProcPtr FileTransferWriteUPP;

#define CallFileTransferWriteProc(userRoutine, count, pData, refCon, fileMsg)		\
	CallUniversalProc((UniversalProcPtr)(userRoutine), \
	uppFileTransferWriteProcInfo, (count), (pData), (refCon), (fileMsg))
#define NewFileTransferWriteProc(userRoutine)		\
	(FileTransferWriteUPP) NewRoutineDescriptor((ProcPtr)(userRoutine), \
	uppFileTransferWriteProcInfo, GetCurrentISA())
#else
typedef FileTransferWriteProcPtr FileTransferWriteUPP;

#define CallFileTransferWriteProc(userRoutine, count, pData, refCon, fileMsg)		\
		(*(userRoutine))((count), (pData), (refCon), (fileMsg))
#define NewFileTransferWriteProc(userRoutine)		\
		(FileTransferWriteUPP)(userRoutine)
#endif

typedef Size (pascal *FileTransferSendProcPtr)\
	(Ptr thePtr, long theSize, long refCon, CMChannel channel, CMFlags flag);

enum {
	uppFileTransferSendProcInfo = kPascalStackBased
		| RESULT_SIZE(SIZE_CODE(sizeof(Size)))
		| STACK_ROUTINE_PARAMETER(1, SIZE_CODE(sizeof(Ptr)))
		| STACK_ROUTINE_PARAMETER(2, SIZE_CODE(sizeof(long)))
		| STACK_ROUTINE_PARAMETER(3, SIZE_CODE(sizeof(long)))
		| STACK_ROUTINE_PARAMETER(4, SIZE_CODE(sizeof(CMChannel)))
		| STACK_ROUTINE_PARAMETER(5, SIZE_CODE(sizeof(CMFlags)))
};

#if USESROUTINEDESCRIPTORS
typedef UniversalProcPtr FileTransferSendUPP;

#define CallFileTransferSendProc(userRoutine, thePtr, theSize, refCon, channel, flag)		\
	CallUniversalProc((UniversalProcPtr)(userRoutine), uppFileTransferSendProcInfo, \
	(thePtr), (theSize), (refCon), (channel), (flag))
#define NewFileTransferSendProc(userRoutine)		\
	(FileTransferSendUPP) NewRoutineDescriptor((ProcPtr)(userRoutine), \
	uppFileTransferSendProcInfo, GetCurrentISA())
#else
typedef FileTransferSendProcPtr FileTransferSendUPP;

#define CallFileTransferSendProc(userRoutine, thePtr, theSize, refCon, channel, flag)		\
		(*(userRoutine))((thePtr), (theSize), (refCon), (channel), (flag))
#define NewFileTransferSendProc(userRoutine)		\
		(FileTransferSendUPP)(userRoutine)
#endif

typedef Size (pascal *FileTransferReceiveProcPtr)	\
	(Ptr thePtr, long theSize, long refCon, CMChannel channel, CMFlags *flag);

enum {
	uppFileTransferReceiveProcInfo = kPascalStackBased
		| RESULT_SIZE(SIZE_CODE(sizeof(Size)))
		| STACK_ROUTINE_PARAMETER(1, SIZE_CODE(sizeof(Ptr)))
		| STACK_ROUTINE_PARAMETER(2, SIZE_CODE(sizeof(long)))
		| STACK_ROUTINE_PARAMETER(3, SIZE_CODE(sizeof(long)))
		| STACK_ROUTINE_PARAMETER(4, SIZE_CODE(sizeof(CMChannel)))
		| STACK_ROUTINE_PARAMETER(5, SIZE_CODE(sizeof(CMFlags*)))
};

#if USESROUTINEDESCRIPTORS
typedef UniversalProcPtr FileTransferReceiveUPP;

#define CallFileTransferReceiveProc(userRoutine, thePtr, theSize, refCon, channel, flag)		\
	CallUniversalProc((UniversalProcPtr)(userRoutine), uppFileTransferReceiveProcInfo, \
	(thePtr), (theSize), (refCon), (channel), (flag))
#define NewFileTransferReceiveProc(userRoutine)		\
	(FileTransferReceiveUPP) NewRoutineDescriptor((ProcPtr)(userRoutine), \
	uppFileTransferReceiveProcInfo, GetCurrentISA())
#else
typedef FileTransferReceiveProcPtr FileTransferReceiveUPP;

#define CallFileTransferReceiveProc(userRoutine, thePtr, theSize, refCon, channel, flag)		\
		(*(userRoutine))((thePtr), (theSize), (refCon), (channel), (flag))
#define NewFileTransferReceiveProc(userRoutine)		\
		(FileTransferReceiveUPP)(userRoutine)
#endif

typedef OSErr (pascal *FileTransferEnvironsProcPtr)(long refCon, ConnEnvironRec *theEnvirons);

enum {
	uppFileTransferEnvironsProcInfo = kPascalStackBased
		| RESULT_SIZE(SIZE_CODE(sizeof(OSErr)))
		| STACK_ROUTINE_PARAMETER(1, SIZE_CODE(sizeof(long)))
		| STACK_ROUTINE_PARAMETER(2, SIZE_CODE(sizeof(ConnEnvironRec*)))
};

#if USESROUTINEDESCRIPTORS
typedef UniversalProcPtr FileTransferEnvironsUPP;

#define CallFileTransferEnvironsProc(userRoutine, refCon, theEnvirons)		\
	CallUniversalProc((UniversalProcPtr)(userRoutine), \
	uppFileTransferEnvironsProcInfo, (refCon), (theEnvirons))
#define NewFileTransferEnvironsProc(userRoutine)	\
	(FileTransferEnvironsUPP) NewRoutineDescriptor((ProcPtr)(userRoutine), \
	uppFileTransferEnvironsProcInfo, GetCurrentISA())
#else
typedef FileTransferEnvironsProcPtr FileTransferEnvironsUPP;

#define CallFileTransferEnvironsProc(userRoutine, refCon, theEnvirons)		\
		(*(userRoutine))((refCon), (theEnvirons))
#define NewFileTransferEnvironsProc(userRoutine)		\
		(FileTransferEnvironsUPP)(userRoutine)
#endif

typedef void (pascal *FileTransferNotificationProcPtr)(FTHandle hFT, FSSpecPtr pFSSpec);

enum {
	uppFileTransferNotificationProcInfo = kPascalStackBased
		| STACK_ROUTINE_PARAMETER(1, SIZE_CODE(sizeof(FTHandle)))
		| STACK_ROUTINE_PARAMETER(2, SIZE_CODE(sizeof(FSSpecPtr)))
};

#if USESROUTINEDESCRIPTORS
typedef UniversalProcPtr FileTransferNotificationUPP;

#define CallFileTransferNotificationProc(userRoutine, hFT, pFSSpec)		\
	CallUniversalProc((UniversalProcPtr)(userRoutine), \
	uppFileTransferNotificationProcInfo, (hFT), (pFSSpec))
#define NewFileTransferNotificationProc(userRoutine)		\
	(FileTransferNotificationUPP) NewRoutineDescriptor((ProcPtr)(userRoutine), \
	uppFileTransferNotificationProcInfo, GetCurrentISA())
#else
typedef FileTransferNotificationProcPtr FileTransferNotificationUPP;

#define CallFileTransferNotificationProc(userRoutine, hFT, pFSSpec)		\
		(*(userRoutine))((hFT), (pFSSpec))
#define NewFileTransferNotificationProc(userRoutine)		\
		(FileTransferNotificationUPP)(userRoutine)
#endif

typedef void (pascal *FileTransferChooseIdleProcPtr)(void);

enum {
	uppFileTransferChooseIdleProcInfo = kPascalStackBased
};

#if USESROUTINEDESCRIPTORS
typedef UniversalProcPtr FileTransferChooseIdleUPP;

#define CallFileTransferChooseIdleProc(userRoutine)		\
		CallUniversalProc((UniversalProcPtr)(userRoutine), \
uppFileTransferChooseIdleProcInfo)
#define NewFileTransferChooseIdleProc(userRoutine)		\
 (FileTransferChooseIdleUPP) NewRoutineDescriptor((ProcPtr)(userRoutine), \
 uppFileTransferChooseIdleProcInfo, GetCurrentISA())
#else
typedef FileTransferChooseIdleProcPtr FileTransferChooseIdleUPP;

#define CallFileTransferChooseIdleProc(userRoutine)		\
		(*(userRoutine))()
#define NewFileTransferChooseIdleProc(userRoutine)		\
		(FileTransferChooseIdleUPP)(userRoutine)
#endif

struct FTRecord {
	short			procID;
	FTFlags			flags;
	FTErr			errCode;
	long			refCon;
	long			userData;
	FileTransferDefUPP			defProc;
	Ptr			config;
	Ptr			oldConfig;
	FileTransferEnvironsUPP		environsProc;
	long			reserved1;
	long			reserved2;
	Ptr			ftPrivate;
	FileTransferSendUPP			sendProc;
	FileTransferReceiveUPP		recvProc;
	FileTransferWriteUPP		writeProc;
	FileTransferReadUPP			readProc;
	WindowPtr			owner;
	FTDirection			direction;
	SFReply			theReply;
	long			writePtr;
	long			readPtr;
	char			*theBuf;
	long			bufSize;
	Str255			autoRec;
	FTAttributes			attributes;
};
enum  {
/* FTReadProc messages */
	ftReadOpenFile			= 0,			/* count = forkFlags, buffer = pblock from PBGetFInfo */
	ftReadDataFork			= 1,
	ftReadRsrcFork			= 2,
	ftReadAbort			= 3,
	ftReadComplete			= 4,
	ftReadSetFPos			= 6,			/* count = forkFlags, buffer = pBlock same as PBSetFPos */
	ftReadGetFPos			= 7,			/* count = forkFlags, buffer = pBlock same as PBGetFPos */
/* FTWriteProc messages */
	ftWriteOpenFile			= 0,			/* count = forkFlags, buffer = pblock from PBGetFInfo */
	ftWriteDataFork			= 1,
	ftWriteRsrcFork			= 2,
	ftWriteAbort			= 3,
	ftWriteComplete			= 4,
	ftWriteFileInfo			= 5,
	ftWriteSetFPos			= 6,			/* count = forkFlags, buffer = pBlock same as PBSetFPos */
	ftWriteGetFPos			= 7,			/* count = forkFlags, buffer = pBlock same as PBGetFPos */
/*	fork flags */
	ftOpenDataFork			= 1,
	ftOpenRsrcFork			= 2
};

#ifdef __cplusplus
extern "C" {
#endif

extern FTErr pascal InitFT(void);
extern Handle pascal FTGetVersion(FTHandle hFT);
extern short pascal FTGetFTVersion(void);
extern FTHandle pascal FTNew(short procID, FTFlags flags, FileTransferSendUPP sendProc, \
FileTransferReceiveUPP recvProc, FileTransferReadUPP readProc, \
FileTransferWriteUPP writeProc, FileTransferEnvironsUPP environsProc, \
WindowPtr owner, long refCon, long userData);
extern void pascal FTDispose(FTHandle hFT);
extern FTErr pascal FTStart(FTHandle hFT, FTDirection direction, const SFReply *fileInfo);
extern FTErr pascal FTAbort(FTHandle hFT);
extern FTErr pascal FTSend(FTHandle hFT, short numFiles, FSSpecArrayPtr pFSSpec, \
FileTransferNotificationUPP notifyProc);
extern FTErr pascal FTReceive(FTHandle hFT, FSSpecPtr pFSSpec, \
FileTransferNotificationUPP notifyProc);
extern void pascal FTExec(FTHandle hFT);
extern void pascal FTActivate(FTHandle hFT, Boolean activate);
extern void pascal FTResume(FTHandle hFT, Boolean resume);
extern Boolean pascal FTMenu(FTHandle hFT, short menuID, short item);
extern short pascal FTChoose(FTHandle *hFT, Point where, FileTransferChooseIdleUPP idleProc);
extern void pascal FTEvent(FTHandle hFT, const EventRecord *theEvent);
extern Boolean pascal FTValidate(FTHandle hFT);
extern void pascal FTDefault(Ptr *theConfig, short procID, Boolean allocate);
extern Handle pascal FTSetupPreflight(short procID, long *magicCookie);
extern void pascal FTSetupSetup(short procID, const void *theConfig, short count, \
DialogPtr theDialog, long *magicCookie);
extern Boolean pascal FTSetupFilter(short procID, const void *theConfig, short count, \
DialogPtr theDialog, EventRecord *theEvent, short *theItem, long *magicCookie);
extern void pascal FTSetupItem(short procID, const void *theConfig, short count, \
DialogPtr theDialog, short *theItem, long *magicCookie);
extern void pascal FTSetupXCleanup(short procID, const void *theConfig, short count, \
DialogPtr theDialog, Boolean OKed, long *magicCookie);
extern void pascal FTSetupPostflight(short procID);
extern Ptr pascal FTGetConfig(FTHandle hFT);
extern short pascal FTSetConfig(FTHandle hFT, const void *thePtr);
extern OSErr pascal FTIntlToEnglish(FTHandle hFT, const void *inputPtr, \
Ptr *outputPtr, short language);
extern OSErr pascal FTEnglishToIntl(FTHandle hFT, const void *inputPtr, \
Ptr *outputPtr, short language);
extern void pascal FTGetToolName(short procID, Str255 name);
extern short pascal FTGetProcID(ConstStr255Param name);
extern void pascal FTSetRefCon(FTHandle hFT, long refCon);
extern long pascal FTGetRefCon(FTHandle hFT);
extern void pascal FTSetUserData(FTHandle hFT, long userData);
extern long pascal FTGetUserData(FTHandle hFT);
extern void pascal FTGetErrorString(FTHandle hFT, short id, Str255 errMsg);
#if PRAGMA_STRUCT_ALIGN
	#pragma options align=reset
#elif PRAGMA_STRUCT_PACKPUSH
	#pragma pack(pop)
#elif PRAGMA_STRUCT_PACK
	#pragma pack()
#endif

#ifdef PRAGMA_IMPORT_OFF
#pragma import off
#elif PRAGMA_IMPORT
#pragma import reset
#endif
#ifdef __cplusplus
}
#endif

#endif


