/*
	File:		Fonts.h

	Copyright:	 1984-1993 by Apple Computer, Inc., all rights reserved.

	WARNING
	This file was auto generated by the interfacer tool. Modifications
	must be made to the master file.

*/

#ifndef __FONTS__
#define __FONTS__

#ifndef __TYPES__
#include <MacTypes.H>
#endif

#if PRAGMA_IMPORT
#pragma import on
#endif

#if PRAGMA_STRUCT_ALIGN
	#pragma options align=mac68k
#elif PRAGMA_STRUCT_PACKPUSH
	#pragma pack(push, 2)
#elif PRAGMA_STRUCT_PACK
	#pragma pack(2)
#endif
enum  {
	systemFont			= 0,
	applFont			= 1,
	newYork			= 2,
	geneva			= 3,
	monaco			= 4,
	venice			= 5,
	london			= 6,
	athens			= 7,
	sanFran			= 8,
	toronto			= 9,
	cairo			= 11,
	losAngeles			= 12,
	times			= 20,
	helvetica			= 21,
	courier			= 22,
	symbol			= 23,
	mobile			= 24,
	commandMark			= 17,
	checkMark			= 18,
	diamondMark			= 19
};

enum {
	kFontIDNewYork				= 2,
	kFontIDGeneva				= 3,
	kFontIDMonaco				= 4,
	kFontIDVenice				= 5,
	kFontIDLondon				= 6,
	kFontIDAthens				= 7,
	kFontIDSanFrancisco			= 8,
	kFontIDToronto				= 9,
	kFontIDCairo				= 11,
	kFontIDLosAngeles			= 12,
	kFontIDTimes				= 20,
	kFontIDHelvetica			= 21,
	kFontIDCourier				= 22,
	kFontIDSymbol				= 23,
	kFontIDMobile				= 24
};

enum  {
	appleMark			= 20
#define	propFont	36864L
#define	prpFntH		36865L
#define	prpFntW		36866L
#define	prpFntHW	36867L
#define	fixedFont	45056L
#define	fxdFntH		45057L
#define	fxdFntW		45058L
#define	fxdFntHW	45059L
#define	fontWid		44208L
};

struct FMInput {
	short			family;
	short			size;
	Style			face;
	Boolean			needBits;
	short			device;
	Point			numer;
	Point			denom;
};
typedef struct FMInput FMInput;

struct FMOutput {
	short			errNum;
	Handle			fontHandle;
	unsigned char			boldPixels;
	unsigned char			italicPixels;
	unsigned char			ulOffset;
	unsigned char			ulShadow;
	unsigned char			ulThick;
	unsigned char			shadowPixels;
	char			extra;
	unsigned char			ascent;
	unsigned char			descent;
	unsigned char			widMax;
	char			leading;
	char			curStyle;
	Point			numer;
	Point			denom;
};
typedef struct FMOutput FMOutput;

typedef FMOutput *FMOutPtr;

struct FontRec {
	short			fontType;			/*font type*/
	short			firstChar;			/*ASCII code of first character*/
	short			lastChar;			/*ASCII code of last character*/
	short			widMax;			/*maximum character width*/
	short			kernMax;			/*negative of maximum character kern*/
	short			nDescent;			/*negative of descent*/
	short			fRectWidth;			/*width of font rectangle*/
	short			fRectHeight;			/*height of font rectangle*/
	unsigned short			owTLoc;			/*offset to offset/width table*/
	short			ascent;			/*ascent*/
	short			descent;			/*descent*/
	short			leading;			/*leading*/
	short			rowWords;			/*row width of bit image / 2 */
};
typedef struct FontRec FontRec;

struct FMetricRec {
	Fixed			ascent;			/*base line to top*/
	Fixed			descent;			/*base line to bottom*/
	Fixed			leading;			/*leading between lines*/
	Fixed			widMax;			/*maximum character width*/
	Handle			wTabHandle;			/*handle to font width table*/
};
typedef struct FMetricRec FMetricRec;

struct WidEntry {
	short			widStyle;			/*style entry applies to*/
};
typedef struct WidEntry WidEntry;

struct WidTable {
	short			numWidths;			/*number of entries - 1*/
};
typedef struct WidTable WidTable;

struct AsscEntry {
	short			fontSize;
	short			fontStyle;
	short			fontID;			/*font resource ID*/
};
typedef struct AsscEntry AsscEntry;

struct FontAssoc {
	short			numAssoc;			/*number of entries - 1*/
};
typedef struct FontAssoc FontAssoc;

struct StyleTable {
	short			fontClass;
	long			offset;
	long			reserved;
	char			indexes[48];
};
typedef struct StyleTable StyleTable;

struct NameTable {
	short			stringCount;
	Str255			baseFontName;
};
typedef struct NameTable NameTable;

struct KernPair {
	char			kernFirst;			/*1st character of kerned pair*/
	char			kernSecond;			/*2nd character of kerned pair*/
	short			kernWidth;			/*kerning in 1pt fixed format*/
};
typedef struct KernPair KernPair;

struct KernEntry {
	short			kernLength;			/*length of this entry*/
	short			kernStyle;			/*style the entry applies to*/
};
typedef struct KernEntry KernEntry;

struct KernTable {
	short			numKerns;			/*number of kerning entries*/
};
typedef struct KernTable KernTable;

struct WidthTable {
	Fixed			tabData[256];			/*character widths*/
	Handle			tabFont;			/*font record used to build table*/
	long			sExtra;			/*space extra used for table*/
	long			style;			/*extra due to style*/
	short			fID;			/*font family ID*/
	short			fSize;			/*font size request*/
	short			face;			/*style (face) request*/
	short			device;			/*device requested*/
	Point			inNumer;			/*scale factors requested*/
	Point			inDenom;			/*scale factors requested*/
	short			aFID;			/*actual font family ID for table*/
	Handle			fHand;			/*family record used to build up table*/
	Boolean			usedFam;			/*used fixed point family widths*/
	unsigned char			aFace;			/*actual face produced*/
	short			vOutput;			/*vertical scale output value*/
	short			hOutput;			/*horizontal scale output value*/
	short			vFactor;			/*vertical scale output value*/
	short			hFactor;			/*horizontal scale output value*/
	short			aSize;			/*actual size of actual font used*/
	short			tabSize;			/*total size of table*/
};
typedef struct WidthTable WidthTable, *WidthTablePtr, **WidthTableHandle;

struct FamRec {
	short			ffFlags;			/*flags for family*/
	short			ffFamID;			/*family ID number*/
	short			ffFirstChar;			/*ASCII code of 1st character*/
	short			ffLastChar;			/*ASCII code of last character*/
	short			ffAscent;			/*maximum ascent for 1pt font*/
	short			ffDescent;			/*maximum descent for 1pt font*/
	short			ffLeading;			/*maximum leading for 1pt font*/
	short			ffWidMax;			/*maximum widMax for 1pt font*/
	long			ffWTabOff;			/*offset to width table*/
	long			ffKernOff;			/*offset to kerning table*/
	long			ffStylOff;			/*offset to style mapping table*/
	short			ffProperty[9];			/*style property info*/
	short			ffIntl[2];			/*for international use*/
	short			ffVersion;			/*version number*/
};
typedef struct FamRec FamRec;

#ifdef __cplusplus
extern "C" {
#endif

extern void pascal InitFonts(void);
extern void pascal GetFontName(short familyID, Str255 name);
extern void pascal GetFNum(ConstStr255Param name, short *familyID);
extern Boolean pascal RealFont(short fontNum, short size);
extern void pascal SetFontLock(Boolean lockFlag);
extern FMOutPtr pascal FMSwapFont(const FMInput *inRec);
extern void pascal SetFScaleDisable(Boolean fscaleDisable);
extern void pascal FontMetrics(FMetricRec *theMetrics);	// LOIC: removed "const"
extern void pascal SetFractEnable(Boolean fractEnable);
extern Boolean pascal IsOutline(Point numer, Point denom);
extern void pascal SetOutlinePreferred(Boolean outlinePreferred);
extern Boolean pascal GetOutlinePreferred(void);
extern OSErr pascal OutlineMetrics(short byteCount, const void *textPtr, Point numer, Point denom, short *yMax, short *yMin, FixedPtr awArray, FixedPtr lsbArray, RectPtr boundsArray);
extern void pascal SetPreserveGlyph(Boolean preserveGlyph);
extern Boolean pascal GetPreserveGlyph(void);
extern OSErr pascal FlushFonts(void);
extern void getfnum(char *theName, short *familyID);
extern void getfontname(short familyID, char *theName);
extern short pascal GetDefFontSize(void);
#if USESCODEFRAGMENTS
extern short pascal GetSysFont(void);
extern short pascal GetAppFont(void);
#else
#endif

#if PRAGMA_STRUCT_ALIGN
	#pragma options align=reset
#elif PRAGMA_STRUCT_PACKPUSH
	#pragma pack(pop)
#elif PRAGMA_STRUCT_PACK
	#pragma pack()
#endif

#ifdef PRAGMA_IMPORT_OFF
#pragma import off
#elif PRAGMA_IMPORT
#pragma import reset
#endif
#ifdef __cplusplus
}
#endif

#endif


