/*
	File:		FragLoad.h

	Copyright:	 1984-1993 by Apple Computer, Inc., all rights reserved.

	WARNING
	This file was auto generated by the interfacer tool. Modifications
	must be made to the master file.

*/

#ifndef __FRAGLOAD__
#define __FRAGLOAD__ 1

#ifndef __TYPES__
#include <MacTypes.H>
#endif

#ifndef __FILES__
#include <Files.H>
#endif

#if PRAGMA_IMPORT
#pragma import on
#endif

#if PRAGMA_STRUCT_ALIGN
	#pragma options align=mac68k
#elif PRAGMA_STRUCT_PACKPUSH
	#pragma pack(push, 2)
#elif PRAGMA_STRUCT_PACK
	#pragma pack(2)
#endif

typedef long ConnectionID;

typedef unsigned long LoadFlags;

typedef unsigned char SymClass;

#define kPowerPCArch OST_pwpc

#define kMotorola68KArch OST_m68k

#define kAnyArchType '???\?'


// *** Confusing names, soon to be removed!

#define kPowerPC OST_pwpc

#define kMotorola68K OST_m68k

#define kNoLibName ((unsigned char *) 0)

#define kNoConnectionID ((ConnectionID) 0)

#define kUnresolvedSymbolAddress ((Ptr) 0x0)


// use for findFlags mask

enum  {
	kLoadLib			= 1,			// use existing connection if possible
	kFindLib			= 2,			// just see if library is already loaded
	kLoadNewCopy			= 5,			// load a new instance no matter what
	kUseInPlace			= 0x80			// use container's sections in place
};

enum  {
	kCodeSym			= 0,
	kDataSym			= 1,
	kTVectSym			= 2,
	kTOCSym			= 3,
	kGlueSym			= 4
};


/************************************************************************/


/*	for fragment initialization routines			*/


/************************************************************************/

struct MemFragment {
	Ptr			address;
	long			length;
	Boolean			inPlace;
};
typedef struct MemFragment MemFragment;

struct DiskFragment {
	FSSpecPtr			fileSpec;			// ! Must correspond to FSSpecPtr in segmented case!
	long			offset;
	long			length;
};
typedef struct DiskFragment DiskFragment;

struct SegmentedFragment {
	FSSpecPtr			fileSpec;			// ! Must correspond to FSSpecPtr in data fork case!
	OSType			rsrcType;
	short			rsrcID;
};
typedef struct SegmentedFragment SegmentedFragment;


// ! Note that the onDisk and inSegs members are required to have an FSSpecPtr


// ! field at the same location!  CFM code uses just one member to access the


// ! information for either case!

struct FragmentLocator {
	long			where;
	union {
		MemFragment			inMem;
		DiskFragment			onDisk;
		SegmentedFragment			inSegs;
	}			u;
};
typedef struct FragmentLocator FragmentLocator, *FragmentLocatorPtr;


// NOTE: when fragLocator. where == kOnDisk, then


//	fragLocator. u. onDisk. fileSpec is a pointer


//	to the file that the library belonged to.


//	the pointer is valid only for the duration


//	of the init routine's invocation, so make


//	a copy of the filespec if it is important

struct InitBlock {
	long			contextID;
	long			closureID;
	long			connectionID;
	FragmentLocator			fragLocator;
	Ptr			libName;
	long			reserved4a;
	long			reserved4b;
	long			reserved4c;
	long			reserved4d;
};
typedef struct InitBlock InitBlock, *InitBlockPtr;


// Prototype for initialization routines.  Note that these are C, not Pascal conventions!


// This differs from customary "Apple-callback" useage, but is felt to be less error prone


// in practice since the vast bulk of 68K CFM aware code will be in C.


// NOTE: Initialization routines may comfortably ignore their parameters, however, they must


//	return an error status (ie: noErr) in order to succeed with the load of the library.


// Termination routines get no parameters and have no return value.

typedef OSErr ConnectionInitializationRoutine(InitBlockPtr initBlkPtr);

typedef void ConnectionTerminationRoutine(void);


/************************************************************************/


/*		for building shared libraries			*/


/************************************************************************/

#define kCFMRsrcType OST_cfrg

#define kCFMRsrcID 0

#define kSHLBFileType OST_shlb



#if TurnOff68KCFMTraps || __powerc || powerc
#define CFMTrap(arg)

#else
#define CFMTrap(arg) = { 0x3F3C, arg, _CodeFragmentDispatch }

#endif

#ifdef __cplusplus
extern "C" {
#endif

extern OSErr pascal GetSharedLibrary(Str63 libName, OSType archType, LoadFlags findFlags, ConnectionID *connID, Ptr *mainAddr, Str255 errName);
#define GetSharedLibraryProcInfo  \
	(kPascalStackBased	|			\
	RESULT_SIZE(kTwoByteCode) |	\
	STACK_ROUTINE_PARAMETER(1, kFourByteCode) |	\
	STACK_ROUTINE_PARAMETER(2, kFourByteCode) |	\
	STACK_ROUTINE_PARAMETER(3, kFourByteCode) |	\
	STACK_ROUTINE_PARAMETER(4, kFourByteCode) |	\
	STACK_ROUTINE_PARAMETER(5, kFourByteCode) |	\
	STACK_ROUTINE_PARAMETER(6, kFourByteCode))

extern OSErr pascal GetDiskFragment(FSSpecPtr fileSpec, long offset, long length, Str63 fragName, LoadFlags findFlags, ConnectionID *connID, Ptr *mainAddr, Str255 errName);
#define GetDiskFragmentProcInfo  \
	(kPascalStackBased	|			\
	RESULT_SIZE(kTwoByteCode) |	\
	STACK_ROUTINE_PARAMETER(1, kFourByteCode) |	\
	STACK_ROUTINE_PARAMETER(2, kFourByteCode) |	\
	STACK_ROUTINE_PARAMETER(3, kFourByteCode) |	\
	STACK_ROUTINE_PARAMETER(4, kFourByteCode) |	\
	STACK_ROUTINE_PARAMETER(5, kFourByteCode) |	\
	STACK_ROUTINE_PARAMETER(6, kFourByteCode) |	\
	STACK_ROUTINE_PARAMETER(7, kFourByteCode) |	\
	STACK_ROUTINE_PARAMETER(8, kFourByteCode))

extern OSErr pascal GetMemFragment(Ptr memAddr, long length, Str63 fragName, LoadFlags findFlags, ConnectionID *connID, Ptr *mainAddr, Str255 errName);
#define GetMemFragmentProcInfo	\
	(kPascalStackBased	|			\
	RESULT_SIZE(kTwoByteCode) |	\
	STACK_ROUTINE_PARAMETER(1, kFourByteCode) |	\
	STACK_ROUTINE_PARAMETER(2, kFourByteCode) |	\
	STACK_ROUTINE_PARAMETER(3, kFourByteCode) |	\
	STACK_ROUTINE_PARAMETER(4, kFourByteCode) |	\
	STACK_ROUTINE_PARAMETER(5, kFourByteCode) |	\
	STACK_ROUTINE_PARAMETER(6, kFourByteCode) |	\
	STACK_ROUTINE_PARAMETER(7, kFourByteCode))

extern OSErr pascal CloseConnection(ConnectionID *connID);
#define CloseConnectionProcInfo  \
	(kPascalStackBased	|			\
	RESULT_SIZE(kTwoByteCode) |	\
	STACK_ROUTINE_PARAMETER(1, kFourByteCode))

extern OSErr pascal FindSymbol(ConnectionID connID, Str255 symName, Ptr *symAddr, SymClass *symClass);
#define FindSymbolProcInfo		\
	(kPascalStackBased	|			\
	RESULT_SIZE(kTwoByteCode) |	\
	STACK_ROUTINE_PARAMETER(1, kFourByteCode) |	\
	STACK_ROUTINE_PARAMETER(2, kFourByteCode) |	\
	STACK_ROUTINE_PARAMETER(3, kFourByteCode) |	\
	STACK_ROUTINE_PARAMETER(4, kFourByteCode))

extern OSErr pascal CountSymbols(ConnectionID connID, long *symCount);
#define CountSymbolsProcInfo	\
	(kPascalStackBased	|			\
	RESULT_SIZE(kTwoByteCode) |	\
	STACK_ROUTINE_PARAMETER(1, kFourByteCode) |	\
	STACK_ROUTINE_PARAMETER(2, kFourByteCode))

extern OSErr pascal GetIndSymbol(ConnectionID connID, long symIndex, Str255 symName, Ptr *symAddr, SymClass *symClass);
#define GetIndSymbolProcInfo	\
	(kPascalStackBased	|			\
	RESULT_SIZE(kTwoByteCode) |	\
	STACK_ROUTINE_PARAMETER(1, kFourByteCode) |	\
	STACK_ROUTINE_PARAMETER(2, kFourByteCode) |	\
	STACK_ROUTINE_PARAMETER(3, kFourByteCode) |	\
	STACK_ROUTINE_PARAMETER(4, kFourByteCode) |	\
	STACK_ROUTINE_PARAMETER(5, kFourByteCode))

#if PRAGMA_STRUCT_ALIGN
	#pragma options align=reset
#elif PRAGMA_STRUCT_PACKPUSH
	#pragma pack(pop)
#elif PRAGMA_STRUCT_PACK
	#pragma pack()
#endif

#ifdef PRAGMA_IMPORT_OFF
#pragma import off
#elif PRAGMA_IMPORT
#pragma import reset
#endif
#ifdef __cplusplus
}
#endif

#endif


