/*
	File:		Memory.h

	Copyright:	 1984-1993 by Apple Computer, Inc., all rights reserved.

	WARNING
	This file was auto generated by the interfacer tool. Modifications
	must be made to the master file.

*/

#ifndef __MEMORY__
#define __MEMORY__

#ifndef __TYPES__
#include <MacTypes.H>
#endif

#if PRAGMA_IMPORT
#pragma import on
#endif

#if PRAGMA_STRUCT_ALIGN
	#pragma options align=mac68k
#elif PRAGMA_STRUCT_PACKPUSH
	#pragma pack(push, 2)
#elif PRAGMA_STRUCT_PACK
	#pragma pack(2)
#endif
enum  {
	maxSize = 0x800000,
//#define maxSize	0x800000			/*Max data block size is 8 megabytes*/
	defaultPhysicalEntryCount	= 8,
/* values returned from the GetPageState function */
	kPageInMemory			= 0,
	kPageOnDisk			= 1,
	kNotPaged			= 2
};

enum  {
/* masks for Zone->heapType field */
	k32BitHeap			= 1,			/* valid in all Memory Managers */
	kNewStyleHeap			= 2,			/* true if new Heap Manager is present */
	kNewDebugHeap			= 4			/* true if new Heap Manager is running in debug mode on this heap */
};


/* size of a block in bytes */

typedef long Size;

typedef struct Zone Zone, *THz;

typedef long (pascal *GrowZoneProcPtr)(Size cbNeeded);

enum {
	uppGrowZoneProcInfo = kPascalStackBased
		| RESULT_SIZE(SIZE_CODE(sizeof(long)))
		| STACK_ROUTINE_PARAMETER(1, SIZE_CODE(sizeof(Size)))
};

#if USESROUTINEDESCRIPTORS
typedef UniversalProcPtr GrowZoneUPP;

#define CallGrowZoneProc(userRoutine, cbNeeded)		\
		CallUniversalProc((UniversalProcPtr)(userRoutine), uppGrowZoneProcInfo, (cbNeeded))
#define NewGrowZoneProc(userRoutine)		\
		(GrowZoneUPP) NewRoutineDescriptor((ProcPtr)(userRoutine), uppGrowZoneProcInfo, GetCurrentISA())
#else
typedef GrowZoneProcPtr GrowZoneUPP;

#define CallGrowZoneProc(userRoutine, cbNeeded)		\
		(*(userRoutine))((cbNeeded))
#define NewGrowZoneProc(userRoutine)		\
		(GrowZoneUPP)(userRoutine)
#endif

typedef void (pascal *PurgeProcPtr)(Handle blockToPurge);

enum {
	uppPurgeProcInfo = kPascalStackBased
		| STACK_ROUTINE_PARAMETER(1, SIZE_CODE(sizeof(Handle)))
};

#if USESROUTINEDESCRIPTORS
typedef UniversalProcPtr PurgeUPP;

#define CallPurgeProc(userRoutine, blockToPurge)		\
		CallUniversalProc((UniversalProcPtr)(userRoutine), uppPurgeProcInfo, (blockToPurge))
#define NewPurgeProc(userRoutine)		\
		(PurgeUPP) NewRoutineDescriptor((ProcPtr)(userRoutine), uppPurgeProcInfo, GetCurrentISA())
#else
typedef PurgeProcPtr PurgeUPP;

#define CallPurgeProc(userRoutine, blockToPurge)		\
		(*(userRoutine))((blockToPurge))
#define NewPurgeProc(userRoutine)		\
		(PurgeUPP)(userRoutine)
#endif

struct Zone {
	Ptr			bkLim;
	Ptr			purgePtr;
	Ptr			hFstFree;
	long			zcbFree;
	GrowZoneUPP			gzProc;
	short			moreMast;
	short			flags;
	short			cntRel;
	short			maxRel;
	short			cntNRel;
	Byte			heapType;
	Byte			unused;
	short			cntEmpty;
	short			cntHandles;
	long			minCBFree;
	PurgeUPP			purgeProc;
	Ptr			sparePtr;
	Ptr			allocPtr;
	short			heapData;
};
struct MemoryBlock {
	void			*address;
	unsigned long			count;
};
typedef struct MemoryBlock MemoryBlock;

struct LogicalToPhysicalTable {
	MemoryBlock			logical;
	MemoryBlock			physical[defaultPhysicalEntryCount];
};
typedef struct LogicalToPhysicalTable LogicalToPhysicalTable;

typedef short PageState;

typedef short StatusRegisterContents;


/*
	UserFnProcs cannot be written in or called from a high-level
	language without the help of mixed mode or assembly glue because they
	use the following parameter-passing convention:

	typedef pascal void (*UserFnProcPtr)(void *parameter);

		In:
			=>	parameter			A0.L
		Out:
			none
*/

enum  {
	uppUserFnProcInfo			= kRegisterBased|REGISTER_ROUTINE_PARAMETER(1,kRegisterA0,kFourByteCode)
};

#if USESROUTINEDESCRIPTORS
typedef void (pascal *UserFnProcPtr)(void *parameter);

typedef UniversalProcPtr UserFnUPP;

#define CallUserFnProc(userRoutine, parameter)  \
	CallUniversalProc((UniversalProcPtr)(userRoutine), uppUserFnProcInfo, (parameter))

#define NewUserFnProc(userRoutine)  \
	(UserFnUPP) NewRoutineDescriptor((ProcPtr)(userRoutine), uppUserFnProcInfo, GetCurrentISA())

#else
typedef ProcPtr UserFnUPP;

#define NewUserFnProc(userRoutine)  \
	(UserFnUPP)(userRoutine)

#endif

#ifdef __cplusplus
extern "C" {
#endif

#if USESCODEFRAGMENTS
extern Ptr pascal GetApplLimit(void);
extern THz pascal SystemZone(void);
extern THz pascal ApplicationZone(void);
extern Handle pascal GZSaveHnd(void);
extern Ptr pascal TopMem(void);
extern OSErr pascal MemError(void);
#else
#endif


extern THz pascal GetZone(void);

extern Handle pascal NewHandle(Size byteCount);

extern Handle pascal NewHandleSys(Size byteCount);

extern Handle pascal NewHandleClear(Size byteCount);

extern Handle pascal NewHandleSysClear(Size byteCount);

extern THz pascal HandleZone(Handle h);

extern Handle pascal RecoverHandle(Ptr p);

extern Handle pascal RecoverHandleSys(Ptr p);

extern Ptr pascal NewPtr(Size byteCount);

extern Ptr pascal NewPtrSys(Size byteCount);

extern Ptr pascal NewPtrClear(Size byteCount);

extern Ptr pascal NewPtrSysClear(Size byteCount);

extern THz pascal PtrZone(Ptr p);

extern long pascal MaxBlock(void);

extern long pascal MaxBlockSys(void);

extern long pascal StackSpace(void);

extern Handle pascal NewEmptyHandle(void);

extern Handle pascal NewEmptyHandleSys(void);

#if WINVER

#if Compile4DLL || SmartHeapSupport || PowerPlant
extern void pascal HLock(Handle h);
extern void pascal HUnlock(Handle h);
#else
#define	HLock( h )		h
#define	HUnlock( h )		h
#endif

#define	TempHLock( h, e )	(*e = noErr)
#define	TempHUnlock( h, e )	(*e = noErr)
#if PowerPlant
extern void pascal HLockHi(Handle h);
extern void pascal MoveHHi(Handle h);
#else
#define HLockHi( h )		h
#define MoveHHi(h)		h
#endif
extern void pascal HSetCBit( Handle h ); 
extern void pascal HClrCBit( Handle h ); 
extern short pascal HTstCBit( Handle h );

#else		// #if WINVER

extern void pascal HLock(Handle h);
extern void pascal HUnlock(Handle h);
extern void pascal HLockHi(Handle h);
extern void pascal MoveHHi(Handle h);

#endif		// #if WINVER

extern void pascal HPurge(Handle h);
extern void pascal HNoPurge(Handle h);

extern Handle pascal TempNewHandle(Size logicalSize, OSErr *resultCode);
extern Size pascal TempMaxMem(Size *grow);
extern long pascal TempFreeMem(void);

/*  Temporary Memory routines renamed, but obsolete, in System 7.0 and later.  */
#if !WINVER
extern void pascal TempHLock(Handle h, OSErr *resultCode);
extern void pascal TempHUnlock(Handle h, OSErr *resultCode);
#endif
extern void pascal TempDisposeHandle(Handle h, OSErr *resultCode);
extern Ptr pascal TempTopMem(void);
extern void pascal InitApplZone(void);
extern void pascal InitZone(GrowZoneUPP pgrowZone, short cmoreMasters, void *limitPtr, void *startPtr);

extern void pascal SetZone(THz hz);

extern Size pascal CompactMem(Size cbNeeded);

extern Size pascal CompactMemSys(Size cbNeeded);

extern void pascal PurgeMem(Size cbNeeded);

extern void pascal PurgeMemSys(Size cbNeeded);

extern long pascal FreeMem(void);

extern long pascal FreeMemSys(void);

extern void pascal ReserveMem(Size cbNeeded);

extern void pascal ReserveMemSys(Size cbNeeded);

extern Size pascal MaxMem(Size *grow);

extern Size pascal MaxMemSys(Size *grow);

extern void pascal SetGrowZone(GrowZoneUPP growZone);

extern void pascal SetApplLimit(void *zoneLimit);

extern void pascal DisposePtr(Ptr p);
extern Size pascal GetPtrSize(Ptr p);
extern Boolean pascal SetPtrSize(Ptr p, Size newSize);

extern void pascal DisposeHandle(Handle h);
extern Boolean pascal SetHandleSize(Handle h, Size newSize);
extern Size pascal GetHandleSize(Handle h);

#if WINVER
#define InlineGetHandleSize GetHandleSize
#else
extern Size pascal InlineGetHandleSize(Handle h);
#endif
extern void pascal ReallocateHandle(Handle h, Size byteCount);

extern void pascal EmptyHandle(Handle h);

extern void pascal HSetRBit(Handle h);

extern void pascal HClrRBit(Handle h);
extern void pascal MoreMasters(void);

extern void pascal BlockMove(const void *srcPtr, void *destPtr, Size byteCount);

extern void pascal BlockMoveData(const void *srcPtr, void *destPtr, Size byteCount);
extern void pascal PurgeSpace(long *total, long *contig);

extern char pascal HGetState(Handle h);

extern void pascal HSetState(Handle h, char flags);

extern void pascal SetApplBase(void *startPtr);
extern void pascal MaxApplZone(void);

extern OSErr pascal HoldMemory(void *address, unsigned long count);

extern OSErr pascal UnholdMemory(void *address, unsigned long count);

extern OSErr pascal LockMemory(void *address, unsigned long count);

extern OSErr pascal LockMemoryContiguous(void *address, unsigned long count);

extern OSErr pascal UnlockMemory(void *address, unsigned long count);
extern OSErr pascal GetPhysical(LogicalToPhysicalTable *addresses, unsigned long *physicalEntryCount);

extern OSErr pascal DeferUserFn(UserFnUPP userFunction, void *argument);

extern long pascal DebuggerGetMax(void);
extern void pascal DebuggerEnter(void);
extern void pascal DebuggerExit(void);
extern void pascal DebuggerPoll(void);

extern PageState pascal GetPageState(const void *address);

extern Boolean pascal PageFaultFatal(void);

extern OSErr pascal DebuggerLockMemory(void *address, unsigned long count);

extern OSErr pascal DebuggerUnlockMemory(void *address, unsigned long count);

extern StatusRegisterContents pascal EnterSupervisorMode(void);
#if USES68KINLINES
#if SystemSixOrLater

extern Ptr pascal StripAddress(void *theAddress);
#else
extern Ptr pascal StripAddress(void *theAddress);
#endif

#else
#define StripAddress(x) ((Ptr)(x))

#endif

#if USES68KINLINES

extern Ptr pascal Translate24To32(void *addr24);
#else
#define Translate24To32(x) ((Ptr)(x))

#endif

#if OLDROUTINENAMES
#define ApplicZone ApplicationZone

#define MFTempNewHandle(logicalSize, resultCode) TempNewHandle(logicalSize, resultCode)

#define MFMaxMem(grow) TempMaxMem(grow)

#define MFFreeMem() TempFreeMem()

#define MFTempHLock(h, resultCode) TempHLock(h, resultCode)

#define MFTempHUnlock(h, resultCode) TempHUnlock(h, resultCode)

#define MFTempDisposHandle(h, resultCode) TempDisposeHandle(h, resultCode)

#define MFTopMem() TempTopMem()

#define ResrvMem(cbNeeded) ReserveMem(cbNeeded)

#define DisposPtr(p) DisposePtr(p)

#define DisposHandle(h) DisposeHandle(h)

#define ReallocHandle(h, byteCount) ReallocateHandle(h, byteCount)

#endif

#if PRAGMA_STRUCT_ALIGN
	#pragma options align=reset
#elif PRAGMA_STRUCT_PACKPUSH
	#pragma pack(pop)
#elif PRAGMA_STRUCT_PACK
	#pragma pack()
#endif

#ifdef PRAGMA_IMPORT_OFF
#pragma import off
#elif PRAGMA_IMPORT
#pragma import reset
#endif
#ifdef __cplusplus
}
#endif

#endif


