/*
	File:		MIDI.h

	Copyright:	 1984-1993 by Apple Computer, Inc., all rights reserved.

	WARNING
	This file was auto generated by the interfacer tool. Modifications
	must be made to the master file.

*/

#ifndef __MIDI__
#define __MIDI__

#ifndef __TYPES__
#include <MacTypes.H>
#endif

#if PRAGMA_IMPORT
#pragma import on
#endif

#if PRAGMA_STRUCT_ALIGN
	#pragma options align=mac68k
#elif PRAGMA_STRUCT_PACKPUSH
	#pragma pack(push, 2)
#elif PRAGMA_STRUCT_PACK
	#pragma pack(2)
#endif

#define midiToolNum 4

enum  {
	midiMaxNameLen			= 31,			/*maximum number of characters in port and client names*/
/* Time formats */
	midiFormatMSec			= 0,			/*milliseconds*/
	midiFormatBeats			= 1,			/*beats*/
	midiFormat24fpsBit		= 2,			/*24 frames/sec.*/
	midiFormat25fpsBit		= 3,			/*25 frames/sec.*/
	midiFormat30fpsDBit		= 4,			/*30 frames/sec. drop-frame*/
	midiFormat30fpsBit		= 5,			/*30 frames/sec.*/
	midiFormat24fpsQF		= 6,			/*24 frames/sec. longInt format */
	midiFormat25fpsQF		= 7,			/*25 frames/sec. longInt format */
	midiFormat30fpsDQF		= 8,			/*30 frames/sec. drop-frame longInt format */
	midiFormat30fpsQF		= 9,			/*30 frames/sec. longInt format */
	midiInternalSync		= 0,			/*internal sync*/
	midiExternalSync		= 1,			/*external sync*/
/* Port types*/
	midiPortTypeTime		= 0,			/*time port*/
	midiPortTypeInput		= 1,			/*input port*/
	midiPortTypeOutput		= 2,			/*output port*/
	midiPortTypeTimeInv		= 3			/*invisible time port*/
/* OffsetTimes  */
#define midiGetEverything	0x7FFFFFFFL	/*get all packets, regardless of time stamps*/
#define	midiGetNothing		0x80000000L	/*get no packets, regardless of time stamps*/
#define	midiGetCurrent		0		/*get current packets only*/
};

enum  {
/*	MIDI data and messages are passed in MIDIPacket records (see below).
	The first byte of every MIDIPacket contains a set of flags

	bits 0-1	00 = new MIDIPacket, not continued
			01 = begining of continued MIDIPacket
			10 = end of continued MIDIPacket
			11 = continuation
	bits 2-3	reserved

	bits 4-6	000 = packet contains MIDI data

			001 = packet contains MIDI Manager message

	bit 7		0 = MIDIPacket has valid stamp
			1 = stamp with current clock */
	midiContMask			= 0x03,
	midiNoCont			= 0x00,
	midiStartCont			= 0x01,
	midiMidCont			= 0x03,
	midiEndCont			= 0x02,
	midiTypeMask			= 0x70,
	midiMsgType			= 0x00,
	midiMgrType			= 0x10,
	midiTimeStampMask			= 0x80,
	midiTimeStampCurrent		= 0x80,
	midiTimeStampValid			= 0x00,
/*	MIDI Manager MIDIPacket command words (the first word in the data field
	for midiMgrType messages) */
	midiOverflowErr			= 0x0001,
	midiSCCErr			= 0x0002,
	midiPacketErr			= 0x0003,
	midiMaxErr			= 0x00FF,			/*all command words less than this value  are error indicators*/
/* Valid results to be returned by readHooks */
	midiKeepPacket			= 0,
	midiMorePacket			= 1,
	midiNoMorePacket			= 2,
/* Errors: */
	midiNoClientErr			= -250,			/*no client with that ID found*/
	midiNoPortErr			= -251			/*no port with that ID found*/
};

enum  {
	midiTooManyPortsErr			= -252,			/*too many ports already installed in the system*/
	midiTooManyConsErr			= -253,			/*too many connections made*/
	midiVConnectErr			= -254,			/*pending virtual connection created*/
	midiVConnectMade			= -255,			/*pending virtual connection resolved*/
	midiVConnectRmvd			= -256,			/*pending virtual connection removed*/
	midiNoConErr			= -257,			/*no connection exists between specified ports*/
	midiWriteErr			= -258,			/*MIDIWritePacket couldn't write to all connected ports*/
	midiNameLenErr			= -259,			/*name supplied is longer than 31 characters*/
	midiDupIDErr			= -260,			/*duplicate client ID*/
	midiInvalidCmdErr			= -261,			/*command not supported for port type*/
/*	Driver calls: */
	midiOpenDriver			= 1,
	midiCloseDriver			= 2
};

struct MIDIPacket {
	unsigned char			flags;
	unsigned char			len;
	long			tStamp;
	unsigned char			data[249];
};
typedef struct MIDIPacket MIDIPacket;

typedef MIDIPacket *MIDIPacketPtr;

struct MIDIClkInfo {
	short			sync;			/*synchronization external/internal*/
	long			curTime;			/*current value of port's clock*/
	short			format;			/*time code format*/
};
typedef struct MIDIClkInfo MIDIClkInfo;

struct MIDIIDRec {
	OSType			clientID;
	OSType			portID;
};
typedef struct MIDIIDRec MIDIIDRec;

struct MIDIPortInfo {
	short			portType;			/*type of port*/
	MIDIIDRec			timeBase;			/*MIDIIDRec for time base*/
	short			numConnects;			/*number of connections*/
	MIDIIDRec			cList[1];			/*ARRAY [1..numConnects] of MIDIIDRec*/
};
typedef struct MIDIPortInfo MIDIPortInfo;

typedef MIDIPortInfo *MIDIPortInfoPtr, **MIDIPortInfoHdl;

struct MIDIPortParams {
	OSType			portID;			/*ID of port, unique within client*/
	short			portType;			/*Type of port - input, output, time, etc.*/
	short			timeBase;			/*refnum of time base, 0 if none*/
	long			offsetTime;			/*offset for current time stamps*/
	Ptr			readHook;			/*routine to call when input data is valid*/
	long			refCon;			/*refcon for port (for client use)*/
	MIDIClkInfo			initClock;			/*initial settings for a time base*/
	Str255			name;			/*name of the port, This is a real live string, not a ptr.*/
};
typedef struct MIDIPortParams MIDIPortParams;

typedef MIDIPortParams *MIDIPortParamsPtr;

struct MIDIIDList {
	short			numIDs;
	OSType			list[1];
};
typedef struct MIDIIDList MIDIIDList;

typedef MIDIIDList *MIDIIDListPtr, **MIDIIDListHdl;

#ifdef __cplusplus
extern "C" {
#endif

/*

	Prototype Declarations for readHook and timeProc

	extern pascal short myReadHook(MIDIPacketPtr myPacket, long myRefCon);
	extern pascal void myTimeProc(long curTime, long myRefCon);

	MIDI Manager Routines
*/

extern NumVersion pascal MIDIVersion(void);
extern OSErr pascal MIDISignIn(OSType clientID, long refCon, Handle icon, ConstStr255Param name);
extern void pascal MIDISignOut(OSType clientID);
extern MIDIIDListHdl pascal MIDIGetClients(void);
extern void pascal MIDIGetClientName(OSType clientID, Str255 name);
extern void pascal MIDISetClientName(OSType clientID, ConstStr255Param name);
extern MIDIIDListHdl pascal MIDIGetPorts(OSType clientID);
extern OSErr pascal MIDIAddPort(OSType clientID, short BufSize, short *refnum, MIDIPortParamsPtr init);
extern MIDIPortInfoHdl pascal MIDIGetPortInfo(OSType clientID, OSType portID);
extern OSErr pascal MIDIConnectData(OSType srcClID, OSType srcPortID, OSType dstClID, OSType dstPortID);
extern OSErr pascal MIDIUnConnectData(OSType srcClID, OSType srcPortID, OSType dstClID, OSType dstPortID);
extern OSErr pascal MIDIConnectTime(OSType srcClID, OSType srcPortID, OSType dstClID, OSType dstPortID);
extern OSErr pascal MIDIUnConnectTime(OSType srcClID, OSType srcPortID, OSType dstClID, OSType dstPortID);
extern void pascal MIDIFlush(short refnum);
extern ProcPtr pascal MIDIGetReadHook(short refnum);
extern void pascal MIDISetReadHook(short refnum, ProcPtr hook);
extern void pascal MIDIGetPortName(OSType clientID, OSType portID, Str255 name);
extern void pascal MIDISetPortName(OSType clientID, OSType portID, ConstStr255Param name);
extern void pascal MIDIWakeUp(short refnum, long time, long period, ProcPtr timeProc);
extern void pascal MIDIRemovePort(short refnum);
extern short pascal MIDIGetSync(short refnum);
extern void pascal MIDISetSync(short refnum, short sync);
extern long pascal MIDIGetCurTime(short refnum);
extern void pascal MIDISetCurTime(short refnum, long time);
extern void pascal MIDIStartTime(short refnum);
extern void pascal MIDIStopTime(short refnum);
extern void pascal MIDIPoll(short refnum, long offsetTime);
extern OSErr pascal MIDIWritePacket(short refnum, MIDIPacketPtr packet);
extern Boolean pascal MIDIWorldChanged(OSType clientID);
extern long pascal MIDIGetOffsetTime(short refnum);
extern void pascal MIDISetOffsetTime(short refnum, long offsetTime);
extern long pascal MIDIConvertTime(short srcFormat, short dstFormat, long time);
extern long pascal MIDIGetRefCon(short refnum);
extern void pascal MIDISetRefCon(short refnum, long refCon);
extern long pascal MIDIGetClRefCon(OSType clientID);
extern void pascal MIDISetClRefCon(OSType clientID, long refCon);
extern short pascal MIDIGetTCFormat(short refnum);
extern void pascal MIDISetTCFormat(short refnum, short format);
extern void pascal MIDISetRunRate(short refnum, short rate, long time);
extern Handle pascal MIDIGetClientIcon(OSType clientID);
extern long pascal SndDispVersion(short toolnum);
#if PRAGMA_STRUCT_ALIGN
	#pragma options align=reset
#elif PRAGMA_STRUCT_PACKPUSH
	#pragma pack(pop)
#elif PRAGMA_STRUCT_PACK
	#pragma pack()
#endif

#ifdef PRAGMA_IMPORT_OFF
#pragma import off
#elif PRAGMA_IMPORT
#pragma import reset
#endif
#ifdef __cplusplus
}
#endif

#endif


