/*
	File:		Palettes.h

	Copyright:	 1984-1993 by Apple Computer, Inc., all rights reserved.

	WARNING
	This file was auto generated by the interfacer tool. Modifications
	must be made to the master file.

*/

#ifndef __PALETTES__
#define __PALETTES__

#ifndef __QUICKDRAW__
#if LONG_FILENAMES
#include <Quickdraw.H>
#else
#include <Quickdra.H>
#endif
#endif

#ifndef __WINDOWS__
#include <WindowM.H>
#endif

#if PRAGMA_IMPORT
#pragma import on
#endif

#if PRAGMA_STRUCT_ALIGN
	#pragma options align=mac68k
#elif PRAGMA_STRUCT_PACKPUSH
	#pragma pack(push, 2)
#elif PRAGMA_STRUCT_PACK
	#pragma pack(2)
#endif

enum  {
	pmCourteous			= 0,			/*Record use of color on each device touched.*/
	pmTolerant			= 0x0002,			/*render ciRGB if ciTolerance is exceeded by best match.*/
	pmAnimated			= 0x0004,			/*reserve an index on each device touched and render ciRGB.*/
	pmExplicit			= 0x0008,			/*no reserve, no render, no record; stuff index into port.*/
	pmWhite			= 0x0010,
	pmBlack			= 0x0020,
	pmInhibitG2			= 0x0100,
	pmInhibitC2			= 0x0200,
	pmInhibitG4			= 0x0400,
	pmInhibitC4			= 0x0800,
	pmInhibitG8			= 0x1000,
	pmInhibitC8			= 0x2000
/* NSetPalette Update Constants */
#define pmNoUpdates	0x8000			/*no updates*/
#define pmBkUpdates	0xA000			/*background updates only*/
#define pmFgUpdates	0xC000			/*foreground updates only*/
#define pmAllUpdates	0xE000			/*all updates*/
};

struct ColorInfo {
	RGBColor			ciRGB;			/*true RGB values*/
	short			ciUsage;			/*color usage*/
	short			ciTolerance;			/*tolerance value*/
#if WINVER
	short		ciFlags;
	long		ciPrivate;
#else
	short			ciDataFields[3];			/*private fields*/
#endif
};
typedef struct ColorInfo ColorInfo;

struct Palette {
	short			pmEntries;			/*entries in pmTable*/
#if WINVER
	GrafPtr		pmWindow;
	short		pmPrivate;
	long		pmDevices;
	long		pmSeeds;
#else
	short			pmDataFields[7];			/*private fields*/
#endif
	ColorInfo			pmInfo[1];
};
typedef struct Palette Palette;

typedef Palette *PalettePtr, **PaletteHandle;

#ifdef __cplusplus
extern "C" {
#endif

extern void pascal InitPalettes(void);
extern PaletteHandle pascal NewPalette(short entries, CTabHandle srcColors, short srcUsage, short srcTolerance);
extern PaletteHandle pascal GetNewPalette(short PaletteID);
extern void pascal DisposePalette(PaletteHandle srcPalette);
extern void pascal ActivatePalette(WindowPtr srcWindow);
extern void pascal SetPalette(WindowPtr dstWindow, PaletteHandle srcPalette, Boolean cUpdates);
extern void pascal NSetPalette(WindowPtr dstWindow, PaletteHandle srcPalette, short nCUpdates);
extern PaletteHandle pascal GetPalette(WindowPtr srcWindow);
extern void pascal CopyPalette(PaletteHandle srcPalette, PaletteHandle dstPalette, short srcEntry, short dstEntry, short dstLength);
extern void pascal PmForeColor(short dstEntry);
extern void pascal PmBackColor(short dstEntry);
extern void pascal AnimateEntry(WindowPtr dstWindow, short dstEntry, const RGBColor *srcRGB);
extern void pascal AnimatePalett(WindowPtr dstWindow, CTabHandle srcCTab, short srcIndex, short dstEntry, short dstLength);
extern void pascal GetEntryColor(PaletteHandle srcPalette, short srcEntry, RGBColor *dstRGB);
extern void pascal SetEntryColor(PaletteHandle dstPalette, short dstEntry, const RGBColor *srcRGB);
extern void pascal GetEntryUsage(PaletteHandle srcPalette, short srcEntry, short *dstUsage, short *dstTolerance);
extern void pascal SetEntryUsage(PaletteHandle dstPalette, short dstEntry, short srcUsage, short srcTolerance);
extern void pascal CTab2Palette(CTabHandle srcCTab, PaletteHandle dstPalette, short srcUsage, short srcTolerance);
extern void pascal Palette2CTab(PaletteHandle srcPalette, CTabHandle dstCTab);
extern long pascal Entry2Index(short entry);
extern void pascal RestoreDeviceClut(GDHandle gd);
extern void pascal ResizePalett(PaletteHandle p, short size);
extern void pascal SaveFore(ColorSpec *c);
extern void pascal SaveBack(ColorSpec *c);
extern void pascal RestoreFore(const ColorSpec *c);
extern void pascal RestoreBack(const ColorSpec *c);
extern OSErr pascal SetDepth(GDHandle gd, short depth, short whichFlags, short flags);
extern short pascal HasDepth(GDHandle gd, short depth, short whichFlags, short flags);
extern short pascal PMgrVersion(void);
extern void pascal SetPaletteUpdates(PaletteHandle p, short updates);
extern short pascal GetPaletteUpdates(PaletteHandle p);
extern Boolean pascal GetGray(GDHandle device, const RGBColor *backGround, RGBColor *foreGround);
#if PRAGMA_STRUCT_ALIGN
	#pragma options align=reset
#elif PRAGMA_STRUCT_PACKPUSH
	#pragma pack(pop)
#elif PRAGMA_STRUCT_PACK
	#pragma pack()
#endif

#ifdef PRAGMA_IMPORT_OFF
#pragma import off
#elif PRAGMA_IMPORT
#pragma import reset
#endif

#ifdef __cplusplus
}
#endif

#endif


