/*
	File:		Power.h

	Copyright:	 1984-1993 by Apple Computer, Inc., all rights reserved.

	WARNING
	This file was auto generated by the interfacer tool. Modifications
	must be made to the master file.

*/

#ifndef __POWER__
#define __POWER__

#ifndef __TYPES__
#include <MacTypes.H>
#endif

#if PRAGMA_IMPORT
#pragma import on
#endif

#if PRAGMA_STRUCT_ALIGN
	#pragma options align=mac68k
#elif PRAGMA_STRUCT_PACKPUSH
	#pragma pack(push, 2)
#elif PRAGMA_STRUCT_PACK
	#pragma pack(2)
#endif

enum  {
/* Bit positions for ModemByte */
	modemOnBit			= 0,
	ringWakeUpBit			= 2,
	modemInstalledBit			= 3,
	ringDetectBit			= 4,
	modemOnHookBit			= 5,
/* masks for ModemByte */
	modemOnMask			= 0x1,
	ringWakeUpMask			= 0x4,
	modemInstalledMask			= 0x8,
	ringDetectMask			= 0x10,
	modemOnHookMask			= 0x20,
/* bit positions for BatteryByte */
	chargerConnBit			= 0,
	hiChargeBit			= 1,
	chargeOverFlowBit			= 2,
	batteryDeadBit			= 3,
	batteryLowBit			= 4,
	connChangedBit			= 5,
/* masks for BatteryByte */
	chargerConnMask			= 0x1,
	hiChargeMask			= 0x2,
	chargeOverFlowMask			= 0x4,
	batteryDeadMask			= 0x8
};

enum  {
	batteryLowMask			= 0x10,
	connChangedMask			= 0x20,
/* commands to SleepQRec sleepQProc */
	sleepRequest			= 1,
	sleepDemand			= 2,
	sleepWakeUp			= 3,
	sleepRevoke			= 4,
/* SleepQRec.sleepQFlags */
	noCalls			= 1,
	noRequest			= 2,
	slpQType			= 16,
	sleepQType			= 16
};

typedef char ModemByte;

typedef char BatteryByte;

typedef long PMResultCode;

typedef struct SleepQRec SleepQRec, *SleepQRecPtr;


/*
	SleepQProcs cannot be written in or called from a high-level
	language without the help of mixed mode or assembly glue because they
	use the following parameter-passing convention:

	typedef pascal long (*SleepQProcPtr)(long message, SleepQRecPtr qRecPtr);

		In:
			=>	message			D0.L
			=>	qRecPtr			A0.L
		Out:
			<=	long			D0.L
*/

enum  {
	uppSleepQProcInfo			= kRegisterBased|RESULT_SIZE(kFourByteCode)|REGISTER_RESULT_LOCATION(kRegisterD0)|REGISTER_ROUTINE_PARAMETER(1,kRegisterD0,kFourByteCode)|REGISTER_ROUTINE_PARAMETER(2,kRegisterA0,kFourByteCode)
};

#if USESROUTINEDESCRIPTORS
typedef long (pascal *SleepQProcPtr)(long message, SleepQRecPtr qRecPtr);

typedef UniversalProcPtr SleepQUPP;

#define CallSleepQProc(userRoutine, message, qRecPtr)  \
	CallUniversalProc((UniversalProcPtr)(userRoutine), (uppSleepQProcInfo), (cbNeeded))

#define NewSleepQProc(userRoutine)  \
	(SleepQUPP) NewRoutineDescriptor((ProcPtr)(userRoutine), uppSleepQProcInfo, GetCurrentISA())

#else
typedef ProcPtr SleepQUPP;

#define NewSleepQProc(userRoutine)  \
	(SleepQUPP)(userRoutine)

#endif

struct SleepQRec {
	struct SleepQRec			*sleepQLink;
	short			sleepQType;			/*type = 16*/
	SleepQUPP			sleepQProc;			/*Pointer to sleep universal proc ptr*/
	short			sleepQFlags;
};
#ifdef __cplusplus
extern "C" {
#endif

extern OSErr pascal DisableWUTime(void);
extern OSErr pascal GetWUTime(long *WUTime, Byte *WUFlag);
extern OSErr pascal SetWUTime(long WUTime);
extern OSErr pascal BatteryStatus(Byte *Status, Byte *Power);
extern OSErr pascal ModemStatus(Byte *Status);

extern long pascal IdleUpdate(void);

extern long pascal GetCPUSpeed(void);
extern void pascal EnableIdle(void);
extern void pascal DisableIdle(void);

extern void pascal SleepQInstall(SleepQRecPtr qRecPtr);

extern void pascal SleepQRemove(SleepQRecPtr qRecPtr);
extern void pascal AOn(void);
extern void pascal AOnIgnoreModem(void);
extern void pascal BOn(void);
extern void pascal AOff(void);
extern void pascal BOff(void);
#if PRAGMA_STRUCT_ALIGN
	#pragma options align=reset
#elif PRAGMA_STRUCT_PACKPUSH
	#pragma pack(pop)
#elif PRAGMA_STRUCT_PACK
	#pragma pack()
#endif

#ifdef PRAGMA_IMPORT_OFF
#pragma import off
#elif PRAGMA_IMPORT
#pragma import reset
#endif

#ifdef __cplusplus
}
#endif

#endif


