/*
	File:		PPCToolBox.h

	Copyright:	 1984-1993 by Apple Computer, Inc., all rights reserved.

	WARNING
	This file was auto generated by the interfacer tool. Modifications
	must be made to the master file.

*/

#ifndef __PPCTOOLBOX__
#define __PPCTOOLBOX__

#ifndef __APPLETALK__
#if LONG_FILENAMES
#include <AppleTalk.H>
#else
#include <AppleTal.H>
#endif
#endif

#ifndef __MEMORY__
#if MACVER
#include <Memory.h>
#else
#include <MemoryM.h>
#endif
#endif


#if PRAGMA_IMPORT
#pragma import on
#endif

#if PRAGMA_STRUCT_ALIGN
	#pragma options align=mac68k
#elif PRAGMA_STRUCT_PACKPUSH
	#pragma pack(push, 2)
#elif PRAGMA_STRUCT_PACK
	#pragma pack(2)
#endif

typedef unsigned char PPCServiceType;

enum  {
	ppcServiceRealTime			= 1
};

typedef short PPCLocationKind;

enum  {
	ppcNoLocation			= 0,			/* There is no PPCLocName */
	ppcNBPLocation			= 1,			/* Use AppleTalk NBP	*/
	ppcNBPTypeLocation			= 2			/* Used for specifying a location name type during PPCOpen only */
};

typedef short PPCPortKinds;

enum  {
	ppcByCreatorAndType			= 1,			/* Port type is specified as colloquial Mac creator and type */
	ppcByString			= 2			/* Port type is in pascal string format */
};


/* Values returned for request field in PPCInform call */

typedef unsigned char PPCSessionOrigin;

enum  {
/* Values returned for requestType field in PPCInform call */
	ppcLocalOrigin			= 1,			/* session originated from this machine */
	ppcRemoteOrigin			= 2			/* session originated from remote machine */
};

typedef short PPCPortRefNum;

typedef long PPCSessRefNum;

struct PPCPortRec {
	ScriptCode			nameScript;			/* script of name */
	Str32			name;			/* name of port as seen in browser */
	PPCPortKinds			portKindSelector;			/* which variant */
	union {
		Str32			portTypeStr;			/* pascal type string */
		struct {
			OSType			creator;
			OSType			type;
		}			port;
	}			u;
};
typedef struct PPCPortRec PPCPortRec;

typedef PPCPortRec *PPCPortPtr;

struct LocationNameRec {
	PPCLocationKind			locationKindSelector;			/* which variant */
	union {
		EntityName			nbpEntity;			/* NBP name entity */
		Str32			nbpType;			/* just the NBP type string, for PPCOpen */
	}			u;
};
typedef struct LocationNameRec LocationNameRec;

typedef LocationNameRec *LocationNamePtr;

struct PortInfoRec {
	unsigned char			filler1;
	Boolean			authRequired;
	PPCPortRec			name;
};
typedef struct PortInfoRec PortInfoRec;

typedef PortInfoRec *PortInfoPtr;

typedef PortInfoRec *PortInfoArrayPtr;

typedef union PPCParamBlockRec PPCParamBlockRec, *PPCParamBlockPtr;

typedef Boolean (pascal *PPCFilterProcPtr)(LocationNamePtr, PortInfoPtr);

enum {
	uppPPCFilterProcInfo = kPascalStackBased
		| RESULT_SIZE(SIZE_CODE(sizeof(Boolean)))
		| STACK_ROUTINE_PARAMETER(1, SIZE_CODE(sizeof(LocationNamePtr)))
		| STACK_ROUTINE_PARAMETER(2, SIZE_CODE(sizeof(PortInfoPtr)))
};

#if USESROUTINEDESCRIPTORS
typedef UniversalProcPtr PPCFilterUPP;

#define CallPPCFilterProc(userRoutine, parameter0, parameter1)		\
		CallUniversalProc((UniversalProcPtr)(userRoutine), uppPPCFilterProcInfo, (parameter0), (parameter1))
#define NewPPCFilterProc(userRoutine)		\
		(PPCFilterUPP) NewRoutineDescriptor((ProcPtr)(userRoutine), uppPPCFilterProcInfo, GetCurrentISA())
#else
typedef PPCFilterProcPtr PPCFilterUPP;

#define CallPPCFilterProc(userRoutine, parameter0, parameter1)		\
		(*(userRoutine))((parameter0), (parameter1))
#define NewPPCFilterProc(userRoutine)		\
		(PPCFilterUPP)(userRoutine)
#endif

typedef void (pascal *PPCCompProcPtr)(PPCParamBlockPtr pb);

enum {
	uppPPCCompProcInfo = kPascalStackBased
		| STACK_ROUTINE_PARAMETER(1, SIZE_CODE(sizeof(PPCParamBlockPtr)))
};

#if USESROUTINEDESCRIPTORS
typedef UniversalProcPtr PPCCompUPP;

#define CallPPCCompProc(userRoutine, pb)		\
		CallUniversalProc((UniversalProcPtr)(userRoutine), uppPPCCompProcInfo, (pb))
#define NewPPCCompProc(userRoutine)		\
		(PPCCompUPP) NewRoutineDescriptor((ProcPtr)(userRoutine), uppPPCCompProcInfo, GetCurrentISA())
#else
typedef PPCCompProcPtr PPCCompUPP;

#define CallPPCCompProc(userRoutine, pb)		\
		(*(userRoutine))((pb))
#define NewPPCCompProc(userRoutine)		\
		(PPCCompUPP)(userRoutine)
#endif

#define PPCHeader			\
	Ptr qLink;			\
	unsigned short csCode;		\
	unsigned short intUse;		\
	Ptr intUsePtr;			\
			\
	PPCCompUPP ioCompletion;		\
			\
	OSErr ioResult;			\
	unsigned long	Reserved[5];

struct PPCOpenPBRec {
	Ptr			qLink;
	unsigned short			csCode;
	unsigned short			intUse;
	Ptr			intUsePtr;
	PPCCompUPP			ioCompletion;
	OSErr			ioResult;
	unsigned long			Reserved[5];
	PPCPortRefNum			portRefNum;			/* 38 <--   Port Reference */
	long			filler1;
	PPCServiceType			serviceType;			/* 44 -->	Bit field describing the requested port service */
	unsigned char			resFlag;			/* Must be set to 0 */
	PPCPortPtr			portName;			/* 46 -->   PortName for PPC */
	LocationNamePtr			locationName;			/* 50 -->   If NBP Registration is required */
	Boolean			networkVisible;			/* 54 -->   make this network visible on network */
	Boolean			nbpRegistered;			/* 55 <--   The given location name was registered on the network */
};
typedef struct PPCOpenPBRec PPCOpenPBRec;

typedef PPCOpenPBRec *PPCOpenPBPtr;

struct PPCInformPBRec {
	Ptr			qLink;
	unsigned short			csCode;
	unsigned short			intUse;
	Ptr			intUsePtr;
	PPCCompUPP			ioCompletion;
	OSErr			ioResult;
	unsigned long			Reserved[5];
	PPCPortRefNum			portRefNum;			/* 38 -->   Port Identifier */
	PPCSessRefNum			sessRefNum;			/* 40 <--   Session Reference */
	PPCServiceType			serviceType;			/* 44 <--   Status Flags for type of session, local, remote */
	Boolean			autoAccept;			/* 45 -->   if true session will be accepted automatically */
	PPCPortPtr			portName;			/* 46 -->   Buffer for Source PPCPortRec */
	LocationNamePtr			locationName;			/* 50 -->   Buffer for Source LocationNameRec */
	StringPtr			userName;			/* 54 -->   Buffer for Soure user's name trying to link. */
	unsigned long			userData;			/* 58 <--   value included in PPCStart's userData */
	PPCSessionOrigin			requestType;			/* 62 <--   Local or Network */
};
typedef struct PPCInformPBRec PPCInformPBRec;

typedef PPCInformPBRec *PPCInformPBPtr;

struct PPCStartPBRec {
	Ptr			qLink;
	unsigned short			csCode;
	unsigned short			intUse;
	Ptr			intUsePtr;
	PPCCompUPP			ioCompletion;
	OSErr			ioResult;
	unsigned long			Reserved[5];
	PPCPortRefNum			portRefNum;			/* 38 -->   Port Identifier */
	PPCSessRefNum			sessRefNum;			/* 40 <--   Session Reference */
	PPCServiceType			serviceType;			/* 44 <--   Actual service method (realTime) */
	unsigned char			resFlag;			/* 45 -->   Must be set to 0  */
	PPCPortPtr			portName;			/* 46 -->   Destination portName */
	LocationNamePtr			locationName;			/* 50 -->   NBP or NAS style service location name */
	unsigned long			rejectInfo;			/* 54 <--   reason for rejecting the session request */
	unsigned long			userData;			/* 58 -->   Copied to destination PPCInform parameter block */
	unsigned long			userRefNum;			/* 62 -->   userRefNum (obtained during login process)  */
};
typedef struct PPCStartPBRec PPCStartPBRec;

typedef PPCStartPBRec *PPCStartPBPtr;

struct PPCAcceptPBRec {
	Ptr			qLink;
	unsigned short			csCode;
	unsigned short			intUse;
	Ptr			intUsePtr;
	PPCCompUPP			ioCompletion;
	OSErr			ioResult;
	unsigned long			Reserved[5];
	short			filler1;
	PPCSessRefNum			sessRefNum;			/* 40 -->   Session Reference */
};
typedef struct PPCAcceptPBRec PPCAcceptPBRec;

typedef PPCAcceptPBRec *PPCAcceptPBPtr;

struct PPCRejectPBRec {
	Ptr			qLink;
	unsigned short			csCode;
	unsigned short			intUse;
	Ptr			intUsePtr;
	PPCCompUPP			ioCompletion;
	OSErr			ioResult;
	unsigned long			Reserved[5];
	short			filler1;
	PPCSessRefNum			sessRefNum;			/* 40 -->   Session Reference */
	short			filler2;
	long			filler3;
	long			filler4;
	unsigned long			rejectInfo;			/* 54 -->   reason for rejecting the session request  */
};
typedef struct PPCRejectPBRec PPCRejectPBRec;

typedef PPCRejectPBRec *PPCRejectPBPtr;

struct PPCWritePBRec {
	Ptr			qLink;
	unsigned short			csCode;
	unsigned short			intUse;
	Ptr			intUsePtr;
	PPCCompUPP			ioCompletion;
	OSErr			ioResult;
	unsigned long			Reserved[5];
	short			filler1;
	PPCSessRefNum			sessRefNum;			/* 40 -->   Session Reference */
	Size			bufferLength;			/* 44 -->   Length of the message buffer */
	Size			actualLength;			/* 48 <--   Actual Length Written */
	Ptr			bufferPtr;			/* 52 -->   Pointer to message buffer */
	Boolean			more;			/* 56 -->   if more data in this block will be written */
	unsigned char			filler2;
	unsigned long			userData;			/* 58 -->   Message block userData Uninterpreted by PPC */
	OSType			blockCreator;			/* 62 -->   Message block creator Uninterpreted by PPC */
	OSType			blockType;			/* 66 -->   Message block type Uninterpreted by PPC */
};
typedef struct PPCWritePBRec PPCWritePBRec;

typedef PPCWritePBRec *PPCWritePBPtr;

struct PPCReadPBRec {
	Ptr			qLink;
	unsigned short			csCode;
	unsigned short			intUse;
	Ptr			intUsePtr;
	PPCCompUPP			ioCompletion;
	OSErr			ioResult;
	unsigned long			Reserved[5];
	short			filler1;
	PPCSessRefNum			sessRefNum;			/* 40 -->   Session Reference */
	Size			bufferLength;			/* 44 -->   Length of the message buffer */
	Size			actualLength;			/* 48 <--   Actual length read */
	Ptr			bufferPtr;			/* 52 -->   Pointer to message buffer */
	Boolean			more;			/* 56 <--   if true more data in this block to be read */
	unsigned char			filler2;
	unsigned long			userData;			/* 58 <--   Message block userData Uninterpreted by PPC */
	OSType			blockCreator;			/* 62 <--   Message block creator Uninterpreted by PPC */
	OSType			blockType;			/* 66 <--   Message block type Uninterpreted by PPC */
};
typedef struct PPCReadPBRec PPCReadPBRec;

typedef PPCReadPBRec *PPCReadPBPtr;

struct PPCEndPBRec {
	Ptr			qLink;
	unsigned short			csCode;
	unsigned short			intUse;
	Ptr			intUsePtr;
	PPCCompUPP			ioCompletion;
	OSErr			ioResult;
	unsigned long			Reserved[5];
	short			filler1;
	PPCSessRefNum			sessRefNum;			/* 40 -->   Session Reference */
};
typedef struct PPCEndPBRec PPCEndPBRec;

typedef PPCEndPBRec *PPCEndPBPtr;

struct PPCClosePBRec {
	Ptr			qLink;
	unsigned short			csCode;
	unsigned short			intUse;
	Ptr			intUsePtr;
	PPCCompUPP			ioCompletion;
	OSErr			ioResult;
	unsigned long			Reserved[5];
	PPCPortRefNum			portRefNum;			/* 38 -->   Port Identifier */
};
typedef struct PPCClosePBRec PPCClosePBRec;

typedef PPCClosePBRec *PPCClosePBPtr;

struct IPCListPortsPBRec {
	Ptr			qLink;
	unsigned short			csCode;
	unsigned short			intUse;
	Ptr			intUsePtr;
	PPCCompUPP			ioCompletion;
	OSErr			ioResult;
	unsigned long			Reserved[5];
	short			filler1;
	unsigned short			startIndex;			/* 40 -->   Start Index */
	unsigned short			requestCount;			/* 42 -->   Number of entries to be returned */
	unsigned short			actualCount;			/* 44 <--   Actual Number of entries to be returned */
	PPCPortPtr			portName;			/* 46 -->   PortName Match */
	LocationNamePtr			locationName;			/* 50 -->   NBP or NAS type name to locate the Port Location */
	PortInfoArrayPtr			bufferPtr;			/* 54 -->   Pointer to a buffer requestCount*sizeof(PortInfo) bytes big */
};
typedef struct IPCListPortsPBRec IPCListPortsPBRec;

typedef IPCListPortsPBRec *IPCListPortsPBPtr;

union PPCParamBlockRec {
	PPCOpenPBRec			openParam;
	PPCInformPBRec			informParam;
	PPCStartPBRec			startParam;
	PPCAcceptPBRec			acceptParam;
	PPCRejectPBRec			rejectParam;
	PPCWritePBRec			writeParam;
	PPCReadPBRec			readParam;
	PPCEndPBRec			endParam;
	PPCClosePBRec			closeParam;
	IPCListPortsPBRec			listPortsParam;
};
#ifdef __cplusplus
extern "C" {
#endif

/*  PPC Calling Conventions  */


extern OSErr pascal PPCInit(void);
#define PPCOpen(pb, async) ((async) ? PPCOpenAsync(pb) : PPCOpenSync(pb))


extern OSErr pascal PPCOpenSync(PPCOpenPBPtr pb);

extern OSErr pascal PPCOpenAsync(PPCOpenPBPtr pb);
#define PPCInform(pb, async) ((async) ? PPCInformAsync(pb) : PPCInformSync(pb))


extern OSErr pascal PPCInformSync(PPCInformPBPtr pb);

extern OSErr pascal PPCInformAsync(PPCInformPBPtr pb);
#define PPCStart(pb, async) ((async) ? PPCStartAsync(pb) : PPCStartSync(pb))


extern OSErr pascal PPCStartSync(PPCStartPBPtr pb);

extern OSErr pascal PPCStartAsync(PPCStartPBPtr pb);
#define PPCAccept(pb, async) ((async) ? PPCAcceptAsync(pb) : PPCAcceptSync(pb))


extern OSErr pascal PPCAcceptSync(PPCAcceptPBPtr pb);

extern OSErr pascal PPCAcceptAsync(PPCAcceptPBPtr pb);
#define PPCReject(pb, async) ((async) ? PPCRejectAsync(pb) : PPCRejectSync(pb))


extern OSErr pascal PPCRejectSync(PPCRejectPBPtr pb);

extern OSErr pascal PPCRejectAsync(PPCRejectPBPtr pb);
#define PPCWrite(pb, async) ((async) ? PPCWriteAsync(pb) : PPCWriteSync(pb))


extern OSErr pascal PPCWriteSync(PPCWritePBPtr pb);

extern OSErr pascal PPCWriteAsync(PPCWritePBPtr pb);
#define PPCRead(pb, async) ((async) ? PPCReadAsync(pb) : PPCReadSync(pb))


extern OSErr pascal PPCReadSync(PPCReadPBPtr pb);

extern OSErr pascal PPCReadAsync(PPCReadPBPtr pb);
#define PPCEnd(pb, async) ((async) ? PPCEndAsync(pb) : PPCEndSync(pb))


extern OSErr pascal PPCEndSync(PPCEndPBPtr pb);

extern OSErr pascal PPCEndAsync(PPCEndPBPtr pb);
#define PPCClose(pb, async) ((async) ? PPCCloseAsync(pb) : PPCCloseSync(pb))


extern OSErr pascal PPCCloseSync(PPCClosePBPtr pb);

extern OSErr pascal PPCCloseAsync(PPCClosePBPtr pb);
#define IPCListPorts(pb, async) ((async) ? IPCListPortsAsync(pb) : IPCListPortsSync(pb))


extern OSErr pascal IPCListPortsSync(IPCListPortsPBPtr pb);

extern OSErr pascal IPCListPortsAsync(IPCListPortsPBPtr pb);
extern OSErr pascal DeleteUserIdentity(unsigned long userRef);
extern OSErr pascal GetDefaultUser(unsigned long *userRef, Str32 userName);
extern OSErr pascal StartSecureSession(PPCStartPBPtr pb, Str32 userName, Boolean useDefault, Boolean allowGuest, Boolean *guestSelected, ConstStr255Param prompt);
extern OSErr pascal PPCBrowser(ConstStr255Param prompt, ConstStr255Param applListLabel, Boolean defaultSpecified, LocationNameRec *theLocation, PortInfoRec *thePortInfo, PPCFilterUPP portFilter, ConstStr32Param theLocNBPType);
#if PRAGMA_STRUCT_ALIGN
	#pragma options align=reset
#elif PRAGMA_STRUCT_PACKPUSH
	#pragma pack(pop)
#elif PRAGMA_STRUCT_PACK
	#pragma pack()
#endif

#ifdef PRAGMA_IMPORT_OFF
#pragma import off
#elif PRAGMA_IMPORT
#pragma import reset
#endif

#ifdef __cplusplus
}
#endif

#endif


