/*
	File:		QDOffscreen.h

	Copyright:	 1984-1993 by Apple Computer, Inc., all rights reserved.

	WARNING
	This file was auto generated by the interfacer tool. Modifications
	must be made to the master file.

*/

#ifndef __QDOFFSCREEN__
#define __QDOFFSCREEN__

#ifndef __QUICKDRAW__
#if LONG_FILENAMES
#include <Quickdraw.H>
#else
#include <Quickdra.H>
#endif
#endif


/* New error codes */

enum  {
/*invalid pixel depth */
	cDepthErr			= -157
};

enum  {
	pixPurgeBit			= 0,
	noNewDeviceBit			= 1,
	useTempMemBit			= 2,
	keepLocalBit			= 3,
	pixelsPurgeableBit			= 6,
	pixelsLockedBit			= 7,
	mapPixBit			= 16,
	newDepthBit			= 17,
	alignPixBit			= 18,
	newRowBytesBit			= 19,
	reallocPixBit			= 20,
	clipPixBit			= 28,
	stretchPixBit			= 29,
	ditherPixBit			= 30,
	gwFlagErrBit			= 31
};

enum  {
	pixPurge			= 1L << pixPurgeBit,
	noNewDevice			= 1L << noNewDeviceBit,
	useTempMem			= 1L << useTempMemBit,
	keepLocal			= 1L << keepLocalBit,
	pixelsPurgeable			= 1L << pixelsPurgeableBit,
	pixelsLocked			= 1L << pixelsLockedBit
#define	mapPix		(1L << mapPixBit)
#define	newDepth	(1L << newDepthBit)
#define	alignPix	(1L << alignPixBit)
#define	newRowBytes	(1L << newRowBytesBit)
#define	reallocPix	(1L << reallocPixBit)
#define	clipPix		(1L << clipPixBit)
#define	stretchPix	(1L << stretchPixBit)
#define	ditherPix	(1L << ditherPixBit)
#define	gwFlagErr	(1L << gwFlagErrBit)
};

typedef unsigned long GWorldFlags;


/* Type definition of a GWorldPtr */

typedef CGrafPtr GWorldPtr;

#ifdef __cplusplus
extern "C" {
#endif

#if PRAGMA_IMPORT
#pragma import on
#endif

#if PRAGMA_STRUCT_ALIGN
	#pragma options align=mac68k
#elif PRAGMA_STRUCT_PACKPUSH
	#pragma pack(push, 2)
#elif PRAGMA_STRUCT_PACK
	#pragma pack(2)
#endif

extern F_PASCAL(QDErr) NewGWorld(GWorldPtr *offscreenGWorld, short PixelDepth, const Rect *boundsRect, CTabHandle cTable, GDHandle aGDevice, GWorldFlags flags);
extern F_PASCAL(Boolean) LockPixels(PixMapHandle pm);
extern F_PASCAL(void) UnlockPixels(PixMapHandle pm);
extern F_PASCAL(GWorldFlags) UpdateGWorld(GWorldPtr *offscreenGWorld, short pixelDepth, const Rect *boundsRect, CTabHandle cTable, GDHandle aGDevice, GWorldFlags flags);
extern F_PASCAL(void) DisposeGWorld(GWorldPtr offscreenGWorld);
extern F_PASCAL(void) GetGWorld(CGrafPtr *port, GDHandle *gdh);
extern F_PASCAL(void) SetGWorld(CGrafPtr port, GDHandle gdh);
extern F_PASCAL(void) CTabChanged(CTabHandle ctab);
extern F_PASCAL(void) PixPatChanged(PixPatHandle ppat);
extern F_PASCAL(void) PortChanged(GrafPtr port);
extern F_PASCAL(void) GDeviceChanged(GDHandle gdh);
extern F_PASCAL(void) AllowPurgePixels(PixMapHandle pm);
extern F_PASCAL(void) NoPurgePixels(PixMapHandle pm);
extern F_PASCAL(GWorldFlags) GetPixelsState(PixMapHandle pm);
extern F_PASCAL(void) SetPixelsState(PixMapHandle pm, GWorldFlags state);
extern F_PASCAL(Ptr) GetPixBaseAddr(PixMapHandle pm);
extern F_PASCAL(QDErr) NewScreenBuffer(const Rect *globalRect, Boolean purgeable, GDHandle *gdh, PixMapHandle *offscreenPixMap);
extern F_PASCAL(void) DisposeScreenBuffer(PixMapHandle offscreenPixMap);
extern F_PASCAL(GDHandle) GetGWorldDevice(GWorldPtr offscreenGWorld);
extern F_PASCAL(Boolean) QDDone(GrafPtr port);
extern F_PASCAL(long) OffscreenVersion(void);
extern F_PASCAL(QDErr) NewTempScreenBuffer(const Rect *globalRect, Boolean purgeable, GDHandle *gdh, PixMapHandle *offscreenPixMap);
extern F_PASCAL(Boolean) PixMap32Bit(PixMapHandle pmHandle);
extern F_PASCAL(PixMapHandle) GetGWorldPixMap(GWorldPtr offscreenGWorld);
#if PRAGMA_STRUCT_ALIGN
	#pragma options align=reset
#elif PRAGMA_STRUCT_PACKPUSH
	#pragma pack(pop)
#elif PRAGMA_STRUCT_PACK
	#pragma pack()
#endif

#ifdef PRAGMA_IMPORT_OFF
#pragma import off
#elif PRAGMA_IMPORT
#pragma import reset
#endif

#ifdef __cplusplus
}
#endif

#endif


