/*
	File:		QuickdrawText.h

	Copyright:	 1984-1993 by Apple Computer, Inc., all rights reserved.

	WARNING
	This file was auto generated by the interfacer tool. Modifications
	must be made to the master file.

*/

#ifndef __QUICKDRAWTEXT__
#define __QUICKDRAWTEXT__

#if PRAGMA_IMPORT
#pragma import on
#endif

#if PRAGMA_STRUCT_ALIGN
	#pragma options align=mac68k
#elif PRAGMA_STRUCT_PACKPUSH
	#pragma pack(push, 2)
#elif PRAGMA_STRUCT_PACK
	#pragma pack(2)
#endif

#ifndef __TYPES__
#include <MacTypes.H>
#endif

#ifndef __INTLRESOURCES__
#if LONG_FILENAMES
#include <IntlResources.H>
#else
#include <IntlReso.H>
#endif
#endif

enum  {
/* CharToPixel directions */
	leftCaret			= 0,			/*Place caret for left block*/
	rightCaret			= -1,			/*Place caret for right block*/
	hilite			= 1,			/*Direction is SysDirection*/
	smLeftCaret			= 0,			/*Place caret for left block	obsolete */
	smRightCaret			= -1,			/*Place caret for right block	obsolete */
	smHilite			= 1,			/*Direction is TESysJust		obsolete */
/*Constants for styleRunPosition argument in PortionLine, DrawJustified,
 MeasureJustified, CharToPixel, and PixelToChar.*/
	onlyStyleRun			= 0,			/* This is the only style run on the line */
	leftStyleRun			= 1,			/* This is leftmost of multiple style runs on the line */
	rightStyleRun			= 2,			/* This is rightmost of multiple style runs on the line */
	middleStyleRun			= 3,			/* There are multiple style runs on the line and this
 is neither the leftmost nor the rightmost. */
	smOnlyStyleRun			= 0,			/*	obsolete */
	smLeftStyleRun			= 1,			/*	obsolete */
	smRightStyleRun			= 2,			/*	obsolete */
	smMiddleStyleRun			= 3			/*	obsolete */
};


/* type for styleRunPosition parameter in PixelToChar etc. */

typedef short JustStyleCode;

struct FontInfo {
	short			ascent;
	short			descent;
	short			widMax;
	short			leading;
};
typedef struct FontInfo FontInfo;

typedef short FormatOrder[1];

typedef FormatOrder *FormatOrderPtr;

typedef short FormatStatus;

#ifdef __cplusplus
extern "C" {
#endif

extern short pascal Pixel2Char(Ptr textBuf, short textLen, short slop, short pixelWidth, Boolean *leadingEdge);
extern short pascal Char2Pixel(Ptr textBuf, short textLen, short slop, short offset, short direction);
extern short pascal PixelToChar(Ptr textBuf, long textLength, Fixed slop, Fixed pixelWidth, Boolean *leadingEdge, Fixed *widthRemaining, JustStyleCode styleRunPosition, Point numer, Point denom);
extern short pascal CharToPixel(Ptr textBuf, long textLength, Fixed slop, long offset, short direction, JustStyleCode styleRunPosition, Point numer, Point denom);
extern void pascal DrawJustified(Ptr textPtr, long textLength, Fixed slop, JustStyleCode styleRunPosition, Point numer, Point denom);
extern void pascal MeasureJustified(Ptr textPtr, long textLength, Fixed slop, Ptr charLocs, JustStyleCode styleRunPosition, Point numer, Point denom);
extern Fixed pascal PortionLine(Ptr textPtr, long textLen, JustStyleCode styleRunPosition, Point numer, Point denom);
extern void pascal HiliteText(Ptr textPtr, short textLength, short firstOffset, short secondOffset, OffsetTable offsets);
extern void pascal DrawJust(Ptr textPtr, short textLength, short slop);
extern void pascal MeasureJust(Ptr textPtr, short textLength, short slop, Ptr charLocs);
extern Fixed pascal PortionText(Ptr textPtr, long textLength);
extern long pascal VisibleLength(Ptr textPtr, long textLength);
extern void pascal GetFormatOrder(FormatOrderPtr ordering, short firstFormat, short lastFormat, Boolean lineRight, Ptr rlDirProc, Ptr dirParam);
extern void pascal TextFont(short font);
extern void pascal TextFace(short face);
extern void pascal TextMode(short mode);
extern void pascal TextSize(short size);
extern void pascal SpaceExtra(Fixed extra);
extern void pascal DrawChar(short ch);
extern void pascal DrawString(ConstStr255Param s);
extern void pascal DrawTex(const void *textBuf, short firstByte, short byteCount);
extern short pascal CharWidth(short ch);
extern short pascal StringWidth(ConstStr255Param s);
extern short pascal TextWidth(const void *textBuf, short firstByte, short byteCount);
extern void pascal MeasureText(short count, const void *textAddr, void *charLocs);
extern void pascal GetFontInfo(FontInfo *info);
extern void pascal CharExtra(Fixed extra);
extern void pascal StdText(short count, const void *textAddr, Point numer, Point denom);
extern void stdtext(short count, const void *textAddr, Point *numer, Point *denom);
extern short pascal StdTxMeas(short byteCount, const void *textAddr, Point *numer, Point *denom, FontInfo *info);
#if OLDROUTINENAMES
#define NPixel2Char(textBuf, textLen, slop, pixelWidth, leadingEdge, widthRemaining, styleRunPosition, numer, denom)  \
	PixelToChar(textBuf, textLen, slop, pixelWidth, leadingEdge, widthRemaining,  \
	styleRunPosition, numer, denom)

#define NChar2Pixel(textBuf, textLen, slop, offset, direction, styleRunPosition, numer, denom)  \
	CharToPixel(textBuf, textLen, slop, offset, direction, styleRunPosition,  \
	numer, denom)

#define NDrawJust(textPtr, textLength, slop, styleRunPosition, numer, denom)  \
	DrawJustified(textPtr, textLength, slop, styleRunPosition, numer, denom)

#define NMeasureJust(textPtr, textLength, slop, charLocs, styleRunPosition, numer, denom)  \
	MeasureJustified(textPtr, textLength, slop, charLocs, styleRunPosition, numer, denom)

#define NPortionText(textPtr, textLen, styleRunPosition, numer, denom)  \
	PortionLine(textPtr, textLen, styleRunPosition, numer, denom)

#endif

#if PRAGMA_STRUCT_ALIGN
	#pragma options align=reset
#elif PRAGMA_STRUCT_PACKPUSH
	#pragma pack(pop)
#elif PRAGMA_STRUCT_PACK
	#pragma pack()
#endif

#ifdef PRAGMA_IMPORT_OFF
#pragma import off
#elif PRAGMA_IMPORT
#pragma import reset
#endif

#ifdef __cplusplus
}
#endif

#endif


