/*
	File:		RTLib.h

	Copyright:	 1984-1993 by Apple Computer, Inc., all rights reserved.

	WARNING
	This file was auto generated by the interfacer tool. Modifications
	must be made to the master file.

*/

#ifndef __RTLib__
#define __RTLib__

#ifndef __TYPES__
#include <Types.h>
/*	#include <ConditionalMacros.h>								*/
/*	#include <MixedMode.h>										*/
/*		#include <Traps.h>										*/
#endif

#ifdef __cplusplus
extern "C" {
#endif

#if PRAGMA_IMPORT
#pragma import on
#endif

#if PRAGMA_STRUCT_ALIGN
	#pragma options align=mac68k
#elif PRAGMA_STRUCT_PACKPUSH
	#pragma pack(push, 2)
#elif PRAGMA_STRUCT_PACK
	#pragma pack(2)
#endif

enum {
	eRTNoErr					= 0,
	eRTBadVersion				= 2,
	eRTInvalidOp				= 4,
	eRTInvalidJTPtr				= 6
};

enum {
	kRTSysErr					= 0,
	kRTRetry					= 1,
	kRTContinue					= 2
};

enum {
	kRTGetVersion				= 10,
	kRTGetVersionA5				= 11,
	kRTGetJTAddress				= 12,
	kRTGetJTAddressA5			= 13,
	kRTSetPreLoad				= 14,
	kRTSetPreLoadA5				= 15,
	kRTSetSegLoadErr			= 16,
	kRTSetSegLoadErrA5			= 17,
	kRTSetPostLoad				= 18,
	kRTSetPostLoadA5			= 19,
	kRTSetPreUnload				= 20,
	kRTSetPreUnloadA5			= 21,
	kRTPreLaunch				= 22,
	kRTPostLaunch				= 23
};

struct RTGetVersionParam {
	unsigned short				fVersion;
};

typedef struct RTGetVersionParam RTGetVersionParam;

struct RTGetJTAddrParam {
	void						*fJTAddr;
	void						*fCodeAddr;
};

typedef struct RTGetJTAddrParam RTGetJTAddrParam;

struct RTState {
	unsigned short				fVersion;
	void						*fSP;
	void						*fJTAddr;
	long						fRegisters[15];
	short						fSegNo;
	ResType						fSegType;
	long						fSegSize;
	Boolean						fSegInCore;
	Boolean						fReserved1;
	OSErr						fOSErr;
	long						fReserved2;
};

typedef struct RTState RTState;

#define kVersion32bit 0xFFFF

#define kVersion16bit 0x0000

typedef short pascal (*SegLoadHdlrPtr)(RTState *state);

#if USESROUTINEDESCRIPTORS

enum {
	uppSegLoadHdlrProcInfo = kPascalStackBased
		 | STACK_RESULT_FIELD(SIZE_CODE(sizeof(short)))
		 | STACK_PARAM_FIELD(1, SIZE_CODE(sizeof(RTState*)))
};

typedef UniversalProcPtr SegLoadHdlrUPP;

#define CallSegLoadHdlrProc(userRoutine, state)		\
		CallUniversalProc(userRoutine, uppSegLoadHdlrProcInfo, state)
#define NewSegLoadHdlrProc(userRoutine)		\
		(SegLoadHdlrUPP) NewRoutineDescriptor(userRoutine, uppSegLoadHdlrProcInfo, GetCurrentISA())
#else
typedef SegLoadHdlrPtr SegLoadHdlrUPP;

#define CallSegLoadHdlrProc(userRoutine, state)		\
		(*userRoutine)(state)
#define NewSegLoadHdlrProc(userRoutine)		\
		(SegLoadHdlrUPP)(userRoutine)
#endif
struct RTSetSegLoadParam {
	SegLoadHdlrUPP				fUserHdlr;
	SegLoadHdlrUPP				fOldUserHdlr;
};

typedef struct RTSetSegLoadParam RTSetSegLoadParam;

struct RTPB {
	short						fOperation;
	void						*fA5;
	union {
		RTGetVersionParam			fVersionParam;
		RTGetJTAddrParam			fJTAddrParam;
		RTSetSegLoadParam			fSegLoadParam;
	}							fRTParam;
};

typedef struct RTPB RTPB;

extern OSErr pascal Runtime(RTPB *runtime_parms);

#if PRAGMA_STRUCT_ALIGN
	#pragma options align=reset
#elif PRAGMA_STRUCT_PACKPUSH
	#pragma pack(pop)
#elif PRAGMA_STRUCT_PACK
	#pragma pack()
#endif

#ifdef PRAGMA_IMPORT_OFF
#pragma import off
#elif PRAGMA_IMPORT
#pragma import reset
#endif

#ifdef __cplusplus
}
#endif

#endif


