/*
	File:		StandardFile.h

	Copyright:	 1984-1993 by Apple Computer, Inc., all rights reserved.

	WARNING
	This file was auto generated by the interfacer tool. Modifications
	must be made to the master file.

*/

#ifndef __STANDARDFILE__
#define __STANDARDFILE__

#ifndef __TYPES__
#include <MacTypes.H>
#endif

#ifndef __DIALOGS__
#include <Dialogs.H>
#endif

#ifndef __FILES__
#include <Files.H>
#endif

#if PRAGMA_IMPORT
#pragma import on
#endif

#if PRAGMA_STRUCT_ALIGN
	#pragma options align=mac68k
#elif PRAGMA_STRUCT_PACKPUSH
	#pragma pack(push, 2)
#elif PRAGMA_STRUCT_PACK
	#pragma pack(2)
#endif

enum  {
/* resource IDs and item offsets of pre-7.0 dialogs */
	putDlgID			= -3999,
	putSave			= 1,
	putCancel			= 2,
	putEject			= 5,
	putDrive			= 6,
	putName			= 7,
	getDlgID			= -4000,
	getOpen			= 1,
	getCancel			= 3,
	getEject			= 5,
	getDrive			= 6,
	getNmList			= 7,
	getScroll			= 8,
/* resource IDs and item offsets of 7.0 dialogs */
	sfPutDialogID			= -6043,
	sfGetDialogID			= -6042,
	sfItemOpenButton			= 1,
	sfItemCancelButton			= 2,
	sfItemBalloonHelp			= 3,
	sfItemVolumeUser			= 4,
	sfItemEjectButton			= 5
};

enum  {
	sfItemDesktopButton			= 6,
	sfItemFileListUser			= 7,
	sfItemPopUpMenuUser			= 8,
	sfItemDividerLinePict		= 9,
	sfItemFileNameTextEdit		= 10,
	sfItemPromptStaticText		= 11,
	sfItemNewFolderUser			= 12,
/* pseudo-item hits for use in DlgHook */
	sfHookFirstCall			= -1,
	sfHookCharOffset			= 0x1000,
	sfHookNullEvent			= 100,
	sfHookRebuildList			= 101,
	sfHookFolderPopUp			= 102,
	sfHookOpenFolder			= 103,
/* the following are only in system 7.0+ */
	sfHookOpenAlias			= 104,
	sfHookGoToDesktop			= 105,
	sfHookGoToAliasTarget		= 106,
	sfHookGoToParent			= 107,
	sfHookGoToNextDrive			= 108,
	sfHookGoToPrevDrive			= 109,
	sfHookChangeSelection		= 110
};

enum  {
	sfHookSetActiveOffset		= 200,
	sfHookLastCall			= -2
};


/* the refcon field of the dialog record during a
 modalfilter or dialoghook contains one of the following */

#define sfMainDialogRefCon OST_stdf

#define sfNewFolderDialogRefCon OST_nfdr

#define sfReplaceDialogRefCon OST_rplc

#define sfStatWarnDialogRefCon OST_stat

#define sfLockWarnDialogRefCon OST_lock

#define sfErrorDialogRefCon OST_errSpc

// WARNING: This struct is larger now on Windows because the SFReply struct
//  has been grown to handle long file names. Make sure you don't save this
//  struct to disk as it will be different sizes on the 2 platforms.

struct SFReply {
	Boolean			good;
	Boolean			copy;
	OSType			fType;
	short			vRefNum;
	short			version;
#if MACVER		
    Str63 fName;	// WARNING: This field is now bigger on Windows
#else
    Str255 fName;
#endif
};
typedef struct SFReply SFReply;

// WARNING: This struct is larger now on Windows because the FSSpec struct
//  has been grown to handle long file names. Make sure you don't save this
//  struct to disk as it will be different sizes on the 2 platforms.

struct StandardFileReply {
	Boolean			sfGood;
	Boolean			sfReplacing;
	OSType			sfType;
	FSSpec			sfFile;
	ScriptCode			sfScript;
	short			sfFlags;
	Boolean			sfIsFolder;
	Boolean			sfIsVolume;
	long			sfReserved1;
	short			sfReserved2;
};
typedef struct StandardFileReply StandardFileReply;

typedef short (pascal *DlgHookProcPtr)(short item, DialogPtr theDialog);

enum {
	uppDlgHookProcInfo = kPascalStackBased
		| RESULT_SIZE(SIZE_CODE(sizeof(short)))
		| STACK_ROUTINE_PARAMETER(1, SIZE_CODE(sizeof(short)))
		| STACK_ROUTINE_PARAMETER(2, SIZE_CODE(sizeof(DialogPtr)))
};

#if USESROUTINEDESCRIPTORS
typedef UniversalProcPtr DlgHookUPP;

#define CallDlgHookProc(userRoutine, item, theDialog)		\
		CallUniversalProc((UniversalProcPtr)(userRoutine), uppDlgHookProcInfo, (item), (theDialog))
#define NewDlgHookProc(userRoutine)		\
		(DlgHookUPP) NewRoutineDescriptor((ProcPtr)(userRoutine), uppDlgHookProcInfo, GetCurrentISA())
#else
typedef DlgHookProcPtr DlgHookUPP;

#define CallDlgHookProc(userRoutine, item, theDialog)		\
		(*(userRoutine))((item), (theDialog))
#define NewDlgHookProc(userRoutine)		\
		(DlgHookUPP)(userRoutine)
#endif

typedef Boolean (pascal *FileFilterProcPtr)(ParmBlkPtr PB);

enum {
	uppFileFilterProcInfo = kPascalStackBased
		| RESULT_SIZE(SIZE_CODE(sizeof(Boolean)))
		| STACK_ROUTINE_PARAMETER(1, SIZE_CODE(sizeof(ParmBlkPtr)))
};

#if USESROUTINEDESCRIPTORS
typedef UniversalProcPtr FileFilterUPP;

#define CallFileFilterProc(userRoutine, PB)		\
		CallUniversalProc((UniversalProcPtr)(userRoutine), uppFileFilterProcInfo, (PB))
#define NewFileFilterProc(userRoutine)		\
		(FileFilterUPP) NewRoutineDescriptor((ProcPtr)(userRoutine), uppFileFilterProcInfo, GetCurrentISA())
#else
typedef FileFilterProcPtr FileFilterUPP;

#define CallFileFilterProc(userRoutine, PB)		\
		(*(userRoutine))((PB))
#define NewFileFilterProc(userRoutine)		\
		(FileFilterUPP)(userRoutine)
#endif


/* the following also include an extra parameter of "your data pointer" */

typedef short (pascal *DlgHookYDProcPtr)(short item, DialogPtr theDialog, void *yourDataPtr);

enum {
	uppDlgHookYDProcInfo = kPascalStackBased
		| RESULT_SIZE(SIZE_CODE(sizeof(short)))
		| STACK_ROUTINE_PARAMETER(1, SIZE_CODE(sizeof(short)))
		| STACK_ROUTINE_PARAMETER(2, SIZE_CODE(sizeof(DialogPtr)))
		| STACK_ROUTINE_PARAMETER(3, SIZE_CODE(sizeof(void*)))
};

#if USESROUTINEDESCRIPTORS
typedef UniversalProcPtr DlgHookYDUPP;

#define CallDlgHookYDProc(userRoutine, item, theDialog, yourDataPtr)		\
		CallUniversalProc((UniversalProcPtr)(userRoutine), uppDlgHookYDProcInfo, (item), (theDialog), (yourDataPtr))
#define NewDlgHookYDProc(userRoutine)		\
		(DlgHookYDUPP) NewRoutineDescriptor((ProcPtr)(userRoutine), uppDlgHookYDProcInfo, GetCurrentISA())
#else
typedef DlgHookYDProcPtr DlgHookYDUPP;

#define CallDlgHookYDProc(userRoutine, item, theDialog, yourDataPtr)		\
		(*(userRoutine))((item), (theDialog), (yourDataPtr))
#define NewDlgHookYDProc(userRoutine)		\
		(DlgHookYDUPP)(userRoutine)
#endif

typedef Boolean (pascal *ModalFilterYDProcPtr)(DialogPtr theDialog, EventRecord *theEvent, short *itemHit, void *yourDataPtr);

enum {
	uppModalFilterYDProcInfo = kPascalStackBased
		| RESULT_SIZE(SIZE_CODE(sizeof(Boolean)))
		| STACK_ROUTINE_PARAMETER(1, SIZE_CODE(sizeof(DialogPtr)))
		| STACK_ROUTINE_PARAMETER(2, SIZE_CODE(sizeof(EventRecord*)))
		| STACK_ROUTINE_PARAMETER(3, SIZE_CODE(sizeof(short*)))
		| STACK_ROUTINE_PARAMETER(4, SIZE_CODE(sizeof(void*)))
};

#if USESROUTINEDESCRIPTORS
typedef UniversalProcPtr ModalFilterYDUPP;

#define CallModalFilterYDProc(userRoutine, theDialog, theEvent, itemHit, yourDataPtr)		\
		CallUniversalProc((UniversalProcPtr)(userRoutine), uppModalFilterYDProcInfo, (theDialog), (theEvent), (itemHit), (yourDataPtr))
#define NewModalFilterYDProc(userRoutine)		\
		(ModalFilterYDUPP) NewRoutineDescriptor((ProcPtr)(userRoutine), uppModalFilterYDProcInfo, GetCurrentISA())
#else
typedef ModalFilterYDProcPtr ModalFilterYDUPP;

#define CallModalFilterYDProc(userRoutine, theDialog, theEvent, itemHit, yourDataPtr)		\
		(*(userRoutine))((theDialog), (theEvent), (itemHit), (yourDataPtr))
#define NewModalFilterYDProc(userRoutine)		\
		(ModalFilterYDUPP)(userRoutine)
#endif

typedef Boolean (pascal *FileFilterYDProcPtr)(ParmBlkPtr PB, void *yourDataPtr);

enum {
	uppFileFilterYDProcInfo = kPascalStackBased
		| RESULT_SIZE(SIZE_CODE(sizeof(Boolean)))
		| STACK_ROUTINE_PARAMETER(1, SIZE_CODE(sizeof(ParmBlkPtr)))
		| STACK_ROUTINE_PARAMETER(2, SIZE_CODE(sizeof(void*)))
};

#if USESROUTINEDESCRIPTORS
typedef UniversalProcPtr FileFilterYDUPP;

#define CallFileFilterYDProc(userRoutine, PB, yourDataPtr)		\
		CallUniversalProc((UniversalProcPtr)(userRoutine), uppFileFilterYDProcInfo, (PB), (yourDataPtr))
#define NewFileFilterYDProc(userRoutine)		\
		(FileFilterYDUPP) NewRoutineDescriptor((ProcPtr)(userRoutine), uppFileFilterYDProcInfo, GetCurrentISA())
#else
typedef FileFilterYDProcPtr FileFilterYDUPP;

#define CallFileFilterYDProc(userRoutine, PB, yourDataPtr)		\
		(*(userRoutine))((PB), (yourDataPtr))
#define NewFileFilterYDProc(userRoutine)		\
		(FileFilterYDUPP)(userRoutine)
#endif

typedef void (pascal *ActivateYDProcPtr)(DialogPtr theDialog, short itemNo, Boolean activating, void *yourDataPtr);

enum {
	uppActivateYDProcInfo = kPascalStackBased
		| STACK_ROUTINE_PARAMETER(1, SIZE_CODE(sizeof(DialogPtr)))
		| STACK_ROUTINE_PARAMETER(2, SIZE_CODE(sizeof(short)))
		| STACK_ROUTINE_PARAMETER(3, SIZE_CODE(sizeof(Boolean)))
		| STACK_ROUTINE_PARAMETER(4, SIZE_CODE(sizeof(void*)))
};

#if USESROUTINEDESCRIPTORS
typedef UniversalProcPtr ActivateYDUPP;

#define CallActivateYDProc(userRoutine, theDialog, itemNo, activating, yourDataPtr)		\
		CallUniversalProc((UniversalProcPtr)(userRoutine), uppActivateYDProcInfo, (theDialog), (itemNo), (activating), (yourDataPtr))
#define NewActivateYDProc(userRoutine)		\
		(ActivateYDUPP) NewRoutineDescriptor((ProcPtr)(userRoutine), uppActivateYDProcInfo, GetCurrentISA())
#else
typedef ActivateYDProcPtr ActivateYDUPP;

#define CallActivateYDProc(userRoutine, theDialog, itemNo, activating, yourDataPtr)		\
		(*(userRoutine))((theDialog), (itemNo), (activating), (yourDataPtr))
#define NewActivateYDProc(userRoutine)		\
		(ActivateYDUPP)(userRoutine)
#endif

typedef OSType SFTypeList[4];

#ifdef __cplusplus
extern "C" {
#endif

extern  F_PASCAL(void) SFPutFile(Point where, ConstStr255Param prompt, ConstStr255Param origName, DlgHookUPP dlgHook, SFReply *reply);
extern F_PASCAL(void) SFGetFile(Point where, ConstStr255Param prompt, FileFilterUPP fileFilter, short numTypes, SFTypeList typeList, DlgHookUPP dlgHook, SFReply *reply);
extern F_PASCAL(void) SFPPutFile(Point where, ConstStr255Param prompt, ConstStr255Param origName, DlgHookUPP dlgHook, SFReply *reply, short dlgID, ModalFilterUPP filterProc);
extern F_PASCAL(void) SFPGetFile(Point where, ConstStr255Param prompt, FileFilterUPP fileFilter, short numTypes, SFTypeList typeList, DlgHookUPP dlgHook, SFReply *reply, short dlgID, ModalFilterUPP filterProc);
extern F_PASCAL(void) StandardPutFile(ConstStr255Param prompt, ConstStr255Param defaultName, StandardFileReply *reply);
extern F_PASCAL(void) StandardGetFile(FileFilterUPP fileFilter, short numTypes, SFTypeList typeList, StandardFileReply *reply);
extern F_PASCAL(void) CustomPutFile(ConstStr255Param prompt, ConstStr255Param defaultName, StandardFileReply *reply, short dlgID, Point where, DlgHookYDUPP dlgHook, ModalFilterYDUPP filterProc, short *activeList, ActivateYDUPP activate, void *yourDataPtr);
extern F_PASCAL(void) CustomGetFile(FileFilterYDUPP fileFilter, short numTypes, SFTypeList typeList, StandardFileReply *reply, short dlgID, Point where, DlgHookYDUPP dlgHook, ModalFilterYDUPP filterProc, short *activeList, ActivateYDUPP activate, void *yourDataPtr);
extern F_PASCAL(void) sfpputfile(Point *where, char *prompt, char *origName, DlgHookUPP dlgHook, SFReply *reply, short dlgID, ModalFilterUPP filterProc);
extern F_PASCAL(void) sfgetfile(Point *where, char *prompt, FileFilterUPP fileFilter, short numTypes, SFTypeList typeList, DlgHookUPP dlgHook, SFReply *reply);
extern F_PASCAL(void) sfpgetfile(Point *where, char *prompt, FileFilterUPP fileFilter, short numTypes, SFTypeList typeList, DlgHookUPP dlgHook, SFReply *reply, short dlgID, ModalFilterUPP filterProc);
extern F_PASCAL(void) sfputfile(Point *where, char *prompt, char *origName, DlgHookUPP dlgHook, SFReply *reply);

/*

  New StandardFile routine comments:

  activeList is pointer to array of integer (16-bits).
  first integer is length of list.
  following integers are possible activatable DITL items, in
  the order that the tab key will cycle through.  The first
  in the list is the item made active when dialog is first shown.

  activateProc is a pointer to a procedure like:

   PROCEDURE MyActivateProc(theDialog:  DialogPtr;
	itemNo:  INTEGER;
	activating: BOOLEAN;
	yourDataPtr: Ptr);

  The activateProc is called with activating=FALSE on the itemNo
  about to deactivate then with activating=TRUE on the itemNo
  about to become the active item. (like activate event)

  yourDataPtr is a nice little extra that makes life easier without
  globals.  CustomGetFile & CustomPPutFile when calling any of their
  call back procedures, pushes the extra parameter of yourDataPtr on
  the stack.

  In addition the filterProc in CustomGetFile & CustomPPutFile is called
  before before SF does any mapping, instead of after.
*/

#if PRAGMA_STRUCT_ALIGN
	#pragma options align=reset
#elif PRAGMA_STRUCT_PACKPUSH
	#pragma pack(pop)
#elif PRAGMA_STRUCT_PACK
	#pragma pack()
#endif

#ifdef PRAGMA_IMPORT_OFF
#pragma import off
#elif PRAGMA_IMPORT
#pragma import reset
#endif

#ifdef __cplusplus
}
#endif

#endif


