/*
	File:		TextServices.h

	Copyright:	 1984-1993 by Apple Computer, Inc., all rights reserved.

	WARNING
	This file was auto generated by the interfacer tool. Modifications
	must be made to the master file.

*/

#ifndef __TEXTSERVICES__
#define __TEXTSERVICES__

#ifndef __TYPES__
#include <MacTypes.H>
#endif

#ifndef __EVENTS__
#include <Events.H>
#endif

#ifndef __MENUS__
#include <Menus.H>
#endif

#ifndef __APPLEEVENTS__
#if LONG_FILENAMES
#include <AppleEvents.H>
#else
#include <AppleEve.H>
#endif
#endif

#ifndef __ERRORS__
#include <Errors.H>
#endif

#ifndef __COMPONENTS__
#if LONG_FILENAMES
#include <Components.H>
#else
#include <Componen.H>
#endif
#endif

#if PRAGMA_IMPORT
#pragma import on
#endif

#if PRAGMA_STRUCT_ALIGN
	#pragma options align=mac68k
#elif PRAGMA_STRUCT_PACKPUSH
	#pragma pack(push, 2)
#elif PRAGMA_STRUCT_PACK
	#pragma pack(2)
#endif

#define kTSMVersion 0x0001

#define kTextService OST_tsvc

#define kInputMethodService OST_inpm


/* Component Flags in ComponentDescription */

#define bTakeActiveEvent 15

#define bHandleAERecording 16

#define bScriptMask 0x00007F00

#define bLanguageMask 0x000000FF

#define bScriptLanguageMask bScriptMask+bLanguageMask


/*	 **************************************   */


/* Hilite styles ... */

enum  {
	kCaretPosition			= 1,			/* specify caret position */
	kRawText			= 2,			/* specify range of raw text */
	kSelectedRawText			= 3,			/* specify range of selected raw text */
	kConvertedText			= 4,			/* specify range of converted text */
	kSelectedConvertedText		= 5			/* specify range of selected converted text */
};


/*	 **************************************   */


/* Apple Event constants ... */


/* Event class ... */

#define kTextServiceClass kTextService


/* event ID ... */

#define kUpdateActiveInputArea OST_updt

#define kPos2Offset OST_p2st

#define kOffset2Pos OST_st2p

#define kShowHideInputWindow OST_shiw


/* Event keywords ... */

#define keyAETSMDocumentRefcon OST_refc


/* Note: keyAETSMScriptTag, keyAERequestedType, keyAETSMTextFont, keyAETextPointSize
	typeAEText, typeIntlWritingCode, typeQDPoint, and keyAEAngle have been moved to
	AERegistry.h */

#define keyAEServerInstance OST_srvi

#define keyAETheData OST_kdat

#define keyAEFixLength OST_fixl

#define keyAEHiliteRange OST_hrng

#define keyAEUpdateRange OST_udng

#define keyAEClauseOffsets OST_clau

#define keyAECurrentPoint OST_cpos

#define keyAEDragging OST_bool

#define keyAEOffset OST_ofst

#define keyAERegionClass OST_rgnc

#define keyAEPoint OST_gpos

#define keyAEBufferSize OST_buff

#define keyAEMoveView OST_mvvw

#define keyAELength OST_leng

#define keyAENextBody OST_nxbd


/* optional keywords for Offset2Pos (Info about the active input area)-- 28Mar92 <#38> */

#define keyAETextLineHeight OST_ktlh

#define keyAETextLineAscent OST_ktas


/* 90 specifies horizonal line direction, 180 specifies vertical line direction.	<#54> */


/* optional keywords for Pos2Offset			-- 20May92 <#44> */

#define keyAELeftSide OST_klef


/* optional keywords for kShowHideInputWindow	-- <#48> */

#define keyAEShowHideInputWindow OST_shiw


/* for PinRange  */

#define keyAEPinRange OST_pnrg


/* Desc type ... */

#define typeComponentInstance OST_cmpi

#define typeTextRangeArray OST_tray

#define typeOffsetArray OST_ofay

#define typeText OST_TEXT

#define typeTextRange OST_txrn


/* error codes */

#define tsmComponentNoErr 0

#define tsmUnsupScriptLanguageErr -2500

#define tsmInputMethodNotFoundErr -2501

#define tsmNotAnAppErr -2502

#define tsmAlreadyRegisteredErr -2503

#define tsmNeverRegisteredErr -2504

#define tsmInvalidDocIDErr -2505

#define tsmTSMDocBusyErr -2506

#define tsmDocNotActiveErr -2507

#define tsmNoOpenTSErr -2508

#define tsmCantOpenComponentErr -2509

#define tsmTextServiceNotFoundErr -2510

#define tsmDocumentOpenErr -2511

#define tsmUseInputWindowErr -2512

#define tsmTSHasNoMenuErr -2513

#define tsmTSNotOpenErr -2514

#define tsmComponentAlreadyOpenErr -2515

#define tsmInputMethodIsOldErr -2516

#define tsmScriptHasNoIMErr -2517

#define tsmUnsupportedTypeErr -2518

#define tsmUnknownErr -2519


/* Desc type constants */

enum  {
	kTSMOutsideOfBody			= 1,
	kTSMInsideOfBody			= 2,
	kTSMInsideOfActiveInputArea	= 3
};

enum  {
	kNextBody			= 1,
	kPreviousBody			= 2
};



/*	 **************************************   */


/* typeTextRange		'txrn' */

struct TextRange {
	long			fStart;
	long			fEnd;
	short			fHiliteStyle;
};
typedef struct TextRange TextRange;

typedef TextRange *TextRangePtr;

typedef TextRangePtr *TextRangeHandle;


/* typeTextRangeArray	'txra' */

struct TextRangeArray {
	short			fNumOfRanges;			/* specify the size of the fRange array */
	TextRange			fRange[1];			/* when fNumOfRanges > 1, the size of this array has to be calculated */
};
typedef struct TextRangeArray TextRangeArray;

typedef TextRangeArray *TextRangeArrayPtr;

typedef TextRangeArrayPtr *TextRangeArrayHandle;


/* typeOffsetArray		'offa' */

struct OffsetArray {
	short			fNumOfOffsets;			/* specify the size of the fOffset array */
	long			fOffset[1];			/* when fNumOfOffsets > 1, the size of this array has to be calculated */
};
typedef struct OffsetArray OffsetArray;

typedef OffsetArray *OffsetArrayPtr;

typedef OffsetArrayPtr *OffsetArrayHandle;


/*	 **************************************   */


/* extract Script/Language code from Component flag ... */

#define mGetScriptCode(cdRec) ((ScriptCode)	((cdRec.componentFlags & bScriptMask) >> 8))

#define mGetLanguageCode(cdRec) ((LangCode)	cdRec.componentFlags & bLanguageMask)

typedef void *TSMDocumentID;


/*	 **************************************   */


/*
 *	Text Service Info List
 */

struct TextServiceInfo {
	Component			fComponent;
	Str255			fItemName;
};
typedef struct TextServiceInfo TextServiceInfo;

typedef TextServiceInfo *TextServiceInfoPtr;

struct TextServiceList {
	short			fTextServiceCount;			/* number of entries in the 'fServices' array */
	TextServiceInfo			fServices[1];			/* Note: array of 'TextServiceInfo' records follows */
};
typedef struct TextServiceList TextServiceList;

typedef TextServiceList *TextServiceListPtr;

typedef TextServiceListPtr *TextServiceListHandle;

struct ScriptLanguageRecord {
	ScriptCode			fScript;
	LangCode			fLanguage;
};
typedef struct ScriptLanguageRecord ScriptLanguageRecord;

struct ScriptLanguageSupport {
	short			fScriptLanguageCount;			/* number of entries in the 'fScriptLanguageArray' array */
	ScriptLanguageRecord		fScriptLanguageArray[1];		/* Note: array of 'ScriptLanguageRecord' records follows */
};
typedef struct ScriptLanguageSupport ScriptLanguageSupport;

typedef ScriptLanguageSupport *ScriptLanguageSupportPtr;

typedef ScriptLanguageSupportPtr *ScriptLanguageSupportHandle;


/*	 **************************************   */

#define TSMTrapNum 0xAA54


/* 	Text Services Manager function selectors ... */


/* 	High level routines ... */

#define kNewTSMDocument 0

#define kDeleteTSMDocument 1

#define kActivateTSMDocument 2

#define kDeactivateTSMDocument 3

#define kTSMEvent 4

#define kTSMMenuSelect 5

#define kSetTSMCursor 6

#define kFixTSMDocument 7

#define kGetServiceList 8

#define kOpenTextService 9

#define kCloseTextService 10

#define kSendAEFromTSMComponent 11


/* 	Utilities ... */

#define kSetDefaultInputMethod 12

#define kGetDefaultInputMethod 13

#define kSetTextServiceLanguage 14

#define kGetTextServiceLanguage 15

#define kUseInputWindow 16

#define kNewServiceWindow 17

#define kCloseServiceWindow 18

#define kGetFrontServiceWindow 19

#define kInitTSMAwareApplication 20

#define kCloseTSMAwareApplication 21

#define kFindServiceWindow 23


/*	 **************************************   */

#ifdef __cplusplus
extern "C" {
#endif


/* High level TSM routines .. */

extern OSErr pascal NewTSMDocument(short numOfInterface, OSType supportedInterfaceTypes[], TSMDocumentID *idocID, long refcon);

/* MOVE.W	#selector,D0		*/

extern OSErr pascal DeleteTSMDocument(TSMDocumentID idocID);
extern OSErr pascal ActivateTSMDocument(TSMDocumentID idocID);
extern OSErr pascal DeactivateTSMDocument(TSMDocumentID idocID);

// pass all events to TSM (removed TSMDocumentID #35)

extern Boolean pascal TSMEvent(EventRecord *event);

// pass menu selection to TSM (removed TSMDocumentID #35)

extern Boolean pascal TSMMenuSelect(long menuResult);

// set the cursor (removed TSMDocumentID #35)

extern Boolean pascal SetTSMCursor(Point mousePos);

// terminate text services

extern OSErr pascal FixTSMDocument(TSMDocumentID idocID);

// get all text services

extern OSErr pascal GetServiceList(short numOfInterface, OSType supportedInterfaceTypes[], TextServiceListHandle *serviceInfo, long *seedValue);

// open the text service (return instance)

extern OSErr pascal OpenTextService(TSMDocumentID idocID, Component aComponent, ComponentInstance *aComponentInstance);

// close the text service (return instance)

extern OSErr pascal CloseTextService(TSMDocumentID idocID, ComponentInstance aComponentInstance);

/* Sending callback AppleEvents ... */


// AppleEvent should be a pointer

extern OSErr pascal SendAEFromTSMComponent(AppleEvent *theAppleEvent, AppleEvent *reply, AESendMode sendMode, AESendPriority sendPriority, long timeOutInTicks, AEIdleUPP idleProc, AEFilterUPP filterProc);

// app registers itself as TSM aware

extern OSErr pascal InitTSMAwareApplication(void);

// app deregisters itself when quit

extern OSErr pascal CloseTSMAwareApplication(void);

/*   Utilities ... */

extern OSErr pascal SetDefaultInputMethod(Component ts, ScriptLanguageRecord *slRecordPtr);
extern OSErr pascal GetDefaultInputMethod(Component *ts, ScriptLanguageRecord *slRecordPtr);
extern OSErr pascal SetTextServiceLanguage(ScriptLanguageRecord *slRecordPtr);
extern OSErr pascal GetTextServiceLanguage(ScriptLanguageRecord *slRecordPtr);
extern OSErr pascal UseInputWindow(TSMDocumentID idocID, Boolean useWindow);
extern OSErr pascal NewServiceWindow(void *wStorage, const Rect *boundsRect, ConstStr255Param title, Boolean visible, short theProc, WindowPtr behind, Boolean goAwayFlag, ComponentInstance ts, WindowPtr *window);
extern OSErr pascal CloseServiceWindow(WindowPtr window);
extern OSErr pascal GetFrontServiceWindow(WindowPtr *window);
extern short pascal FindServiceWindow(Point thePoint, WindowPtr *theWindow);

/* 	Low level routines which are dispatched directly to the Component Manager ... */

#define kCMGetScriptLangSupport 0x0001

#define kCMInitiateTextService 0x0002

#define kCMTerminateTextService 0x0003

#define kCMActivateTextService 0x0004

#define kCMDeactivateTextService 0x0005

#define kCMTextServiceEvent 0x0006

#define kCMGetTextServiceMenu 0x0007

#define kCMTextServiceMenuSelect 0x0008

#define kCMFixTextService 0x0009

#define kCMSetTextServiceCursor 0x000A

#define kCMHidePaletteWindows 0x000B


/*   Low level TSM routines ... */


/* selector = 1 */

extern ComponentResult pascal GetScriptLanguageSupport(ComponentInstance ts, ScriptLanguageSupportHandle *scriptHdl);

/* selector = 2 */

extern ComponentResult pascal InitiateTextService(ComponentInstance ts);

/* selector = 3 */

extern ComponentResult pascal TerminateTextService(ComponentInstance ts);

/* selector = 4 */

extern ComponentResult pascal ActivateTextService(ComponentInstance ts);

/* selector = 5 */

extern ComponentResult pascal DeactivateTextService(ComponentInstance ts);

/* selector = 6 */

extern ComponentResult pascal TextServiceEvent(ComponentInstance ts, short numOfEvents, EventRecord *event);

/* selector = 7 */

extern ComponentResult pascal GetTextServiceMenu(ComponentInstance ts, MenuHandle *serviceMenu);

/* selector = 8 */

extern ComponentResult pascal TextServiceMenuSelect(ComponentInstance ts, MenuHandle serviceMenu, short item);

/* selector = 9 */

extern ComponentResult pascal FixTextService(ComponentInstance ts);

/* selector = 10 */

extern ComponentResult pascal SetTextServiceCursor(ComponentInstance ts, Point mousePos);

/* selector = 11			<#37> */

extern ComponentResult pascal HidePaletteWindows(ComponentInstance ts);
#if PRAGMA_STRUCT_ALIGN
	#pragma options align=reset
#elif PRAGMA_STRUCT_PACKPUSH
	#pragma pack(pop)
#elif PRAGMA_STRUCT_PACK
	#pragma pack()
#endif

#ifdef PRAGMA_IMPORT_OFF
#pragma import off
#elif PRAGMA_IMPORT
#pragma import reset
#endif

#ifdef __cplusplus
}
#endif

#endif


