/*
 *  Json_Plugin.h
 *  MA_Plugin_x64
 *
 *  Created by pasi on 11.1.2011.
 *  Copyright 2011 Manage Applications. All rights reserved.
 *
 */
//#ifndef MA_Json_Plugin_HPP
//#define MA_Json_Plugin_HPP

#include "Includes.h"

#ifdef MA_Json // must be after #include "Includes.h"

// static wstring lastGeneralErrorText;
long MA_Json_PluginMain( long selector, PA_PluginParameters params );

// void SetLastGeneralErrorText(wstring err, wstring methName, long errNum );

// --- MA_MA_Json 4D Plugin Commands
void MA_Json_GetLastErrorText( PA_PluginParameters params );
void MA_Json_GetReferences( PA_PluginParameters params );

// Supply a block of JSON, and this returns a c_JSON object you can interrogate. Call c_JSON_Delete when finished.
void MA_Json_Parse( PA_PluginParameters params );
// Render a c_JSON entity to text for transfer/storage. Free the char* when finished.
void MA_Json_Print( PA_PluginParameters params );
// Render a c_JSON entity to text for transfer/storage without any formatting. Free the char* when finished.
void MA_Json_PrintUnformatted( PA_PluginParameters params );
// Delete a c_JSON entity and all subentities.
void MA_Json_Delete( PA_PluginParameters params );

// Returns the number of items in an array (or object).
void MA_Json_GetArraySize( PA_PluginParameters params );
// Retrieve item number "item" from array "array". Returns NULL if unsuccessful.
void MA_Json_GetArrayItem( PA_PluginParameters params );
// Get item "string" from object. Case insensitive.
void MA_Json_GetObjectItem( PA_PluginParameters params );

void MA_Json_GetObjectString( PA_PluginParameters params );
void MA_Json_GetObjectLong( PA_PluginParameters params );
void MA_Json_GetObjectReal( PA_PluginParameters params );

void MA_Json_GetItemName( PA_PluginParameters params );
void MA_Json_GetItemType( PA_PluginParameters params );

void MA_Json_GetItemString( PA_PluginParameters params );
void MA_Json_GetItemBoolean( PA_PluginParameters params );
void MA_Json_GetItemLong( PA_PluginParameters params );
void MA_Json_GetItemReal( PA_PluginParameters params );

void MA_Json_GetItemStringArray( PA_PluginParameters params );
void MA_Json_GetItemLongArray( PA_PluginParameters params );
void MA_Json_GetItemRealArray( PA_PluginParameters params );

// These calls create a c_JSON item of the appropriate type.
void MA_Json_CreateNull( PA_PluginParameters params );
void MA_Json_CreateTrue( PA_PluginParameters params );
void MA_Json_CreateFalse( PA_PluginParameters params );
void MA_Json_CreateNumber( PA_PluginParameters params );
void MA_Json_CreateString( PA_PluginParameters params );

void MA_Json_CreateArray( PA_PluginParameters params );
void MA_Json_CreateObject( PA_PluginParameters params );
													 
// These utilities create an Array of count items.		 
void MA_Json_CreateStringArray( PA_PluginParameters params );
void MA_Json_CreateLongArray( PA_PluginParameters params );
void MA_Json_CreateRealArray( PA_PluginParameters params );

													 
// Append item to the specified array/object.
void MA_Json_AddItemToArray( PA_PluginParameters params );
void MA_Json_AddItemToObject( PA_PluginParameters params );
// Append reference to item to the specified array/object. Use this when you want to add an existing c_JSON to a new c_JSON, but don't want to corrupt your existing c_JSON.
void MA_Json_AddItemRefToArray( PA_PluginParameters params );
void MA_Json_AddItemRefToObject( PA_PluginParameters params );

// Remove/Detatch items from Arrays/Objects.
void MA_Json_DetachItemFromArray( PA_PluginParameters params );
void MA_Json_DeleteItemFromArray( PA_PluginParameters params );
void MA_Json_DetachItemFromObject( PA_PluginParameters params );
void MA_Json_DeleteItemFromObject( PA_PluginParameters params );


// Update array items.
void MA_Json_ReplaceItemInArray( PA_PluginParameters params );
void MA_Json_ReplaceItemInObject( PA_PluginParameters params );

void MA_Json_AddNullToObject( PA_PluginParameters params );
void MA_Json_AddTrueToObject( PA_PluginParameters params );
void MA_Json_AddFalseToObject( PA_PluginParameters params );
void MA_Json_AddNumberToObject( PA_PluginParameters params );
void MA_Json_AddStringToObject( PA_PluginParameters params );

#endif
