/* -*- mode: C++ c-basic-offset: 4 -*-
 * 
 * Copyright (c) 1999 Joe Yandle <jwy@divisionbyzero.com>
 * 
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 * 
 */

#include "Blob.h"

//#include "util.hh"

//#include <sstream>

const long CAPACITY = 255; // default initial size	

TBlob::TBlob() {
    m_cap = CAPACITY;
    m_data = new string( m_cap, ' ' );
    m_sz = 0;		// just initial capacity size set here, not real used size
}

TBlob::TBlob(long n) {
    m_cap = n;
    m_data = new string( m_cap, ' ' );
    m_sz = 0;		// just initial capacity size set here, not real used size
}


TBlob::~TBlob() {
    delete m_data;	// delete m_data;
}

/* inline, in Blob.h
long TBlob::length() const {
    return m_sz;
}
*/

/* inline, in Blob.h
long TBlob::get_size() const {
    return m_cap;
}
*/

void TBlob::set_length(long i) {
    if(m_cap < i) { // = this->set_size_if(i);
        m_cap = i;
				m_data->reserve( m_cap );
    }
    m_sz = i;
}

void TBlob::set_length_preserve_old(long i) {
    if(m_cap < i) {
				m_data->resize(i);
				m_cap = i;
    }
    m_sz = i;
}

/* inline  in Blob.h
char* TBlob::startPtr() {
	const char *startPtr = m_data->data();
	return (char *)startPtr;
}
*/

void TBlob::clear() {
    m_sz = 0;
}

void TBlob::set_size_if(long s) {
    if(m_cap < s) {
        m_cap = s;
				m_data->reserve( m_cap );
    }
}

void TBlob::set_size(long s) {
    if(m_cap != s) {
				m_data->reserve( m_cap );
    }
}
