/* -*- mode: C++ c-basic-offset: 4 -*-
 * 
 * Copyright (c) 1999 Joe Yandle <jwy@divisionbyzero.com>
 * 
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 * 
 */

#include "Includes.h"

#ifndef TBlobHPP
#define TBlobHPP


/**
 * Class TBlob is a container for binary large objects, hence blob.
 */
class TBlob {

protected:
    
    string *m_data;
    long m_sz;
    long m_cap;

public:
    /**
     * Default constructor.
     */
    TBlob();
    
    /**
     * Construct empty blob with specified capacity.
     *
     * @param n initial capacity
     */
    TBlob(long n);
    
    /**
     * Destructor.
     */
    virtual ~TBlob();
    
    inline long length() const {
				return m_sz;
		}
		
    inline long get_size() const {
				return m_cap;
		}
    /**
     * Set length of TBlob.
     *
     * @param size number of bytes occupied by data
     */
    void set_length(long size);

    /**
     * Set length of TBlob.
     *
     * @param size number of bytes occupied by data and copy old data if resize is needed
     */
    void set_length_preserve_old(long size);

    /**
     * make buffer at least s big; if it's big enough, leave
     * it alone.
     */
    void set_size_if(long s);


    /**
     * make buffer exactly s big
     *
     */
    void set_size(long s);

    
    /**
     * Get a pointer to the internal data array.
     *
     * @return pointer to internal array
     */
		//char* startPtr();
		inline char* startPtr() {
		const char *startPtr = m_data->data();
			//char *startPtr = m_data->data();
			return (char *)startPtr;
		}
    
    void clear();
    
    template<class T>
		void byte_copy(T* t, long n, long offset=0) {

			if( offset + n > m_cap ) { // NOT max_size
				m_cap = offset + n;
				m_data->resize( m_cap ); // logical size error here!
			}
			
			//wstring& assign( const char* str, size_type num );
			if( offset < 0 )
				offset = 0;									 // logical size error here!

			if( offset == 0 )
				m_data->assign( t, n);
			else {
				m_data->resize( offset );
				m_data->append( t, n);
			}

			if( m_sz < (offset + n) )
				m_sz = offset + n;			// logical size error here!

		}
    
};

#endif //TBlobHPP
