// -----------------------------------------------------------------------------
//		MA_Plugin_x64.r
// 
//		Written by: Pasi Mankinen
// 
//		Copyright:	© 2002-2008 by Manage Applications, All rights reserved. 
//		This file is used in macintos to compile resorce
// -----------------------------------------------------------------------------


#ifndef	__MA_PluginIMPL_R__
#define	__MA_PluginIMPL_R__


#include <Carbon/Carbon.r>

#include "Const.h"


// -----------------------------------------------------------------------------
//	Types
// -----------------------------------------------------------------------------

type '4BNX'
{
	integer = $$Countof(BundleArray);
	array BundleArray
	{
		literal longint;		// Type
		integer;				// Local Id
		integer;				// Global Id	
	};
};

type '4DK#'
{
	integer = $$Countof(VarArray);
	array VarArray
	{
		pstring;
	};
};

type 'VAR#'
{
	integer = $$Countof(VarArray);
	array VarArray
	{
		pstring;
	};
};

type 'THM#'
{
	integer = $$Countof(ThmArray);
	array ThmArray
	{
		pstring;
	};
};

type 'FON#'
{
	array MapArray
	{
		byte;
	};
};


// -----------------------------------------------------------------------------
//	4D Bundle
// -----------------------------------------------------------------------------

resource '4BNX' (kMA_PluginGlobalBaseResID + 0, "MA_Plugin_x64") 
{
	{
		'STR#', kMA_PluginLocalBaseResID, kMA_PluginGlobalBaseResID,
		'THM#', kMA_PluginLocalBaseResID, kMA_PluginGlobalBaseResID,
		'FON#', kMA_PluginLocalBaseResID, kMA_PluginGlobalBaseResID
	}
};


// -----------------------------------------------------------------------------
//	Commands
// -----------------------------------------------------------------------------

resource 'STR#' (kMA_PluginGlobalBaseResID + 0, "MA_Plugin_x64_Commands", purgeable) 
{
	{			
		
		"MA_v12_Register(&S):L",		
		"MA_v12_IsRegistered():L",		
		"MA_v12_SetErrorCallback(&S):L",	
		"MA_Util_Sha2(&L;&S):S",
					     
		// MA_DNS
		"MA_DNS_GetHostName:S",
		"MA_DNS_GetHostByName(&S):S",
		"MA_DNS_GetHostByAddress(&S):S",
		"MA_DNS_GetLocalAddresses(&Y;&Y;&Y)",
		
		// MA_TCP
    "MA_TCP_SQLReinitialize:L",
    "MA_TCP_GetVersion():S",

		"MA_TCP_GetLastErrorText(&L):T",
		"MA_TCP_Connect(&S;&L;&T):L",
		"MA_TCP_Close(&L):L",
		"MA_TCP_Listen(&S;&L;&T):L",
		"MA_TCP_Accept(&L):L",
		"MA_TCP_SendBlob(&L;&O;&L;&L):L",
		"MA_TCP_ReceiveBlob(&L;&O;&L;&L):L",
		"MA_TCP_LookaheadBlob(&L;&O;&L;&L):L",
		"MA_TCP_GetLocalAddress(&L;&S;&L):L",
		"MA_TCP_GetRemoteAddress(&L;&S;&L):L",
		"MA_TCP_GetOSSocket(&L):L",
		"MA_TCP_GetState(&L):L",
    
    "MA_TCP_SetPollArrays(&L,&Y;&Y;&Y):L",
    "MA_TCP_CreatePollset(&L;&L):L",
    "MA_TCP_DestroyPollset(&L):L",
    "MA_TCP_Poll(&L;&L;&Y;&Y):L",
    "MA_TCP_GetPollCounts(&L;&L;&L):L",
		
		// MA_Zmq
		"MA_Zmq_Test(&L):L",
		"MA_Zmq_GetVersion(&L):T",
		"MA_Zmq_GetLastErrorText():T",
		"MA_Zmq_GetLastErrorNum():L",
		"MA_Zmq_GetContext():L",
		"MA_Zmq_GetSocketCount():L",
		"MA_Zmq_GetSocketValidity(&L):L:",
		"MA_Zmq_GetSockets(&Y):L",
		"MA_Zmq_SetPollArrays(&Y;&Y;&Y;&Y):L",
		
		"MA_Zmq_context_init(&L):L",
		"MA_Zmq_context_terminate(&L):L",
		
		"MA_Zmq_socket_create(&L;&L):L",
		"MA_Zmq_socket_close(&L):L",
		"MA_Zmq_socket_opt_set(&L;&L;&L):L",
		"MA_Zmq_socket_opt_get(&L;&L;&L):L",
		"MA_Zmq_socket_identity_set(&L;&T):L",
		"MA_Zmq_socket_identity_get(&L;&T):L",
		
		"MA_Zmq_socket_bind(&L;&T):L",
		"MA_Zmq_socket_connect(&L;&T):L",
		
		"MA_Zmq_send(&L;&O;&L):L",
		"MA_Zmq_receive(&L;&O;&L):L",
    "MA_Zmq_forward(&L;&L):L",
		"MA_Zmq_poll(&L):L",
		
		
		// --- MA_MA_Json 4D Plugin Commands
		"MA_Json_GetLastErrorText(&L):T",
		"MA_Json_GetReferences(&Y,&Y):L",
		
		// Supply a block of JSON, and this returns a c_JSON object you can interrogate. Call c_JSON_Delete when finished.
		"MA_Json_Parse(&O):L",
		// Render a c_JSON entity to text for transfer/storage. Free the char* when finished.
		"MA_Json_Print(&L;&O):L",
		// Render a c_JSON entity to text for transfer/storage without any formatting. Free the char* when finished.
		"MA_Json_PrintUnformatted(&L;&O):L",
		// Delete a c_JSON entity and all subentities.
		"MA_Json_Delete(&L):L",
		
		// Returns the number of items in an array (or object).
		"MA_Json_GetArraySize(&L):L",
		// Retrieve item number "item" from array "array". Returns NULL if unsuccessful.
		"MA_Json_GetArrayItem(&L;&L):L",
		// Get item "string" from object. Case insensitive.
		"MA_Json_GetObjectItem(&L;&O):L",
		
		"MA_Json_GetObjectString(&L;&O;&O):L",
		"MA_Json_GetObjectLong(&L;&O;&L):L",
		"MA_Json_GetObjectReal(&L;&O;&8):L",
		
		"MA_Json_GetItemName(&L;&O):L",
		"MA_Json_GetItemType(&L):L",
    
		"MA_Json_GetItemString(&L;&O):L",
		"MA_Json_GetItemBoolean(&L;&L):L",
		"MA_Json_GetItemLong(&L;&L):L",
		"MA_Json_GetItemReal(&L;&8):L",
		
		"MA_Json_GetItemStringArray(&L;&Y;&L;&L):L", 
		"MA_Json_GetItemLongArray(&L;&Y;&L;&L):L", 
		"MA_Json_GetItemRealArray(&L;&Y;&L;&L):L",
		
				// These calls create a c_JSON item of the appropriate type.
		"MA_Json_CreateNull():L",
		"MA_Json_CreateTrue():L",
		"MA_Json_CreateFalse():L",
		"MA_Json_CreateNumber(&8):L",
		"MA_Json_CreateString(&O):L",
		"MA_Json_CreateArray():L",
		"MA_Json_CreateObject():L",
		
		// These utilities create an Array of count items.	
		"MA_Json_CreateStringArray(&Y;&L;&L):L",	 
		"MA_Json_CreateLongArray(&Y;&L;&L):L",
		"MA_Json_CreateRealArray(&Y;&L;&L):L",
		
		// Append item to the specified array/object.
		"MA_Json_AddItemToArray(&L;&L):L",
		"MA_Json_AddItemToObject(&L;&O;&L):L",
		// Append reference to item to the specified array/object. Use this when you want to add an existing c_JSON to a new c_JSON, but don't want to corrupt your existing c_JSON.
		"MA_Json_AddItemRefToArray(&L;&L):L",
		"MA_Json_AddItemRefToObject(&L;&O;&L):L",
		
		// Remove/Detatch items from Arrays/Objects.
		"MA_Json_DetachItemFromArray(&L;&L):L",
		"MA_Json_DeleteItemFromArray(&L;&L):L",
		"MA_Json_DetachItemFromObject(&L;&O):L",
		"MA_Json_DeleteItemFromObject(&L;&O):L",
		
		
		// Update array items.
		"MA_Json_ReplaceItemInArray(&L;&L;&L):L",
		"MA_Json_ReplaceItemInObject(&L;&O;&L):L",
		
		"MA_Json_AddNullToObject(&L;&O):L",
		"MA_Json_AddTrueToObject(&L;&O):L",
		"MA_Json_AddFalseToObject(&L;&O:L",
		"MA_Json_AddNumberToObject(&L;&O;&8):L",
		"MA_Json_AddStringToObject(&L;&O;&O):L",
    
    "MA_SharedMemory(&L;&L;&O):L",
    "MA_Microseconds(&8):8",
    "MA_Milliseconds(&8):8",
    "MA_Seconds(&8):8",
    "MA_Markdown(&O;&O;&L;&L;&L):L",
    "MA_LuaText(&T;&T):T",
    "MA_LuaBlob(&O;&O;&O):L" // no "," after last!
		
    
		// "MA_TCP_Send(&L;&T):L",
		/* [18] */
		// "MA_TCP_Receive(&L;&T;&L):L",
		/* [19] */
		// "MA_TCP_Lookahead(&L;&T;&L):L",
		/* [20] */
		// "MA_TCP_Get SSL Verify Result(&L;&L;&S)",
		/* [21] */
		// "MA_TCP_Is Secure Connection(&L):L",
		/* [22] */
		// "MA_UDP_Open:L",
		/* [23] */
		// "MA_UDP_Listen(&S;&L):L",
		/* [24] */
		// "MA_UDP_Close(&L)",
		/* [25] */
		// "MA_UDP_Send(&L;&T;&S;&L):L",
		/* [26] */
		// "MA_UDP_Send Blob(&L;&O;&S;&L):L",
		/* [27] */
		// "MA_UDP_Receive(&L;&T;&S;&L):L",
		/* [28] */
		// "MA_UDP_Receive Blob(&L;&O;&S;&L):L",
		/* [29] */
		// "MA_UDP_Join Group(&L;&S)",
		/* [30] */
		// "MA_UDP_Leave Group(&L;&S)",
		/* [31] */
		// "MA_UDP_Set Max Router Hops(&L;&L)",
		/* [32] */
		// "MA_UDP_Send To Self(&L;&L)",
		/* [33] */
		// "MA_IPC_New Channel(&L;&S):L",
		/* [34] */
		// "MA_IPC_Delete Channel(&L)",
		/* [35] */
		// "MA_IPC_Get Channel Name(&L):S",
		/* [36] */
		// "MA_IPC_Send(&L;&T;&T;&L)",
		/* [37] */
		// "MA_IPC_Broadcast(&S;&T;&T;&L)",
		/* [38] */
		// "MA_IPC_Receive(&L;&T;&T;&L):L",
		/* [39] */
		// "MA_IPC_Count Messages(&L):L",
		/* [40] */
		// "MA_IPC_Get Message By Index(&L;&L;&T;&T)",
		/* [41] */
		// "MA_IPC_Count Channels:L",
		/* [42] */
		// "MA_IPC_Get Channel By Index(&L):L",
		/* [43] */
		// "MA_IPC_Get Channel By Name(&S):L"
				

	}
};


// -----------------------------------------------------------------------------
//	Topics
// -----------------------------------------------------------------------------


resource 'FON#' (kMA_PluginGlobalBaseResID + 0, "MA_Plugin_x64_Topics")
{
	{
		// this order must match with the resource 'THM#'
			
		1,					// "MA_v12_Register(&S):L",		
		1,					// "MA_v12_IsRegistered():L",		
		1,					// "MA_v12_SetErrorCallback(&S):L",	
		1,					// "MA_Util_Sha2(&L;&S):S"

		// MA_DNS Commands
		2,					// MA_DNS_GetHostName
		2,					// MA_DNS_GetHostByName
		2,					// MA_DNS_GetHostByAddress
		2,					// MA_DNS_GetLocalAddresses
		
		// MA_TCP Commands
		3,					// MA_TCP_SQLReinitialize
    3,          // MA_TCP_GetVersion

		3,					// MA_TCP_GetLastErrorText
		3,					// MA_TCP_Connect
		3,					// MA_TCP_Close
		3,					// MA_TCP_Listen
		3,					// MA_TCP_Accept
		3,					// MA_TCP_SendBlob
		3,					// MA_TCP_ReceiveBlob
		3,					// MA_TCP_LookaheadBlob
		3,					// MA_TCP_GetLocalAddress
		3,					// MA_TCP_GetRemoteAddress
		3,					// MA_TCP_GetOSSocket
		3,					// MA_TCP_GetState
    
    3,					// "MA_TCP_SetPollArrays(&L,&Y;&Y;&Y):L",
    3,					// "MA_TCP_CreatePollset(&L;&L):L",
    3,					// "MA_TCP_DestroyPollset(&L):L",
    3,					// "MA_TCP_Poll(&L;&L;&Y;&Y):L"
    3,					// "MA_TCP_GetPollCounts(&L;&L;&L):L",
		
		// MA_Zmq Commands		
		4, // "MA_Zmq_Test(&L):L",
		4, // "MA_Zmq_GetVersion(&L):T",
		4, // "MA_Zmq_GetLastErrorText():T",
		4, // "MA_Zmq_GetLastErrorNum():L",
		4, // "MA_Zmq_GetContext():L",
		4, // "MA_Zmq_GetSocketCount():L",
		4, // "MA_Zmq_GetSocketValidity(&L):L:",
		4, // "MA_Zmq_GetSockets(&Y):L",
		4, // "MA_Zmq_SetPollArrays(&Y;&Y;&Y;&Y):L"
	
		
		4, // "MA_Zmq_context_init(&L):L",
		4, // "MA_Zmq_context_terminate(&L):L",
		
		4, // "MA_Zmq_socket_create(&L;&L):L",
		4, // "MA_Zmq_socket_close(&L):L",
		4, // "MA_Zmq_socket_opt_set(&L;&L;&L):L",
		4, // "MA_Zmq_socket_opt_get(&L;&L;&L):L",
		4, // "MA_Zmq_socket_identity_set(&L;&T):L",
		4, // "MA_Zmq_socket_identity_get(&L;&T):L",
		
		4, // "MA_Zmq_socket_bind(&L;&T):L",
		4, // "MA_Zmq_socket_connect(&L;&T):L",
		
		4, // "MA_Zmq_send(&L;&O;&L):L",
		4, // "MA_Zmq_receive(&L;&O;&L):L",
		4, // "MA_Zmq_forward(&L;&L):L",
		4,  // "MA_Zmq_poll(&L):L"	
		
		// --- MA_MA_Json 4D Plugin Commands
		5, //MA_Json_GetLastErrorText
		
		// Supply a block of JSON, and this returns a c_JSON object you can interrogate. Call c_JSON_Delete when finished.
		5, //MA_Json_Parse
		// Render a c_JSON entity to text for transfer/storage. Free the char* when finished.
		5, //MA_Json_Print
		// Render a c_JSON entity to text for transfer/storage without any formatting. Free the char* when finished.
		5, //MA_Json_PrintUnformatted
		// Delete a c_JSON entity and all subentities.
		5, //MA_Json_Delete
		
		// Returns the number of items in an array (or object).
		5, //MA_Json_GetArraySize
		// Retrieve item number "item" from array "array". Returns NULL if unsuccessful.
		5, //MA_Json_GetArrayItem
		// Get item "string" from object. Case insensitive.
		5, //MA_Json_GetObjectItem
		
		5, //	"MA_Json_GetObjectString(&L;&O;&O):L",
		5, // "MA_Json_GetObjectLong(&L;&O;&L):L",
		5, // "MA_Json_GetObjectReal(&L;&O;&8):L",
		
		5, //	"MA_Json_GetItemString(&L;&O):L",
		5, // "MA_Json_GetItemBoolean(&L;&L):L",
		5, // "MA_Json_GetItemLong(&L;&L):L",
		5, // "MA_Json_GetItemReal(&L;&8):L",
		
		5, //	"MA_Json_GetItemStringArray(&Y;&L;&L):L",
		5, //	"MA_Json_GetItemLongArray(&Y;&L;&L):L",
		5, //	"MA_Json_GetItemRealArray(&Y;&L;&L):L",
		
		// These calls create a c_JSON item of the appropriate type.
		5, //MA_Json_CreateNull
		5, //MA_Json_CreateTrue
		5, //MA_Json_CreateFalse
		5, //MA_Json_CreateNumber
		5, //MA_Json_CreateString
		5, //MA_Json_CreateArray
		5, //MA_Json_CreateObject
		
		// These utilities create an Array of count items.	
		5, //MA_Json_CreateStringArray	 
		5, //MA_Json_CreateLongArray
		5, //MA_Json_CreateRealArray
		
		
		// Append item to the specified array/object.
		5, //MA_Json_AddItemToArray PA_PluginParameters params );
		5, //MA_Json_AddItemToObject
		// Append reference to item to the specified array/object. Use this when you want to add an existing c_JSON to a new c_JSON, but don't want to corrupt your existing c_JSON.
		5, //MA_Json_AddItemRefToArray
		5, //MA_Json_AddItemRefToObject
		
		// Remove/Detatch items from Arrays/Objects.
		5, //MA_Json_DetachItemFromArray
		5, //MA_Json_DeleteItemFromArray
		5, //MA_Json_DetachItemFromObject
		5, //MA_Json_DeleteItemFromObject
		
		
		// Update array items.
		5, //MA_Json_ReplaceItemInArray
		5, //MA_Json_ReplaceItemInObject
		
		5, //MA_Json_AddNullToObject
		5, //MA_Json_AddTrueToObject
		5, //MA_Json_AddFalseToObject
		5, //MA_Json_AddNumberToObject
		5, //MA_Json_AddStringToObject
		
		6, //MA_SharedMemory(&L;&L;&O):L"
    6, //"MA_Microseconds(8):8",
    6, //"MA_Milliseconds(8):8",
    6, //"MA_Seconds(8):8",
		6, //MA_Markdown(&O;&O;&L;&L;&L):L"
		6, //MA_LuaText(&T;&T):T"
		6  //MA_LuaBlob(&O;&O;&O):L"
		
	}
};


/* old or not in use
 7,					// MA_TCP_Send // use only Send Blob
 7,					// MA_TCP_Receive
 7,					// MA_TCP_Lookahead
 7,					// MA_TCP_Get SSL Verify Result
 7,					// MA_TCP_Is Secure Connection
 
 8,					// MA_UDP_Open
 8,					// MA_UDP_Listen
 8,					// MA_UDP_Close
 8,					// MA_UDP_Send
 8,					// MA_UDP_Send Blob
 8,					// MA_UDP_Receive
 8,					// MA_UDP_Receive Blob
 8,					// MA_UDP_Join Group
 8,					// MA_UDP_Leave Group
 8,					// MA_UDP_Set Max Router Hops
 8,					// MA_UDP_Send To Self
 
 9,					// MA_IPC_New Channel
 9,					// MA_IPC_Delete Channel
 9,					// MA_IPC_Get Channel Name
 9,					// MA_IPC_Send
 9,					// MA_IPC_Broadcast
 9,					// MA_IPC_Receive
 9,					// MA_IPC_Count Messages
 9,					// MA_IPC_Get Message By Index
 9,					// MA_IPC_Count Channels
 9,					// MA_IPC_Get Channel By Index
 9,					// MA_IPC_Get Channel By Name		
*/


// -----------------------------------------------------------------------------
//	Themes
// -----------------------------------------------------------------------------

resource 'THM#' (kMA_PluginGlobalBaseResID + 0, "MA_Plugin_x64_Themes")
{
	{
		"MA_Plugin_x64",			// 1
		"MA_Socket_DNS",	// 2
		"MA_Socket_TCP",			// 3
		"MA_Zmq",	// 4
		"MA_Json",	// 5
		"MA_Utility"			// 6
		
		//"MA_Socket_UDP",			// x
		//"MA_Socket_IPC"			// x
	}
};

// -----------------------------------------------------------------------------
//	Konstants
// -----------------------------------------------------------------------------

/* in User Constants.bundle 
resource '4DK#' (kMA_PluginGlobalBaseResID + 0, "_GlobalKonstants")
{
	{
		//
		"kFalse:0:L",
		"kTrue:1:L",
		"ksCR:\r:S",
		"ksTab:\t:S"
	}
};
 */

// #ifdef MA_Zmq
resource '4DK#' (kMA_PluginGlobalBaseResID + 0, "MA_Zmq_General")
{
	{	
		// Socket types.             
		"MA_Zmq_VersionZmq:0:L",                            
		"MA_Zmq_VersionPlugin:1:L"
	}
};

resource '4DK#' (kMA_PluginGlobalBaseResID + 1, "MA_Zmq_SocketTypes")
{
	{	
// Socket types.                                         
		"ZMQ_PAIR:0:L",
		"ZMQ_PUB:1:L",
		"ZMQ_SUB:2:L",
		"ZMQ_REQ:3:L",
		"ZMQ_REP:4:L",
		"ZMQ_XREQ:5:L",
		"ZMQ_DEALER:5:L",
		"ZMQ_XREP:6:L",
		"ZMQ_ROUTER:6:L",
		"ZMQ_PULL:7:L",
		"ZMQ_PUSH:8:L",
		"ZMQ_XPUB:9:L",
		"ZMQ_XSUB:10:L"
	}
};

resource '4DK#' (kMA_PluginGlobalBaseResID + 2, "MA_Zmq_SocketOptions")
{
	{	
// Socket options. 
		"ZMQ_AFFINITY:4:L",
		"ZMQ_IDENTITY:5:L",
		"ZMQ_SUBSCRIBE:6:L",
		"ZMQ_UNSUBSCRIBE:7:L",
		"ZMQ_RATE:8:L",
		"ZMQ_RECOVERY_IVL:9:L",
		"ZMQ_SNDBUF:11:L",
		"ZMQ_RCVBUF:12:L",
		"ZMQ_RCVMORE:13:L",
		"ZMQ_FD:14:L",
		"ZMQ_EVENTS:15:L",
		"ZMQ_TYPE:16:L",
		"ZMQ_LINGER:17:L",
		"ZMQ_RECONNECT_IVL:18:L",
		"ZMQ_BACKLOG:19:L",
		"ZMQ_RECONNECT_IVL_MAX:21:L",
		"ZMQ_MAXMSGSIZE:22:L",
		"ZMQ_SNDHWM:23:L",
		"ZMQ_RCVHWM:24:L",
		"ZMQ_MULTICAST_HOPS:25:L",
		"ZMQ_RCVTIMEO:27:L",
		"ZMQ_SNDTIMEO:28:L",
		"ZMQ_IPV4ONLY:31:L",
		"ZMQ_LAST_ENDPOINT:32:L",
		"ZMQ_FAIL_UNROUTABLE:33:L",
		"ZMQ_TCP_KEEPALIVE:34:L",
		"ZMQ_TCP_KEEPALIVE_CNT:35:L",
		"ZMQ_TCP_KEEPALIVE_IDLE:36:L",
		"ZMQ_TCP_KEEPALIVE_INTVL:37:L",
		"ZMQ_TCP_ACCEPT_FILTER:38:L"
	}
};


resource '4DK#' (kMA_PluginGlobalBaseResID + 3, "MA_Zmq_SendRecvOptions")
{
	{	
		
// Send/recv options.
		"ZMQ_SND:0:L",		
		"ZMQ_DONTWAIT:1:L",
		"ZMQ_SNDMORE:2:L",				
//  I/O multiplexing.
		"ZMQ_POLLIN:1:L",
		"ZMQ_POLLOUT:2:L",
		"ZMQ_POLLERR:4:L"
	}
};

resource '4DK#' (kMA_PluginGlobalBaseResID + 4, "MA_Zmq_EventOptions")
{
	{	
		/*
     #define ZMQ_EVENT_CONNECTED 1
     #define ZMQ_EVENT_CONNECT_DELAYED 2
     #define ZMQ_EVENT_CONNECT_RETRIED 4
     
     #define ZMQ_EVENT_LISTENING 8
     #define ZMQ_EVENT_BIND_FAILED 16
     
     #define ZMQ_EVENT_ACCEPTED 32
     #define ZMQ_EVENT_ACCEPT_FAILED 64
     
     #define ZMQ_EVENT_CLOSED 128
     #define ZMQ_EVENT_CLOSE_FAILED 256
     #define ZMQ_EVENT_DISCONNECTED 512
     */
    // event options.
		"ZMQ_EVENT_CONNECTED:1:L",		
		"ZMQ_EVENT_CONNECT_DELAYED:2:L",
		"ZMQ_EVENT_CONNECT_RETRIED:4:L",	
    
		"ZMQ_EVENT_LISTENING:8:L",
		"ZMQ_EVENT_BIND_FAILED:16:L",
    
		"ZMQ_EVENT_ACCEPTED:32:L",
		"ZMQ_EVENT_ACCEPT_FAILED:64:L",
    
		"ZMQ_EVENT_CLOSED:128:L",
		"ZMQ_EVENT_CLOSE_FAILED:256:L",
		"ZMQ_EVENT_DISCONNECTED:512:L"
	}
};

resource '4DK#' (kMA_PluginGlobalBaseResID + 5, "MA_JsonErrorTypes")
{
	{	
		/*
		#define				kJsonNotValid					-1
		#define				kJsonNotFound					-101
		#define				kJsonWrongType				-102
		*/
		// MA_JsonErrorTypes
		"kJsonNotValid:-1:L",
		"kJsonNotFound:-101:L",			
		"kJsonWrongType:-102:L"
	}
};

resource '4DK#' (kMA_PluginGlobalBaseResID + 6, "MA_TcpPollOptions")
{
	{	
		/*
     #define 	APR_POLLIN   0x001
     #define 	APR_POLLPRI   0x002
     #define 	APR_POLLOUT   0x004
     #define 	APR_POLLERR   0x010
     #define 	APR_POLLHUP   0x020
     #define 	APR_POLLNVAL   0x040
     
     #define 	APR_POLLSET_THREADSAFE   0x001
     #define 	APR_POLLSET_NOCOPY   0x002
     #define 	APR_POLLSET_WAKEABLE   0x004
     #define 	APR_POLLSET_NODEFAULT   0x010
     
     The event bitmasks in events and revents have the following bits:
     
     POLLERR        An exceptional condition has occurred on the device or socket.  This flag is output
     only, and ignored if present in the input events bitmask.
     
     POLLHUP        The device or socket has been disconnected.  This flag is output only, and ignored if
     present in the input events bitmask.  Note that POLLHUP and POLLOUT are mutually exclu-
     sive and should never be present in the revents bitmask at the same time.
     
     POLLIN         Data other than high priority data may be read without blocking.  This is equivalent to
     ( POLLRDNORM | POLLRDBAND ).
     
     POLLNVAL       The file descriptor is not open.  This flag is output only, and ignored if present in
     the input events bitmask.
     
     POLLOUT        Normal data may be written without blocking.  This is equivalent to POLLWRNORM.
     
     POLLPRI        High priority data may be read without blocking.
     
     POLLRDBAND     Priority data may be read without blocking.
     
     POLLRDNORM     Normal data may be read without blocking.
     
     POLLWRBAND     Priority data may be written without blocking.
     
     POLLWRNORM     Normal data may be written without blocking.
     
     The distinction between normal, priority, and high-priority data is specific to particular file types
     or devices.

     
     enum  	apr_pollset_method_e { 
     APR_POLLSET_DEFAULT, APR_POLLSET_SELECT, APR_POLLSET_KQUEUE, APR_POLLSET_PORT, 
     APR_POLLSET_EPOLL, APR_POLLSET_POLL 
     }
     
     APR_POLLSET_DEFAULT 	
     Platform default poll method
     
     APR_POLLSET_SELECT 	
     Poll uses select method
     
     APR_POLLSET_KQUEUE 	
     Poll uses kqueue method
     
     APR_POLLSET_PORT 	
     Poll uses Solaris event port method
     
     APR_POLLSET_EPOLL 	
     Poll uses epoll method
     
     APR_POLLSET_POLL 	
     Poll uses poll method
     
     */
    
		// MA_TcpOptions
    
		"TCP_POLLIN:1:L",
		"TCP_POLLPRI:2:L",			
		"TCP_POLLOUT:4:L",			
		"TCP_POLLERR:16:L",			
		"TCP_POLLHUP:32:L",			
		"TCP_POLLNVAL:64:L",			
		"TCP_POLLSET_THREADSAFE:1:L",			
		"TCP_POLLSET_NOCOPY:2:L",			
		"TCP_POLLSET_WAKEABLE:4:L",			
		"TCP_POLLSET_NODEFAULT:16:L",
    
		"TCP_POLLSET_DEFAULT:0:L",
		"TCP_POLLSET_SELECT:1:L",
		"TCP_POLLSET_KQUEUE:2:L",
		"TCP_POLLSET_PORT:3:L",
		"TCP_POLLSET_EPOLL:4:L",
		"TCP_POLLSET_POLL:5:L"
    
	}
};

resource '4DK#' (kMA_PluginGlobalBaseResID + 7, "MA_SharedMemoryCommands")
{
	{	
		"kShmBoostCreate:11:L",			
		"kShmBoostDelete:12:L",			
		"kShmBoostAttach:13:L",			
		"kShmBoostDetach:14:L",
		"kShmBoostStatus:21:L",	
		"kShmBoostMessageSize:22:L",
		"kShmBoostRead:23:L",			
		"kShmBoostWrite:24:L",	
    
		"kShmAprCreate:111:L",			
		"kShmAprDelete:112:L",			
		"kShmAprAttach:113:L",			
		"kShmAprDetach:114:L",
		"kShmAprStatus:121:L",	
		"kShmAprMessageSize:122:L",
		"kShmAprRead:123:L",			
		"kShmAprWrite:124:L"
	}
};


resource '4DK#' (kMA_PluginGlobalBaseResID + 8, "MA_MarkdownOptions")
{
  /*
  // inExtensions:
  enum mkd_extensions {
    MKDEXT_NO_INTRA_EMPHASIS = (1 << 0), // no_intra_emphasis
    MKDEXT_TABLES = (1 << 1), // tables
    MKDEXT_FENCED_CODE = (1 << 2), // fenced_code_blocks
    MKDEXT_AUTOLINK = (1 << 3), // autolink
    MKDEXT_STRIKETHROUGH = (1 << 4), // strikethrough
    MKDEXT_SPACE_HEADERS = (1 << 6), // space_after_headers
    MKDEXT_SUPERSCRIPT = (1 << 7), // superscript
    MKDEXT_LAX_SPACING = (1 << 8), // lax_spacing
  };
  
  // inRendererFlags (=HtmlOptions):
  typedef enum {
    HTML_SKIP_HTML = (1 << 0), // filter_html
    HTML_SKIP_STYLE = (1 << 1), // no_styles
    HTML_SKIP_IMAGES = (1 << 2), // no_images
    HTML_SKIP_LINKS = (1 << 3), // no_links
    HTML_EXPAND_TABS = (1 << 4), // expand_tabs
    HTML_SAFELINK = (1 << 5), // safe_links_only
    HTML_TOC = (1 << 6), // with_toc_data
    HTML_HARD_WRAP = (1 << 7), // hard_wrap
    HTML_USE_XHTML = (1 << 8), // xhtml
    HTML_ESCAPE = (1 << 9), // html_escape (?)
  } html_render_mode;
  */
   
	{	
		"MarkdownExt_no_intra_emphasis:1:L",		
		"MarkdownExt_tables:2:L",
		"MarkdownExt_fenced_code_blocks:4:L",	
		"MarkdownExt_autolink:8:L",
		"MarkdownExt_strikethrough:16:L",
    // no (1 << 5) = 32
		"MarkdownExt_space_after_headers:64:L",
		"MarkdownExt_superscript:128:L",
		"MarkdownExt_lax_spacing:256:L",
    
		"MarkdownRender_filter_html:1:L",		
		"MarkdownRender_no_styles:2:L",
		"MarkdownRender_no_images:4:L",	
		"MarkdownRender_no_links:8:L",
		"MarkdownRender_expand_tabs:16:L",
		"MarkdownRender_safe_links_only:32:L",
		"MarkdownRender_with_toc_data:64:L",
		"MarkdownRender_hard_wrap:128:L",
		"MarkdownRender_xhtml:256:L",
		"MarkdownRender_html_escape:512:L",
    
    "MarkdownTypography:1:L" // no , after last
	}
};


// #endif // #ifdef MA_Zmq


#endif
