
// Utility.h, Utility.cpp

#include "Includes.h"

#ifndef UtilityHPP
#define UtilityHPP

/*
 http://sources.4d.com/svn_public/4d_keisuke/SOURCES/Apple%20Push%20Notification/4DPluginAPI_Extensions.c
 
 > if a pass a PA_Unistring* to PA_SetStringVariable, i see, that 4D is   
 > not called but in PA_ClearVariable. Do i have to call   
 > PA_ClearVariable if using PA_SetStringVariable? 
 
 From François Marchal (for some reason this was not archived on   
 nabble): 
 
 Here are some informations about who owns what... 
 
 * After those calls, you will own the object and it is your   
 responsability to dispose it 
 PA_CreatePicture, PA_CreateUnistring, PA_GetPictureField,   
 PA_GetStringField 
 
 * When you set a field with a string or a picture using   
 PA_SetPictureField or PA_SetStringField, you are still the owner of   
 the given object and it will be up to you to dispose it. No copy is   
 performed, 4D will just retain the given object. 
 
 * Those calls returns objects that belongs to 4D. Do NOT dispose them. 
 PA_GetPictureParameter, PA_GetStringParameter 
 
 * Those calls returns objects that belongs to the PA_Variable. Do NOT   
 dispose them. 
 PA_GetPictureInVariable, PA_GetStringInVariable 
 
 * Those calls returns objects that belongs to the PA_Array, do NOT   
 dispose them. 
 PA_GetPictureInArray, PA_GetStringInArray 
 
 * When you call PA_SetStringInArray, PA_SetPictureInArray, the given   
 object will now belongs to the array. Any previous object in the array   
 will be disposed. 
 
 Once you give the variable to 4D by calling PA_SetVariable, 4D will be   
 the owner of the variable and you should not dispose it. This is true   
 if you get the variable by calling PA_GetVariable or if you create it   
 by calling PA_CreateVariable. 
 
 Kind regards, 
 
 Aparajita 
 www.aparajitaworld.com 
 
 */


/*
#if VERSIONWIN
  #define ReadWriteMemoryBarrier(void) ( MemoryBarrier() )//_ReadWriteBarrier();
#else
  // see: https://bitbucket.org/olivierg/jackbeat/src/6c89a76e3131/src/core/pa_ringbuffer.c
  #define ReadWriteMemoryBarrier(void) ( OSMemoryBarrier() )//_ReadWriteBarrier();

  //__sync_synchronize();

  // asm volatile("mfence":::"memory");

  // int32_t dummy = 0;
  // OSAtomicIncrement32Barrier( &dummy ); // OSMemoryBarrier();
#endif
*/

void ReadWriteMemoryBarrier(void);

/*
void plg_CStringToUnistring (wstring sourceCString, PA_Unistring* destinationPAUnistring);
void plg_UnistringToCString (PA_Unistring* sourcePAUnistring, wstring destinationCString);
void plg_WstringToUnistring(wstring src, PA_Unistring *dest)
*/
long plg_SetBlobParameter( PA_PluginParameters params, short index, char* data, long dataLen );
long plg_ErrorCallbackMethodNameSet( wstring errMeth );

void plg_DelayCurrentProcess(long delayInTicks);

/*
string plg_EncodeNonAsciiCharacters( string value );
string plg_DecodeEncodedNonAsciiCharacters( string value );
*/

void plg_GetWstringParameter( PA_PluginParameters params, long paramNum, wstring &paramWstring );
void plg_GetStringParameter( PA_PluginParameters params, long paramNum, string &paramString );
long plg_GetCharParameter( PA_PluginParameters params, long paramNum, char* paramChar, long maxCharLen );


wstring plg_StringToWstring( const string &src);
string plg_WstringToString( const wstring &src);

long plg_CharToUnichar( const char *src, PA_Unichar *dest, long destMaxLen ); // returns length

void plg_UnicharToWstring( PA_Unichar* src, wstring &dest );
void plg_UnicharToString( PA_Unichar* src, string &dest );

void plg_WstringToUnichar( const wstring src, PA_Unichar *dest, long destMaxLen ); // will copy max destMaxLen chars
void plg_StringToUnichar( const string src, PA_Unichar *dest, long destMaxLen ); // will copy max destMaxLen chars

void plg_UnistringToWstring( PA_Unistring* src, wstring &dest );
void plg_UnistringToString( const PA_Unistring* src, string &dest );

char* plg_CreateUtf8CharFromUnistring( PA_Unistring *unistr );
PA_Unistring plg_CreateUnistringFromUtf8Char( const char* utf8Char );

//void plg_WstringToUnistring( const wstring src, PA_Unistring &dest );

//void plg_StringToUnistring( const string src, PA_Unistring &dest );



// - area instance selection
long plg_AreaSelect( long wantedAreaType, long areaRef, wstring callingMethod );
// - area instance selection end
void plg_Alert( wstring errtxt );
void plg_ErrMessage( wstring errtxt, wstring methodName );

// utility methods ----------------------------------------

// #include <libkern/OSAtomic.h> for OSMemoryBarrier();
// #include <libkern/OSBase.h> // OSSynchronizeIO();

long	 BoyerMooreSearch(char* sourceText, char* whatToFind, long txtLen, long findLen);
long 	 Trunc( double in );
double Round( double in, int decimals );
long	 Round( double in );
//double Abs( double in );
wstring String(double d, wstring format = L"### ### ### ### ##0,0" );
wstring String(long i, wstring format = L"### ### ### ### ##0" );
wstring String(int i, wstring format = L"### ### ### ### ##0");
string  NarrowString(long i, string format = "### ### ### ### ##0" );

wstring StringToUpper(wstring strToConvert);
wstring StringToLower(wstring strToConvert);
long 	 Position( wstring txtToFind, wstring source );
wstring Substring( wstring source, long fromWhere, long countChars );
wstring Substring( wstring source, long fromWhere );
wstring Parse( wstring source, wstring divider, long num ); // parses n'th part of a wstring
wstring Replace( wstring source, wstring fromWhat, wstring toWhat );

void	 SmallerFirstSwap( long &var1, long &var2 );
long	 ColorDarknessChange( long color, double darknessPercentage );
//  methods

// utility methods end ----------------------------------------
long		StringToNum( wstring source );


#endif
