//
//  UtilityPlugin.h
//  MA_Plugin_x64
//
//  Created by Pasi Mankinen on 9.10.2012.
//  Copyright (c) 2012 Manage Applications. All rights reserved.
//
#ifndef UtilityPluginHPP
#define UtilityPluginHPP

#include "Includes.h"

#include "luajit-2.1/lua.hpp"

#include "markdown.h"
#include "html.h"
#include "buffer.h"
#include <map>


long MA_UtilityPluginMain( long selector, PA_PluginParameters params );

void InitUtility();
void DeInitUtility();
void CloseProcessUtility();

double seconds( int multiplier );
void MA_Microseconds( PA_PluginParameters params ); //  High precision timestamp.
void MA_Milliseconds( PA_PluginParameters params );
void MA_Seconds( PA_PluginParameters params );

void MA_Markdown( PA_PluginParameters params );

void MA_LuaText( PA_PluginParameters params );
void MA_LuaBlob( PA_PluginParameters params );

string lua_state_key();
lua_State* lua_state_ref_get();
long lua_state_ref_add();
long lua_state_ref_delete(lua_State *L);

lua_State* loadLua();
void   unLoadLua(lua_State *L);
string luaScriptCallFunction( const char* luaCommand, const char* luaParams );
string luaScriptRunString( string luaCommand, string luaParams, int isFile );
string luaScriptRunChar( const char* luaCommand, const char* luaParams, int isFile );

#endif /* defined(UtilityPluginHPP) */
