-- create scatterplot in Excel
-- local ma = require "lua/ma_lib" 
 --io.popen"cd":read'*l'
 isWin = os.getenv('WINDIR') or (os.getenv('OS') or '')
if isWin:match('[Ww]indows') then
	isWin = true
else
	isWin = false
end

if isWin then
	local current_dir = inTxt or ""
	package.cpath = current_dir .. ';;' .. package.cpath
	local luacom = require('luacom')
	
	local excel = luacom.CreateObject("Excel.Application")
	excel.Visible = true
	
	local wb = excel.Workbooks:Add()
	local ws = wb.Worksheets(1)
	for row=1,100 do
		 ws.Cells(row,1).Value2 = math.random()
		 ws.Cells(row,2).Value2 = math.random()
		 -- note: using ".Value2" since ".Value" fails
		 -- with type mismatch error. why?
	end
	local chart = excel.Charts:Add()
	chart.ChartType = -4169  -- scatter XY
	chart.HasLegend = 0
	local range = ws.UsedRange
	chart:SetSourceData(range, 2)
	
	local txt = "Range: "
	range = ws:Range("B1:B15")
	for n = 1, range.Cells.Count-1 do
		txt = txt .. range.Cells(n).Value2 .. "\n"
	end
	txt = txt .. range.Cells(range.Cells.Count).Value2 -- no return at the end
	print(txt)
	
	ws:Range("A1").Formula = "=10*RAND()"
	print('done')
	returnTxt = inTxt .. "\n" .. txt 
else -- mac
	returnTxt = "Hello from excel.lua file: " .. inTxt
end

