/*
	File:		CommResources.h

	Copyright:	 1984-1993 by Apple Computer, Inc., all rights reserved.

	WARNING
	This file was auto generated by the interfacer tool. Modifications
	must be made to the master file.

*/

#ifndef __COMMRESOURCES__
#define __COMMRESOURCES__

#ifndef __OSUTILS__
#include <OSUtils.H>
#endif

#if PRAGMA_IMPORT
#pragma import on
#endif

#if PRAGMA_STRUCT_ALIGN
	#pragma options align=mac68k
#elif PRAGMA_STRUCT_PACKPUSH
	#pragma pack(push, 2)
#elif PRAGMA_STRUCT_PACK
	#pragma pack(2)
#endif

/*	tool classes (also the tool file types)	*/

#define classCM OST_cbnd

#define classFT OST_fbnd

#define classTM OST_tbnd

enum  {
/*	version of the Comm Resource Manager	*/
	curCRMVersion			= 2,
/* constants general to the use of the Communications Resource Manager */
	crmType			= 9,			/* queue type	*/
	crmRecVersion			= 1,			/* version of queue structure */
/*	error codes */
	crmGenericError			= -1,
	crmNoErr			= 0
};


/* data structures general to the use of the Communications Resource Manager */

typedef OSErr CRMErr;

struct CRMRec {
	QElemPtr			qLink;			/*reserved*/
	short			qType;			/*queue type -- ORD(crmType) = 9*/
	short			crmVersion;			/*version of queue element data structure*/
	long			crmPrivate;			/*reserved*/
	short			crmReserved;			/*reserved*/
	long			crmDeviceType;			/*type of device, assigned by DTS*/
	long			crmDeviceID;			/*device ID; assigned when CRMInstall is called*/
	long			crmAttributes;			/*pointer to attribute block*/
	long			crmStatus;			/*status variable - device specific*/
	long			crmRefCon;			/*for device private use*/
};
typedef struct CRMRec CRMRec;

typedef CRMRec *CRMRecPtr;

#ifdef __cplusplus
extern "C" {
#endif

extern CRMErr pascal InitCRM(void);
extern QHdrPtr pascal CRMGetHeader(void);
extern void pascal CRMInstall(CRMRecPtr crmReqPtr);
extern OSErr pascal CRMRemove(CRMRecPtr crmReqPtr);
extern CRMRecPtr pascal CRMSearch(CRMRecPtr crmReqPtr);
extern short pascal CRMGetCRMVersion(void);
extern Handle pascal CRMGetResource(ResType theType, short theID);
extern Handle pascal CRMGet1Resource(ResType theType, short theID);
extern Handle pascal CRMGetIndResource(ResType theType, short index);
extern Handle pascal CRMGet1IndResource(ResType theType, short index);
extern Handle pascal CRMGetNamedResource(ResType theType, ConstStr255Param name);
extern Handle pascal CRMGet1NamedResource(ResType theType, ConstStr255Param name);
extern void pascal CRMReleaseResource(Handle theHandle);
extern Handle pascal CRMGetToolResource(short procID, ResType theType, short theID);
extern Handle pascal CRMGetToolNamedResource(short procID, ResType theType, ConstStr255Param name);
extern void pascal CRMReleaseToolResource(short procID, Handle theHandle);
extern long pascal CRMGetIndex(Handle theHandle);
extern short pascal CRMLocalToRealID(ResType bundleType, short toolID, ResType theType, short localID);
extern short pascal CRMRealToLocalID(ResType bundleType, short toolID, ResType theType, short realID);
extern OSErr pascal CRMGetIndToolName(OSType bundleType, short index, Str255 toolName);
extern OSErr pascal CRMFindCommunications(short *vRefNum, long *dirID);
extern Boolean pascal CRMIsDriverOpen(ConstStr255Param driverName);
extern CRMErr pascal CRMParseCAPSResource(Handle theHandle, ResType selector, unsigned long *value);
extern OSErr pascal CRMReserveRF(short refNum);
extern OSErr pascal CRMReleaseRF(short refNum);
#if PRAGMA_STRUCT_ALIGN
	#pragma options align=reset
#elif PRAGMA_STRUCT_PACKPUSH
	#pragma pack(pop)
#elif PRAGMA_STRUCT_PACK
	#pragma pack()
#endif

#ifdef PRAGMA_IMPORT_OFF
#pragma import off
#elif PRAGMA_IMPORT
#pragma import reset
#endif
#ifdef __cplusplus
}
#endif

#endif


