/*
	File:		Components.h

	Copyright:	 1984-1993 by Apple Computer, Inc., all rights reserved.

	WARNING
	This file was auto generated by the interfacer tool. Modifications
	must be made to the master file.

*/

#ifndef __COMPONENTS__
#define __COMPONENTS__

#ifdef __cplusplus
extern "C" {
#endif
#if PRAGMA_IMPORT
#pragma import on
#endif

#if PRAGMA_STRUCT_ALIGN
	#pragma options align=mac68k
#elif PRAGMA_STRUCT_PACKPUSH
	#pragma pack(push, 2)
#elif PRAGMA_STRUCT_PACK
	#pragma pack(2)
#endif

#ifndef __TYPES__
#include <MacTypes.H>
#endif

#define kAppleManufacturer OST_appl

#define kComponentResourceType OST_thng

enum  {
	kAnyComponentType			= 0,
	kAnyComponentSubType		= 0,
	kAnyComponentManufacturer	= 0,
	kAnyComponentFlagsMask		= 0
};

#define	cmpWantsRegisterMessage	(1L << 31)

enum  {
	kComponentOpenSelect		= -1,			/* ComponentInstance for this open */
	kComponentCloseSelect		= -2,			/* ComponentInstance for this close */
	kComponentCanDoSelect		= -3,			/* selector # being queried */
	kComponentVersionSelect		= -4,			/* no params */
	kComponentRegisterSelect	= -5,			/* no params */
	kComponentTargetSelect		= -6,			/* ComponentInstance for top of call chain */
	kComponentUnregisterSelect	= -7			/* no params */
};


/* Component Resource Extension flags */

enum  {
	componentDoAutoVersion		= (1 << 0),
	componentWantsUnregister	= (1 << 1),
	componentAutoVersionIncludeFlags = (1 << 2),
	componentHasMultiplePlatforms = (1 << 3)
};


/* Set Default Component flags */

enum  {
	defaultComponentIdentical	= 0,
	defaultComponentAnyFlags	= 1,
	defaultComponentAnyManufacturer = 2,
	defaultComponentAnySubType	= 4,
	defaultComponentAnyFlagsAnyManufacturer = (defaultComponentAnyFlags + defaultComponentAnyManufacturer),
	defaultComponentAnyFlagsAnyManufacturerAnySubType = (defaultComponentAnyFlags + defaultComponentAnyManufacturer + defaultComponentAnySubType)
};

struct ComponentDescription {
	OSType			componentType;			/* A unique 4-byte code indentifying the command set */
	OSType			componentSubType;			/* Particular flavor of this instance */
	OSType			componentManufacturer;			/* Vendor indentification */
	unsigned long			componentFlags;			/* 8 each for Component,Type,SubType,Manuf/revision */
	unsigned long			componentFlagsMask;			/* Mask for specifying which flags to consider in search, zero during registration */
};
typedef struct ComponentDescription ComponentDescription;

struct ResourceSpec {
	OSType			resType;			/* 4-byte code  */
	short			resId;
};
typedef struct ResourceSpec ResourceSpec;

struct ComponentResource {
	ComponentDescription		cd;			/* Registration parameters */
	ResourceSpec			component;			/* resource where Component code is found */
	ResourceSpec			componentName;			/* name string resource */
	ResourceSpec			componentInfo;			/* info string resource */
	ResourceSpec			componentIcon;			/* icon resource */
};
typedef struct ComponentResource ComponentResource;

typedef ComponentResource *ComponentResourcePtr, **ComponentResourceHandle;

struct ComponentPlatformInfo {
	long			componentFlags;			/* flags of Component */
	ResourceSpec			component;			/* resource where Component code is found */
	short			platformType;			/* gestaltSysArchitecture result */
};
typedef struct ComponentPlatformInfo ComponentPlatformInfo;

struct ComponentResourceExtension {
	long			componentVersion;			/* version of Component */
	long			componentRegisterFlags;			/* flags for registration */
	short			componentIconFamily;			/* resource id of Icon Family */
};
typedef struct ComponentResourceExtension ComponentResourceExtension;

struct ComponentPlatformInfoArray {
	long			count;
	ComponentPlatformInfo		platformArray[1];
};
typedef struct ComponentPlatformInfoArray ComponentPlatformInfoArray;

struct ExtComponentResource {
	ComponentDescription		cd;			/* registration parameters */
	ResourceSpec			component;			/* resource where Component code is found */
	ResourceSpec			componentName;			/* name string resource */
	ResourceSpec			componentInfo;			/* info string resource */
	ResourceSpec			componentIcon;			/* icon resource */
	long			componentVersion;			/* version of Component */
	long			componentRegisterFlags;			/* flags for registration */
	short			componentIconFamily;			/* resource id of Icon Family */
	long			count;			/* elements in platformArray */
	ComponentPlatformInfo		platformArray[1];
};
typedef struct ExtComponentResource ExtComponentResource;

struct ComponentParameters {
	unsigned char			flags;			/* call modifiers: sync/async, deferred, immed, etc */
	unsigned char			paramSize;			/* size in bytes of actual parameters passed to this call */
	short			what;			/* routine selector, negative for Component management calls */
	long			params[1];			/* actual parameters for the indicated routine */
};
typedef struct ComponentParameters ComponentParameters;

struct ComponentRecord {
	long			data[1];
};
typedef struct ComponentRecord ComponentRecord;

typedef ComponentRecord *Component;

struct ComponentInstanceRecord {
	long			data[1];
};
typedef struct ComponentInstanceRecord ComponentInstanceRecord;

typedef ComponentInstanceRecord *ComponentInstance;

typedef long ComponentResult;

typedef F_PASCAL_PTR(ComponentResult, *ComponentRoutineProcPtr)(ComponentParameters *cp, Handle componentStorage);

enum {
	uppComponentRoutineProcInfo = kPascalStackBased
		| RESULT_SIZE(SIZE_CODE(sizeof(ComponentResult)))
		| STACK_ROUTINE_PARAMETER(1, SIZE_CODE(sizeof(ComponentParameters*)))
		| STACK_ROUTINE_PARAMETER(2, SIZE_CODE(sizeof(Handle)))
};

#if USESROUTINEDESCRIPTORS
typedef UniversalProcPtr ComponentRoutineUPP;

#define CallComponentRoutineProc(userRoutine, cp, componentStorage)		\
		CallUniversalProc((UniversalProcPtr)(userRoutine), uppComponentRoutineProcInfo, (cp), (componentStorage))
#define NewComponentRoutineProc(userRoutine)		\
		(ComponentRoutineUPP) NewRoutineDescriptor((ProcPtr)(userRoutine), uppComponentRoutineProcInfo, GetCurrentISA())
#else
typedef ComponentRoutineProcPtr ComponentRoutineUPP;

#define CallComponentRoutineProc(userRoutine, cp, componentStorage)		\
		(*(userRoutine))((cp), (componentStorage))
#define NewComponentRoutineProc(userRoutine)		\
		(ComponentRoutineUPP)(userRoutine)
#endif

typedef ComponentRoutineProcPtr ComponentRoutine;


/*
	The parameter list for each ComponentFunction is unique. It is
	therefore up to users to create the appropriate procInfo for their
	own ComponentFunctions where necessary.
*/

typedef UniversalProcPtr ComponentFunctionUPP;

#if USES68KINLINES
#define ComponentCallNow(callNumber, paramSize)  \
	= {0x2F3C,paramSize,callNumber,0x7000,0xA82A}

#else
#define ComponentCallNow(callNumber, paramSize)

extern UniversalProcPtr CallComponentUPP;

#endif

#ifdef WIN32
#if QTMLWindows
#include "QTMLName.h"
#define F_QTML(typ) typ __declspec(dllimport) __cdecl
#elif	BuildMac2Win
#include "CompoNam.h"
#define F_QTML(typ) __declspec(dllexport) F_PASCAL(typ)
#else
#include "CompoNam.h"
#if __MWERKS__
#define F_QTML(typ) F_PASCAL(typ)
#else
#define F_QTML(typ) __declspec(dllimport) F_PASCAL(typ)
#endif
#endif
#else
#define F_QTML(typ) F_PASCAL(typ)
#endif



#if PRAGMA_STRUCT_ALIGN
	#pragma options align=reset
#elif PRAGMA_STRUCT_PACKPUSH
	#pragma pack(pop)
#elif PRAGMA_STRUCT_PACK
	#pragma pack()
#endif

#ifdef PRAGMA_IMPORT_OFF
#pragma import off
#elif PRAGMA_IMPORT
#pragma import reset
#endif


/********************************************************
 * Component Database Add, Delete, and Query Routines
 ********************************************************/

F_QTML(Component) RegisterComponent(ComponentDescription *cd, ComponentRoutineUPP componentEntryPoint, short global, Handle componentName, Handle componentInfo, Handle componentIcon);
F_QTML(Component) RegisterComponentResource(ComponentResourceHandle tr, short global);
F_QTML(OSErr) UnregisterComponent(Component aComponent);
F_QTML(Component) FindNextComponent(Component aComponent, ComponentDescription *looking);
F_QTML(long) CountComponents(ComponentDescription *looking);
F_QTML(OSErr) GetComponentInfo(Component aComponent, ComponentDescription *cd, Handle componentName, Handle componentInfo, Handle componentIcon);
F_QTML(long) GetComponentListModSeed(void);

/********************************************************
 * Component Instance Allocation and dispatch routines
 ********************************************************/

extern F_QTML(ComponentInstance) OpenComponent(Component aComponent);
extern F_QTML(OSErr) CloseComponent(ComponentInstance aComponentInstance);
extern F_QTML(OSErr) GetComponentInstanceError(ComponentInstance aComponentInstance);

/* Direct calls to the Components */

extern F_QTML(long) ComponentFunctionImplemented(ComponentInstance ci, short ftnNumber);
extern F_QTML(long) GetComponentVersion(ComponentInstance ci);
extern F_QTML(long) ComponentSetTarget(ComponentInstance ci, ComponentInstance target);


/********************************************************
 * Component Management routines
 ********************************************************/

extern F_QTML(void) SetComponentInstanceError(ComponentInstance aComponentInstance, OSErr theError);
extern F_QTML(long) GetComponentRefcon(Component aComponent);
extern F_QTML(void) SetComponentRefcon(Component aComponent, long theRefcon);
extern F_QTML(short) OpenComponentResFile(Component aComponent);
extern F_QTML(OSErr) CloseComponentResFile(short refnum);

/********************************************************
 * Component Instance Management routines
 ********************************************************/

extern F_QTML(Handle) GetComponentInstanceStorage(ComponentInstance aComponentInstance);
extern F_QTML(void) SetComponentInstanceStorage(ComponentInstance aComponentInstance, Handle theStorage);
extern F_QTML(long) GetComponentInstanceA5(ComponentInstance aComponentInstance);
extern F_QTML(void) SetComponentInstanceA5(ComponentInstance aComponentInstance, long theA5);
extern F_QTML(long) CountComponentInstances(Component aComponent);

/* Useful helper routines for convenient method dispatching */

extern F_QTML(long) CallComponentFunction(ComponentParameters *params, ComponentFunctionUPP func);
extern F_QTML(long) CallComponentFunctionWithStorage(Handle storage, ComponentParameters *params, ComponentFunctionUPP func);
extern F_QTML(long) DelegateComponentCall(ComponentParameters *originalParams, ComponentInstance ci);

extern F_QTML(OSErr) SetDefaultComponent(Component aComponent, short flags);
extern F_QTML(ComponentInstance) OpenDefaultComponent(OSType componentType, OSType componentSubType);
extern F_QTML(Component) CaptureComponent(Component capturedComponent, Component capturingComponent);
extern F_QTML(OSErr) UncaptureComponent(Component aComponent);
extern F_QTML(long) RegisterComponentResourceFile(short resRefNum, short global);
extern F_QTML(OSErr) GetComponentIconSuite(Component aComponent, Handle *iconSuite);



#ifdef __cplusplus
}
#endif

#endif
