/*
	File:		OSUtils.h

	Copyright:	 1984-1993 by Apple Computer, Inc., all rights reserved.

	WARNING
	This file was auto generated by the interfacer tool. Modifications
	must be made to the master file.

*/

#ifndef __OSUTILS__
#define __OSUTILS__

#ifndef __TYPES__
#include <MacTypes.H>
#endif

#if PRAGMA_IMPORT
#pragma import on
#endif

#if PRAGMA_STRUCT_ALIGN
	#pragma options align=mac68k
#elif PRAGMA_STRUCT_PACKPUSH
	#pragma pack(push, 2)
#elif PRAGMA_STRUCT_PACK
	#pragma pack(2)
#endif

enum  {
	useFree			= 0,
	useATalk			= 1,
	useAsync			= 2,
	useExtClk			= 3,			/*Externally clocked*/
	useMIDI			= 4,
/**** Environs Equates ****/
	curSysEnvVers			= 2,			/*Updated to equal latest SysEnvirons version*/
/* Machine Types */
	envMac			= -1,
	envXL			= -2,
	envMachUnknown			= 0,
	env512KE			= 1,
	envMacPlus			= 2,
	envSE			= 3,
	envMacII			= 4,
	envMacIIx			= 5,
	envMacIIcx			= 6,
	envSE30			= 7,
	envPortable			= 8,
	envMacIIci			= 9,
	envMacIIfx			= 11,
/* CPU types */
	envCPUUnknown			= 0
};

enum  {
	env68000			= 1,
	env68010			= 2,
	env68020			= 3,
	env68030			= 4,
	env68040			= 5,
/* Keyboard types */
	envUnknownKbd			= 0,
	envMacKbd			= 1,
	envMacAndPad			= 2,
	envMacPlusKbd			= 3,
	envAExtendKbd			= 4,
	envStandADBKbd			= 5,
	envPrtblADBKbd			= 6,
	envPrtblISOKbd			= 7,
	envStdISOADBKbd			= 8,
	envExtISOADBKbd			= 9,
	false32b			= 0,			/*24 bit addressing error*/
	true32b			= 1,			/*32 bit addressing error*/
/* result types for RelString Call */
	sortsBefore			= -1,			/*first string < second string*/
	sortsEqual			= 0,			/*first string = second string*/
	sortsAfter			= 1			/*first string > second string*/
};

enum  {
/* Toggle results */
	toggleUndefined			= 0,
	toggleOK			= 1,
	toggleBadField			= 2,
	toggleBadDelta			= 3,
	toggleBadChar			= 4,
	toggleUnknown			= 5,
	toggleBadNum			= 6,
	toggleOutOfRange			= 7,			/*synonym for toggleErr3*/
	toggleErr3			= 7,
	toggleErr4			= 8,
	toggleErr5			= 9,
/* Date equates */
	smallDateBit			= 31,			/*Restrict valid date/time to range of Time global*/
	togChar12HourBit			= 30,			/*If toggling hour by char, accept hours 1..12 only*/
	togCharZCycleBit			= 29,			/*Modifier for togChar12HourBit: accept hours 0..11 only*/
	togDelta12HourBit			= 28,			/*If toggling hour up/down, restrict to 12-hour range (am/pm)*/
	genCdevRangeBit			= 27,			/*Restrict date/time to range used by genl CDEV*/
	validDateFields			= -1,
	maxDateField			= 10,
	eraMask			= 0x0001,
	yearMask			= 0x0002,
	monthMask			= 0x0004,
	dayMask			= 0x0008,
	hourMask			= 0x0010,
	minuteMask			= 0x0020,
	secondMask			= 0x0040,
	dayOfWeekMask			= 0x0080,
	dayOfYearMask			= 0x0100,
	weekOfYearMask			= 0x0200,
	pmMask			= 0x0400,
	dateStdMask			= 0x007F			/*default for ValidDate flags and ToggleDate TogglePB.togFlags*/
};

enum  {
	eraField,
	yearField,
	monthField,
	dayField,
	hourField,
	minuteField,
	secondField,
	dayOfWeekField,
	dayOfYearField,
	weekOfYearField,
	pmField,
	res1Field,
	res2Field,
	res3Field
};

typedef unsigned char LongDateField;

enum  {
	dummyType,
	vType,
	ioQType,
	drvQType,
	evType,
	fsQType,
	sIQType,
	dtQType
};

typedef unsigned short QTypes;

enum  {
	OSTrap,
	ToolTrap
};

typedef unsigned char TrapType;

struct SysParmType {
	char			valid;
	char			aTalkA;
	char			aTalkB;
	char			config;
	short			portA;
	short			portB;
	long			alarm;
	short			font;
	short			kbdPrint;
	short			volClik;
	short			misc;
};
typedef struct SysParmType SysParmType;

typedef SysParmType *SysPPtr;

struct QElem {
	struct QElem			*qLink;
	short			qType;
	short			qData[1];
};
typedef struct QElem QElem;

typedef QElem *QElemPtr;

struct QHdr {
	short			qFlags;
	QElemPtr			qHead;
	QElemPtr			qTail;
};
typedef struct QHdr QHdr;

typedef QHdr *QHdrPtr;


/*
	DeferredTaskProcs cannot be written in or called from a high-level
	language without the help of mixed mode or assembly glue because they
	use the following parameter-passing convention:

	typedef pascal void (*DeferredTaskProcPtr)(long dtParam);

		In:
			=>	dtParam			A1.L
		Out:
			none
*/

enum  {
	uppDeferredTaskProcInfo		= kRegisterBased|REGISTER_ROUTINE_PARAMETER(1,kRegisterA1,kFourByteCode)
};

#if USESROUTINEDESCRIPTORS
typedef void (pascal *DeferredTaskProcPtr)(long dtParam);

typedef UniversalProcPtr DeferredTaskUPP;

#define CallDeferredTaskProc(userRoutine, dtParam)  \
	CallUniversalProc((UniversalProcPtr)(userRoutine), uppDeferredTaskProcInfo, (dtParam))

#define NewDeferredTaskProc(userRoutine)  \
	(DeferredTaskUPP) NewRoutineDescriptor((ProcPtr)(userRoutine),  \
	uppDeferredTaskProcInfo, GetCurrentISA())

#else
typedef ProcPtr DeferredTaskUPP;

#define NewDeferredTaskProc(userRoutine)  \
	(DeferredTaskUPP)(userRoutine)

#endif

struct DeferredTask {
	QElemPtr			qLink;
	short			qType;
	short			dtFlags;
	DeferredTaskUPP			dtAddr;
	long			dtParam;
	long			dtReserved;
};
typedef struct DeferredTask DeferredTask;

typedef DeferredTask *DeferredTaskPtr;

struct SysEnvRec {
	short			environsVersion;
	short			machineType;
	short			systemVersion;
	short			processor;
	Boolean			hasFPU;
	Boolean			hasColorQD;
	short			keyBoardType;
	short			atDrvrVersNum;
	short			sysVRefNum;
};
typedef struct SysEnvRec SysEnvRec, *SysEnvRecPtr;

struct MachineLocation {
	Fract			latitude;
	Fract			longitude;
	union {
		char			dlsDelta;			/*signed byte; daylight savings delta*/
		long			gmtDelta;			/*must mask - see documentation*/
	}			gmtFlags;
};
typedef struct MachineLocation MachineLocation;

struct DateTimeRec {
	short			year;
	short			month;
	short			day;
	short			hour;
	short			minute;
	short			second;
	short			dayOfWeek;
};
typedef struct DateTimeRec DateTimeRec;

typedef wide LongDateTime;

union LongDateCvt {
	wide			c;
	struct {
		long			lHigh;
		long			lLow;
	}			hl;
};
typedef union LongDateCvt LongDateCvt;

union LongDateRec {
	struct {
		short			era;
		short			year;
		short			month;
		short			day;
		short			hour;
		short			minute;
		short			second;
		short			dayOfWeek;
		short			dayOfYear;
		short			weekOfYear;
		short			pm;
		short			res1;
		short			res2;
		short			res3;
	}			ld;
	short			list[14];			/*Index by LongDateField!*/
	struct {
		short			eraAlt;
		DateTimeRec			oldDate;
	}			od;
};
typedef union LongDateRec LongDateRec;

typedef char DateDelta;

struct TogglePB {
	long			togFlags;			/*caller normally sets low word to dateStdMask=$7F*/
	ResType			amChars;			/*from 'itl0', but uppercased*/
	ResType			pmChars;			/*from 'itl0', but uppercased*/
	long			reserved[4];
};
typedef struct TogglePB TogglePB;

typedef short ToggleResults;

#ifdef __cplusplus
extern "C" {
#endif

extern void pascal LongDateToSeconds(const LongDateRec *lDate, LongDateTime *lSecs);
extern void pascal LongSecondsToDate(LongDateTime *lSecs, LongDateRec *lDate);
extern ToggleResults pascal ToggleDate(LongDateTime *lSecs, LongDateField field, DateDelta delta, short ch, const TogglePB *params);
extern short pascal ValidDate(const LongDateRec *vDate, long flags, LongDateTime *newSecs);
extern Boolean pascal IsMetric(void);
#if USESCODEFRAGMENTS
extern SysPPtr pascal GetSysPPtr(void);
#else
#define GetSysPPtr() ((SysPPtr) 0x01F8)

#endif


extern OSErr pascal ReadDateTime(unsigned long *time);

extern void pascal GetDateTime(unsigned long *secs);

extern OSErr pascal SetDateTime(unsigned long time);

extern void pascal SetTime(const DateTimeRec *d);

extern void pascal GetTime(DateTimeRec *d);
extern void pascal DateToSeconds(const DateTimeRec *d, unsigned long *secs);

extern void pascal SecondsToDate(unsigned long secs, DateTimeRec *d);
extern void pascal SysBeep(short duration);

extern OSErr pascal DTInstall(DeferredTaskPtr dtTaskPtr);
#if USES68KINLINES
extern void pascal SwapMMUMode(char *mode);
#else
#define GetMMUMode() ((char)true32b)

#define SwapMMUMode(x) (*(char*)(x) = true32b)

#endif

#if SystemSixOrLater

extern OSErr pascal SysEnvirons(short versionRequested, SysEnvRec *theWorld);
#else
extern OSErr pascal SysEnvirons(short versionRequested, SysEnvRec *theWorld);
#endif

#ifndef UNSIGNEDDELAY
#if GENE_CODES
#define UNSIGNEDDELAY 1
#else
#define UNSIGNEDDELAY 0
#endif
#endif

#if UNSIGNEDDELAY
extern void pascal Delay(long numTicks, unsigned long *finalTicks);
#else
extern void pascal Delay(long numTicks, long *finalTicks);
#endif
/*
	GetTrapAddress and SetTrapAddress are obsolete and should not
	be used. Always use NGetTrapAddress and NSetTrapAddress instead.
	The old routines will not be supported for PowerPC apps.
*/

#if defined(OBSOLETE) && !defined(powerc) && !defined(__powerc)

extern UniversalProcPtr pascal GetTrapAddress(short trapNum);

extern void pascal SetTrapAddress(UniversalProcPtr trapAddr, short trapNum);
#endif

extern UniversalProcPtr pascal NGetTrapAddress(short trapNum, TrapType tTyp);
extern void pascal NSetTrapAddress(UniversalProcPtr trapAddr, short trapNum, TrapType tTyp);

extern UniversalProcPtr pascal GetOSTrapAddress(short trapNum);

extern void pascal SetOSTrapAddress(UniversalProcPtr trapAddr, short trapNum);

extern UniversalProcPtr pascal GetToolTrapAddress(short trapNum);

extern void pascal SetToolTrapAddress(UniversalProcPtr trapAddr, short trapNum);

extern UniversalProcPtr pascal GetToolboxTrapAddress(short trapNum);

extern void pascal SetToolboxTrapAddress(UniversalProcPtr trapAddr, short trapNum);
extern OSErr pascal WriteParam(void);

extern void pascal Enqueue(QElemPtr qElement, QHdrPtr qHeader);

extern OSErr pascal Dequeue(QElemPtr qElement, QHdrPtr qHeader);
extern long WINPASCAL SetCurrentA5(void);

extern long WINPASCAL SetA5(long newA5);
#if !SystemSevenOrLater
extern void pascal Environs(short *rom, short *machine);
#endif

extern OSErr pascal HandToHand(Handle *theHndl);

extern OSErr pascal PtrToXHand(const void *srcPtr, Handle dstHndl, long size);
extern OSErr pascal PtrToHand(const void *srcPtr, Handle *dstHndl, long size);

extern OSErr pascal HandAndHand(Handle hand1, Handle hand2);

extern OSErr pascal PtrAndHand(const void *ptr1, Handle hand2, long size);

extern OSErr pascal InitUtil(void);
#if defined(powerc) || defined(__powerc)
extern void pascal MakeDataExecutable(void *baseAddress, unsigned long length);
#else
extern Boolean pascal SwapInstructionCache(Boolean cacheEnable);
extern void pascal FlushInstructionCach(void);
extern Boolean pascal SwapDataCache(Boolean cacheEnable);
#if WINVER
  #define FlushDataCache
#else
  extern void pascal FlushDataCache(void);
#endif
#endif

extern void pascal ReadLocation(MachineLocation *loc);
extern void pascal WriteLocation(const MachineLocation *loc);
#if !USES68KINLINES
#if !WINVER
extern UniversalProcPtr pascal *GetTrapVector(short trapNumber);
#endif
#endif

#if OLDROUTINENAMES
#define LongDate2Secs(lDate, lSecs) LongDateToSeconds(lDate, lSecs)

#define LongSecs2Date(lSecs, lDate) LongSecondsToDate(lSecs, lDate)

#define IUMetric() IsMetric()

#define Date2Secs(d, secs) DateToSeconds(d, secs)

#define Secs2Date(secs, d) SecondsToDate(secs, d)

#endif

#if PRAGMA_STRUCT_ALIGN
	#pragma options align=reset
#elif PRAGMA_STRUCT_PACKPUSH
	#pragma pack(pop)
#elif PRAGMA_STRUCT_PACK
	#pragma pack()
#endif

#ifdef PRAGMA_IMPORT_OFF
#pragma import off
#elif PRAGMA_IMPORT
#pragma import reset
#endif

#ifdef __cplusplus
}
#endif

#endif


