/*
	File:		Picker.h

	Copyright:	 1984-1993 by Apple Computer, Inc., all rights reserved.

	WARNING
	This file was auto generated by the interfacer tool. Modifications
	must be made to the master file.

*/

#ifndef __PICKER__
#define __PICKER__

#ifndef __QUICKDRAW__
#if LONG_FILENAMES
#include <Quickdraw.H>
#else
#include <Quickdra.H>
#endif
#endif

#if PRAGMA_IMPORT
#pragma import on
#endif

#if PRAGMA_STRUCT_ALIGN
	#pragma options align=mac68k
#elif PRAGMA_STRUCT_PACKPUSH
	#pragma pack(push, 2)
#elif PRAGMA_STRUCT_PACK
	#pragma pack(2)
#endif

enum  {
/*Maximum small fract value, as long*/
	MaxSmallFract			= 0x0000FFFF
};


/* A SmallFract value is just the fractional part of a Fixed number,
which is the low order word.  SmallFracts are used to save room,
and to be compatible with Quickdraw's RGBColor.  They can be
assigned directly to and from INTEGERs. */


/* Unsigned fraction between 0 and 1 */

typedef unsigned short SmallFract;


/* For developmental simplicity in switching between the HLS and HSV
models, HLS is reordered into HSL. Thus both models start with
hue and saturation values; value/lightness/brightness is last. */

struct HSVColor {
	SmallFract			hue;			/*Fraction of circle, red at 0*/
	SmallFract			saturation;			/*0-1, 0 for gray, 1 for pure color*/
	SmallFract			value;			/*0-1, 0 for black, 1 for max intensity*/
};
typedef struct HSVColor HSVColor;

struct HSLColor {
	SmallFract			hue;			/*Fraction of circle, red at 0*/
	SmallFract			saturation;			/*0-1, 0 for gray, 1 for pure color*/
	SmallFract			lightness;			/*0-1, 0 for black, 1 for white*/
};
typedef struct HSLColor HSLColor;

struct CMYColor {
	SmallFract			cyan;
	SmallFract			magenta;
	SmallFract			yellow;
};
typedef struct CMYColor CMYColor;

#ifdef __cplusplus
extern "C" {
#endif

extern SmallFract pascal Fix2SmallFract(Fixed f);
extern Fixed pascal SmallFract2Fix(SmallFract s);
extern void pascal CMY2RGB(const CMYColor *cColor, RGBColor *rColor);
extern void pascal RGB2CMY(const RGBColor *rColor, CMYColor *cColor);
extern void pascal HSL2RGB(const HSLColor *hColor, RGBColor *rColor);
extern void pascal RGB2HSL(const RGBColor *rColor, HSLColor *hColor);
extern void pascal HSV2RGB(const HSVColor *hColor, RGBColor *rColor);
extern void pascal RGB2HSV(const RGBColor *rColor, HSVColor *hColor);
extern Boolean pascal GetColor(Point where, ConstStr255Param prompt, const RGBColor *inColor, RGBColor *outColor);
#if PRAGMA_STRUCT_ALIGN
	#pragma options align=reset
#elif PRAGMA_STRUCT_PACKPUSH
	#pragma pack(pop)
#elif PRAGMA_STRUCT_PACK
	#pragma pack()
#endif

#ifdef PRAGMA_IMPORT_OFF
#pragma import off
#elif PRAGMA_IMPORT
#pragma import reset
#endif

#ifdef __cplusplus
}
#endif

#endif


