/*
	File:		Printing.h

	Copyright:	 1984-1993 by Apple Computer, Inc., all rights reserved.

	WARNING
	This file was auto generated by the interfacer tool. Modifications
	must be made to the master file.

*/

#ifndef __PRINTING__
#define __PRINTING__

#ifndef __QUICKDRAW__
#if LONG_FILENAMES
#include <Quickdraw.H>
#else
#include <Quickdra.H>
#endif
#endif

#ifndef __DIALOGS__
#include <Dialogs.H>
#endif

enum  {
	iPFMaxPgs			= 128,
	iPrPgFract			= 120,			/*Page scale factor. ptPgSize (below) is in units of 1/iPrPgFract*/
	iPrPgFst			= 1,			/*Page range constants*/
	iPrPgMax			= 9999,
	iPrRelease			= 3,			/*Current version number of the code.*/
	iPrSavPFil			= -1,
	iPrAbort			= 0x0080,
	iPrDevCtl			= 7,			/*The PrDevCtl Proc's ctl number*/
#define lPrReset	0x00010000			/*The PrDevCtl Proc's CParam for reset*/
#define lPrLineFeed	0x00030000
#define lPrLFStd	0x0003FFFF			/*The PrDevCtl Proc's CParam for std paper advance*/
#define lPrLFSixth	0x0003FFFF
#define lPrPageEnd	0x00020000			/*The PrDevCtl Proc's CParam for end page*/
#define lPrDocOpen	0x00010000
#define lPrPageOpen	0x00040000
#define lPrPageClose	0x00020000
#define lPrDocClose	0x00050000
	iFMgrCtl			= 8,			/*The FMgr's Tail-hook Proc's ctl number*/
	iMscCtl			= 9,			/*The FMgr's Tail-hook Proc's ctl number*/
	iPvtCtl			= 10			/*The FMgr's Tail-hook Proc's ctl number*/
};

#define sPrDrvr ".Print"

enum  {
	iMemFullErr			= -108,
	iIOAbort			= -27,
	pPrGlobals			= 0x0944,			/*The PrVars lo mem area:*/
	bDraftLoop			= 0,
	bSpoolLoop			= 1,
	bUser1Loop			= 2,
	bUser2Loop			= 3,
	fNewRunBit			= 2,
	fHiResOK			= 3,
	fWeOpenedRF			= 4,
/*Driver constants */
	iPrBitsCtl			= 4,
	lScreenBits			= 0,
	lPaintBits			= 1,
	lHiScreenBits			= 0x0002,			/*The Bitmap Print Proc's Screen Bitmap param*/
	lHiPaintBits			= 0x0003,			/*The Bitmap Print Proc's Paint [sq pix] param*/
	iPrIOCtl			= 5,
	iPrEvtCtl			= 6,			/*The PrEvent Proc's ctl number*/
#define lPrEvtAll	0x0002FFFD			/*The PrEvent Proc's CParam for the entire screen*/
#define lPrEvtTop	0x0001FFFD			/*The PrEvent Proc's CParam for the top folder*/
	iPrDrvrRef			= -3
};

enum  {
	getRslDataOp			= 4,
	setRslOp			= 5,
	draftBitsOp			= 6,
	noDraftBitsOp			= 7,
	getRotnOp			= 8,
	NoSuchRsl			= 1,
	OpNotImpl			= 2,			/*the driver doesn't support this opcode*/
	RgType1			= 1
};

enum  {
	feedCut,
	feedFanfold,
	feedMechCut,
	feedOther
};

typedef unsigned char TFeed;

enum  {
	scanTB,
	scanBT,
	scanLR,
	scanRL
};

typedef unsigned char TScan;


/* A Rect Ptr */

typedef Rect *TPRect;

typedef void (pascal *PrIdleProcPtr)(void);

enum {
	uppPrIdleProcInfo = kPascalStackBased
};

#if USESROUTINEDESCRIPTORS
typedef UniversalProcPtr PrIdleUPP;

#define CallPrIdleProc(userRoutine)		\
		CallUniversalProc((UniversalProcPtr)(userRoutine), uppPrIdleProcInfo)
#define NewPrIdleProc(userRoutine)		\
		(PrIdleUPP) NewRoutineDescriptor((ProcPtr)(userRoutine), uppPrIdleProcInfo, GetCurrentISA())
#else
typedef PrIdleProcPtr PrIdleUPP;

#define CallPrIdleProc(userRoutine)		\
		(*(userRoutine))()
#define NewPrIdleProc(userRoutine)		\
		(PrIdleUPP)(userRoutine)
#endif

typedef void (pascal *PItemProcPtr)(DialogPtr theDialog, short item);

enum {
	uppPItemProcInfo = kPascalStackBased
		| STACK_ROUTINE_PARAMETER(1, SIZE_CODE(sizeof(DialogPtr)))
		| STACK_ROUTINE_PARAMETER(2, SIZE_CODE(sizeof(short)))
};

#if USESROUTINEDESCRIPTORS
typedef UniversalProcPtr PItemUPP;

#define CallPItemProc(userRoutine, theDialog, item)		\
		CallUniversalProc((UniversalProcPtr)(userRoutine), uppPItemProcInfo, (theDialog), (item))
#define NewPItemProc(userRoutine)		\
		(PItemUPP) NewRoutineDescriptor((ProcPtr)(userRoutine), uppPItemProcInfo, GetCurrentISA())
#else
typedef PItemProcPtr PItemUPP;

#define CallPItemProc(userRoutine, theDialog, item)		\
		(*(userRoutine))((theDialog), (item))
#define NewPItemProc(userRoutine)		\
		(PItemUPP)(userRoutine)
#endif

#if PRAGMA_IMPORT
#pragma import on
#endif

#if PRAGMA_STRUCT_ALIGN
	#pragma options align=mac68k
#elif PRAGMA_STRUCT_PACKPUSH
	#pragma pack(push, 2)
#elif PRAGMA_STRUCT_PACK
	#pragma pack(2)
#endif

#pragma PRAGMA_PACK_1

struct TPrPort {
	GrafPort			gPort;			/*The Printer's graf port.*/
	QDProcs			gProcs;			/*..and its procs*/
	long			lGParam1;			/*16 bytes for private parameter storage.*/
	long			lGParam2;
	long			lGParam3;
	long			lGParam4;
	Boolean			fOurPtr;			/*Whether the PrPort allocation was done by us.*/
	Boolean			fOurBits;			/*Whether the BitMap allocation was done by us.*/
};
typedef struct TPrPort TPrPort;

typedef TPrPort *TPPrPort;


/* Printing Graf Port. All printer imaging, whether spooling, banding, etc, happens "thru" a GrafPort.
  This is the "PrPeek" record. */

struct TPrInfo {
	short			iDev;			/*Font mgr/QuickDraw device code*/
	short			iVRes;			/*Resolution of device, in device coordinates*/
	short			iHRes;			/*..note: V before H => compatable with Point.*/
	Rect			rPage;			/*The page (printable) rectangle in device coordinates.*/
};
typedef struct TPrInfo TPrInfo;

typedef TPrInfo *TPPrInfo;


/* Print Info Record: The parameters needed for page composition. */

struct TPrStl {
	short			wDev;
	short			iPageV;
	short			iPageH;
	char			bPort;
	TFeed			feed;
};
typedef struct TPrStl TPrStl;

typedef TPrStl *TPPrStl;

struct TPrXInfo {
	short			iRowBytes;
	short			iBandV;
	short			iBandH;
	short			iDevBytes;
	short			iBands;
	char			bPatScale;
	char			bUlThick;
	char			bUlOffset;
	char			bUlShadow;
	TScan			scan;
	char			bXInfoX;
};
typedef struct TPrXInfo TPrXInfo;

typedef TPrXInfo *TPPrXInfo;

struct TPrJob {
	short			iFstPage;			/*Page Range.*/
	short			iLstPage;
	short			iCopies;			/*No. copies.*/
	char			bJDocLoop;			/*The Doc style: Draft, Spool, .., and ..*/
	Boolean			fFromUsr;			/*Printing from an User's App (not PrApp) flag*/
	PrIdleUPP			pIdleProc;			/*The Proc called while waiting on IO etc.*/
	StringPtr			pFileName;			/*Spool File Name: NIL for default.*/
	short			iFileVol;			/*Spool File vol, set to 0 initially*/
	char			bFileVers;			/*Spool File version, set to 0 initially*/
	char			bJobX;			/*An eXtra byte.*/
};
typedef struct TPrJob TPrJob;

typedef TPrJob *TPPrJob;


/* Print Job: Print "form" for a single print request. */

struct TPrint {
	short			iPrVersion;			/*(2) Printing software version*/
	TPrInfo			prInfo;			/*(14) the PrInfo data associated with the current style.*/
	Rect			rPaper;			/*(8) The paper rectangle [offset from rPage]*/
	TPrStl			prStl;			/*(8)  This print request's style.*/
	TPrInfo			prInfoPT;			/*(14)  Print Time Imaging metrics*/
	TPrXInfo			prXInfo;			/*(16)  Print-time (expanded) Print info record.*/
	TPrJob			prJob;			/*(20) The Print Job request (82)  Total of the above; 120-82 = 38 bytes needed to fill 120*/
	short			printX[19];			/*Spare to fill to 120 bytes!*/
};
typedef struct TPrint TPrint;

typedef TPrint *TPPrint, **THPrint;


/* The universal 120 byte printing record */

struct TPrStatus {
	short			iTotPages;			/*Total pages in Print File.*/
	short			iCurPage;			/*Current page number*/
	short			iTotCopies;			/*Total copies requested*/
	short			iCurCopy;			/*Current copy number*/
	short			iTotBands;			/*Total bands per page.*/
	short			iCurBand;			/*Current band number*/
	Boolean			fPgDirty;			/*True if current page has been written to.*/
	Boolean			fImaging;			/*Set while in band's DrawPic call.*/
	THPrint			hPrint;			/*Handle to the active Printer record*/
	TPPrPort			pPrPort;			/*Ptr to the active PrPort*/
	PicHandle			hPic;			/*Handle to the active Picture*/
};
typedef struct TPrStatus TPrStatus;

typedef TPrStatus *TPPrStatus;


/* Print Status: Print information during printing. */

struct TPfPgDir {
	short			iPages;
	long			iPgPos[129];			/*ARRAY [0..iPfMaxPgs] OF LONGINT*/
};
typedef struct TPfPgDir TPfPgDir;

typedef TPfPgDir *TPPfPgDir, **THPfPgDir;


/* PicFile = a TPfHeader followed by n QuickDraw Pics (whose PicSize is invalid!) */

struct TPrDlg {
	DialogRecord			Dlg;			/*The Dialog window*/
	ModalFilterUPP			pFltrProc;			/*The Filter Proc.*/
	PItemUPP			pItemProc;			/*The Item evaluating proc.*/
	THPrint			hPrintUsr;			/*The user's print record.*/
	Boolean			fDoIt;
	Boolean			fDone;
	long			lUser1;			/*Four longs for user's to hang global data.*/
	long			lUser2;			/*...Plus more stuff needed by the particular printing dialog.*/
	long			lUser3;
	long			lUser4;
};
typedef struct TPrDlg TPrDlg;

typedef TPrDlg *TPPrDlg;

typedef TPPrDlg (pascal *PDlgInitProcPtr)(THPrint hPrint);

enum {
	uppPDlgInitProcInfo = kPascalStackBased
		| RESULT_SIZE(SIZE_CODE(sizeof(TPPrDlg)))
		| STACK_ROUTINE_PARAMETER(1, SIZE_CODE(sizeof(THPrint)))
};

#if USESROUTINEDESCRIPTORS
typedef UniversalProcPtr PDlgInitUPP;

#define CallPDlgInitProc(userRoutine, hPrint)		\
		CallUniversalProc((UniversalProcPtr)(userRoutine), uppPDlgInitProcInfo, (hPrint))
#define NewPDlgInitProc(userRoutine)		\
		(PDlgInitUPP) NewRoutineDescriptor((ProcPtr)(userRoutine), uppPDlgInitProcInfo, GetCurrentISA())
#else
typedef PDlgInitProcPtr PDlgInitUPP;

#define CallPDlgInitProc(userRoutine, hPrint)		\
		(*(userRoutine))((hPrint))
#define NewPDlgInitProc(userRoutine)		\
		(PDlgInitUPP)(userRoutine)
#endif


/* This is the Printing Dialog Record. Only used by folks appending their own dialogs.
Print Dialog: The Dialog Stream object. */

struct TGnlData {
	short			iOpCode;
	short			iError;
	long			lReserved;			/*more fields here depending on call*/
};
typedef struct TGnlData TGnlData;

struct TRslRg {
	short			iMin;
	short			iMax;
};
typedef struct TRslRg TRslRg;

struct TRslRec {
	short			iXRsl;
	short			iYRsl;
};
typedef struct TRslRec TRslRec;

struct TGetRslBlk {
	short			iOpCode;
	short			iError;
	long			lReserved;
	short			iRgType;
	TRslRg			xRslRg;
	TRslRg			yRslRg;
	short			iRslRecCnt;
	TRslRec			rgRslRec[27];
};
typedef struct TGetRslBlk TGetRslBlk;

struct TSetRslBlk {
	short			iOpCode;
	short			iError;
	long			lReserved;
	THPrint			hPrint;
	short			iXRsl;
	short			iYRsl;
};
typedef struct TSetRslBlk TSetRslBlk;

struct TDftBitsBlk {
	short			iOpCode;
	short			iError;
	long			lReserved;
	THPrint			hPrint;
};
typedef struct TDftBitsBlk TDftBitsBlk;

struct TGetRotnBlk {
	short			iOpCode;
	short			iError;
	long			lReserved;
	THPrint			hPrint;
	Boolean			fLandscape;
	char			bXtra;
};
typedef struct TGetRotnBlk TGetRotnBlk;

#pragma PRAGMA_PACK_RESET

#ifdef __cplusplus
extern "C" {
#endif

extern void pascal PrPurge(void);
extern void pascal PrNoPurge(void);
extern void pascal PrOpen(void);
extern void pascal PrClose(void);
extern void pascal PrintDefault(THPrint hPrint);
extern Boolean pascal PrValidate(THPrint hPrint);
extern Boolean pascal PrStlDialog(THPrint hPrint);
extern Boolean pascal PrJobDialog(THPrint hPrint);
extern TPPrDlg pascal PrStlInit(THPrint hPrint);
extern TPPrDlg pascal PrJobInit(THPrint hPrint);
extern void pascal PrJobMerge(THPrint hPrintSrc, THPrint hPrintDst);
extern Boolean pascal PrDlgMain(THPrint hPrint, PDlgInitUPP pDlgInit);
extern TPPrPort pascal PrOpenDoc(THPrint hPrint, TPPrPort pPrPort, Ptr pIOBuf);
extern void pascal PrCloseDoc(TPPrPort pPrPort);
extern void pascal PrOpenPage(TPPrPort pPrPort, TPRect pPageFrame);
extern void pascal PrClosePage(TPPrPort pPrPort);
extern void pascal PrPicFile(THPrint hPrint, TPPrPort pPrPort, Ptr pIOBuf, Ptr pDevBuf, TPrStatus *prStatus);
extern short pascal PrError(void);
extern void pascal PrSetError(short iErr);
extern void pascal PrGeneral(Ptr pData);
extern void pascal PrDrvrOpen(void);
extern void pascal PrDrvrClose(void);
extern void pascal PrCtlCall(short iWhichCtl, long lParam1, long lParam2, long lParam3);
extern Handle pascal PrDrvrDCE(void);
extern short pascal PrDrvrVers(void);

// pa 30/10/02 MidnightSun33 
extern Boolean pascal do_WinSetPrintOptionII(THPrint, int cmd, int param1, int param2);
extern Boolean pascal do_WinGetPrintOptionII(THPrint, int cmd, long * param1, long * param2);
extern void PrInitStdSettings(THPrint hPrint);
extern int PMGetDeviceInfo(THPrint hprint, int cmd, int * NbValues, char ** ValArray, int * MaxStringLen);
#if PRAGMA_STRUCT_ALIGN
	#pragma options align=reset
#elif PRAGMA_STRUCT_PACKPUSH
	#pragma pack(pop)
#elif PRAGMA_STRUCT_PACK
	#pragma pack()
#endif

#ifdef PRAGMA_IMPORT_OFF
#pragma import off
#elif PRAGMA_IMPORT
#pragma import reset
#endif

#ifdef __cplusplus
}
#endif

#endif


