/*
	File:		Processes.h

	Copyright:	 1984-1993 by Apple Computer, Inc., all rights reserved.

	WARNING
	This file was auto generated by the interfacer tool. Modifications
	must be made to the master file.

*/

#ifndef __PROCESSES__
#define __PROCESSES__

#ifndef __TYPES__
#include <MacTypes.H>
#endif

#ifndef __EVENTS__
#include <Events.H>
#endif

#ifndef __FILES__
#include <Files.H>
#endif


#if PRAGMA_IMPORT
#pragma import on
#endif

#if PRAGMA_STRUCT_ALIGN
	#pragma options align=mac68k
#elif PRAGMA_STRUCT_PACKPUSH
	#pragma pack(push, 2)
#elif PRAGMA_STRUCT_PACK
	#pragma pack(2)
#endif

/* type for unique process identifier */

struct ProcessSerialNumber {
	unsigned long			highLongOfPSN;
	unsigned long			lowLongOfPSN;
};
typedef struct ProcessSerialNumber ProcessSerialNumber;

typedef ProcessSerialNumber *ProcessSerialNumberPtr;

enum  {
/*************************************************************************
 *			Process identifier.
 ************************************************************************
 Various reserved process serial numbers. */
	kNoProcess			= 0,
	kSystemProcess			= 1,
	kCurrentProcess			= 2
};


/**********************************************************************************************************************************************
 *	Definition of the parameter block passed to _Launch.
 *************************************************************************

* Typedef and flags for launchControlFlags field */

typedef unsigned short LaunchFlags;

enum  {
/*************************************************************************
 *	Definition of the parameter block passed to _Launch.
 *************************************************************************/
	launchContinue			= 0x4000,
	launchNoFileFlags			= 0x0800,
	launchUseMinimum			= 0x0400,
	launchDontSwitch			= 0x0200,
	launchAllow24Bit			= 0x0100,
	launchInhibitDaemon			= 0x0080
};


/* Format for first AppleEvent to pass to new process.  The size of the overall
 * buffer variable: the message body immediately follows the messageLength.
 */

struct AppParameters {
	EventRecord			theMsgEvent;
	unsigned long			eventRefCon;
	unsigned long			messageLength;
};
typedef struct AppParameters AppParameters;

typedef AppParameters *AppParametersPtr;


/* Parameter block to _Launch */

struct LaunchParamBlockRec {
	unsigned long			reserved1;
	unsigned short			reserved2;
	unsigned short			launchBlockID;
	unsigned long			launchEPBLength;
	unsigned short			launchFileFlags;
	LaunchFlags			launchControlFlags;
	FSSpecPtr			launchAppSpec;
	ProcessSerialNumber			launchProcessSN;
	unsigned long			launchPreferredSize;
	unsigned long			launchMinimumSize;
	unsigned long			launchAvailableSize;
	AppParametersPtr			launchAppParameters;
};
typedef struct LaunchParamBlockRec LaunchParamBlockRec;

typedef LaunchParamBlockRec *LaunchPBPtr;


/* Set launchBlockID to extendedBlock to specify that extensions exist.
* Set launchEPBLength to extendedBlockLen for compatibility.*/

#define extendedBlock ((unsigned short)OST_LC)

#define extendedBlockLen (sizeof(LaunchParamBlockRec) - 12)

enum  {
/*************************************************************************
 * Definition of the information block returned by GetProcessInformation
 ************************************************************************
 Bits in the processMode field */
#define modeDeskAccessory	0x00020000
#define modeMultiLaunch	0x00010000
	modeNeedSuspendResume		= 0x4000,
	modeCanBackground			= 0x1000,
	modeDoesActivateOnFGSwitch	= 0x0800,
	modeOnlyBackground			= 0x0400,
	modeGetFrontClicks			= 0x0200,
	modeGetAppDiedMsg			= 0x0100,
	mode32BitCompatible			= 0x0080,
	modeHighLevelEventAware		= 0x0040,
	modeLocalAndRemoteHLEvents	= 0x0020,
	modeStationeryAware			= 0x0010,
	modeUseTextEditServices		= 0x00000008
};


/* Record returned by GetProcessInformation */

struct ProcessInfoRec {
	unsigned long			processInfoLength;
	StringPtr			processName;
	ProcessSerialNumber			processNumber;
	unsigned long			processType;
	OSType			processSignature;
	unsigned long			processMode;
	Ptr			processLocation;
	unsigned long			processSize;
	unsigned long			processFreeMem;
	ProcessSerialNumber			processLauncher;
	unsigned long			processLaunchDate;
	unsigned long			processActiveTime;
	FSSpecPtr			processAppSpec;
};
typedef struct ProcessInfoRec ProcessInfoRec;

typedef ProcessInfoRec *ProcessInfoRecPtr;

#ifdef __cplusplus
extern "C" {
#endif


EXTERN F_PASCAL(OSErr) LaunchApplication(const LaunchParamBlockRec *LaunchParams);
EXTERN F_PASCAL(OSErr) LaunchDeskAccessory(const FSSpec *pFileSpec, ConstStr255Param pDAName);
EXTERN F_PASCAL(OSErr) GetCurrentProces(ProcessSerialNumber *PSN);
EXTERN F_PASCAL(OSErr) GetFrontProcess(ProcessSerialNumber *PSN);
EXTERN F_PASCAL(OSErr) GetNextProcess(ProcessSerialNumber *PSN);
EXTERN F_PASCAL(OSErr) GetProcessInformation(const ProcessSerialNumber *PSN, ProcessInfoRecPtr info);
EXTERN F_PASCAL(OSErr) SetFrontProcess(const ProcessSerialNumber *PSN);
EXTERN F_PASCAL(OSErr) WakeUpProcess(const ProcessSerialNumber *PSN);
EXTERN F_PASCAL(OSErr) SameProcess(const ProcessSerialNumber *PSN1, const ProcessSerialNumber *PSN2, Boolean *result);
#if PRAGMA_STRUCT_ALIGN
	#pragma options align=reset
#elif PRAGMA_STRUCT_PACKPUSH
	#pragma pack(pop)
#elif PRAGMA_STRUCT_PACK
	#pragma pack()
#endif

#ifdef PRAGMA_IMPORT_OFF
#pragma import off
#elif PRAGMA_IMPORT
#pragma import reset
#endif

#ifdef __cplusplus
}
#endif

#endif


