/*
	File:		Controls.h

	Copyright:	 1984-1993 by Apple Computer, Inc., all rights reserved.

	WARNING
	This file was auto generated by the interfacer tool. Modifications
	must be made to the master file.

*/

#ifndef __CONTROLS__
#define __CONTROLS__

#ifndef __QUICKDRAW__
#if LONG_FILENAMES
#include <Quickdraw.H>
#else
#include <Quickdra.H>

#endif
#endif

#ifndef __MENUS__
#include <Menus.H>
#endif

#if PRAGMA_IMPORT
#pragma import on
#endif

#if PRAGMA_STRUCT_ALIGN
	#pragma options align=mac68k
#elif PRAGMA_STRUCT_PACKPUSH
	#pragma pack(push, 2)
#elif PRAGMA_STRUCT_PACK
	#pragma pack(2)
#endif
enum {
	kControlUsesOwningWindowsFontVariant = 1 << 3				/* Control uses owning windows font to display text*/
};

enum  {
	pushButProc			= 0,
	checkBoxProc			= 1,
	radioButProc			= 2,
	useWFont			= 8,
	scrollBarProc			= 16,
	inButton			= 10,
	inCheckBox			= 11,
	inUpButton			= 20,
	inDownButton			= 21,
	inPageUp			= 22,
	inPageDown			= 23,
	inThumb			= 129,
	popupMenuProc			= 1008,			/* 63 * 16 */
	inLabel			= 1,
	inMenu			= 2,
	inTriangle			= 4
};

/*_________________________________________________________________________________________________________*/
/**/
/*  CONTROL PART CODES*/
/**/
/*_________________________________________________________________________________________________________*/
typedef SInt16 ControlPartCode;


enum {
	kControlNoPart				= 0,
	kControlLabelPart			= 1,
	kControlMenuPart			= 2,
	kControlTrianglePart		= 4,
	kControlButtonPart			= 10,
	kControlCheckBoxPart		= 11,
	kControlRadioButtonPart		= 11,
	kControlUpButtonPart		= 20,
	kControlDownButtonPart		= 21,
	kControlPageUpPart			= 22,
	kControlPageDownPart		= 23,
	kControlIndicatorPart		= 129,
	kControlDisabledPart		= 254,
	kControlInactivePart		= 255
};

/*_________________________________________________________________________________________________________*/
/**/
/*  CHECK BOX VALUES*/
/**/
/*_________________________________________________________________________________________________________*/
enum {
	kControlCheckboxUncheckedValue = 0,
	kControlCheckboxCheckedValue = 1,
	kControlCheckboxMixedValue	= 2
};

/*_________________________________________________________________________________________________________*/
/**/
/*  RADIO BUTTON VALUES*/
/**/
/*_________________________________________________________________________________________________________*/
enum {
	kControlRadioButtonUncheckedValue = 0,
	kControlRadioButtonCheckedValue = 1,
	kControlRadioButtonMixedValue = 2
};

/*_________________________________________________________________________________________________________*/
/* */
/*  CONTROL POP-UP MENU CONSTANTS*/
/**/
/*_________________________________________________________________________________________________________*/
/**/
/* Variant codes for the System 7 pop-up menu*/
/**/
enum  {
	popupFixedWidth			= 1 << 0,
	popupVariableWidth			= 1 << 1,
	popupUseAddResMenu			= 1 << 2,
	popupUseWFont			= 1 << 3
};

enum  {
	popupTitleBold			= 1 << 8,
	popupTitleItalic			= 1 << 9,
	popupTitleUnderline			= 1 << 10,
	popupTitleOutline			= 1 << 11,
	popupTitleShadow			= 1 << 12,
	popupTitleCondense			= 1 << 13,
	popupTitleExtend			= 1 << 14,
	popupTitleNoStyle			= 1 << 15
};

enum  {
	popupTitleLeftJust			= 0x0000,
	popupTitleCenterJust		= 0x0001,
	popupTitleRightJust			= 0x00FF,
/*
axis constraints for DragGrayRgn call*/
	noConstraint			= 0,
	hAxisOnly			= 1,
	vAxisOnly			= 2,
/*
control messages*/
	drawCntl			= 0,
	testCntl			= 1,
	calcCRgns			= 2,
	initCntl			= 3,
	dispCntl			= 4,
	posCntl			= 5,
	thumbCntl			= 6,
	dragCntl			= 7,
	autoTrack			= 8,
	calcCntlRgn			= 10,
	calcThumbRgn			= 11,
	cFrameColor			= 0,
	cBodyColor			= 1,
	cTextColor			= 2
};

enum  {
	cThumbColor			= 3
};

#if STRICT_CONTROLS
typedef struct OpaqueControlRef *ControlRef;

typedef ControlRef ControlHandle;

#else
typedef struct ControlRecord ControlRecord, *ControlPtr, **ControlHandle;

#ifndef ControlRef
typedef ControlHandle ControlRef;
#endif

#endif

typedef long (pascal *ControlDefProcPtr)(short varCode, ControlHandle theControl, short message, long param);

enum {
	uppControlDefProcInfo = kPascalStackBased
		| RESULT_SIZE(SIZE_CODE(sizeof(long)))
		| STACK_ROUTINE_PARAMETER(1, SIZE_CODE(sizeof(short)))
		| STACK_ROUTINE_PARAMETER(2, SIZE_CODE(sizeof(ControlHandle)))
		| STACK_ROUTINE_PARAMETER(3, SIZE_CODE(sizeof(short)))
		| STACK_ROUTINE_PARAMETER(4, SIZE_CODE(sizeof(long)))
};

#if USESROUTINEDESCRIPTORS
typedef UniversalProcPtr ControlDefUPP;

#define CallControlDefProc(userRoutine, varCode, theControl, message, param)		\
		CallUniversalProc((UniversalProcPtr)(userRoutine), uppControlDefProcInfo, (varCode), (theControl), (message), (param))
#define NewControlDefProc(userRoutine)		\
		(ControlDefUPP) NewRoutineDescriptor((ProcPtr)(userRoutine), uppControlDefProcInfo, GetCurrentISA())
#else
typedef ControlDefProcPtr ControlDefUPP;

#define CallControlDefProc(userRoutine, varCode, theControl, message, param)		\
		(*(userRoutine))((varCode), (theControl), (message), (param))
#define NewControlDefProc(userRoutine)		\
		(ControlDefUPP)(userRoutine)
#endif

/*_________________________________________________________________________________________________________*/
/**/
/*  CONTROL TYPE DECLARATIONS*/
/**/
/*_________________________________________________________________________________________________________*/
/**/
/* Define ControlRef and ControlHandle*/
/**/
typedef void (pascal *ControlActionProcPtr)(ControlHandle theControl, short partCode);

enum {
	uppControlActionProcInfo = kPascalStackBased
		| STACK_ROUTINE_PARAMETER(1, SIZE_CODE(sizeof(ControlHandle)))
		| STACK_ROUTINE_PARAMETER(2, SIZE_CODE(sizeof(short)))
};

#if USESROUTINEDESCRIPTORS
typedef UniversalProcPtr ControlActionUPP;

#define CallControlActionProc(userRoutine, theControl, partCode)		\
		CallUniversalProc((UniversalProcPtr)(userRoutine), uppControlActionProcInfo, (theControl), (partCode))
#define NewControlActionProc(userRoutine)		\
		(ControlActionUPP) NewRoutineDescriptor((ProcPtr)(userRoutine), uppControlActionProcInfo, GetCurrentISA())
#else
typedef ControlActionProcPtr ControlActionUPP;

#define CallControlActionProc(userRoutine, theControl, partCode)		\
		(*(userRoutine))((theControl), (partCode))
#define NewControlActionProc(userRoutine)		\
		(ControlActionUPP)(userRoutine)
#endif

struct ControlRecord {
	ControlHandle			nextControl;
	WindowPtr			contrlOwner;
	Rect			contrlRect;
	unsigned char			contrlVis;
	unsigned char			contrlHilite;
	short			contrlValue;
	short			contrlMin;
	short			contrlMax;
	Handle			contrlDefProc;
	Handle			contrlData;
	ControlActionUPP			contrlAction;
	long			contrlRfCon;
	Str255			contrlTitle;
};
struct PopupPrivateData {
	MenuHandle			mHandle;			/*popup menu handle*/
	short			mID;			/*popup menu ID*/
};
typedef struct PopupPrivateData PopupPrivateData;

typedef PopupPrivateData *PopupPrivateDataPtr, **PopupPrivateDataHandle;

struct CtlCTab {
	long			ccSeed;			/*reserved*/
	short			ccRider;			/*see what you have done - reserved*/
	short			ctSize;			/*usually 3 for controls*/
	ColorSpec			ctTable[4];
};
typedef struct CtlCTab CtlCTab;

typedef CtlCTab *CCTabPtr, **CCTabHandle;

struct AuxCtlRec {
	Handle			acNext;			/*handle to next AuxCtlRec*/
	ControlHandle			acOwner;			/*handle for aux record's control*/
	CCTabHandle			acCTable;			/*color table for this control*/
	short			acFlags;			/*misc flag byte*/
	long			acReserved;			/*reserved for use by Apple*/
	long			acRefCon;			/*for use by application*/
};
typedef struct AuxCtlRec AuxCtlRec;

typedef AuxCtlRec *AuxCtlPtr, **AuxCtlHandle;

#ifdef __cplusplus
extern "C" {
#endif

extern ControlHandle pascal NewControl(WindowPtr theWindow, const Rect *boundsRect, ConstStr255Param title, Boolean visible, short value, short min, short max, short procID, long refCon);
extern void pascal SetControlTitle(ControlHandle theControl, ConstStr255Param title);
extern void pascal GetControlTitle(ControlHandle theControl, Str255 title);
extern ControlHandle pascal GetNewControl(short controlID, WindowPtr owner);
extern void pascal DisposeControl(ControlHandle theControl);
extern void pascal KillControls(WindowPtr theWindow);
extern void pascal HideControl(ControlHandle theControl);
extern void pascal ShowControl(ControlHandle theControl);
extern void pascal DrawControls(WindowPtr theWindow);
extern void pascal Draw1Control(ControlHandle theControl);
extern void pascal HiliteControl(ControlHandle theControl, short hiliteState);
extern void pascal UpdateControls(WindowPtr theWindow, RgnHandle updateRgn);
extern void pascal MoveControl(ControlHandle theControl, short h, short v);
extern void pascal SizeControl(ControlHandle theControl, short w, short h);
extern void pascal SetControlValue(ControlHandle theControl, short theValue);
extern short pascal GetControlValue(ControlHandle theControl);
extern void pascal SetControlMinimum(ControlHandle theControl, short minValue);
extern short pascal GetControlMinimum(ControlHandle theControl);
extern void pascal SetControlMaximum(ControlHandle theControl, short maxValue);
extern short pascal GetControlMaximum(ControlHandle theControl);
extern void pascal SetControlReference(ControlHandle theControl, long data);
extern long pascal GetControlReference(ControlHandle theControl);
extern void pascal SetControlAction(ControlHandle theControl, ControlActionUPP actionProc);
extern ControlActionUPP pascal GetControlAction(ControlHandle theControl);
extern void pascal DragControl(ControlHandle theControl, Point startPt, const Rect *limitRect, const Rect *slopRect, short axis);
extern short pascal TestControl(ControlHandle theControl, Point thePt);
extern short pascal TrackControl(ControlHandle theControl, Point thePoint, ControlActionUPP actionProc);
extern short pascal FindControl(Point thePoint, WindowPtr theWindow, ControlHandle *theControl);
extern void pascal SetControlColor(ControlHandle theControl, CCTabHandle newColorTable);
extern Boolean pascal GetAuxiliaryControlRecord(ControlHandle theControl, AuxCtlHandle *acHndl);
extern short pascal GetControlVariant(ControlHandle theControl);
extern void dragcontrol(ControlHandle theControl, Point *startPt, const Rect *limitRect, const Rect *slopRect, short axis);
extern ControlHandle newcontrol(WindowPtr theWindow, const Rect *boundsRect, char *title, Boolean visible, short value, short min, short max, short procID, long refCon);
extern short findcontrol(Point *thePoint, WindowPtr theWindow, ControlHandle *theControl);
extern void getcontroltitle(ControlHandle theControl, char *title);
extern void setcontroltitle(ControlHandle theControl, char *title);
extern short trackcontrol(ControlHandle theControl, Point *thePoint, ControlActionUPP actionProc);
extern short testcontrol(ControlHandle theControl, Point *thePt);

#define GetControlListFromWindow(theWindow)		((WindowPeek) theWindow)->controlList
#define GetControlOwningWindowControlList(theWindow) ((WindowPeek) theWindow)->controlList

// Added for support of combo box control
extern ControlHandle pascal DG_NewComboControl(WindowPtr theWindow, const Rect *boundsRect, ConstStr255Param title, Boolean visible, short value, short min, short max, short procID, long refCon);
#if OLDROUTINENAMES
#define SetCTitle(theControl, title) SetControlTitle(theControl, title)

#define GetCTitle(theControl, title) GetControlTitle(theControl, title)

#define UpdtControl(theWindow, updateRgn) UpdateControls(theWindow, updateRgn)

#define SetCtlValue(theControl, theValue) SetControlValue(theControl, theValue)

#define GetCtlValue(theControl) GetControlValue(theControl)

#define SetCtlMin(theControl, minValue) SetControlMinimum(theControl, minValue)

#define GetCtlMin(theControl) GetControlMinimum(theControl)

#define SetCtlMax(theControl, maxValue) SetControlMaximum(theControl, maxValue)

#define GetCtlMax(theControl) GetControlMaximum(theControl)

#define SetCRefCon(theControl, data) SetControlReference(theControl, data)

#define GetCRefCon(theControl) GetControlReference(theControl)

#define SetCtlAction(theControl, actionProc) SetControlAction(theControl, actionProc)

#define GetCtlAction(theControl) GetControlAction(theControl)

#define SetCtlColor(theControl, newColorTable) SetControlColor(theControl, newColorTable)

#define GetAuxCtl(theControl, acHndl) GetAuxiliaryControlRecord(theControl, acHndl)

#define GetCVariant(theControl) GetControlVariant(theControl)

#define getctitle(theControl, title) getcontroltitle(theControl, title)

#define setctitle(theControl, title) setcontroltitle(theControl, title)

#endif

#if PRAGMA_STRUCT_ALIGN
	#pragma options align=reset
#elif PRAGMA_STRUCT_PACKPUSH
	#pragma pack(pop)
#elif PRAGMA_STRUCT_PACK
	#pragma pack()
#endif

#ifdef PRAGMA_IMPORT_OFF
#pragma import off
#elif PRAGMA_IMPORT
#pragma import reset
#endif
#ifdef __cplusplus
}
#endif

#endif


