/*
	File:		DatabaseAccess.h

	Copyright:	 1984-1993 by Apple Computer, Inc., all rights reserved.

	WARNING
	This file was auto generated by the interfacer tool. Modifications
	must be made to the master file.

*/

#ifndef __DATABASEACCESS__
#define __DATABASEACCESS__

#ifndef __RESOURCES__
#if LONG_FILENAMES
#include <Resources.H>
#else
#include <Resource.H>
#endif
#endif


#if PRAGMA_STRUCT_ALIGN
	#pragma options align=mac68k
#elif PRAGMA_STRUCT_PACKPUSH
	#pragma pack(push, 2)
#elif PRAGMA_STRUCT_PACK
	#pragma pack(2)
#endif

/* data type codes */

#define typeNone OST_none

#define typeDate OST_date

#define typeTime OST_time

#define typeTimeStamp OST_tims

#define typeDecimal OST_deci

#define typeMoney OST_mone

#define typeVChar OST_vcha

#define typeVBin OST_vbin

#define typeLChar OST_lcha

#define typeLBin OST_lbin

#define typeDiscard OST_disc


/* "dummy" types for DBResultsToText */

#define typeUnknown OST_unkn

#define typeColBreak OST_colb

#define typeRowBreak OST_rowb


/* pass this in to DBGetItem for any data type */

#define typeAnyType (DBType)0


/* infinite timeout value for DBGetItem */

// the errors constants are in Errors.h


typedef OSType DBType;

typedef struct DBAsyncParamBlockRec DBAsyncParamBlockRec, *DBAsyncParmBlkPtr;


/*
	DBCompletionProcs cannot be written in or called from a high-level
	language without the help of mixed mode or assembly glue because they
	use the following parameter-passing convention:

	typedef pascal void (*DBCompletionProcPtr)(DBAsyncParmBlkPtr pb);

		In:
			=>	pb		A0.L
		Out:
			none
*/

enum  {
	uppDBCompletionProcInfo		= kRegisterBased|REGISTER_ROUTINE_PARAMETER(1,kRegisterA0,kFourByteCode)
};

#if USESROUTINEDESCRIPTORS
typedef void (pascal *DBCompletionProcPtr)(DBAsyncParmBlkPtr pb);

typedef UniversalProcPtr DBCompletionUPP;

#define CallDBCompletionProc(userRoutine, pb)  \
	CallUniversalProc((UniversalProcPtr)(userRoutine), uppDBCompletionProcInfo, (pb))

#define NewDBCompletionProc(userRoutine)  \
	(DBCompletionUPP) NewRoutineDescriptor((ProcPtr)(userRoutine), uppDBCompletionProcInfo, GetCurrentISA())

#else
typedef ProcPtr DBCompletionUPP;

#define NewDBCompletionProc(userRoutine)  \
	(DBCompletionUPP)((userRoutine))

#endif


/* structure for asynchronous parameter block */

struct DBAsyncParamBlockRec {
	DBCompletionUPP			completionProc;			/* pointer to completion routine */
	OSErr			result;			/* result of call */
	long			userRef;			/* for application's use */
	long			ddevRef;			/* for ddev's use */
	long			reserved;			/* for internal use */
};
/* structure for resource list in QueryRecord */

struct ResListElem {
	ResType			theType;			/* resource type */
	short			id;			/* resource id */
};
typedef struct ResListElem ResListElem;

typedef ResListElem *ResListPtr, **ResListHandle;


/* structure for query list in QueryRecord */

typedef Handle **QueryListHandle;

struct QueryRecord {
	short			version;			/* version */
	short			id;			/* id of 'qrsc' this came from */
	Handle			queryProc;			/* handle to query def proc */
	Str63			ddevName;			/* ddev name */
	Str255			host;			/* host name */
	Str255			user;			/* user name */
	Str255			password;			/* password */
	Str255			connStr;			/* connection string */
	short			currQuery;			/* index of current query */
	short			numQueries;			/* number of queries in list */
	QueryListHandle			queryList;			/* handle to array of handles to text */
	short			numRes;			/* number of resources in list */
	ResListHandle			resList;			/* handle to array of resource list elements */
	Handle			dataHandle;			/* for use by query def proc */
	long			refCon;			/* for use by application */
};
typedef struct QueryRecord QueryRecord;

typedef QueryRecord *QueryPtr, **QueryHandle;

typedef OSErr (pascal *DBQueryDefProcPtr)(long *sessID, QueryHandle query);

enum {
	uppDBQueryDefProcInfo = kPascalStackBased
		| RESULT_SIZE(SIZE_CODE(sizeof(OSErr)))
		| STACK_ROUTINE_PARAMETER(1, SIZE_CODE(sizeof(long*)))
		| STACK_ROUTINE_PARAMETER(2, SIZE_CODE(sizeof(QueryHandle)))
};

#if USESROUTINEDESCRIPTORS
typedef UniversalProcPtr DBQueryDefUPP;

#define CallDBQueryDefProc(userRoutine, sessID, query)		\
		CallUniversalProc((UniversalProcPtr)(userRoutine), uppDBQueryDefProcInfo, (sessID), (query))
#define NewDBQueryDefProc(userRoutine)		\
		(DBQueryDefUPP) NewRoutineDescriptor((ProcPtr)(userRoutine), uppDBQueryDefProcInfo, GetCurrentISA())
#else
typedef DBQueryDefProcPtr DBQueryDefUPP;

#define CallDBQueryDefProc(userRoutine, sessID, query)		\
		(*(userRoutine))((sessID), (query))
#define NewDBQueryDefProc(userRoutine)		\
		(DBQueryDefUPP)(userRoutine)
#endif


/* structure of column types array in ResultsRecord */

typedef Handle ColTypesHandle;


/* structure for column info in ResultsRecord */

struct DBColInfoRecord {
	short			len;
	short			places;
	short			flags;
};
typedef struct DBColInfoRecord DBColInfoRecord;

typedef Handle ColInfoHandle;


/* structure of results returned by DBGetResults */

struct ResultsRecord {
	short			numRows;			/* number of rows in result */
	short			numCols;			/* number of columns per row */
	ColTypesHandle			colTypes;			/* data type array */
	Handle			colData;			/* actual results */
	ColInfoHandle			colInfo;			/* DBColInfoRecord array */
};
typedef struct ResultsRecord ResultsRecord;

typedef Boolean (pascal *DBStatusProcPtr)(short message, OSErr result, short dataLen, short dataPlaces, short dataFlags, DBType dataType, Ptr dataPtr);

enum {
	uppDBStatusProcInfo = kPascalStackBased
		| RESULT_SIZE(SIZE_CODE(sizeof(Boolean)))
		| STACK_ROUTINE_PARAMETER(1, SIZE_CODE(sizeof(short)))
		| STACK_ROUTINE_PARAMETER(2, SIZE_CODE(sizeof(OSErr)))
		| STACK_ROUTINE_PARAMETER(3, SIZE_CODE(sizeof(short)))
		| STACK_ROUTINE_PARAMETER(4, SIZE_CODE(sizeof(short)))
		| STACK_ROUTINE_PARAMETER(5, SIZE_CODE(sizeof(short)))
		| STACK_ROUTINE_PARAMETER(6, SIZE_CODE(sizeof(DBType)))
		| STACK_ROUTINE_PARAMETER(7, SIZE_CODE(sizeof(Ptr)))
};

#if USESROUTINEDESCRIPTORS
typedef UniversalProcPtr DBStatusUPP;

#define CallDBStatusProc(userRoutine, message, result, dataLen, dataPlaces, dataFlags, dataType, dataPtr)		\
		CallUniversalProc((UniversalProcPtr)(userRoutine), uppDBStatusProcInfo, (message), (result), (dataLen), (dataPlaces), (dataFlags), (dataType), (dataPtr))
#define NewDBStatusProc(userRoutine)		\
		(DBStatusUPP) NewRoutineDescriptor((ProcPtr)(userRoutine), uppDBStatusProcInfo, GetCurrentISA())
#else
typedef DBStatusProcPtr DBStatusUPP;

#define CallDBStatusProc(userRoutine, message, result, dataLen, dataPlaces, dataFlags, dataType, dataPtr)		\
		(*(userRoutine))((message), (result), (dataLen), (dataPlaces), (dataFlags), (dataType), (dataPtr))
#define NewDBStatusProc(userRoutine)		\
		(DBStatusUPP)(userRoutine)
#endif

typedef OSErr (pascal *DBResultHandlerProcPtr)(DBType dataType, short theLen, short thePlaces, short theFlags, Ptr theData, Handle theText);

enum {
	uppDBResultHandlerProcInfo = kPascalStackBased
		| RESULT_SIZE(SIZE_CODE(sizeof(OSErr)))
		| STACK_ROUTINE_PARAMETER(1, SIZE_CODE(sizeof(DBType)))
		| STACK_ROUTINE_PARAMETER(2, SIZE_CODE(sizeof(short)))
		| STACK_ROUTINE_PARAMETER(3, SIZE_CODE(sizeof(short)))
		| STACK_ROUTINE_PARAMETER(4, SIZE_CODE(sizeof(short)))
		| STACK_ROUTINE_PARAMETER(5, SIZE_CODE(sizeof(Ptr)))
		| STACK_ROUTINE_PARAMETER(6, SIZE_CODE(sizeof(Handle)))
};

#if USESROUTINEDESCRIPTORS
typedef UniversalProcPtr DBResultHandlerUPP;

#define CallDBResultHandlerProc(userRoutine, dataType, theLen, thePlaces, theFlags, theData, theText)		\
		CallUniversalProc((UniversalProcPtr)(userRoutine), uppDBResultHandlerProcInfo, (dataType), (theLen), (thePlaces), (theFlags), (theData), (theText))
#define NewDBResultHandlerProc(userRoutine)		\
		(DBResultHandlerUPP) NewRoutineDescriptor((ProcPtr)(userRoutine), uppDBResultHandlerProcInfo, GetCurrentISA())
#else
typedef DBResultHandlerProcPtr DBResultHandlerUPP;

#define CallDBResultHandlerProc(userRoutine, dataType, theLen, thePlaces, theFlags, theData, theText)		\
		(*(userRoutine))((dataType), (theLen), (thePlaces), (theFlags), (theData), (theText))
#define NewDBResultHandlerProc(userRoutine)		\
		(DBResultHandlerUPP)(userRoutine)
#endif

#ifdef __cplusplus
extern "C" {
#endif
#if PRAGMA_IMPORT
#pragma import on
#endif

extern OSErr pascal InitDBPack(void);
extern OSErr pascal DBInit(long *sessID, ConstStr63Param ddevName, ConstStr255Param host, ConstStr255Param user, ConstStr255Param passwd, ConstStr255Param connStr, DBAsyncParmBlkPtr asyncPB);
extern OSErr pascal DBEnd(long sessID, DBAsyncParmBlkPtr asyncPB);
extern OSErr pascal DBGetConnInfo(long sessID, short sessNum, long *returnedID, long *version, Str63 ddevName, Str255 host, Str255 user, Str255 network, Str255 connStr, long *start, OSErr *state, DBAsyncParmBlkPtr asyncPB);
extern OSErr pascal DBGetSessionNum(long sessID, short *sessNum, DBAsyncParmBlkPtr asyncPB);
extern OSErr pascal DBSend(long sessID, char *text, short len, DBAsyncParmBlkPtr asyncPB);
extern OSErr pascal DBSendItem(long sessID, DBType dataType, short len, short places, short flags, void *buffer, DBAsyncParmBlkPtr asyncPB);
extern OSErr pascal DBExec(long sessID, DBAsyncParmBlkPtr asyncPB);
extern OSErr pascal DBState(long sessID, DBAsyncParmBlkPtr asyncPB);
extern OSErr pascal DBGetErr(long sessID, long *err1, long *err2, Str255 item1, Str255 item2, Str255 errorMsg, DBAsyncParmBlkPtr asyncPB);
extern OSErr pascal DBBreak(long sessID, Boolean abort, DBAsyncParmBlkPtr asyncPB);
extern OSErr pascal DBGetItem(long sessID, long timeout, DBType *dataType, short *len, short *places, short *flags, void *buffer, DBAsyncParmBlkPtr asyncPB);
extern OSErr pascal DBUnGetItem(long sessID, DBAsyncParmBlkPtr asyncPB);
extern OSErr pascal DBKill(DBAsyncParmBlkPtr asyncPB);
extern OSErr pascal DBGetNewQuery(short queryID, QueryHandle *query);
extern OSErr pascal DBDisposeQuery(QueryHandle query);
extern OSErr pascal DBStartQuery(long *sessID, QueryHandle query, DBStatusUPP statusProc, DBAsyncParmBlkPtr asyncPB);
extern OSErr pascal DBGetQueryResults(long sessID, ResultsRecord *results, long timeout, DBStatusUPP statusProc, DBAsyncParmBlkPtr asyncPB);
extern OSErr pascal DBResultsToText(ResultsRecord *results, Handle *theText);
extern OSErr pascal DBInstallResultHandler(DBType dataType, DBResultHandlerUPP theHandler, Boolean isSysHandler);
extern OSErr pascal DBRemoveResultHandler(DBType dataType);
extern OSErr pascal DBGetResultHandler(DBType dataType, DBResultHandlerUPP *theHandler, Boolean getSysHandler);
#if PRAGMA_STRUCT_ALIGN
	#pragma options align=reset
#elif PRAGMA_STRUCT_PACKPUSH
	#pragma pack(pop)
#elif PRAGMA_STRUCT_PACK
	#pragma pack()
#endif

#ifdef PRAGMA_IMPORT_OFF
#pragma import off
#elif PRAGMA_IMPORT
#pragma import reset
#endif
#ifdef __cplusplus
}
#endif

#endif


