/*
	File:		Editions.h

	Copyright:	 1984-1993 by Apple Computer, Inc., all rights reserved.

	WARNING
	This file was auto generated by the interfacer tool. Modifications
	must be made to the master file.

*/

#ifndef __EDITIONS__
#define __EDITIONS__

#ifndef __MEMORY__
#if MACVER
#include <Memory.h>
#else
#include <MemoryM.h>
#endif
#endif

#ifndef __FILES__
#include <Files.H>
#endif

#ifndef __ALIASES__
#include <Aliases.H>
#endif

#ifndef __DIALOGS__
#include <Dialogs.H>
#endif

#if PRAGMA_IMPORT
#pragma import on
#endif

#if PRAGMA_STRUCT_ALIGN
	#pragma options align=mac68k
#elif PRAGMA_STRUCT_PACKPUSH
	#pragma pack(push, 2)
#elif PRAGMA_STRUCT_PACK
	#pragma pack(2)
#endif


/* resource types  */

#define rSectionType OST_sect


/* Finder types for edition files */

#define kPICTEditionFileType OST_edtp

#define kTEXTEditionFileType OST_edtt

#define ksndEditionFileType OST_edts

#define kUnknownEditionFileType OST_edtu

#define kPublisherDocAliasFormat OST_alis

#define kPreviewFormat OST_prvw

#define kFormatListFormat OST_fmts

enum  {
/* section types */
	stSubscriber			= 0x01,
	stPublisher			= 0x0A,
	sumAutomatic			= 0,			/* subscriber update mode - Automatically	*/
	sumManual			= 1,			/* subscriber update mode - Manually */
	pumOnSave			= 0,			/* publisher update mode - OnSave		*/
	pumManual			= 1,			/* publisher update mode - Manually */
	kPartsNotUsed			= 0,
	kPartNumberUnknown			= -1,			/* misc */
	kPreviewWidth			= 120,
	kPreviewHeight			= 120,
/* bits for formatsMask */
	kPICTformatMask			= 1,
	kTEXTformatMask			= 2,
	ksndFormatMask			= 4,
/* pseudo-item hits for dialogHooks
 the first if for NewPublisher or NewSubscriber Dialogs */
	emHookRedrawPreview			= 150,
/* the following are for SectionOptions Dialog */
	emHookCancelSection			= 160,
	emHookGoToPublisher			= 161,
	emHookGetEditionNow			= 162,
	emHookSendEditionNow		= 162,
	emHookManualUpdateMode		= 163,
	emHookAutoUpdateMode		= 164
};

#define emOptionsDialogRefCon OST_optn

#define emCancelSectionDialogRefCon OST_cncl

#define emGoToPubErrDialogRefCon OST_gerr

enum  {
/* the refcon field of the dialog record during a modalfilter
 or dialoghook contains one the following */
	kFormatLengthUnknown		= -1
};


/* one byte, stSubscriber or stPublisher */

typedef char SectionType;


/* seconds since 1904 */

typedef unsigned long TimeStamp;


/* similar to ResType */

typedef unsigned long FormatType;


/* used in Edition I/O */

typedef Handle EditionRefNum;


/* update modes */


/* sumAutomatic, pumSuspend, etc */

typedef short UpdateMode;

struct SectionRecord {
	SignedByte			version;			/* always 0x01 in system 7.0 */
	SectionType			kind;			/* stSubscriber or stPublisher */
	UpdateMode			mode;			/* auto or manual */
	TimeStamp			mdDate;			/* last change in document */
	long			sectionID;			/* app. specific, unique per document */
	long			refCon;			/* application specific */
	AliasHandle			alias;			/* handle to Alias Record */
	long			subPart;			/* which part of container file */
	struct SectionRecord		**nextSection;			/* for linked list of app's Sections */
	Handle			controlBlock;			/* used internally */
	EditionRefNum			refNum;			/* used internally */
};
typedef struct SectionRecord SectionRecord;

typedef SectionRecord *SectionPtr, **SectionHandle;

// WARNING: This struct is larger now on Windows because the FSSpec struct
//  has been grown to handle long file names. Make sure you don't save this
//  struct to disk as it will be different sizes on the 2 platforms.

struct EditionContainerSpec {
	FSSpec			theFile;
	ScriptCode			theFileScript;
	long			thePart;
	Str31			thePartName;
	ScriptCode			thePartScript;
};
typedef struct EditionContainerSpec EditionContainerSpec;

typedef EditionContainerSpec *EditionContainerSpecPtr;

struct EditionInfoRecord {
	TimeStamp			crDate;			/* date EditionContainer was created */
	TimeStamp			mdDate;			/* date of last change */
	OSType			fdCreator;			/* file creator */
	OSType			fdType;			/* file type */
	EditionContainerSpec		container;			/* the Edition */
};
typedef struct EditionInfoRecord EditionInfoRecord;

struct NewPublisherReply {
	Boolean			canceled;			/* O */
	Boolean			replacing;
	Boolean			usePart;			/* I */
	Handle			preview;			/* I */
	FormatType			previewFormat;			/* I */
	EditionContainerSpec		container;			/* I/O */
};
typedef struct NewPublisherReply NewPublisherReply;

struct NewSubscriberReply {
	Boolean			canceled;			/* O */
	unsigned char			formatsMask;
	EditionContainerSpec		container;			/*I/O*/
};
typedef struct NewSubscriberReply NewSubscriberReply;

struct SectionOptionsReply {
	Boolean			canceled;			/* O */
	Boolean			changed;			/* O */
	SectionHandle			sectionH;			/* I */
	ResType			action;			/* O */
};
typedef struct SectionOptionsReply SectionOptionsReply;

typedef Boolean (pascal *ExpModalFilterProcPtr)(DialogPtr theDialog, EventRecord *theEvent, short itemOffset, short *itemHit, Ptr yourDataPtr);

enum {
	uppExpModalFilterProcInfo = kPascalStackBased
		| RESULT_SIZE(SIZE_CODE(sizeof(Boolean)))
		| STACK_ROUTINE_PARAMETER(1, SIZE_CODE(sizeof(DialogPtr)))
		| STACK_ROUTINE_PARAMETER(2, SIZE_CODE(sizeof(EventRecord*)))
		| STACK_ROUTINE_PARAMETER(3, SIZE_CODE(sizeof(short)))
		| STACK_ROUTINE_PARAMETER(4, SIZE_CODE(sizeof(short*)))
		| STACK_ROUTINE_PARAMETER(5, SIZE_CODE(sizeof(Ptr)))
};

#if USESROUTINEDESCRIPTORS
typedef UniversalProcPtr ExpModalFilterUPP;

#define CallExpModalFilterProc(userRoutine, theDialog, theEvent, itemOffset, itemHit, yourDataPtr)		\
		CallUniversalProc((UniversalProcPtr)(userRoutine), uppExpModalFilterProcInfo, (theDialog), (theEvent), (itemOffset), (itemHit), (yourDataPtr))
#define NewExpModalFilterProc(userRoutine)		\
		(ExpModalFilterUPP) NewRoutineDescriptor((ProcPtr)(userRoutine), uppExpModalFilterProcInfo, GetCurrentISA())
#else
typedef ExpModalFilterProcPtr ExpModalFilterUPP;

#define CallExpModalFilterProc(userRoutine, theDialog, theEvent, itemOffset, itemHit, yourDataPtr)		\
		(*(userRoutine))((theDialog), (theEvent), (itemOffset), (itemHit), (yourDataPtr))
#define NewExpModalFilterProc(userRoutine)		\
		(ExpModalFilterUPP)(userRoutine)
#endif

typedef short (pascal *ExpDlgHookProcPtr)(short itemOffset, short itemHit, DialogPtr theDialog, Ptr yourDataPtr);

enum {
	uppExpDlgHookProcInfo = kPascalStackBased
		| RESULT_SIZE(SIZE_CODE(sizeof(short)))
		| STACK_ROUTINE_PARAMETER(1, SIZE_CODE(sizeof(short)))
		| STACK_ROUTINE_PARAMETER(2, SIZE_CODE(sizeof(short)))
		| STACK_ROUTINE_PARAMETER(3, SIZE_CODE(sizeof(DialogPtr)))
		| STACK_ROUTINE_PARAMETER(4, SIZE_CODE(sizeof(Ptr)))
};

#if USESROUTINEDESCRIPTORS
typedef UniversalProcPtr ExpDlgHookUPP;

#define CallExpDlgHookProc(userRoutine, itemOffset, itemHit, theDialog, yourDataPtr)		\
		CallUniversalProc((UniversalProcPtr)(userRoutine), uppExpDlgHookProcInfo, (itemOffset), (itemHit), (theDialog), (yourDataPtr))
#define NewExpDlgHookProc(userRoutine)		\
		(ExpDlgHookUPP) NewRoutineDescriptor((ProcPtr)(userRoutine), uppExpDlgHookProcInfo, GetCurrentISA())
#else
typedef ExpDlgHookProcPtr ExpDlgHookUPP;

#define CallExpDlgHookProc(userRoutine, itemOffset, itemHit, theDialog, yourDataPtr)		\
		(*(userRoutine))((itemOffset), (itemHit), (theDialog), (yourDataPtr))
#define NewExpDlgHookProc(userRoutine)		\
		(ExpDlgHookUPP)(userRoutine)
#endif

enum  {
	ioHasFormat,
	ioReadFormat,
	ioNewFormat,
	ioWriteFormat
};

typedef unsigned char FormatIOVerb;

enum  {
	eoOpen,
	eoClose,
	eoOpenNew,
	eoCloseNew,
	eoCanSubscribe
};

typedef unsigned char EditionOpenerVerb;

struct FormatIOParamBlock {
	long			ioRefNum;
	FormatType			format;
	long			formatIndex;
	unsigned long			offset;
	Ptr			buffPtr;
	unsigned long			buffLen;
};
typedef struct FormatIOParamBlock FormatIOParamBlock;

typedef struct EditionOpenerParamBlock EditionOpenerParamBlock;

typedef short (pascal *FormatIOProcPtr)(FormatIOVerb selector, FormatIOParamBlock *PB);

typedef short (pascal *EditionOpenerProcPtr)(EditionOpenerVerb selector, EditionOpenerParamBlock *PB);

enum  {
	uppFormatIOProcInfo			= kPascalStackBased|RESULT_SIZE(kTwoByteCode)|STACK_ROUTINE_PARAMETER(1,kOneByteCode)|STACK_ROUTINE_PARAMETER(2,kFourByteCode),
	uppEditionOpenerProcInfo	= kPascalStackBased|RESULT_SIZE(kTwoByteCode)|STACK_ROUTINE_PARAMETER(1,kOneByteCode)|STACK_ROUTINE_PARAMETER(2,kFourByteCode)
};


/* Note: Use CallEditionOpenerProc and CallFormatIOProc to call these routines */

#if USESROUTINEDESCRIPTORS
typedef UniversalProcPtr FormatIOUPP;

typedef UniversalProcPtr EditionOpenerUPP;

#define NewFormatIOProc(userRoutine)  \
	(FormatIOUPP) NewRoutineDescriptor((ProcPtr)(userRoutine), uppFormatIOProcInfo, GetCurrentISA())

#define NewEditionOpenerProc(userRoutine)  \
	(EditionOpenerUPP) NewRoutineDescriptor((ProcPtr)(userRoutine), uppEditionOpenerProcInfo, GetCurrentISA())

#else
typedef FormatIOProcPtr FormatIOUPP;

typedef EditionOpenerProcPtr EditionOpenerUPP;

#define NewFormatIOProc(userRoutine) (FormatIOUPP)(userRoutine)

#define NewEditionOpenerProc(userRoutine) (EditionOpenerUPP)(userRoutine)

#endif

struct EditionOpenerParamBlock {
	EditionInfoRecord			info;
	SectionHandle			sectionH;
	FSSpecPtr			document;
	OSType			fdCreator;
	long			ioRefNum;
	FormatIOUPP			ioProc;
	Boolean			success;
	unsigned char			formatsMask;
};
/*
 Section events now arrive in the message buffer using the AppleEvent format.
 The direct object parameter is an aeTemporaryIDParamType ('tid '). The temporary
 ID's type is rSectionType ('sect') and the 32-bit value is a SectionHandle.
 The following is a sample buffer

 name   offset contents
 ----   ------ --------

 header   0  'aevt'
 majorVersion 4  0x01
 minorVersion 6  0x01
 endOfMetaData 8  ';;;;'
 directObjKey 12  '----'
 paramType  16  'tid '
 paramLength  20  0x0008
 tempIDType  24  'sect'
 tempID	28  the SectionHandle <-- this is want you want*/

#define sectionEventMsgClass OST_sect

#define sectionReadMsgID OST_read

#define sectionWriteMsgID OST_writ

#define sectionScrollMsgID OST_scrl

#define sectionCancelMsgID OST_cncl

#define currentEditionMgrVers 0x0011

#ifdef __cplusplus
extern "C" {
#endif
#if !USESCODEFRAGMENTS
extern OSErr pascal InitEditionPack(void);
#else
extern OSErr pascal InitEditionPackVersion(short curEditionMgrVers);
#define InitEditionPack() InitEditionPackVersion(currentEditionMgrVers)

#endif

extern OSErr pascal NewSection(const EditionContainerSpec *container, const FSSpec *sectionDocument, SectionType kind, long sectionID, UpdateMode initalMode, SectionHandle *sectionH);
extern OSErr pascal RegisterSection(const FSSpec *sectionDocument, SectionHandle sectionH, Boolean *aliasWasUpdated);
extern OSErr pascal UnRegisterSection(SectionHandle sectionH);
extern OSErr pascal IsRegisteredSection(SectionHandle sectionH);
extern OSErr pascal AssociateSection(SectionHandle sectionH, const FSSpec *newSectionDocument);
extern OSErr pascal CreateEditionContainerFile(const FSSpec *editionFile, OSType fdCreator, ScriptCode editionFileNameScript);
extern OSErr pascal DeleteEditionContainerFile(const FSSpec *editionFile);
extern OSErr pascal OpenEdition(SectionHandle subscriberSectionH, EditionRefNum *refNum);
extern OSErr pascal OpenNewEdition(SectionHandle publisherSectionH, OSType fdCreator, const FSSpec *publisherSectionDocument, EditionRefNum *refNum);
extern OSErr pascal CloseEdition(EditionRefNum whichEdition, Boolean successful);
extern OSErr pascal EditionHasFormat(EditionRefNum whichEdition, FormatType whichFormat, Size *formatSize);
extern OSErr pascal ReadEdition(EditionRefNum whichEdition, FormatType whichFormat, void *buffPtr, Size *buffLen);
extern OSErr pascal WriteEdition(EditionRefNum whichEdition, FormatType whichFormat, const void *buffPtr, Size buffLen);
extern OSErr pascal GetEditionFormatMark(EditionRefNum whichEdition, FormatType whichFormat, unsigned long *currentMark);
extern OSErr pascal SetEditionFormatMark(EditionRefNum whichEdition, FormatType whichFormat, unsigned long setMarkTo);
extern OSErr pascal GetEditionInfo(const SectionHandle sectionH, EditionInfoRecord *editionInfo);
extern OSErr pascal GoToPublisherSection(const EditionContainerSpec *container);
extern OSErr pascal GetLastEditionContainerUsed(EditionContainerSpec *container);
extern OSErr pascal GetStandardFormats(const EditionContainerSpec *container, FormatType *previewFormat, Handle preview, Handle publisherAlias, Handle formats);
extern OSErr pascal GetEditionOpenerProc(EditionOpenerUPP *opener);
extern OSErr pascal SetEditionOpenerProc(EditionOpenerUPP opener);
extern OSErr pascal CallEditionOpenerProc(EditionOpenerVerb selector, EditionOpenerParamBlock *PB, EditionOpenerUPP routine);
extern OSErr pascal CallFormatIOProc(FormatIOVerb selector, FormatIOParamBlock *PB, FormatIOUPP routine);
extern OSErr pascal NewSubscriberDialog(NewSubscriberReply *reply);
extern OSErr pascal NewSubscriberExpDialog(NewSubscriberReply *reply, Point where, short expansionDITLresID, ExpDlgHookUPP dlgHook, ExpModalFilterUPP filter, void *yourDataPtr);
extern OSErr pascal NewPublisherDialog(NewPublisherReply *reply);
extern OSErr pascal NewPublisherExpDialog(NewPublisherReply *reply, Point where, short expansionDITLresID, ExpDlgHookUPP dlgHook, ExpModalFilterUPP filter, void *yourDataPtr);
extern OSErr pascal SectionOptionsDialog(SectionOptionsReply *reply);
extern OSErr pascal SectionOptionsExpDialog(SectionOptionsReply *reply, Point where, short expansionDITLresID, ExpDlgHookUPP dlgHook, ExpModalFilterUPP filter, void *yourDataPtr);
#if PRAGMA_STRUCT_ALIGN
	#pragma options align=reset
#elif PRAGMA_STRUCT_PACKPUSH
	#pragma pack(pop)
#elif PRAGMA_STRUCT_PACK
	#pragma pack()
#endif

#ifdef PRAGMA_IMPORT_OFF
#pragma import off
#elif PRAGMA_IMPORT
#pragma import reset
#endif
#ifdef __cplusplus
}
#endif

#endif


