/*
	File:		Menus.h

	Copyright:	 1984-1993 by Apple Computer, Inc., all rights reserved.

	WARNING
	This file was auto generated by the interfacer tool. Modifications
	must be made to the master file.

*/

#ifndef __MENUS__
#define __MENUS__

#ifndef __QUICKDRAW__
#if LONG_FILENAMES
#include <Quickdraw.H>
#else
#include <Quickdra.H>
#endif
#endif

#define noMark '\0'

#if PRAGMA_IMPORT
#pragma import on
#endif

#if PRAGMA_STRUCT_ALIGN
	#pragma options align=mac68k
#elif PRAGMA_STRUCT_PACKPUSH
	#pragma pack(push, 2)
#elif PRAGMA_STRUCT_PACK
	#pragma pack(2)
#endif

enum  {
/* menu defProc messages */
	mDrawMsg			= 0,
	mChooseMsg			= 1,
	mSizeMsg			= 2,
	mDrawItemMsg			= 4,
	mCalcItemMsg			= 5,
	textMenuProc			= 0,
	hMenuCmd			= 27,			/*itemCmd == 0x001B ==> hierarchical menu*/
	hierMenu			= -1,			/*a hierarchical menu - for InsertMenu call*/
	mPopUpMsg			= 3,			/*menu defProc messages - place yourself*/
	mctAllItems			= -98,			/*search for all Items for the given ID*/
	mctLastIDIndic			= -99			/*last color table entry has this in ID field*/
};

typedef struct MenuInfo MenuInfo, *MenuPtr, **MenuHandle;
typedef MenuHandle MenuRef;

typedef void (pascal *MenuDefProcPtr)(short message, MenuHandle theMenu, Rect *menuRect, Point hitPt, short *whichItem);

enum {
	uppMenuDefProcInfo = kPascalStackBased
		| STACK_ROUTINE_PARAMETER(1, SIZE_CODE(sizeof(short)))
		| STACK_ROUTINE_PARAMETER(2, SIZE_CODE(sizeof(MenuHandle)))
		| STACK_ROUTINE_PARAMETER(3, SIZE_CODE(sizeof(Rect*)))
		| STACK_ROUTINE_PARAMETER(4, SIZE_CODE(sizeof(Point)))
		| STACK_ROUTINE_PARAMETER(5, SIZE_CODE(sizeof(short*)))
};

#if USESROUTINEDESCRIPTORS
typedef UniversalProcPtr MenuDefUPP;

#define CallMenuDefProc(userRoutine, message, theMenu, menuRect, hitPt, whichItem)		\
		CallUniversalProc((UniversalProcPtr)(userRoutine), uppMenuDefProcInfo, (message), (theMenu), (menuRect), (hitPt), (whichItem))
#define NewMenuDefProc(userRoutine)		\
		(MenuDefUPP) NewRoutineDescriptor((ProcPtr)(userRoutine), uppMenuDefProcInfo, GetCurrentISA())
#else
typedef MenuDefProcPtr MenuDefUPP;

#define CallMenuDefProc(userRoutine, message, theMenu, menuRect, hitPt, whichItem)		\
		(*(userRoutine))((message), (theMenu), (menuRect), (hitPt), (whichItem))
#define NewMenuDefProc(userRoutine)		\
		(MenuDefUPP)(userRoutine)
#endif

typedef long (pascal *MenuBarDefProcPtr)(short selector, short message, short parameter1, long parameter2);

enum {
	uppMenuBarDefProcInfo = kPascalStackBased
		| RESULT_SIZE(SIZE_CODE(sizeof(long)))
		| STACK_ROUTINE_PARAMETER(1, SIZE_CODE(sizeof(short)))
		| STACK_ROUTINE_PARAMETER(2, SIZE_CODE(sizeof(short)))
		| STACK_ROUTINE_PARAMETER(3, SIZE_CODE(sizeof(short)))
		| STACK_ROUTINE_PARAMETER(4, SIZE_CODE(sizeof(long)))
};

#if USESROUTINEDESCRIPTORS
typedef UniversalProcPtr MenuBarDefUPP;

#define CallMenuBarDefProc(userRoutine, selector, message, parameter1, parameter2)		\
		CallUniversalProc((UniversalProcPtr)(userRoutine), uppMenuBarDefProcInfo, (selector), (message), (parameter1), (parameter2))
#define NewMenuBarDefProc(userRoutine)		\
		(MenuBarDefUPP) NewRoutineDescriptor((ProcPtr)(userRoutine), uppMenuBarDefProcInfo, GetCurrentISA())
#else
typedef MenuBarDefProcPtr MenuBarDefUPP;

#define CallMenuBarDefProc(userRoutine, selector, message, parameter1, parameter2)		\
		(*(userRoutine))((selector), (message), (parameter1), (parameter2))
#define NewMenuBarDefProc(userRoutine)		\
		(MenuBarDefUPP)(userRoutine)
#endif


/*
	typedef pascal short (*MBarHookProcPtr)(Rect* menuRect);

		In:
			=>	menuRect		Pascal Stack

		Out:
			=>	result			D0.W
*/

enum  {
	uppMBarHookProcInfo			= SPECIAL_CASE_PROCINFO(kSpecialCaseMBarHook)
};

#if USESROUTINEDESCRIPTORS
typedef short (pascal *MBarHookProcPtr)(Rect *menuRect);

typedef UniversalProcPtr MBarHookUPP;

#define CallMBarHookProc(userRoutine, menuRect)  \
	CallUniversalProc((UniversalProcPtr)(userRoutine), uppMBarHookProcInfo, menuRect)

#define NewMBarHookProc(userRoutine)  \
	(MBarHookUPP) NewRoutineDescriptor((ProcPtr)(userRoutine), uppMBarHookProcInfo, GetCurrentISA())

#else
typedef ProcPtr MBarHookUPP;

#define NewMBarHookProc(userRoutine)  \
	(MBarHookUPP)(userRoutine)

#endif

typedef void (pascal *MenuHookProcPtr)();

enum {
	uppMenuHookProcInfo = kPascalStackBased
};

#if USESROUTINEDESCRIPTORS
typedef UniversalProcPtr MenuHookUPP;

#define CallMenuHookProc(userRoutine)		\
		CallUniversalProc((UniversalProcPtr)(userRoutine), uppMenuHookProcInfo)
#define NewMenuHookProc(userRoutine)		\
		(MenuHookUPP) NewRoutineDescriptor((ProcPtr)(userRoutine), uppMenuHookProcInfo, GetCurrentISA())
#else
typedef MenuHookProcPtr MenuHookUPP;

#define CallMenuHookProc(userRoutine)		\
		(*(userRoutine))()
#define NewMenuHookProc(userRoutine)		\
		(MenuHookUPP)(userRoutine)
#endif

#pragma PRAGMA_PACK_1

struct MenuInfo {
	short			menuID;
	short			menuWidth;
	short			menuHeight;
	Handle			menuProc;
	long			enableFlags;
	Str255			menuData;
};

#pragma PRAGMA_PACK_RESET

struct MCEntry {
	short			mctID;			/*menu ID.  ID = 0 is the menu bar*/
	short			mctItem;			/*menu Item. Item = 0 is a title*/
	RGBColor			mctRGB1;			/*usage depends on ID and Item*/
	RGBColor			mctRGB2;			/*usage depends on ID and Item*/
	RGBColor			mctRGB3;			/*usage depends on ID and Item*/
	RGBColor			mctRGB4;			/*usage depends on ID and Item*/
	short			mctReserved;			/*reserved for internal use*/
};
typedef struct MCEntry MCEntry;

typedef MCEntry *MCEntryPtr;

typedef MCEntry MCTable[1], *MCTablePtr, **MCTableHandle;

struct MenuCRsrc {
	short			numEntries;			/*number of entries*/
	MCTable			mcEntryRecs;			/*ARRAY [1..numEntries] of MCEntry*/
};
typedef struct MenuCRsrc MenuCRsrc;

typedef MenuCRsrc *MenuCRsrcPtr, **MenuCRsrcHandle;

#ifdef __cplusplus
extern "C" {
#endif

#if USESCODEFRAGMENTS
extern short pascal GetMBarHeight(void);
#else
#endif

extern void pascal InitMenus(void);
extern MenuHandle pascal NewMenu(short menuID, const Str255 menuTitle);
extern MenuHandle pascal GetMen(short resourceID);
extern void pascal DisposeMenu(MenuHandle theMenu);
extern void pascal AppendMen(MenuHandle menu, ConstStr255Param data);
extern void pascal AppendResMenu(MenuHandle theMenu, ResType theType);
extern void pascal InsertResMenu(MenuHandle theMenu, ResType theType, short afterItem);
extern void pascal InsertMen(MenuHandle theMenu, short beforeID);
extern void pascal DrawMenuBa(void);
extern void pascal InvalMenuBar(void);
extern void pascal DeleteMen(short menuID);
extern void pascal ClearMenuBar(void);
extern Handle pascal GetNewMBar(short menuBarID);
extern Handle pascal GetMenuBar(void);
extern void pascal SetMenuBar(Handle menuList);
#ifndef	BUILD_ASIDLL
#ifndef InsertMenuItem
#define InsertMenuItem InsertMenuIte
#endif
#endif
extern void pascal InsertMenuIte(MenuHandle theMenu, ConstStr255Param itemString, short afterItem);
extern void pascal DeleteMenuItem(MenuHandle theMenu, short item);
extern long pascal MenuKey(short ch);
extern void pascal HiliteMenu(short menuID);
extern void pascal SetMenuItemText(MenuHandle theMenu, short item, ConstStr255Param itemString);
extern void pascal GetMenuItemText(MenuHandle theMenu, short item, Str255 itemString);
extern void pascal DisableItem(MenuHandle theMenu, short item);
extern void pascal EnableItem(MenuHandle theMenu, short item);
extern void pascal CheckItem(MenuHandle theMenu, short item, Boolean checked);
extern void pascal SetItemMark(MenuHandle theMenu, short item, short markChar);
extern void pascal GetItemMark(MenuHandle theMenu, short item, short *markChar);
extern void pascal SetItemIcon(MenuHandle theMenu, short item, short iconIndex);
extern void pascal GetItemIcon(MenuHandle theMenu, short item, short *iconIndex);
extern void pascal SetItemStyle(MenuHandle theMenu, short item, short chStyle);
extern void pascal GetItemStyle(MenuHandle theMenu, short item, Style *chStyle);
extern void pascal CalcMenuSize(MenuHandle theMenu);
extern short pascal CountMItems(MenuHandle theMenu);
#undef CountMenuItems
#define CountMenuItems(menu) CountMItems(menu)
extern MenuHandle pascal GetMenuHandle(short menuID);
extern void pascal FlashMenuBar(short menuID);
extern void pascal SetMenuFlash(short count);
extern long pascal MenuSelect(Point startPt);
extern void pascal InitProcMenu(short resID);
extern void pascal GetItemCmd(MenuHandle theMenu, short item, short *cmdChar);
extern void pascal SetItemCmd(MenuHandle theMenu, short item, short cmdChar);
extern long pascal PopUpMenuSelect(MenuHandle menu, short top, short left, short popUpItem);
extern long pascal MenuChoice(void);
extern void pascal DeleteMCEntries(short menuID, short menuItem);
extern MCTableHandle pascal GetMCInfo(void);
extern void pascal SetMCInfo(MCTableHandle menuCTbl);
extern void pascal DisposeMCInfo(MCTableHandle menuCTbl);
extern MCEntryPtr pascal GetMCEntry(short menuID, short menuItem);
extern void pascal SetMCEntries(short numEntries, MCTablePtr menuCEntries);
extern void pascal InsertFontResMenu(MenuHandle theMenu, short afterItem, short scriptFilter);
extern void pascal InsertIntlResMenu(MenuHandle theMenu, ResType theType, short afterItem, short scriptFilter);
extern MenuHandle newmenu(short menuID, char *menuTitle);
extern void appendmenu(MenuHandle menu, char *data);
extern void insertmenuitem(MenuHandle theMenu, char *itemString, short afterItem);
extern long menuselect(Point *startPt);
extern void setmenuitemtext(MenuHandle menu, short item, char *itemString);
extern void getmenuitemtext(MenuHandle menu, short item, char *itemString);
#if OLDROUTINENAMES
#define AddResMenu(theMenu, theType) AppendResMenu(theMenu, theType)

#if 1
extern void pascal InsMenuItem(MenuHandle theMenu,ConstStr255Param itemString,
 short afterItem); 
#else
#define InsMenuItem(theMenu, itemString, afterItem)  \
	InsertMenuIte(theMenu, itemString, afterItem)
#endif

#define DelMenuItem(theMenu, item) DeleteMenuItem(theMenu, item)

#define SetItem(theMenu, item, itemString) SetMenuItemText(theMenu, item, itemString)

#define GetItem(theMenu, item, itemString) GetMenuItemText(theMenu, item, itemString)

#define GetMHandle(menuID) GetMenuHandle(menuID)

#define DelMCEntries(menuID, menuItem) DeleteMCEntries(menuID, menuItem)

#define DispMCInfo(menuCTbl) DisposeMCInfo(menuCTbl)

#define addresmenu(menu, data) appendresmenu(menu, data)

#define getitem(menu, item, itemString) getmenuitemtext(menu, item, itemString)

#define setitem(menu, item, itemString) setmenuitemtext(menu, item, itemString)

#define insmenuitem(theMenu, itemString, afterItem)  \
	insertmenuitem(theMenu, itemString, afterItem)

#endif

#if PRAGMA_STRUCT_ALIGN
	#pragma options align=reset
#elif PRAGMA_STRUCT_PACKPUSH
	#pragma pack(pop)
#elif PRAGMA_STRUCT_PACK
	#pragma pack()
#endif

#ifdef PRAGMA_IMPORT_OFF
#pragma import off
#elif PRAGMA_IMPORT
#pragma import reset
#endif
#ifdef __cplusplus
}
#endif

#endif


