/*
	File:		MixedMode.h

	Copyright:	 1984-1993 by Apple Computer, Inc., all rights reserved.

	WARNING
	This file was auto generated by the interfacer tool. Modifications
	must be made to the master file.

*/

#ifndef __MIXEDMODE__
#define __MIXEDMODE__

#ifndef __TYPES__
#include <MacTypes.H>
#endif

#ifndef __TRAPS__
#include <Traps.h>
#endif

#if PRAGMA_IMPORT
#pragma import on
#endif

#if PRAGMA_STRUCT_ALIGN
	#pragma options align=mac68k
#elif PRAGMA_STRUCT_PACKPUSH
	#pragma pack(push, 2)
#elif PRAGMA_STRUCT_PACK
	#pragma pack(2)
#endif

/*
##########################
#    #
#  MIXED MODE CONSTANTS  #
#    #
##########################
*/


//


//	The current Routine Descriptor Version


//

enum  {
	kRoutineDescriptorVersion	= 7
};


//


// The Calling Conventions


//

typedef unsigned short CallingConventionType;

enum  {
	kPascalStackBased			= (CallingConventionType)0,
	kCStackBased			= (CallingConventionType)1,
	kRegisterBased			= (CallingConventionType)2,
	kD0DispatchedPascalStackBased = (CallingConventionType)8,
	kD1DispatchedPascalStackBased = (CallingConventionType)12,
	kD0DispatchedCStackBased	= (CallingConventionType)9,
	kStackDispatchedPascalStackBased = (CallingConventionType)14,
	kThinkCStackBased			= (CallingConventionType)5
};


//


// ISA Types


//

typedef unsigned char ISAType;

enum  {
	kM68kISA			= (ISAType)0,
	kPowerPCISA			= (ISAType)1
};


//


// Constants for specifing 68k registers


//

enum  {
	kRegisterD0			= 0,
	kRegisterD1			= 1,
	kRegisterD2			= 2,
	kRegisterD3			= 3,
	kRegisterD4			= 8,
	kRegisterD5			= 9,
	kRegisterD6			= 10,
	kRegisterD7			= 11,
	kRegisterA0			= 4,
	kRegisterA1			= 5,
	kRegisterA2			= 6,
	kRegisterA3			= 7,
	kRegisterA4			= 12,
	kRegisterA5			= 13,
	kRegisterA6			= 14,
// A7 is the same as the PowerPC SP
	kCCRegisterCBit			= 16,
	kCCRegisterVBit			= 17,
	kCCRegisterZBit			= 18,
	kCCRegisterNBit			= 19,
	kCCRegisterXBit			= 20
};

typedef unsigned short registerSelectorType;


//


// SizeCodes we use everywhere


//

enum  {
	kNoByteCode			= 0,
	kOneByteCode			= 1,
	kTwoByteCode			= 2,
	kFourByteCode			= 3
};


/*
####
################################
#    #
#  ROUTINE RECORD DEFINITIONS  #
#    #
################################
*/

typedef unsigned long ProcInfoType;


// Routine Flag Bits

typedef unsigned short RoutineFlagsType;

enum  {
	kProcDescriptorIsAbsolute	= (RoutineFlagsType)0x00,
	kProcDescriptorIsRelative	= (RoutineFlagsType)0x01
};

enum  {
	kFragmentIsPrepared			= (RoutineFlagsType)0x00,
	kFragmentNeedsPreparing		= (RoutineFlagsType)0x02
};

enum  {
	kUseCurrentISA			= (RoutineFlagsType)0x00,
	kUseNativeISA			= (RoutineFlagsType)0x04
};

enum  {
	kPassSelector			= (RoutineFlagsType)0x0,
	kDontPassSelector			= (RoutineFlagsType)0x08
};

enum  {
	kRoutineIsNotDispatchedDefaultRoutine = (RoutineFlagsType)0x0,
	kRoutineIsDispatchedDefaultRoutine = (RoutineFlagsType)0x10
};

struct RoutineRecord {
	ProcInfoType			procInfo;			// calling conventions
	unsigned char			reserved1;			// Must be 0
	ISAType			ISA;			// Instruction Set Architecture
	RoutineFlagsType			routineFlags;			// Flags for each routine
	ProcPtr			procDescriptor;			// Where is the thing were calling?
	unsigned long			reserved2;			// Must be 0
	unsigned long			selector;			// For dispatched routines, the selector
};
typedef struct RoutineRecord RoutineRecord;

typedef RoutineRecord *RoutineRecordPtr, **RoutineRecordHandle;


/*
####
####################################
#    #
#  ROUTINE DESCRIPTOR DEFINITIONS  #
#    #
####################################
*/


//


// Definitions of the Routine Descriptor Flag Bits


//

typedef unsigned char RDFlagsType;

enum  {
	kSelectorsAreNotIndexable	= (RDFlagsType)0x00,
	kSelectorsAreIndexable		= (RDFlagsType)0x01
};


//


//  Routine Descriptor Structure


//

struct RoutineDescriptor {
	unsigned short			goMixedModeTrap;			// Our A-Trap
	char			version;			// Current Routine Descriptor version
	RDFlagsType			routineDescriptorFlags;			// Routine Descriptor Flags
	unsigned long			reserved1;			// Unused, must be zero
	unsigned char			reserved2;			// Unused, must be zero
	unsigned char			selectorInfo;			// If a dispatched routine, calling convention, else 0
	short			routineCount;			// Number of routines in this RD
	RoutineRecord			routineRecords[1];			// The individual routines
};
typedef struct RoutineDescriptor RoutineDescriptor;

#if	USESROUTINEDESCRIPTORS

/* Note: if USESROUTINEDESCRIPTORS is not true, UniversalProcPtr and
		UniversalProcHandle are defined in Types.h */

#if WINVER
typedef void (*UniversalProcPtr)( void );
typedef void (**UniversalProcHandle)( void );
#else
typedef RoutineDescriptor *UniversalProcPtr, **UniversalProcHandle;
#endif

#endif

typedef RoutineDescriptor *RoutineDescriptorPtr, **RoutineDescriptorHandle;


//


// Macros for building static Routine Descriptors


//


// A macro which creates a static instance of a non dispatched routine descriptor

#define BUILD_ROUTINE_DESCRIPTOR(procInfo, procedure)  \
	{			\
	_MixedModeMagic,			\
	kRoutineDescriptorVersion,		\
	kSelectorsAreNotIndexable,		\
	0,			\
	0,			\
	0,			\
	0,			\
	{			\
	{			\
	(procInfo),			\
	0,			\
	kPowerPCISA,			\
	kProcDescriptorIsAbsolute |	\
	kFragmentIsPrepared |			\
	kUseNativeISA,			\
	(ProcPtr)(procedure),			\
	0,			\
	0,			\
	},			\
	},			\
	}


// a macro which creates a static instance of a fat routine descriptor

#define BUILD_FAT_ROUTINE_DESCRIPTOR(m68kProcInfo, m68kProcPtr, powerPCProcInfo, powerPCProcPtr)  \
	{			\
	_MixedModeMagic,			\
	kRoutineDescriptorVersion,		\
	kSelectorsAreNotIndexable,		\
	0,			\
	0,			\
	0,			\
	1,			\
	{			\
	{			\
	(m68kProcInfo),			\
	0,			\
	kM68kISA,			\
	kProcDescriptorIsAbsolute |	\
	kUseCurrentISA,			\
	(ProcPtr)(m68kProcPtr),		\
	0,			\
	0,			\
	},			\
	{			\
	(powerPCProcInfo),			\
	0,			\
	kPowerPCISA,			\
	kProcDescriptorIsAbsolute |	\
	kFragmentIsPrepared |			\
	kUseCurrentISA,			\
	(ProcPtr)(powerPCProcPtr),		\
	0,			\
	0,			\
	},			\
	},			\
	}


/*
####
#################################
#		#
#	DEFINITIONS FOR PROCINFOS	#
#		#
#################################
*/


//


// Calling Convention Offsets


//

#define kCallingConventionWidth 4

#define kCallingConventionPhase 0


//


// Result Offsets.  All Routines put their results in the same place.


//

#define kResultSizeWidth 2

#define kResultSizePhase kCallingConventionWidth

#define kResultSizeMask 0x30


//


// Parameter offsets & widths


//

#define kStackParameterWidth 2

#define kStackParameterPhase (kCallingConventionWidth + kResultSizeWidth)


//


// Register Result Location offsets & widths


//

#define kRegisterResultLocationWidth 5

#define kRegisterResultLocationPhase (kCallingConventionWidth + kResultSizeWidth)


//


// Register Parameter offsets & widths


//

#define kRegisterParameterWidth 5

#define kRegisterParameterPhase (kCallingConventionWidth + kResultSizeWidth + kRegisterResultLocationWidth)

#define kRegisterParameterSizePhase 0

#define kRegisterParameterWhichPhase 2


//


// Dispatched Stack Routine Selector offsets & widths


//

#define kDispatchedSelectorSizeWidth 2

#define kDispatchedSelectorSizePhase (kCallingConventionWidth + kResultSizeWidth)


//


// Dispatched Stack Routine Parameter offsets


//

#define kDispatchedParameterPhase (kCallingConventionWidth + kResultSizeWidth + kDispatchedSelectorSizeWidth)


/*
####
#
#################################
#  #
# MACROS FOR BUILDING PROCINFOS #
#  #
#################################
*/


//


//	SIZE_CODE -	Return the size code for an object, given its size in bytes.


//		size - size of an object in bytes


//

#if forInterfacerTool
#else

// A macro for return the size of any parameter or return result

#define SIZE_CODE(size)		\
	(((size) == 4) ? kFourByteCode : (((size) == 2) ? kTwoByteCode : (((size) == 1) ? kOneByteCode : 0)))

#endif


//


//	RESULT_SIZE -	Return the result field of a ProcInfo, given the return objects size.


//			This is the same for all ProcInfos


//		sizeCode - size code


//

#if forInterfacerTool
#else
#define RESULT_SIZE(sizeCode)	\
	((ProcInfoType)(sizeCode) << kResultSizePhase)

#endif


//


//	STACK_ROUTINE_PARAMETER -	Return a parameter field of a ProcInfo, for a simple,


//			non-dispatched, stack based routine.


//		whichParam - which parameter


//		sizeCode - size code


//

#if forInterfacerTool
#else
#define STACK_ROUTINE_PARAMETER(whichParam, sizeCode)  \
	((ProcInfoType)(sizeCode) << (kStackParameterPhase + (((whichParam) - 1) * kStackParameterWidth)))

#endif


//


//	DISPATCHED_STACK_ROUTINE_PARAMETER -	Return a parameter field of a ProcInfo, for


//			a dispatched, stack based routine.  The same


//			macro is used regardless of the type of


//			dispatching.


//		whichParam - which parameter


//		sizeCode - size code


//

#if forInterfacerTool
#else
#define DISPATCHED_STACK_ROUTINE_PARAMETER(whichParam, sizeCode)  \
	((ProcInfoType)(sizeCode) << (kDispatchedParameterPhase + (((whichParam) - 1) * kStackParameterWidth)))

#endif


//


//	DISPATCHED_STACK_ROUTINE_SELECTOR_SIZE -	Return a the selector size field of a ProcInfo


//			for a dispatched, stack based routine.  The


//			same macro is used regardless of the type of


//			dispatching.


//		sizeCode - size code


//

#if forInterfacerTool
#else
#define DISPATCHED_STACK_ROUTINE_SELECTOR_SIZE(sizeCode)  \
	((ProcInfoType)(sizeCode) << kDispatchedSelectorSizePhase)

#endif


//


//	REGISTER_RESULT_LOCATION -			Return the Result Location field of a ProcInfo,


//			given the location.


//		$1 - which register


//

#if forInterfacerTool
#else
#define REGISTER_RESULT_LOCATION(whichReg)  \
	((ProcInfoType)(whichReg) << kRegisterResultLocationPhase)

#endif


//


//	REGISTER_ROUTINE_PARAMETER -	Return a parameter field of a ProcInfo for a


//			register based routine.


//		$1 - which parameter


//		$2 - which register


//		$3 - size code


//

#if forInterfacerTool
#else
#define REGISTER_ROUTINE_PARAMETER(whichParam, whichReg, sizeCode)  \
	((((ProcInfoType)(sizeCode) << kRegisterParameterSizePhase) | ((ProcInfoType)(whichReg) << kRegisterParameterWhichPhase)) <<  \
	(kRegisterParameterPhase + (((whichParam) - 1) * kRegisterParameterWidth)))

#endif


/*
#### */


///


///


///		SPECIAL CASE CONSTANTS


///		


///


/*
	Explanation of special cases:
	
	High Hook & Caret Hook -  (see I-379)
		C calling conventions, Rect on stack, pointer in A3, no return value
	EOL Hook - (see VI-15-26)
		Register-based; inputs in D0, A3, A4;
		output is Z flag of status register
	Width Hook - (see VI-15-27)
		Register-based; inputs in D0, D1, A0, A3, A4; output in D1
	NWidth Hook - (see VI-15-27)
		Register-based; inputs in D0, D1, D2, A0, A2, A3, A4; output in D1
	TextWidthHook - (see VI-15-28)
		Register-based; inputs in D0, D1, A0, A3, A4; output in D1
	DrawHook - (see VI-15-28)
		Register-based; inputs in D0, D1, A0, A3, A4; no output
	HitTestHook - (See VI-15-29)
		Register-based; inputs in D0, D1, D2, A0, A3, A4; outputs in D0, D1, D2
	FindWord -  (see VI-15-30)
		Register-based; inputs in D0, D2, A3, A4; outputs in D0, D1
	ADBRoutines - (see V-371)
		Register-based; inputs in A0, A1, A2, D0; no outputs
	ProtocolHandler - (see II-326)
		Register-based; inputs in A0, A1, A2, A3, A4, D1.w; output in Z
	SocketListener - (see II-329)
		Register-based; inputs in A0, A1, A2, A3, A4, D0.b, D1.w; output in Z
	Reclac - (see I-391)
		Register-based; inputs in A3, D7; outputs in D2, D3, D4
	DoText - (see I-391)
		Register-based; inputs in A3, D3, D4, D7; outputs in A0, D0
	GNEFilterProc - (see tech note 85)
		Register & Stack Based; inputs in A1, D0 & on the stack; outputs on the stack
	MenuBarHook - (see I-356)
		Register & Stack Based; input on the stack; output in D0


*/

#if forInterfacerTool
#else
#define SPECIAL_CASE_PROCINFO(specialCaseCode)  \
	(kSpecialCase | ((ProcInfoType)(specialCaseCode) << 4))

#endif

enum  {
	kSpecialCase			= (CallingConventionType)0x0000000F
};

enum  {
// all of the special cases enumerated
	kSpecialCaseHighHook		= 0,
	kSpecialCaseCaretHook		= kSpecialCaseHighHook,
	kSpecialCaseEOLHook			= 1,
	kSpecialCaseWidthHook		= 2,
	kSpecialCaseNWidthHook		= 3,
	kSpecialCaseTextWidthHook	= kSpecialCaseWidthHook,
	kSpecialCaseDrawHook		= 4,
	kSpecialCaseHitTestHook		= 5,
	kSpecialCaseTEFindWord		= 6,
	kSpecialCaseProtocolHandler	= 7,
	kSpecialCaseSocketListener	= 8,
	kSpecialCaseTERecalc		= 9,
	kSpecialCaseTEDoText		= 10,
	kSpecialCaseGNEFilterProc	= 11,
	kSpecialCaseMBarHook		= 12
};


/*
#### */


///


///


///		MIXED MODE TOOLBOX DEFINITIONS


///		


///

enum  {
// the Mixed Mode error codes
	mmInternalError			= -2526
};

typedef short MMErrType;

#if defined(powerc) || defined(__powerc)
#define GetCurrentISA() ((ISAType) kPowerPCISA)

#else
#define GetCurrentISA() ((ISAType) kM68kISA)

#endif

#ifdef __cplusplus
extern "C" {
#endif

#ifndef BUILDING_INTERFACER
#if USESROUTINEDESCRIPTORS
extern UniversalProcPtr pascal NewRoutineDescriptor(ProcPtr theProc, ProcInfoType theProcInfo, ISAType theISA);
#else
#define NewRoutineDescriptor(theProc, theProcInfo, theISA) (theProc)

#endif

#if USESROUTINEDESCRIPTORS
extern void pascal DisposeRoutineDescriptor(UniversalProcPtr theProcPtr);
#else
#define DisposeRoutineDescriptor(theProcPtr)

#endif


/* Note that the call to NewFatRoutineDescriptor is undefined
   when USESROUTINEDESCRIPTORS is false. */

#if USESROUTINEDESCRIPTORS
extern UniversalProcPtr pascal NewFatRoutineDescriptor(ProcPtr theM68kProc, ProcPtr thePowerPCProc, ProcInfoType theProcInfo);
#endif

extern long CallUniversalProc(UniversalProcPtr theProcPtr, ProcInfoType procInfo, ...);
extern long CallOSTrapUniversalProc(UniversalProcPtr theProcPtr, ProcInfoType procInfo, ...);
#endif

#if PRAGMA_STRUCT_ALIGN
	#pragma options align=reset
#elif PRAGMA_STRUCT_PACKPUSH
	#pragma pack(pop)
#elif PRAGMA_STRUCT_PACK
	#pragma pack()
#endif

#ifdef PRAGMA_IMPORT_OFF
#pragma import off
#elif PRAGMA_IMPORT
#pragma import reset
#endif
#ifdef __cplusplus
}
#endif

#endif


