/*
	File:		Resources.h

	Copyright:	 1984-1993 by Apple Computer, Inc., all rights reserved.

	WARNING
	This file was auto generated by the interfacer tool. Modifications
	must be made to the master file.

*/

#ifndef __RESOURCES__
#define __RESOURCES__

#ifndef __TYPES__
#include <MacTypes.H>
#endif

#ifndef __FILES__
#include <Files.H>
#endif

enum  {
	resSysHeap			= 64,			/*System or application heap?*/
	resPurgeable			= 32,			/*Purgeable resource?*/
	resLocked			= 16,			/*Load it in locked?*/
	resProtected			= 8,			/*Protected?*/
	resPreload			= 4,			/*Load in on OpenResFile?*/
	resChanged			= 2,			/*Resource changed?*/
	mapReadOnly			= 128,			/*Resource file read-only*/
	mapCompact			= 64,			/*Compact resource file*/
	mapChanged			= 32,			/*Write map out at updat*/
	kResFileNotOpened			= -1,			/*ref num return as error when opening a resourc file*/
	kSystemResFile			= 0			/*this is the default ref num to the system file*/
};


/*
	ResErrProcs cannot be written in or called from a high-level
	language without the help of mixed mode or assembly glue because they
	use the following parameter-passing convention:

	typedef pascal void (*ResErrProcPtr)(OSErr error);

		In:
			=>	parameter			D0.W
		Out:
			none
*/

enum  {
	uppResErrProcInfo			= kRegisterBased|REGISTER_ROUTINE_PARAMETER(1,kRegisterD0,SIZE_CODE(sizeof(OSErr)))
};

#if USESROUTINEDESCRIPTORS
typedef void (pascal *ResErrProcPtr)(OSErr error);

typedef UniversalProcPtr ResErrUPP;

#define CallResErrProc(userRoutine, parameter)  \
	CallUniversalProc((UniversalProcPtr)(userRoutine), uppResErrProcInfo, (parameter))

#define NewResErrProc(userRoutine)  \
	(ResErrUPP) NewRoutineDescriptor((ProcPtr)(userRoutine), uppResErrProcInfo, GetCurrentISA())

#else
typedef ProcPtr ResErrUPP;

#define NewResErrProc(userRoutine)  \
	(ResErrUPP)(userRoutine)

#endif

#ifdef __cplusplus
extern "C" {
#endif

#if PRAGMA_IMPORT
#pragma import on
#endif

#if PRAGMA_STRUCT_ALIGN
	#pragma options align=mac68k
#elif PRAGMA_STRUCT_PACKPUSH
	#pragma pack(push, 2)
#elif PRAGMA_STRUCT_PACK
	#pragma pack(2)
#endif

extern short pascal InitResources(void);
extern void pascal RsrcZoneInit(void);
extern void pascal CloseResFile(short refNum);
extern short pascal ResError(void);
extern short pascal CurResFile(void);
extern short pascal HomeResFile(Handle theResource);
extern void pascal CreateResFile(ConstStr255Param fileName);
extern short pascal OpenResFile(ConstStr255Param fileName);
extern void pascal UseResFile(short refNum);
extern short pascal CountTypes(void);
extern short pascal Count1Types(void);
extern void pascal GetIndType(ResType *theType, short index);
extern void pascal Get1IndType(ResType *theType, short index);
extern void pascal SetResLoad(Boolean load);
extern short pascal CountResources(ResType theType);
extern short pascal Count1Resources(ResType theType);
extern Handle pascal GetIndResource(ResType theType, short index);
extern Handle pascal Get1IndResource(ResType theType, short index);
extern Handle pascal GetResource(ResType theType, short theID);
extern Handle pascal Get1Resource(ResType theType, short theID);
extern Handle pascal GetNamedResource(ResType theType, ConstStr255Param name);
extern Handle pascal Get1NamedResource(ResType theType, ConstStr255Param name);
extern void pascal LoadResourc(Handle theResource);
extern void pascal ReleaseResource(Handle theResource);
extern void pascal DetachResource(Handle theResource);
extern short pascal UniqueID(ResType theType);
extern short pascal Unique1ID(ResType theType);
extern short pascal GetResAttrs(Handle theResource);
extern void pascal GetResInfo(Handle theResource, short *theID, ResType *theType, Str255 name);
extern void pascal SetResInfo(Handle theResource, short theID, ConstStr255Param name);
extern void pascal AddResource(Handle theData, ResType theType, short theID, ConstStr255Param name);
extern long pascal GetResourceSizeOnDisk(Handle theResource);
extern long pascal GetMaxResourceSize(Handle theResource);
extern long pascal RsrcMapEntry(Handle theResource);
extern void pascal SetResAttrs(Handle theResource, short attrs);
extern void pascal ChangedResource(Handle theResource);
extern void pascal RemoveResource(Handle theResource);
extern void pascal UpdateResFile(short refNum);
extern Handle getnamedresource(ResType theType, char *name);
extern void pascal WriteResource(Handle theResource);
extern void pascal SetResPurge(Boolean install);
extern Handle get1namedresource(ResType theType, char *name);
extern short pascal GetResFileAttrs(short refNum);
extern void pascal SetResFileAttrs(short refNum, short attrs);
extern short pascal OpenRFPerm(ConstStr255Param fileName, short vRefNum, char permission);
extern Handle pascal RGetResource(ResType theType, short theID);
#if SystemSevenOrLater
extern short pascal HOpenResFile(short vRefNum, long dirID, ConstStr255Param fileName, char permission);
#else
extern short pascal HOpenResFile(short vRefNum, long dirID, ConstStr255Param fileName, char permission);
#endif

#if SystemSevenOrLater
extern void pascal HCreateResFile(short vRefNum, long dirID, ConstStr255Param fileName);
#else
extern void pascal HCreateResFile(short vRefNum, long dirID, ConstStr255Param fileName);
#endif

extern short pascal FSpOpenResFile(const FSSpec *spec, SignedByte permission);
extern void pascal FSpCreateResFile(const FSSpec *spec, OSType creator, OSType fileType, ScriptCode scriptTag);

/*  partial resource calls  */

extern void pascal ReadPartialResource(Handle theResource, long offset, void *buffer, long count);
extern void pascal WritePartialResource(Handle theResource, long offset, const void *buffer, long count);
extern void pascal SetResourceSize(Handle theResource, long newSize);
extern Handle pascal GetNextFOND(Handle fondHandle);

/* Use TempInsertROMMap to force the ROM resource map to be
   inserted into the chain in front of the system. Note that
   this call is only temporary - the modified resource chain
   is only used for the next call to the resource manager.
   See IM IV 19 for more information. */

#if USESCODEFRAGMENTS
extern void TempInsertROMMap(Boolean tempResLoad);
#else
#define TempInsertROMMap(tempResLoad)  \
	((tempResLoad) ? *(unsigned short*)0x0B9E = 0xFFFF :  \
	*(unsigned short*)0x0B9E = 0xFF00)

#endif

extern short openrfperm(char *fileName, short vRefNum, char permission);
extern short openresfile(char *fileName);
extern void createresfile(char *fileName);
extern void getresinfo(Handle theResource, short *theID, ResType *theType, char *name);
extern void setresinfo(Handle theResource, short theID, char *name);
extern void addresource(Handle theResource, ResType theType, short theID, char *name);
#if OLDROUTINENAMES
#define SizeResource(theResource) GetResourceSizeOnDisk(theResource)

#define MaxSizeRsrc(theResource) GetMaxResourceSize(theResource)

#define RmveResource(theResource) RemoveResource(theResource)

#endif

#if PRAGMA_STRUCT_ALIGN
	#pragma options align=reset
#elif PRAGMA_STRUCT_PACKPUSH
	#pragma pack(pop)
#elif PRAGMA_STRUCT_PACK
	#pragma pack()
#endif

#ifdef PRAGMA_IMPORT_OFF
#pragma import off
#elif PRAGMA_IMPORT
#pragma import reset
#endif

#ifdef __cplusplus
}
#endif

#endif


