/*
	File:		SoundInput.h

	Copyright:	 1984-1993 by Apple Computer, Inc., all rights reserved.

	WARNING
	This file was auto generated by the interfacer tool. Modifications
	must be made to the master file.

*/

#ifndef __SOUNDINPUT__
#define __SOUNDINPUT__

#ifndef __TYPES__
#include <MacTypes.H>
#endif

#ifndef __DIALOGS__
#include <Dialogs.H>
#endif

#ifndef __FILES__
#include <Files.H>
#endif

#if PRAGMA_IMPORT
#pragma import on
#endif

#if PRAGMA_STRUCT_ALIGN
	#pragma options align=mac68k
#elif PRAGMA_STRUCT_PACKPUSH
	#pragma pack(push, 2)
#elif PRAGMA_STRUCT_PACK
	#pragma pack(2)
#endif

enum  {
	siDeviceIsConnected			= 1,			/* input device is connected and ready for input */
	siDeviceNotConnected		= 0,			/* input device is not connected */
	siDontKnowIfConnected		= -1,			/* can't tell if input device is connected */
	siReadPermission			= 0,			/* permission passed to SPBOpenDevice */
	siWritePermission			= 1			/* permission passed to SPBOpenDevice */
};


/* Info Selectors for Sound Input Drivers */

#define siDeviceConnected OST_dcon

#define siAGCOnOff OST_agcSpc

#define siPlayThruOnOff OST_plth

#define siTwosComplementOnOff OST_twos

#define siLevelMeterOnOff OST_lmet

#define siRecordingQuality OST_qual

#define siVoxRecordInfo OST_voxr

#define siVoxStopInfo OST_voxs

#define siNumberChannels OST_chan

#define siSampleSize OST_ssiz

#define siSampleRate OST_srat

#define siCompressionType OST_comp

#define siCompressionFactor OST_cmfa

#define siCompressionHeader OST_cmhd

#define siDeviceName OST_name

#define siDeviceIcon OST_icon

#define siDeviceBufferInfo OST_dbin

#define siSampleSizeAvailable OST_ssav

#define siSampleRateAvailable OST_srav

#define siCompressionAvailable OST_cmav

#define siChannelAvailable OST_chav

#define siAsync OST_asyn

#define siOptionsDialog OST_optd

#define siContinuous OST_cont

#define siActiveChannels OST_chac

#define siActiveLevels OST_lmac

#define siInputSource OST_sour

#define siInitializeDriver OST_init

#define siCloseDriver OST_clos

#define siPauseRecording OST_paus

#define siUserInterruptProc OST_user


/* Qualities */

#define siBestQuality OST_best

#define siBetterQuality OST_betr

#define siGoodQuality OST_good

typedef struct SPB SPB, *SPBPtr;


/* user procedures called by sound input routines */


/*
	SIInterruptProcs cannot be written in or called from a high-level
	language without the help of mixed mode or assembly glue because they
	use the following parameter-passing convention:

		typedef pascal void (*SIInterruptProcPtr)(SPBPtr inParamPtr, Ptr dataBuffer,
			short peakAmplitude, long sampleSize);

		In:
			=>	inParamPtr			A0.L
			=>	dataBuffer			A1.L
			=>	peakAmplitude			D0.W
			=>	sampleSize			D1.L
		Out:
			none
*/

enum  {
	uppSIInterruptProcInfo		= kRegisterBased|REGISTER_ROUTINE_PARAMETER(1,kRegisterA0,kFourByteCode)|REGISTER_ROUTINE_PARAMETER(2,kRegisterA1,kFourByteCode)|REGISTER_ROUTINE_PARAMETER(3,kRegisterD0,kTwoByteCode)|REGISTER_ROUTINE_PARAMETER(4,kRegisterD1,kFourByteCode)
};

#if USESROUTINEDESCRIPTORS
typedef void (pascal *SIInterruptProcPtr)(SPBPtr inParamPtr, Ptr dataBuffer, short peakAmplitude, long sampleSize);

typedef UniversalProcPtr SIInterruptUPP;

#define CallSIInterruptProc(userRoutine, inParamPtr, dataBuffer, peakAmplitude, sampleSize)  \
	CallUniversalProc((UniversalProcPtr)(userRoutine), uppSIInterruptProcInfo, (inParamPtr),  \
	(dataBuffer), (peakAmplitude), (sampleSize))

#define NewSIInterruptProc(userRoutine)  \
	(SIInterruptUPP) NewRoutineDescriptor((ProcPtr)(userRoutine), uppSIInterruptProcInfo, GetCurrentISA())

#else
typedef ProcPtr SIInterruptUPP;

#define NewSIInterruptProc(userRoutine)  \
	(SIInterruptUPP)(userRoutine)

#endif

typedef void (pascal *SICompletionProcPtr)(SPBPtr inParamPtr);

enum {
	uppSICompletionProcInfo = kPascalStackBased
		| STACK_ROUTINE_PARAMETER(1, SIZE_CODE(sizeof(SPBPtr)))
};

#if USESROUTINEDESCRIPTORS
typedef UniversalProcPtr SICompletionUPP;

#define CallSICompletionProc(userRoutine, inParamPtr)		\
		CallUniversalProc((UniversalProcPtr)(userRoutine), uppSICompletionProcInfo, (inParamPtr))
#define NewSICompletionProc(userRoutine)		\
		(SICompletionUPP) NewRoutineDescriptor((ProcPtr)(userRoutine), uppSICompletionProcInfo, GetCurrentISA())
#else
typedef SICompletionProcPtr SICompletionUPP;

#define CallSICompletionProc(userRoutine, inParamPtr)		\
		(*(userRoutine))((inParamPtr))
#define NewSICompletionProc(userRoutine)		\
		(SICompletionUPP)(userRoutine)
#endif


/* Sound Input Parameter Block */

struct SPB {
	long			inRefNum;			/* reference number of sound input device */
	unsigned long			count;			/* number of bytes to record */
	unsigned long			milliseconds;			/* number of milliseconds to record */
	unsigned long			bufferLength;			/* length of buffer in bytes */
	Ptr			bufferPtr;			/* buffer to store sound data in */
	SICompletionUPP			completionRoutine;			/* completion routine */
	SIInterruptUPP			interruptRoutine;			/* interrupt routine */
	long			userLong;			/* user-defined field */
	OSErr			error;			/* error */
	long			unused1;			/* reserved - must be zero */
};
#ifdef __cplusplus
extern "C" {
#endif

extern NumVersion pascal SPBVersion(void);
extern OSErr pascal SndRecord(ModalFilterUPP filterProc, Point corner, OSType quality, Handle *sndHandle);
extern OSErr pascal SndRecordToFile(ModalFilterUPP filterProc, Point corner, OSType quality, short fRefNum);
extern OSErr pascal SPBSignInDevice(short deviceRefNum, ConstStr255Param deviceName);
extern OSErr pascal SPBSignOutDevice(short deviceRefNum);
extern OSErr pascal SPBGetIndexedDevice(short count, Str255 deviceName, Handle *deviceIconHandle);
extern OSErr pascal SPBOpenDevice(ConstStr255Param deviceName, short permission, long *inRefNum);
extern OSErr pascal SPBCloseDevice(long inRefNum);
extern OSErr pascal SPBRecord(SPBPtr inParamPtr, Boolean asynchFlag);
extern OSErr pascal SPBRecordToFile(short fRefNum, SPBPtr inParamPtr, Boolean asynchFlag);
extern OSErr pascal SPBPauseRecording(long inRefNum);
extern OSErr pascal SPBResumeRecording(long inRefNum);
extern OSErr pascal SPBStopRecording(long inRefNum);
extern OSErr pascal SPBGetRecordingStatus(long inRefNum, short *recordingStatus, short *meterLevel, unsigned long *totalSamplesToRecord, unsigned long *numberOfSamplesRecorded, unsigned long *totalMsecsToRecord, unsigned long *numberOfMsecsRecorded);
extern OSErr pascal SPBGetDeviceInfo(long inRefNum, OSType infoType, char *infoData);
extern OSErr pascal SPBSetDeviceInfo(long inRefNum, OSType infoType, char *infoData);
extern OSErr pascal SPBMillisecondsToBytes(long inRefNum, long *milliseconds);
extern OSErr pascal SPBBytesToMilliseconds(long inRefNum, long *byteCount);
extern OSErr pascal SetupSndHeader(Handle sndHandle, short numChannels, Fixed sampleRate, short sampleSize, OSType compressionType, short baseNote, unsigned long numBytes, short *headerLen);
extern OSErr pascal SetupAIFFHeader(short fRefNum, short numChannels, Fixed sampleRate, short sampleSize, OSType compressionType, unsigned long numBytes, unsigned long numFrames);
#if PRAGMA_STRUCT_ALIGN
	#pragma options align=reset
#elif PRAGMA_STRUCT_PACKPUSH
	#pragma pack(pop)
#elif PRAGMA_STRUCT_PACK
	#pragma pack()
#endif

#ifdef PRAGMA_IMPORT_OFF
#pragma import off
#elif PRAGMA_IMPORT
#pragma import reset
#endif

#ifdef __cplusplus
}
#endif

#endif


