/*
	File:		Windows.h

	Copyright:	 1984-1993 by Apple Computer, Inc., all rights reserved.

	WARNING
	This file was auto generated by the interfacer tool. Modifications
	must be made to the master file.

*/

#ifndef __WINDOWS__
#define __WINDOWS__

#ifndef __QUICKDRAW__
#if LONG_FILENAMES
#include <Quickdraw.H>
#else
#include <Quickdra.H>
#endif
#endif

#ifndef __EVENTS__
#include <Events.H>
#endif

#ifndef __CONTROLS__
#include <Controls.H>
#endif

#if PRAGMA_IMPORT
#pragma import on
#endif

#if PRAGMA_STRUCT_ALIGN
	#pragma options align=mac68k
#elif PRAGMA_STRUCT_PACKPUSH
	#pragma pack(push, 2)
#elif PRAGMA_STRUCT_PACK
	#pragma pack(2)
#endif

enum  {
	documentProc			= 0,
	dBoxProc			= 1,
	plainDBox			= 2,
	altDBoxProc			= 3,
	noGrowDocProc			= 4,
	movableDBoxProc			= 5,
	zoomDocProc			= 8,
	zoomNoGrow			= 12,
	rDocProc			= 16,
	dialogKind			= 2,
	userKind			= 8,
/*FindWindow Result Codes*/
	inDesk			= 0,
	inMenuBar			= 1,
	inSysWindow			= 2,
	inContent			= 3,
	inDrag			= 4,
	inGrow			= 5,
	inGoAway			= 6,
	inZoomIn			= 7,
	inZoomOut			= 8
};

enum  {
/*window messages*/
	wDraw			= 0,
	wHit			= 1,
	wCalcRgns			= 2,
	wNew			= 3,
	wDispose			= 4,
	wGrow			= 5,
	wDrawGIcon			= 6,
/*defProc hit test codes*/
	wNoHit			= 0,
	wInContent			= 1,
	wInDrag			= 2,
	wInGrow			= 3,
	wInGoAway			= 4,
	wInZoomIn			= 5,
	wInZoomOut			= 6,
	deskPatID			= 16,
/*Window Part Identifiers which correlate color table entries with window elements*/
	wContentColor			= 0,
	wFrameColor			= 1,
	wTextColor			= 2,
	wHiliteColor			= 3,
	wTitleBarColor			= 4
};

typedef void (pascal *DragGrayRgnProcPtr)(void);

enum {
	uppDragGrayRgnProcInfo = kPascalStackBased
};

#if USESROUTINEDESCRIPTORS
typedef UniversalProcPtr DragGrayRgnUPP;

#define CallDragGrayRgnProc(userRoutine)		\
		CallUniversalProc((UniversalProcPtr)(userRoutine), uppDragGrayRgnProcInfo)
#define NewDragGrayRgnProc(userRoutine)		\
		(DragGrayRgnUPP) NewRoutineDescriptor((ProcPtr)(userRoutine), uppDragGrayRgnProcInfo, GetCurrentISA())
#else
typedef DragGrayRgnProcPtr DragGrayRgnUPP;

#define CallDragGrayRgnProc(userRoutine)		\
		(*(userRoutine))()
#define NewDragGrayRgnProc(userRoutine)		\
		(DragGrayRgnUPP)(userRoutine)
#endif

#pragma PRAGMA_PACK_1
struct WindowRecord {
	GrafPort		port;
	short			windowKind;
	Boolean			visible;
	Boolean			hilited;
	Boolean			goAwayFlag;
	Boolean			spareFlag;
	RgnHandle		strucRgn;
	RgnHandle		contRgn;
	RgnHandle		updateRgn;
	Handle			windowDefProc;
	Handle			dataHandle;
	StringHandle		titleHandle;
	short			titleWidth;
	ControlHandle		controlList;
	struct WindowRecord	*nextWindow;
	PicHandle		windowPic;
	long			refCon;
};
typedef struct WindowRecord WindowRecord;

typedef WindowRecord *WindowPeek;

struct CWindowRecord {
	CGrafPort			port;
	short			windowKind;
	Boolean			visible;
	Boolean			hilited;
	Boolean			goAwayFlag;
	Boolean			spareFlag;
	RgnHandle			strucRgn;
	RgnHandle			contRgn;
	RgnHandle			updateRgn;
	Handle			windowDefProc;
	Handle			dataHandle;
	StringHandle			titleHandle;
	short			titleWidth;
	ControlHandle			controlList;
	struct CWindowRecord		*nextWindow;
	PicHandle			windowPic;
	long			refCon;
};
typedef struct CWindowRecord CWindowRecord;

typedef CWindowRecord *CWindowPeek;

typedef long (pascal *WindowDefProcPtr)(short varCode, WindowPtr theWindow, short message, long param);

enum {
	uppWindowDefProcInfo = kPascalStackBased
		| RESULT_SIZE(SIZE_CODE(sizeof(long)))
		| STACK_ROUTINE_PARAMETER(1, SIZE_CODE(sizeof(short)))
		| STACK_ROUTINE_PARAMETER(2, SIZE_CODE(sizeof(WindowPtr)))
		| STACK_ROUTINE_PARAMETER(3, SIZE_CODE(sizeof(short)))
		| STACK_ROUTINE_PARAMETER(4, SIZE_CODE(sizeof(long)))
};

#if USESROUTINEDESCRIPTORS
typedef UniversalProcPtr WindowDefUPP;

#define CallWindowDefProc(userRoutine, varCode, theWindow, message, param)		\
		CallUniversalProc((UniversalProcPtr)(userRoutine), uppWindowDefProcInfo, (varCode), (theWindow), (message), (param))
#define NewWindowDefProc(userRoutine)		\
		(WindowDefUPP) NewRoutineDescriptor((ProcPtr)(userRoutine), uppWindowDefProcInfo, GetCurrentISA())
#else
typedef WindowDefProcPtr WindowDefUPP;

#define CallWindowDefProc(userRoutine, varCode, theWindow, message, param)		\
		(*(userRoutine))((varCode), (theWindow), (message), (param))
#define NewWindowDefProc(userRoutine)		\
		(WindowDefUPP)(userRoutine)
#endif

struct WStateData {
	Rect			userState;			/*user state*/
	Rect			stdState;			/*standard state*/
};
typedef struct WStateData WStateData;

typedef WStateData *WStateDataPtr, **WStateDataHandle;

struct AuxWinRec {
	struct AuxWinRec			**awNext;			/*handle to next AuxWinRec*/
	WindowPtr			awOwner;			/*ptr to window */
	CTabHandle			awCTable;			/*color table for this window*/
	Handle			dialogCItem;			/*handle to dialog manager structures*/
	long			awFlags;			/*reserved for expansion*/
	CTabHandle			awReserved;			/*reserved for expansion*/
	long			awRefCon;			/*user Constant*/
};
typedef struct AuxWinRec AuxWinRec;

typedef AuxWinRec *AuxWinPtr, **AuxWinHandle;

struct WinCTab {
	long			wCSeed;			/*reserved*/
	short			wCReserved;			/*reserved*/
	short			ctSize;			/*usually 4 for windows*/
	ColorSpec			ctTable[5];
};
typedef struct WinCTab WinCTab;

typedef WinCTab *WCTabPtr, **WCTabHandle;

#pragma PRAGMA_PACK_RESET

/*
	DeskHookProcs cannot be written in or called from a high-level
	language without the help of mixed mode or assembly glue because they
	use the following parameter-passing convention:

	typedef pascal void (*DeskHookProcPtr)(Boolean mouseClick, EventRecord *theEvent);

		In:
			=>	mouseClick			D0.B
			=>	theEvent			A0.L
		Out:
			none
*/

#define	uppDeskHookProcInfo	(kRegisterBased|REGISTER_ROUTINE_PARAMETER(1,kRegisterD0,kOneByteCode)|REGISTER_ROUTINE_PARAMETER(2,kRegisterA0,kFourByteCode))

#if USESROUTINEDESCRIPTORS
typedef void (pascal *DeskHookProcPtr)(Boolean mouseClick, EventRecord *theEvent);

typedef UniversalProcPtr DeskHookUPP;

#define CallDeskHookProc(userRoutine, mouseClick, theEvent)  \
	CallUniversalProc((UniversalProcPtr)(userRoutine), uppDeskHookProcInfo, (mouseClick), (theEvent))

#define NewDeskHookProc(userRoutine)  \
	(DeskHookUPP) NewRoutineDescriptor((ProcPtr)(userRoutine), uppDeskHookProcInfo, GetCurrentISA())

#else
typedef ProcPtr DeskHookUPP;

#define NewDeskHookProc(userRoutine)  \
	(DeskHookUPP)(userRoutine)

#endif

#if !GRAPHSOFT && defined(__cplusplus)
extern "C" {
#endif

#ifndef H_NO_RENAME

	/*####################################################################################

 	Window Accessors

	Use these with or without STRICT_WINDOWS and your source will more easily migrate
	to being Copland-savvy.  When STRICT_WINDOWS is set to true, the WindowRecord and
	WindowPeek are no longer defined.  This will allow you to, from a source code level, 
	remove all direct accesses to Window Manager data structures.  

	These accessors will be available as true API entrypoints in Copland, but are not
	guaranteed to match exactly.  Specifically, GetNextWindow will not be supported and
	a whole new model for iterating the window list will be presented.  Using GetNextWindow
	for now is ok, however, as it will let you leverage the STRICT flags.

	If you don't see an accessor for a field you need, there's probably a very good
	reason.  Needing access to fields for which there is no accessor is a good indicator
	of behavior that is not Copland-savvy.  Such behavior does not necessarily make your 
	code incompatible, but it likely something we are trying to discourage as we evolve
	the toolbox into a more robust and useful service.

	Please direct all questions regarding usage to the TOOLBOX AppleLink address.

	 <<<< See Controls.h for access to the window's control list >>>>

#####################################################################################*/
#if defined(__cplusplus) && !defined(_INC_WINDOWS)
inline CGrafPtr	GetWindowPort(WindowRef w) 					{ return (CGrafPtr) w; 													}
inline void		SetPortWindowPort(WindowRef aWindowRef)		{	SetPort( (GrafPtr) GetWindowPort(aWindowRef)); }
inline SInt16		GetWindowKind(WindowRef w) 					{ return ( *(SInt16 *)	(((UInt8 *) w) + sizeof(GrafPort))); 			}
inline void		SetWindowKind(WindowRef	w, SInt16 wKind)	{  *(SInt16 *)	(((UInt8 *) w) + sizeof(GrafPort)) = wKind;  			}
inline	Boolean		IsWindowVisible(WindowRef w)				{ return *(Boolean *)	(((UInt8 *) w) + sizeof(GrafPort) + 0x2); 		}
inline Boolean		IsWindowHilited(WindowRef w)				{ return *(Boolean *)	(((UInt8 *) w) + sizeof(GrafPort) + 0x3);		}
inline Boolean		GetWindowGoAwayFlag(WindowRef w)			{ return *(Boolean *)	(((UInt8 *) w) + sizeof(GrafPort) + 0x4);		}
inline Boolean		GetWindowZoomFlag(WindowRef w)				{ return *(Boolean *)	(((UInt8 *) w) + sizeof(GrafPort) + 0x5);		}
inline void		GetWindowStructureRgn(WindowRef w, RgnHandle r)	{	CopyRgn( *(RgnHandle *)(((UInt8 *) w) + sizeof(GrafPort) + 0x6), r );	}
inline void		GetWindowContentRgn(WindowRef w, RgnHandle r)	{	CopyRgn( *(RgnHandle *)(((UInt8 *) w) + sizeof(GrafPort) + 0xA), r );	}
inline void		GetWindowUpdateRgn(WindowRef w, RgnHandle r)	{	CopyRgn( *(RgnHandle *)(((UInt8 *) w) + sizeof(GrafPort) + 0xE), r );	}
inline SInt16		GetWindowTitleWidth(WindowRef w)				{ return *(SInt16 *)(((UInt8 *) w) + sizeof(GrafPort) + 0x1E);			}
inline WindowRef	GetNextWindow(WindowRef w)						{ return *(WindowRef *)	(((UInt8 *) w) + sizeof(GrafPort) + 0x24);		}
inline void	GetWindowStandardState(WindowRef w, Rect *r)  {	Rect *stateRects = (  (Rect *) (**(Handle *) (((UInt8 *) w) + sizeof(GrafPort) + 0x16)));	if (stateRects != NULL)	*r = stateRects[1];		}
inline void	SetWindowStandardState(WindowRef w, const Rect *r)	{ 	Rect *stateRects = (  (Rect *) (**(Handle *) (((UInt8 *) w) + sizeof(GrafPort) + 0x16))); if (stateRects != NULL)	stateRects[1] = *r; 	}
inline void	GetWindowUserState(WindowRef w, Rect *r)	{ 	Rect *stateRects = (  (Rect *) (**(Handle *) (((UInt8 *) w) + sizeof(GrafPort) + 0x16)));	if (stateRects != NULL)	*r = stateRects[0]; }
inline void	SetWindowUserState(WindowRef w, const Rect *r)	{ Rect *stateRects = (  (Rect *) (**(Handle *) (((UInt8 *) w) + sizeof(GrafPort) + 0x16)));	if (stateRects != NULL)	stateRects[0] = *r; }
#else
#define SetPortWindowPort(aWindowRef) SetPort( (GrafPtr) GetWindowPort(aWindowRef) )
#define GetWindowPort(aWindowRef) ( (CGrafPtr) aWindowRef)
#define GetWindowKind(aWindowRef) ( *(SInt16 *)	(((UInt8 *) aWindowRef) + sizeof(GrafPort)))

//#define SetWindowKind(aWindowRef, wKind) ( *(SInt16 *)	(((UInt8 *) aWindowRef) + sizeof(GrafPort)) = wKind )
#undef IsWindowVisible
#define IsWindowVisible(aWindowRef) ( *(Boolean *)	(((UInt8 *) aWindowRef) + sizeof(GrafPort) + 0x2))
#define IsWindowHilited(aWindowRef) ( *(Boolean *)	(((UInt8 *) aWindowRef) + sizeof(GrafPort) + 0x3))
#define GetWindowGoAwayFlag(aWindowRef) ( *(Boolean *)	(((UInt8 *) aWindowRef) + sizeof(GrafPort) + 0x4))
#define GetWindowZoomFlag(aWindowRef) ( *(Boolean *)	(((UInt8 *) aWindowRef) + sizeof(GrafPort) + 0x5))
#define GetWindowStructureRgn(aWindowRef, aRgnHandle) CopyRgn( *(RgnHandle *)(((UInt8 *) aWindowRef) + sizeof(GrafPort) + 0x6),  \
	aRgnHandle )
#define GetWindowContentRgn(aWindowRef, aRgnHandle) CopyRgn( *(RgnHandle *)(((UInt8 *) aWindowRef) + sizeof(GrafPort) + 0xA),  \
	aRgnHandle )
#define GetWindowUpdateRgn(aWindowRef, aRgnHandle) CopyRgn( *(RgnHandle *)(((UInt8 *) aWindowRef) + sizeof(GrafPort) + 0xE),  \
	aRgnHandle )
#define GetWindowTitleWidth(aWindowRef) ( *(SInt16 *)	(((UInt8 *) aWindowRef) + sizeof(GrafPort) + 0x1E))
#undef GetNextWindow
#define GetNextWindow(aWindowRef) ( *(WindowRef *)	(((UInt8 *) aWindowRef) + sizeof(GrafPort) + 0x24))
#define GetWindowStandardState(aWindowRef, aRectPtr) do { Rect *stateRects = ( (Rect *) (**(Handle *) (((UInt8 *) aWindowRef) + sizeof(GrafPort) + 0x16)));	 \
	if (stateRects != NULL)	*aRectPtr = stateRects[1]; } while (false)
#define SetWindowStandardState(aWindowRef, aRectPtr) do { Rect *stateRects = ( (Rect *) (**(Handle *) (((UInt8 *) aWindowRef) + sizeof(GrafPort) + 0x16)));	 \
	if (stateRects != NULL)	stateRects[1] = *aRectPtr; } while (false)
#define GetWindowUserState(aWindowRef, aRectPtr) do { Rect *stateRects = ( (Rect *) (**(Handle *) (((UInt8 *) aWindowRef) + sizeof(GrafPort) + 0x16)));	 \
	if (stateRects != NULL)	*aRectPtr = stateRects[0]; } while (false)
#define SetWindowUserState(aWindowRef, aRectPtr) do { Rect *stateRects = ( (Rect *) (**(Handle *) (((UInt8 *) aWindowRef) + sizeof(GrafPort) + 0x16)));	 \
	if (stateRects != NULL)	stateRects[0] = *aRectPtr; } while (false)
#endif
#endif


#if GRAPHSOFT && defined(__cplusplus)
extern "C" {
#endif


#if USESCODEFRAGMENTS
extern RgnHandle pascal GetGrayRgn(void);
#else
#endif

extern void pascal InitWindows(void);
extern void pascal GetWMgrPort(GrafPtr *wPort);
extern WindowPtr pascal NewWindow(void *wStorage, const Rect *boundsRect, ConstStr255Param title, Boolean visible, short theProc, WindowPtr behind, Boolean goAwayFlag, long refCon);
extern WindowPtr pascal GetNewWindow(short windowID, void *wStorage, WindowPtr behind);
extern void pascal CloseWindo(WindowPtr theWindow);
extern void pascal DisposeWindow(WindowPtr theWindow);
extern void setwtitle(WindowPtr theWindow, char *title);
extern void pascal GetWTitle(WindowPtr theWindow, Str255 title);
extern void pascal SelectWindow(WindowPtr theWindow);
extern void pascal HideWindow(WindowPtr theWindow);
extern void pascal ShowWindo(WindowPtr theWindow);
extern void pascal ShowHide(WindowPtr theWindow, Boolean showFlag);
extern void pascal HiliteWindow(WindowPtr theWindow, Boolean fHilite);
extern void pascal BringToFront(WindowPtr theWindow);
extern void pascal SendBehind(WindowPtr theWindow, WindowPtr behindWindow);
extern WindowRef pascal FrontWindow(void);
extern void pascal DrawGrowIcon(WindowPtr theWindow);
extern void pascal MoveWindo(WindowPtr theWindow, short hGlobal, short vGlobal, Boolean front);
extern void pascal SizeWindow(WindowPtr theWindow, short w, short h, Boolean fUpdate);
extern void pascal ZoomWindow(WindowPtr theWindow, short partCode, Boolean front);
extern void pascal InvalRect(const Rect *badRect);
extern void pascal InvalRgn(RgnHandle badRgn);
extern void pascal ValidRect(const Rect *goodRect);
extern void pascal ValidRgn(RgnHandle goodRgn);
extern void pascal BeginUpdate(WindowPtr theWindow);
extern void pascal EndUpdate(WindowPtr theWindow);
extern void pascal SetWRefCon(WindowPtr theWindow, long data);
extern long pascal GetWRefCon(WindowPtr theWindow);
extern void pascal SetWindowPic(WindowPtr theWindow, PicHandle pic);
extern PicHandle pascal GetWindowPic(WindowPtr theWindow);
extern Boolean pascal CheckUpdate(EventRecord *theEvent);
extern void pascal ClipAbove(WindowPeek window);
extern void pascal SaveOld(WindowPeek window);
extern void pascal DrawNew(WindowPeek window, Boolean update);
extern void pascal PaintOne(WindowRef window, RgnHandle clobberedRgn);
extern void pascal PaintBehind(WindowRef startWindow, RgnHandle clobberedRgn);
extern void pascal CalcVis(WindowRef window);
extern void pascal CalcVisBehind(WindowRef startWindow, RgnHandle clobberedRgn);
extern long pascal GrowWindow(WindowPtr theWindow, Point startPt, const Rect *bBox);
extern Boolean trackgoaway(WindowPtr theWindow, Point *thePt);
extern short pascal FindWindo(Point thePoint, WindowPtr *theWindow);
extern short findwindow(Point *thePoint, WindowPtr *theWindow);
extern long pascal PinRect(const Rect *theRect, Point thePt);
extern long pascal DragGrayRgn(RgnHandle theRgn, Point startPt, const Rect *limitRect, const Rect *slopRect, short axis, DragGrayRgnUPP actionProc);
extern long pascal DragTheRgn(RgnHandle theRgn, Point startPt, const Rect *limitRect, const Rect *slopRect, short axis, DragGrayRgnUPP actionProc);
extern Boolean pascal TrackBox(WindowPtr theWindow, Point thePt, short partCode);
extern void pascal GetCWMgrPort(CGrafPtr *wMgrCPort);
extern void getwtitle(WindowPtr theWindow, char *title);
extern void pascal SetWinColor(WindowPtr theWindow, WCTabHandle newColorTable);
extern Boolean pascal GetAuxWin(WindowPtr theWindow, AuxWinHandle *awHndl);
extern long growwindow(WindowPtr theWindow, Point *startPt, const Rect *bBox);
extern void pascal SetDeskCPat(PixPatHandle deskPixPat);
extern WindowPtr newwindow(void *wStorage, const Rect *boundsRect, char *title, Boolean visible, short theProc, WindowPtr behind, Boolean goAwayFlag, long refCon);
extern WindowPtr pascal NewCWindow(void *wStorage, const Rect *boundsRect, ConstStr255Param title, Boolean visible, short procID, WindowPtr behind, Boolean goAwayFlag, long refCon);
extern WindowPtr newcwindow(void *wStorage, const Rect *boundsRect, char *title, Boolean visible, short procID, WindowPtr behind, Boolean goAwayFlag, long refCon);
extern WindowPtr pascal GetNewCWindow(short windowID, void *wStorage, WindowPtr behind);
extern short pascal GetWVariant(WindowPtr theWindow);
extern long pinrect(const Rect *theRect, Point *thePt);
extern void pascal SetWTitle(WindowPtr theWindow, ConstStr255Param title);
extern Boolean trackbox(WindowPtr theWindow, Point *thePt, short partCode);
extern Boolean pascal TrackGoAway(WindowPtr theWindow, Point thePt);
extern void pascal DragWindow(WindowPtr theWindow, Point startPt, const Rect *boundsRect);
extern long draggrayrgn(RgnHandle theRgn, Point *startPt, const Rect *boundsRect, const Rect *slopRect, short axis, DragGrayRgnUPP actionProc);
extern void dragwindow(WindowPtr theWindow, Point *startPt, const Rect *boundsRect);
#ifdef __cplusplus
}
#endif

#if PRAGMA_STRUCT_ALIGN
	#pragma options align=reset
#elif PRAGMA_STRUCT_PACKPUSH
	#pragma pack(pop)
#elif PRAGMA_STRUCT_PACK
	#pragma pack()
#endif

#ifdef PRAGMA_IMPORT_OFF
#pragma import off
#elif PRAGMA_IMPORT
#pragma import reset
#endif

#endif


