/*
	File:		AIFF.h

	Copyright:	 1984-1993 by Apple Computer, Inc., all rights reserved.

	WARNING
	This file was auto generated by the interfacer tool. Modifications
	must be made to the master file.

*/

#ifndef __AIFF__
#define __AIFF__

#ifdef __cplusplus
extern "C" {
#endif
#if PRAGMA_IMPORT
#pragma import on
#endif

#if PRAGMA_STRUCT_ALIGN
	#pragma options align=mac68k
#elif PRAGMA_STRUCT_PACKPUSH
	#pragma pack(push, 2)
#elif PRAGMA_STRUCT_PACK
	#pragma pack(2)
#endif


#ifndef __TYPES__
#include <MacTypes.H>
#endif

#define AIFFID OST_AIFF

#define AIFCID OST_AIFC

#define FormatVersionID OST_FVER

#define CommonID OST_COMM

#define FORMID OST_FORM

#define SoundDataID OST_SSND

#define MarkerID OST_MARK

#define InstrumentID OST_INST

#define MIDIDataID OST_MIDI

#define AudioRecordingID OST_AESD

#define ApplicationSpecificID OST_APPL

#define CommentID OST_COMT

#define NameID OST_NAME

#define AuthorID OST_AUTH

#define CopyrightID OST_CopyRight

#define AnnotationID OST_ANNO

enum  {
	NoLooping			= 0,
	ForwardLooping			= 1,
	ForwardBackwardLooping		= 2,
/* AIFF-C Versions */
	AIFCVersion1			= 0xA2805140
};

typedef unsigned long ID;

typedef short MarkerIdType;

struct ChunkHeader {
	ID			ckID;
	long			ckSize;
};
/* Compression Names */

#define NoneName "\016not compressed"

#define ACE2to1Name "\012ACE 2-to-1"

#define ACE8to3Name "\012ACE 8-to-3"

#define MACE3to1Name "\013MACE 3-to-1"

#define MACE6to1Name "\013MACE 6-to-1"


/* Compression Types */

#define NoneType OST_NONE

#define ACE2Type OST_ACE2

#define ACE8Type OST_ACE8

#define MACE3Type OST_MAC3

#define MACE6Type OST_MAC6

typedef struct ChunkHeader ChunkHeader;

struct ContainerChunk {
	ID			ckID;
	long			ckSize;
	ID			formType;
};
typedef struct ContainerChunk ContainerChunk;

struct FormatVersionChunk {
	ID			ckID;
	long			ckSize;
	unsigned long			timestamp;
};
typedef struct FormatVersionChunk FormatVersionChunk;

typedef FormatVersionChunk *FormatVersionChunkPtr;

struct CommonChunk {
	ID			ckID;
	long			ckSize;
	short			numChannels;
	unsigned long			numSampleFrames;
	short			sampleSize;
	extended80			sampleRate;
};
typedef struct CommonChunk CommonChunk;

typedef CommonChunk *CommonChunkPtr;

struct ExtCommonChunk {
	ID			ckID;
	long			ckSize;
	short			numChannels;
	unsigned long			numSampleFrames;
	short			sampleSize;
	extended80			sampleRate;
	ID			compressionType;
	char			compressionName[1];
};
typedef struct ExtCommonChunk ExtCommonChunk;

typedef ExtCommonChunk *ExtCommonChunkPtr;

struct SoundDataChunk {
	ID			ckID;
	long			ckSize;
	unsigned long			offset;
	unsigned long			blockSize;
};
typedef struct SoundDataChunk SoundDataChunk;

typedef SoundDataChunk *SoundDataChunkPtr;

struct Marker {
	MarkerIdType			id;
	unsigned long			position;
	Str255			markerName;
};
typedef struct Marker Marker;

struct MarkerChunk {
	ID			ckID;
	long			ckSize;
	unsigned short			numMarkers;
	Marker			Markers[1];
};
typedef struct MarkerChunk MarkerChunk;

typedef MarkerChunk *MarkerChunkPtr;

struct AIFFLoop {
	short			playMode;
	MarkerIdType			beginLoop;
	MarkerIdType			endLoop;
};
typedef struct AIFFLoop AIFFLoop;

struct InstrumentChunk {
	ID			ckID;
	long			ckSize;
	char			baseFrequency;
	char			detune;
	char			lowFrequency;
	char			highFrequency;
	char			lowVelocity;
	char			highVelocity;
	short			gain;
	AIFFLoop			sustainLoop;
	AIFFLoop			releaseLoop;
};
typedef struct InstrumentChunk InstrumentChunk;

typedef InstrumentChunk *InstrumentChunkPtr;

struct MIDIDataChunk {
	ID			ckID;
	long			ckSize;
	unsigned char			MIDIdata[1];
};
typedef struct MIDIDataChunk MIDIDataChunk;

typedef MIDIDataChunk *MIDIDataChunkPtr;

struct AudioRecordingChunk {
	ID			ckID;
	long			ckSize;
	unsigned char			AESChannelStatus[24];
};
typedef struct AudioRecordingChunk AudioRecordingChunk;

typedef AudioRecordingChunk *AudioRecordingChunkPtr;

struct ApplicationSpecificChunk {
	ID			ckID;
	long			ckSize;
	OSType			applicationSignature;
	char			data[1];
};
typedef struct ApplicationSpecificChunk ApplicationSpecificChunk;

typedef ApplicationSpecificChunk *ApplicationSpecificChunkPtr;

struct Comment {
	unsigned long			timeStamp;
	MarkerIdType			marker;
	unsigned short			count;
	char			text[1];
};
typedef struct Comment Comment;

struct CommentsChunk {
	ID			ckID;
	long			ckSize;
	unsigned short			numComments;
	Comment			comments[1];
};
typedef struct CommentsChunk CommentsChunk;

typedef CommentsChunk *CommentsChunkPtr;

struct TextChunk {
	ID			ckID;
	long			ckSize;
	char			text[1];
};
typedef struct TextChunk TextChunk;

typedef TextChunk *TextChunkPtr;

#if PRAGMA_STRUCT_ALIGN
	#pragma options align=reset
#elif PRAGMA_STRUCT_PACKPUSH
	#pragma pack(pop)
#elif PRAGMA_STRUCT_PACK
	#pragma pack()
#endif

#ifdef PRAGMA_IMPORT_OFF
#pragma import off
#elif PRAGMA_IMPORT
#pragma import reset
#endif
#ifdef __cplusplus
}
#endif

#endif


