/*
	File:		AppleEvents.h

	Copyright:	 1984-1993 by Apple Computer, Inc., all rights reserved.

	WARNING
	This file was auto generated by the interfacer tool. Modifications
	must be made to the master file.

*/

#ifndef __APPLEEVENTS__
#define __APPLEEVENTS__

#ifndef __TYPES__
#include <MacTypes.H>
#endif

#ifndef __MEMORY__
#if MACVER
#include <Memory.h>
#else
#include <MemoryM.h>
#endif
#endif

#ifndef __OSUTILS__
#include <OSUtils.H>
#endif

#ifndef __EVENTS__
#include <Events.H>
#endif

#ifndef __EPPC__
#include <EPPC.H>
#endif

#ifndef __NOTIFICATION__
#if LONG_FILENAMES
#include <Notification.H>
#else
#include <Notifica.H>
#endif
#endif

#if PRAGMA_IMPORT
#pragma import on
#endif

#if PRAGMA_STRUCT_ALIGN
	#pragma options align=mac68k
#elif PRAGMA_STRUCT_PACKPUSH
	#pragma pack(push, 2)
#elif PRAGMA_STRUCT_PACK
	#pragma pack(2)
#endif


/*--------------------------------------------------------------
		Apple event descriptor types
--------------------------------------------------------------*/

#define typeBoolean OST_bool

#define typeChar OST_TEXT

#define typeSMInt OST_shor

#define typeInteger OST_long

#define typeSMFloat OST_sing

#define typeFloat OST_doub

#define typeLongInteger OST_long

#define typeShortInteger OST_shor

#define typeLongFloat OST_doub

#define typeShortFloat OST_sing

#define typeExtended OST_exte

#define typeComp OST_comp

#define typeMagnitude OST_magn

#define typeAEList OST_list

#define typeAERecord OST_reco

#define typeAppleEvent OST_aevt

#define typeTrue OST_true

#define typeFalse OST_fals

#define typeAlias OST_alis

#define typeEnumerated OST_enum

#define typeType OST_type

#define typeAppParameters OST_appa

#define typeProperty OST_prop

#define typeFSS OST_fssSpc

#define typeKeyword OST_keyw

#define typeSectionH OST_sect

#define typeWildCard OST_4Star

#define typeApplSignature OST_sign

#define typeSessionID OST_ssid

#define typeTargetID OST_targ

#define typeProcessSerialNumber OST_psnSpc

#define typeNull OST_null

#define typeQDRectangle	'qdrt'


/*--------------------------------------------------------------
		Keywords for Apple event parameters
--------------------------------------------------------------*/

#define keyDirectObject OST_4Dash

#define keyErrorNumber OST_errn

#define keyErrorString OST_errs

#define keyProcessSerialNumber OST_psnSpc


/*--------------------------------------------------------------
		Keywords for Apple event attributes
--------------------------------------------------------------*/

#define keyTransactionIDAttr OST_tran

#define keyReturnIDAttr OST_rtid

#define keyEventClassAttr OST_evcl

#define keyEventIDAttr OST_evid

#define keyAddressAttr OST_addr

#define keyOptionalKeywordAttr OST_optk

#define keyTimeoutAttr OST_timo

#define keyInteractLevelAttr OST_inte

#define keyEventSourceAttr OST_esrc

#define keyMissedKeywordAttr OST_miss

#define keyOriginalAddressAttr OST_from


/*--------------------------------------------------------------
		Keywords for special handlers
--------------------------------------------------------------*/

#define keyPreDispatch OST_phac

#define keySelectProc OST_selh


/*--------------------------------------------------------------
		Keyword for recording
--------------------------------------------------------------*/

#define keyAERecorderCount OST_recr


/*--------------------------------------------------------------
		Keyword for version information
--------------------------------------------------------------*/

#define keyAEVersion OST_vers


/*--------------------------------------------------------------
		Event Class
--------------------------------------------------------------*/

#define kCoreEventClass OST_aevt


/*--------------------------------------------------------------
		Event ID's
--------------------------------------------------------------*/

#define kAEOpenApplication OST_oapp

#define kAEOpenDocuments OST_odoc

#define kAEPrintDocuments OST_pdoc

#define kAEQuitApplication OST_quit

#define kAEAnswer OST_ansr

#define kAEApplicationDied OST_obit


/*--------------------------------------------------------------
		Constants for use in AESend mode
--------------------------------------------------------------*/

enum  {
	kAENoReply			= 0x0001,			/* sender doesn't want a reply to event */
	kAEQueueReply			= 0x0002,			/* sender wants a reply but won't wait */
	kAEWaitReply			= 0x0003,			/* sender wants a reply and will wait */
	kAENeverInteract			= 0x0010,			/* server should not interact with user */
	kAECanInteract			= 0x0020,			/* server may try to interact with user */
	kAEAlwaysInteract			= 0x0030,			/* server should always interact with user where appropriate */
	kAECanSwitchLayer			= 0x0040,			/* interaction may switch layer */
	kAEDontReconnect			= 0x0080,			/* don't reconnect if there is a sessClosedErr from PPCToolbox */
	kAEWantReceipt			= nReturnReceipt,			/* sender wants a receipt of message */
	kAEDontRecord			= 0x1000,			/* don't record this event - available only in vers 1.0.1 and greater */
	kAEDontExecute			= 0x2000,			/* don't send the event for recording - available only in vers 1.0.1 and greater */
/*--------------------------------------------------------------
		Constants for the send priority in AESend
--------------------------------------------------------------*/
	kAENormalPriority			= 0x0000,			/* post message at the end of the event queue */
	kAEHighPriority			= nAttnMsg			/* post message at the front of the event queue */
};


/*--------------------------------------------------------------
		Constants for recording
--------------------------------------------------------------*/

#define kAEStartRecording OST_reca

#define kAEStopRecording OST_recc

#define kAENotifyStartRecording OST_rec1

#define kAENotifyStopRecording OST_rec0

#define kAENotifyRecording OST_recr


/*--------------------------------------------------------------
		Constant for the returnID param of AECreateAppleEvent
--------------------------------------------------------------*/

enum  {
	kAutoGenerateReturnID		= -1,			/* AECreateAppleEvent will generate a session-unique ID */
/*--------------------------------------------------------------
		Constant for transaction ID's
--------------------------------------------------------------*/
	kAnyTransactionID			= 0,			/* no transaction is in use */
/*--------------------------------------------------------------
		Constants for timeout durations
--------------------------------------------------------------*/
	kAEDefaultTimeout			= -1,			/* timeout value determined by AEM */
	kNoTimeOut			= -2			/* wait until reply comes back, however long it takes */
};


/*--------------------------------------------------------------
		Constants for AEResumeTheCurrentEvent
--------------------------------------------------------------*/

enum  {
	kAENoDispatch			= 0,			/* dispatch parameter to AEResumeTheCurrentEvent takes a pointer to a dispatch */
#define kAEUseStandardDispatch	0xFFFFFFFF			/* table, or one of these two constants */
/*--------------------------------------------------------------
		Constants for Refcon in AEResumeTheCurrentEvent with kAEUseStandardDispatch
--------------------------------------------------------------*/
	kAEDoNotIgnoreHandler		= 0x0000,
	kAEIgnoreAppPhacHandler		= 0x0001,			/* available only in vers 1.0.1 and greater */
	kAEIgnoreAppEventHandler	= 0x0002,			/* available only in vers 1.0.1 and greater */
	kAEIgnoreSysPhacHandler		= 0x0004,			/* available only in vers 1.0.1 and greater */
	kAEIgnoreSysEventHandler	= 0x0008,			/* available only in vers 1.0.1 and greater */
	kAEIngoreBuiltInEventHandler = 0x0010			/* available only in vers 1.0.1 and greater */
#define	kAEDontDisposeOnResume	0x80000000   			/* available only in vers 1.0.1 and greater */
};


/*--------------------------------------------------------------
		Apple event manager data types
--------------------------------------------------------------*/

typedef unsigned long AEEventClass;

typedef unsigned long AEEventID;

typedef unsigned long AEKeyword;

typedef ResType DescType;

struct AEDesc {
	DescType			descriptorType;
	Handle			dataHandle;
};
typedef struct AEDesc AEDesc;

struct AEKeyDesc {
	AEKeyword			descKey;
	AEDesc			descContent;
};
typedef struct AEKeyDesc AEKeyDesc;


/* an AEDesc which contains address data */

typedef AEDesc AEAddressDesc;


/* a list of AEDesc's is a special kind of AEDesc */

typedef AEDesc AEDescList;


/* AERecord is a list of keyworded AEDesc's */

typedef AEDescList AERecord;


/* an AERecord that contains an AppleEvent */

typedef AERecord AppleEvent;


/* parameter to AESend */

typedef long AESendMode;


/* priority param of AESend */

typedef short AESendPriority;

enum  {
	kAEInteractWithSelf,
	kAEInteractWithLocal,
	kAEInteractWithAll
};

typedef unsigned char AEInteractAllowed;

enum  {
	kAEUnknownSource,
	kAEDirectCall,
	kAESameProcess,
	kAELocalProcess,
	kAERemoteProcess
};

typedef unsigned char AEEventSource;

enum  {
	kAEDataArray,
	kAEPackedArray,
	kAEHandleArray,
	kAEDescArray,
	kAEKeyDescArray
};

typedef unsigned char AEArrayType;

union AEArrayData {
	short			kAEDataArray[1];
	char			kAEPackedArray[1];
	Handle			kAEHandleArray[1];
	AEDesc			kAEDescArray[1];
	AEKeyDesc			kAEKeyDescArray[1];
};
typedef union AEArrayData AEArrayData;

typedef AEArrayData *AEArrayDataPointer;

typedef Boolean (pascal *AEIdleProcPtr)(EventRecord *theEvent, long *sleepTime, RgnHandle *mouseRgn);

enum {
	uppAEIdleProcInfo = kPascalStackBased
		| RESULT_SIZE(SIZE_CODE(sizeof(Boolean)))
		| STACK_ROUTINE_PARAMETER(1, SIZE_CODE(sizeof(EventRecord*)))
		| STACK_ROUTINE_PARAMETER(2, SIZE_CODE(sizeof(long*)))
		| STACK_ROUTINE_PARAMETER(3, SIZE_CODE(sizeof(RgnHandle*)))
};

#if USESROUTINEDESCRIPTORS
typedef UniversalProcPtr AEIdleUPP;

#define CallAEIdleProc(userRoutine, theEvent, sleepTime, mouseRgn)		\
		CallUniversalProc((UniversalProcPtr)(userRoutine), uppAEIdleProcInfo, (theEvent), (sleepTime), (mouseRgn))
#define NewAEIdleProc(userRoutine)		\
		(AEIdleUPP) NewRoutineDescriptor((ProcPtr)(userRoutine), uppAEIdleProcInfo, GetCurrentISA())
#else
typedef AEIdleProcPtr AEIdleUPP;

#define CallAEIdleProc(userRoutine, theEvent, sleepTime, mouseRgn)		\
		(*(userRoutine))((theEvent), (sleepTime), (mouseRgn))
#define NewAEIdleProc(userRoutine)		\
		(AEIdleUPP)(userRoutine)
#endif

typedef Boolean (pascal *AEFilterProcPtr)(EventRecord *theEvent, long returnID, long transactionID, const AEAddressDesc *sender);

enum {
	uppAEFilterProcInfo = kPascalStackBased
		| RESULT_SIZE(SIZE_CODE(sizeof(Boolean)))
		| STACK_ROUTINE_PARAMETER(1, SIZE_CODE(sizeof(EventRecord*)))
		| STACK_ROUTINE_PARAMETER(2, SIZE_CODE(sizeof(long)))
		| STACK_ROUTINE_PARAMETER(3, SIZE_CODE(sizeof(long)))
		| STACK_ROUTINE_PARAMETER(4, SIZE_CODE(sizeof(AEAddressDesc*)))
};

#if USESROUTINEDESCRIPTORS
typedef UniversalProcPtr AEFilterUPP;

#define CallAEFilterProc(userRoutine, theEvent, returnID, transactionID, sender)		\
		CallUniversalProc((UniversalProcPtr)(userRoutine), uppAEFilterProcInfo, (theEvent), (returnID), (transactionID), (sender))
#define NewAEFilterProc(userRoutine)		\
		(AEFilterUPP) NewRoutineDescriptor((ProcPtr)(userRoutine), uppAEFilterProcInfo, GetCurrentISA())
#else
typedef AEFilterProcPtr AEFilterUPP;

#define CallAEFilterProc(userRoutine, theEvent, returnID, transactionID, sender)		\
		(*(userRoutine))((theEvent), (returnID), (transactionID), (sender))
#define NewAEFilterProc(userRoutine)		\
		(AEFilterUPP)(userRoutine)
#endif

typedef OSErr (pascal *AEEventHandlerProcPtr)(const AppleEvent *theAppleEvent, AppleEvent *reply, long handlerRefcon);

enum {
	uppAEEventHandlerProcInfo = kPascalStackBased
		| RESULT_SIZE(SIZE_CODE(sizeof(OSErr)))
		| STACK_ROUTINE_PARAMETER(1, SIZE_CODE(sizeof(AppleEvent*)))
		| STACK_ROUTINE_PARAMETER(2, SIZE_CODE(sizeof(AppleEvent*)))
		| STACK_ROUTINE_PARAMETER(3, SIZE_CODE(sizeof(long)))
};

#if USESROUTINEDESCRIPTORS
typedef UniversalProcPtr AEEventHandlerUPP;

#define CallAEEventHandlerProc(userRoutine, theAppleEvent, reply, handlerRefcon)		\
		CallUniversalProc((UniversalProcPtr)(userRoutine), uppAEEventHandlerProcInfo, (theAppleEvent), (reply), (handlerRefcon))
#define NewAEEventHandlerProc(userRoutine)		\
		(AEEventHandlerUPP) NewRoutineDescriptor((ProcPtr)(userRoutine), uppAEEventHandlerProcInfo, GetCurrentISA())
#else
typedef AEEventHandlerProcPtr AEEventHandlerUPP;

#define CallAEEventHandlerProc(userRoutine, theAppleEvent, reply, handlerRefcon)		\
		(*(userRoutine))((theAppleEvent), (reply), (handlerRefcon))
#define NewAEEventHandlerProc(userRoutine)		\
		(AEEventHandlerUPP)(userRoutine)
#endif

typedef OSErr (pascal *AECoerceDescProcPtr)(const AEDesc *fromDesc, DescType toType, long handlerRefcon, AEDesc *toDesc);

enum {
	uppAECoerceDescProcInfo = kPascalStackBased
		| RESULT_SIZE(SIZE_CODE(sizeof(OSErr)))
		| STACK_ROUTINE_PARAMETER(1, SIZE_CODE(sizeof(AEDesc*)))
		| STACK_ROUTINE_PARAMETER(2, SIZE_CODE(sizeof(DescType)))
		| STACK_ROUTINE_PARAMETER(3, SIZE_CODE(sizeof(long)))
		| STACK_ROUTINE_PARAMETER(4, SIZE_CODE(sizeof(AEDesc*)))
};

#if USESROUTINEDESCRIPTORS
typedef UniversalProcPtr AECoerceDescUPP;

#define CallAECoerceDescProc(userRoutine, fromDesc, toType, handlerRefcon, toDesc)		\
		CallUniversalProc((UniversalProcPtr)(userRoutine), uppAECoerceDescProcInfo, (fromDesc), (toType), (handlerRefcon), (toDesc))
#define NewAECoerceDescProc(userRoutine)		\
		(AECoerceDescUPP) NewRoutineDescriptor((ProcPtr)(userRoutine), uppAECoerceDescProcInfo, GetCurrentISA())
#else
typedef AECoerceDescProcPtr AECoerceDescUPP;

#define CallAECoerceDescProc(userRoutine, fromDesc, toType, handlerRefcon, toDesc)		\
		(*(userRoutine))((fromDesc), (toType), (handlerRefcon), (toDesc))
#define NewAECoerceDescProc(userRoutine)		\
		(AECoerceDescUPP)(userRoutine)
#endif

typedef OSErr (pascal *AECoercePtrProcPtr)(DescType typeCode, const void *dataPtr, Size dataSize, DescType toType, long handlerRefcon, AEDesc *result);

#define	uppAECoercePtrProcInfo	\
		kPascalStackBased \
		| RESULT_SIZE(SIZE_CODE(sizeof(OSErr))) \
		| STACK_ROUTINE_PARAMETER(1, SIZE_CODE(sizeof(DescType))) \
		| STACK_ROUTINE_PARAMETER(2, SIZE_CODE(sizeof(void*))) \
		| STACK_ROUTINE_PARAMETER(3, SIZE_CODE(sizeof(Size))) \
		| STACK_ROUTINE_PARAMETER(4, SIZE_CODE(sizeof(DescType))) \
		| STACK_ROUTINE_PARAMETER(5, SIZE_CODE(sizeof(long))) \
		| STACK_ROUTINE_PARAMETER(6, SIZE_CODE(sizeof(AEDesc*)))

#if USESROUTINEDESCRIPTORS
typedef UniversalProcPtr AECoercePtrUPP;

#define CallAECoercePtrProc(userRoutine, typeCode, dataPtr, dataSize, toType, handlerRefcon, result)		\
		CallUniversalProc((UniversalProcPtr)(userRoutine), uppAECoercePtrProcInfo, (typeCode), (dataPtr), (dataSize), (toType), (handlerRefcon), (result))
#define NewAECoercePtrProc(userRoutine)		\
		(AECoercePtrUPP) NewRoutineDescriptor((ProcPtr)(userRoutine), uppAECoercePtrProcInfo, GetCurrentISA())
#else
typedef AECoercePtrProcPtr AECoercePtrUPP;

#define CallAECoercePtrProc(userRoutine, typeCode, dataPtr, dataSize, toType, handlerRefcon, result)		\
		(*(userRoutine))((typeCode), (dataPtr), (dataSize), (toType), (handlerRefcon), (result))
#define NewAECoercePtrProc(userRoutine)		\
		(AECoercePtrUPP)(userRoutine)
#endif

typedef UniversalProcPtr AECoercionHandlerUPP;


/*--------------------------------------------------------------
		Apple event manager error messages
--------------------------------------------------------------*/

enum  {
	errAECoercionFail			= -1700,			/* bad parameter data or unable to coerce the data supplied */
	errAEDescNotFound			= -1701,
	errAECorruptData			= -1702,
	errAEWrongDataType			= -1703,
	errAENotAEDesc			= -1704,
	errAEBadListItem			= -1705,			/* the specified list item does not exist */
	errAENewerVersion			= -1706,			/* need newer version of the AppleEvent manager */
	errAENotAppleEvent			= -1707,			/* the event is not in AppleEvent format */
	errAEEventNotHandled		= -1708,			/* the AppleEvent was not handled by any handler */
	errAEReplyNotValid			= -1709,			/* AEResetTimer was passed an invalid reply parameter */
	errAEUnknownSendMode		= -1710,			/* mode wasn't NoReply, WaitReply, or QueueReply or Interaction level is unknown */
	errAEWaitCanceled			= -1711,			/* in AESend, the user cancelled out of wait loop for reply or receipt */
	errAETimeout			= -1712,			/* the AppleEvent timed out */
	errAENoUserInteraction		= -1713,			/* no user interaction is allowed */
	errAENotASpecialFunction	= -1714,			/* there is no special function for/with this keyword */
	errAEParamMissed			= -1715,			/* a required parameter was not accessed */
	errAEUnknownAddressType		= -1716,			/* the target address type is not known */
	errAEHandlerNotFound		= -1717,			/* no handler in the dispatch tables fits the parameters to AEGetEventHandler or AEGetCoercionHandler */
	errAEReplyNotArrived		= -1718			/* the contents of the reply you are accessing have not arrived yet */
};

enum  {
	errAEIllegalIndex			= -1719,			/* index is out of range in a put operation */
	errAEUnknownObjectType		= -1731,			/* available only in version 1.0.1 or greater */
	errAERecordingIsAlreadyOn	= -1732			/* available only in version 1.0.1 or greater */
};

#ifdef __cplusplus
extern "C" {
#endif

/**************************************************************************
 The following calls apply to any AEDesc. Every 'result' descriptor is
 created for you, so you will be responsible for memory management
 (including disposing) of the descriptors so created. Note: purgeable
 descriptor data is not supported - the AEM does not call LoadResource.
**************************************************************************/

extern OSErr pascal AECreateDesc(DescType typeCode, const void *dataPtr, Size dataSize, AEDesc *result);
extern OSErr pascal AECoercePtr(DescType typeCode, const void *dataPtr, Size dataSize, DescType toType, AEDesc *result);
extern OSErr pascal AECoerceDesc(const AEDesc *theAEDesc, DescType toType, AEDesc *result);
extern OSErr pascal AEDisposeDesc(AEDesc *theAEDesc);
extern OSErr pascal AEDuplicateDesc(const AEDesc *theAEDesc, AEDesc *result);

/**************************************************************************
  The following calls apply to AEDescList. Since AEDescList is a subtype of
  AEDesc, the calls in the previous section can also be used for AEDescList.
  All list and array indices are 1-based. If the data was greater than
  maximumSize in the routines below, then actualSize will be greater than
  maximumSize, but only maximumSize bytes will actually be retrieved.
**************************************************************************/

extern OSErr pascal AECreateList(const void *factoringPtr, Size factoredSize, Boolean isRecord, AEDescList *resultList);
extern OSErr pascal AECountItems(const AEDescList *theAEDescList, long *theCount);
extern OSErr pascal AEPutPtr(const AEDescList *theAEDescList, long index, DescType typeCode, const void *dataPtr, Size dataSize);
extern OSErr pascal AEPutDesc(const AEDescList *theAEDescList, long index, const AEDesc *theAEDesc);
extern OSErr pascal AEGetNthPtr(const AEDescList *theAEDescList, long index, DescType desiredType, AEKeyword *theAEKeyword, DescType *typeCode, void *dataPtr, Size maximumSize, Size *actualSize);
extern OSErr pascal AEGetNthDesc(const AEDescList *theAEDescList, long index, DescType desiredType, AEKeyword *theAEKeyword, AEDesc *result);
extern OSErr pascal AESizeOfNthItem(const AEDescList *theAEDescList, long index, DescType *typeCode, Size *dataSize);
extern OSErr pascal AEGetArray(const AEDescList *theAEDescList, AEArrayType arrayType, AEArrayDataPointer arrayPtr, Size maximumSize, DescType *itemType, Size *itemSize, long *itemCount);
extern OSErr pascal AEPutArray(const AEDescList *theAEDescList, AEArrayType arrayType, const AEArrayData *arrayPtr, DescType itemType, Size itemSize, long itemCount);
extern OSErr pascal AEDeleteItem(const AEDescList *theAEDescList, long index);

/**************************************************************************
 The following calls apply to AERecord. Since AERecord is a subtype of
 AEDescList, the calls in the previous sections can also be used for
 AERecord an AERecord can be created by using AECreateList with isRecord
 set to true.

 NOTE: These calls are duplicately named, so their implementation has
 been changed to a macro which calls the duplicate function.
**************************************************************************/

#define AEPutKeyPtr(theAERecord, theAEKeyword, typeCode, dataPtr, dataSize)  \
	AEPutParamPtr((theAERecord), (theAEKeyword), (typeCode), (dataPtr), (dataSize))

#define AEPutKeyDesc(theAERecord, theAEKeyword, theAEDesc)  \
	AEPutParamDesc((theAERecord), (theAEKeyword), (theAEDesc))

#define AEGetKeyPtr(theAERecord, theAEKeyword, desiredType, typeCode, dataPtr, maxSize, actualSize)  \
	AEGetParamPtr((theAERecord), (theAEKeyword), (desiredType), (typeCode), (dataPtr), (maxSize), (actualSize))

#define AEGetKeyDesc(theAERecord, theAEKeyword, desiredType, result)  \
	AEGetParamDesc((theAERecord), (theAEKeyword), (desiredType), (result))

#define AESizeOfKeyDesc(theAERecord, theAEKeyword, typeCode, dataSize)  \
	AESizeOfParam((theAERecord), (theAEKeyword), (typeCode), (dataSize))

#define AEDeleteKeyDesc(theAERecord, theAEKeyword)  \
	AEDeleteParam((theAERecord), (theAEKeyword))


/**************************************************************************
  The following calls are used to pack and unpack parameters from records
  of type AppleEvent. Since AppleEvent is a subtype of AERecord, the calls
  in the previous sections can also be used for variables of type
  AppleEvent. The next six calls are in fact identical to the six calls
  for AERecord.
**************************************************************************/

extern OSErr pascal AEPutParamPtr(const AppleEvent *theAppleEvent, AEKeyword theAEKeyword, DescType typeCode, const void *dataPtr, Size dataSize);
extern OSErr pascal AEPutParamDesc(const AppleEvent *theAppleEvent, AEKeyword theAEKeyword, const AEDesc *theAEDesc);
extern OSErr pascal AEGetParamPtr(const AppleEvent *theAppleEvent, AEKeyword theAEKeyword, DescType desiredType, DescType *typeCode, void *dataPtr, Size maximumSize, Size *actualSize);
extern OSErr pascal AEGetParamDesc(const AppleEvent *theAppleEvent, AEKeyword theAEKeyword, DescType desiredType, AEDesc *result);
extern OSErr pascal AESizeOfParam(const AppleEvent *theAppleEvent, AEKeyword theAEKeyword, DescType *typeCode, Size *dataSize);
extern OSErr pascal AEDeleteParam(const AppleEvent *theAppleEvent, AEKeyword theAEKeyword);

/**************************************************************************
 The following calls also apply to type AppleEvent. Message attributes are
 far more restricted, and can only be accessed through the following 5
 calls. The various list and record routines cannot be used to access the
 attributes of an event.
**************************************************************************/

extern OSErr pascal AEGetAttributePtr(const AppleEvent *theAppleEvent, AEKeyword theAEKeyword, DescType desiredType, DescType *typeCode, void *dataPtr, Size maximumSize, Size *actualSize);
extern OSErr pascal AEGetAttributeDesc(const AppleEvent *theAppleEvent, AEKeyword theAEKeyword, DescType desiredType, AEDesc *result);
extern OSErr pascal AESizeOfAttribute(const AppleEvent *theAppleEvent, AEKeyword theAEKeyword, DescType *typeCode, Size *dataSize);
extern OSErr pascal AEPutAttributePtr(const AppleEvent *theAppleEvent, AEKeyword theAEKeyword, DescType typeCode, const void *dataPtr, Size dataSize);
extern OSErr pascal AEPutAttributeDesc(const AppleEvent *theAppleEvent, AEKeyword theAEKeyword, const AEDesc *theAEDesc);

/**************************************************************************
  The next couple of calls are basic routines used to create, send,
  and process AppleEvents.
**************************************************************************/

extern OSErr pascal AECreateAppleEvent(AEEventClass theAEEventClass, AEEventID theAEEventID, const AEAddressDesc *target, short returnID, long transactionID, AppleEvent *result);
extern OSErr pascal AESend(const AppleEvent *theAppleEvent, AppleEvent *reply, AESendMode sendMode, AESendPriority sendPriority, long timeOutInTicks, AEIdleUPP idleProc, AEFilterUPP filterProc);
extern OSErr pascal AEProcessAppleEvent(const EventRecord *theEventRecord);

/*
 Note: during event processing, an event handler may realize that it is likely
 to exceed the client's timeout limit. Passing the reply to this
 routine causes a wait event to be generated that asks the client
 for more time.
*/

extern OSErr pascal AEResetTimer(const AppleEvent *reply);

/**************************************************************************
 The following four calls are available for applications which need more
 sophisticated control over when and how events are processed. Applications
 which implement multi-session servers or which implement their own
 internal event queueing will probably be the major clients of these
 routines. They can be called from within a handler to prevent the AEM from
 disposing of the AppleEvent when the handler returns. They can be used to
 asynchronously process the event (as MacApp does).
**************************************************************************/

extern OSErr pascal AESuspendTheCurrentEvent(const AppleEvent *theAppleEvent);

/*
 Note: The following routine tells the AppleEvent manager that processing
 is either about to resume or has been completed on a previously suspended
 event. The procPtr passed in as the dispatcher parameter will be called to
 attempt to redispatch the event. Several constants for the dispatcher
 parameter allow special behavior. They are:
	- kAEUseStandardDispatch means redispatch as if the event was just
	received, using the standard AppleEvent dispatch mechanism.
	- kAENoDispatch means ignore the parameter.
	Use this in the case where the event has been handled and no
	redispatch is needed.
	- non nil means call the routine which the dispatcher points to.
*/

extern OSErr pascal AEResumeTheCurrentEvent(const AppleEvent *theAppleEvent, const AppleEvent *reply, AEEventHandlerUPP dispatcher, long handlerRefcon);
extern OSErr pascal AEGetTheCurrentEvent(AppleEvent *theAppleEvent);
extern OSErr pascal AESetTheCurrentEvent(const AppleEvent *theAppleEvent);

/**************************************************************************
  The following three calls are used to allow applications to behave
  courteously when a user interaction such as a dialog box is needed.
**************************************************************************/

extern OSErr pascal AEGetInteractionAllowed(AEInteractAllowed *level);
extern OSErr pascal AESetInteractionAllowed(AEInteractAllowed level);
extern OSErr pascal AEInteractWithUser(long timeOutInTicks, NMRecPtr nmReqPtr, AEIdleUPP idleProc);

/**************************************************************************
  These calls are used to set up and modify the event dispatch table.
**************************************************************************/

extern OSErr pascal AEInstallEventHandler(AEEventClass theAEEventClass, AEEventID theAEEventID, AEEventHandlerUPP handler, long handlerRefcon, Boolean isSysHandler);
extern OSErr pascal AERemoveEventHandler(AEEventClass theAEEventClass, AEEventID theAEEventID, AEEventHandlerUPP handler, Boolean isSysHandler);
extern OSErr pascal AEGetEventHandler(AEEventClass theAEEventClass, AEEventID theAEEventID, AEEventHandlerUPP *handler, long *handlerRefcon, Boolean isSysHandler);

/**************************************************************************
  These calls are used to set up and modify the coercion dispatch table.
**************************************************************************/

extern OSErr pascal AEInstallCoercionHandler(DescType fromType, DescType toType, AECoercionHandlerUPP handler, long handlerRefcon, Boolean fromTypeIsDesc, Boolean isSysHandler);
extern OSErr pascal AERemoveCoercionHandler(DescType fromType, DescType toType, AECoercionHandlerUPP handler, Boolean isSysHandler);
extern OSErr pascal AEGetCoercionHandler(DescType fromType, DescType toType, AECoercionHandlerUPP *handler, long *handlerRefcon, Boolean *fromTypeIsDesc, Boolean isSysHandler);

/**************************************************************************
  These calls are used to set up and modify special hooks into the
  AppleEvent manager.
**************************************************************************/

extern OSErr pascal AEInstallSpecialHandler(AEKeyword functionClass, UniversalProcPtr handler, Boolean isSysHandler);
extern OSErr pascal AERemoveSpecialHandler(AEKeyword functionClass, UniversalProcPtr handler, Boolean isSysHandler);
extern OSErr pascal AEGetSpecialHandler(AEKeyword functionClass, UniversalProcPtr *handler, Boolean isSysHandler);

/**************************************************************************
  This call was added in version 1.0.1. If called with the keyword
  keyAERecorderCount ('recr'), the number of recorders that are
  currently active is returned in 'result'.
**************************************************************************/


/* available only in vers 1.0.1 and greater */

extern OSErr pascal AEManagerInfo(AEKeyword keyWord, long *result);
#if PRAGMA_STRUCT_ALIGN
	#pragma options align=reset
#elif PRAGMA_STRUCT_PACKPUSH
	#pragma pack(pop)
#elif PRAGMA_STRUCT_PACK
	#pragma pack()
#endif

#ifdef PRAGMA_IMPORT_OFF
#pragma import off
#elif PRAGMA_IMPORT
#pragma import reset
#endif
#ifdef __cplusplus
}
#endif

#endif


