/*
	File:		AppleTalk.h

	Copyright:	 1984-1993 by Apple Computer, Inc., all rights reserved.

	WARNING
	This file was auto generated by the interfacer tool. Modifications
	must be made to the master file.

*/

#ifndef __APPLETALK__
#define __APPLETALK__

#ifndef __TYPES__
#include <MacTypes.H>
#endif

#ifndef __OSUTILS__
#include <OSUtils.H>
#endif

#if PRAGMA_IMPORT
#pragma import on
#endif

#if PRAGMA_STRUCT_ALIGN
	#pragma options align=mac68k
#elif PRAGMA_STRUCT_PACKPUSH
	#pragma pack(push, 2)
#elif PRAGMA_STRUCT_PACK
	#pragma pack(2)
#endif

enum  {
/* Driver unit and reference numbers (ADSP is dynamic) */
	mppUnitNum			= 9,			/* MPP unit number */
	atpUnitNum			= 10,			/* ATP unit number */
	xppUnitNum			= 40,			/* XPP unit number */
	mppRefNum			= -10,			/* MPP reference number */
	atpRefNum			= -11,			/* ATP reference number */
	xppRefNum			= -41,			/* XPP reference number */
/* .MPP csCodes */
	lookupReply			= 242,			/* This command queued to ourself */
	writeLAP			= 243,			/* Write out LAP packet */
	detachPH			= 244,			/* Detach LAP protocol handler */
	attachPH			= 245,			/* Attach LAP protocol handler */
	writeDDP			= 246,			/* Write out DDP packet */
	closeSkt			= 247,			/* Close DDP socket */
	openSkt			= 248,			/* Open DDP socket */
	loadNBP			= 249,			/* Load NBP command-executing code */
	lastResident			= 249,			/* Last resident command */
	confirmName			= 250,			/* Confirm name */
	lookupName			= 251,			/* Look up name on internet */
	removeName			= 252,			/* Remove name from Names Table */
	registerName			= 253,			/* Register name in Names Table */
	killNBP			= 254			/* Kill outstanding NBP request */
};

enum  {
	unloadNBP			= 255,			/* Unload NBP command code */
	setSelfSend			= 256,			/* MPP: Set to allow writes to self */
	SetMyZone			= 257,			/* Set my zone name */
	GetATalkInfo			= 258,			/* get AppleTalk information */
	ATalkClosePrep			= 259,			/* AppleTalk close query */
/* .ATP csCodes */
	nSendRequest			= 248,			/* NSendRequest code */
	relRspCB			= 249,			/* Release RspCB */
	closeATPSkt			= 250,			/* Close ATP socket */
	addResponse			= 251,			/* Add response code | Require open skt */
	sendResponse			= 252,			/* Send response code */
	getRequest			= 253,			/* Get request code */
	openATPSkt			= 254,			/* Open ATP socket */
	sendRequest			= 255,			/* Send request code */
	relTCB			= 256,			/* Release TCB */
	killGetReq			= 257,			/* Kill GetRequest */
	killSendReq			= 258,			/* Kill SendRequest */
	killAllGetReq			= 259,			/* Kill all getRequests for a skt */
/* .XPP csCodes */
	openSess			= 255,			/* Open session */
	closeSess			= 254,			/* Close session */
	userCommand			= 253			/* User command */
};

enum  {
	userWrite			= 252,			/* User write */
	getStatus			= 251,			/* Get status */
	afpCall			= 250,			/* AFP command (buffer has command code) */
	getParms			= 249,			/* Get parameters */
	abortOS			= 248,			/* Abort open session request */
	closeAll			= 247,			/* Close all open sessions */
	xCall			= 246,			/* .XPP extended calls */
/* Transition Queue transition types */
	ATTransOpen			= 0,			/*AppleTalk has opened*/
	ATTransClose			= 2,			/*AppleTalk is about to close*/
	ATTransClosePrep			= 3,			/*Is it OK to close AppleTalk ?*/
	ATTransCancelClose			= 4,			/*Cancel the ClosePrep transition*/
	afpByteRangeLock			= 1,			/*AFPCall command codes*/
	afpVolClose			= 2,			/*AFPCall command codes*/
	afpDirClose			= 3,			/*AFPCall command codes*/
	afpForkClose			= 4,			/*AFPCall command codes*/
	afpCopyFile			= 5,			/*AFPCall command codes*/
	afpDirCreate			= 6,			/*AFPCall command codes*/
	afpFileCreate			= 7,			/*AFPCall command codes*/
	afpDelete			= 8,			/*AFPCall command codes*/
	afpEnumerate			= 9			/*AFPCall command codes*/
};

enum  {
	afpFlush			= 10,			/*AFPCall command codes*/
	afpForkFlush			= 11,			/*AFPCall command codes*/
	afpGetDirParms			= 12,			/*AFPCall command codes*/
	afpGetFileParms			= 13,			/*AFPCall command codes*/
	afpGetForkParms			= 14,			/*AFPCall command codes*/
	afpGetSInfo			= 15,			/*AFPCall command codes*/
	afpGetSParms			= 16,			/*AFPCall command codes*/
	afpGetVolParms			= 17,			/*AFPCall command codes*/
	afpLogin			= 18,			/*AFPCall command codes*/
	afpContLogin			= 19,			/*AFPCall command codes*/
	afpLogout			= 20,			/*AFPCall command codes*/
	afpMapID			= 21,			/*AFPCall command codes*/
	afpMapName			= 22,			/*AFPCall command codes*/
	afpMove			= 23,			/*AFPCall command codes*/
	afpOpenVol			= 24,			/*AFPCall command codes*/
	afpOpenDir			= 25,			/*AFPCall command codes*/
	afpOpenFork			= 26,			/*AFPCall command codes*/
	afpRead			= 27,			/*AFPCall command codes*/
	afpRename			= 28,			/*AFPCall command codes*/
	afpSetDirParms			= 29			/*AFPCall command codes*/
};

enum  {
	afpSetFileParms			= 30,			/*AFPCall command codes*/
	afpSetForkParms			= 31,			/*AFPCall command codes*/
	afpSetVolParms			= 32,			/*AFPCall command codes*/
	afpWrite			= 33,			/*AFPCall command codes*/
	afpGetFlDrParms			= 34,			/*AFPCall command codes*/
	afpSetFlDrParms			= 35,			/*AFPCall command codes*/
	afpDTOpen			= 48,			/*AFPCall command codes*/
	afpDTClose			= 49,			/*AFPCall command codes*/
	afpGetIcon			= 51,			/*AFPCall command codes*/
	afpGtIcnInfo			= 52,			/*AFPCall command codes*/
	afpAddAPPL			= 53,			/*AFPCall command codes*/
	afpRmvAPPL			= 54,			/*AFPCall command codes*/
	afpGetAPPL			= 55,			/*AFPCall command codes*/
	afpAddCmt			= 56,			/*AFPCall command codes*/
	afpRmvCmt			= 57,			/*AFPCall command codes*/
	afpGetCmt			= 58,			/*AFPCall command codes*/
	afpAddIcon			= 192,			/*Special code for ASP Write commands*/
	xppLoadedBit			= 5,			/* XPP bit in PortBUse */
	scbMemSize			= 192,			/* Size of memory for SCB */
	xppFlagClr			= 0			/* Cs for AFPCommandBlock */
};

#define MPPioCompletion MPP.ioCompletion

#define MPPioResult MPP.ioResult

#define MPPioRefNum MPP.ioRefNum

#define MPPcsCode MPP.csCode

#define LAPprotType LAP.protType

#define LAPwdsPointer LAP.LAPptrs.wdsPointer

#define LAPhandler LAP.LAPptrs.handler

#define DDPsocket DDP.socket

#define DDPchecksumFlag DDP.checksumFlag

#define DDPwdsPointer DDP.DDPptrs.wdsPointer

#define DDPlistener DDP.DDPptrs.listener

#define NBPinterval NBP.interval

#define NBPcount NBP.count

#define NBPntQElPtr NBP.NBPPtrs.ntQElPtr

#define NBPentityPtr NBP.NBPPtrs.entityPtr

#define NBPverifyFlag NBP.parm.verifyFlag

#define NBPretBuffPtr NBP.parm.Lookup.retBuffPtr

#define NBPretBuffSize NBP.parm.Lookup.retBuffSize

#define NBPmaxToGet NBP.parm.Lookup.maxToGet

#define NBPnumGotten NBP.parm.Lookup.numGotten

#define NBPconfirmAddr NBP.parm.Confirm.confirmAddr

#define NBPnKillQEl NBPKILL.nKillQEl

#define NBPnewSocket NBP.parm.Confirm.newSocket

#define ATPioCompletion ATP.ioCompletion

#define ATPioResult ATP.ioResult

#define ATPuserData ATP.userData

#define ATPreqTID ATP.reqTID

#define ATPioRefNum ATP.ioRefNum

#define ATPcsCode ATP.csCode

#define ATPatpSocket ATP.atpSocket

#define ATPatpFlags ATP.atpFlags

#define ATPaddrBlock ATP.addrBlock

#define ATPreqLength ATP.reqLength

#define ATPreqPointer ATP.reqPointer

#define ATPbdsPointer ATP.bdsPointer

#define ATPtimeOutVal SREQ.timeOutVal

#define ATPnumOfResps SREQ.numOfResps

#define ATPretryCount SREQ.retryCount

#define ATPnumOfBuffs OTH1.u0.numOfBuffs

#define ATPbitMap OTH1.u0.bitMap

#define ATPrspNum OTH1.u0.rspNum

#define ATPbdsSize OTH2.bdsSize

#define ATPtransID OTH2.transID

#define ATPaKillQEl KILL.aKillQEl

enum  {
	xppFlagSet			= 128,			/* StartEndFlag & NewLineFlag fields. */
	lapSize			= 20,
	ddpSize			= 26,
	nbpSize			= 26,
	atpSize			= 56,
	atpXOvalue			= 32,			/*ATP exactly-once bit */
	atpEOMvalue			= 16,			/*ATP End-Of-Message bit */
	atpSTSvalue			= 8,			/*ATP Send-Transmission-Status bit */
	atpTIDValidvalue			= 2,			/*ATP trans. ID valid bit */
	atpSendChkvalue			= 1,			/*ATP send checksum bit */
	zipGetLocalZones			= 5,
	zipGetZoneList			= 6,
	zipGetMyZone			= 7,
	LAPMgrPtr			= 0xB18,			/*Entry point for LAP Manager*/
	LAPMgrCall			= 2,			/*Offset to LAP routines*/
	LAddAEQ			= 23,			/*LAPAddATQ routine selector*/
	LRmvAEQ			= 24			/*LAPRmvATQ routine selector*/
};

enum  {
	tLAPRead,
	tLAPWrite,
	tDDPRead,
	tDDPWrite,
	tNBPLookup,
	tNBPConfirm,
	tNBPRegister,
	tATPSndRequest,
	tATPGetRequest,
	tATPSdRsp,
	tATPAddRsp,
	tATPRequest,
	tATPResponse
};

typedef unsigned char ABCallType;

enum  {
	lapProto,
	ddpProto,
	nbpProto,
	atpProto
};

typedef unsigned char ABProtoType;

typedef Byte ABByte;

struct LAPAdrBlock {
	unsigned char			dstNodeID;
	unsigned char			srcNodeID;
	ABByte			lapProtType;
};
typedef struct LAPAdrBlock LAPAdrBlock;

typedef struct ATQEntry ATQEntry, *ATQEntryPtr;

typedef long (*ATalkTransitionEventProcPtr)(long eventCode, ATQEntryPtr qElem, void *eventParameter);

enum {
	uppATalkTransitionEventProcInfo = kCStackBased
		| RESULT_SIZE(SIZE_CODE(sizeof(long)))
		| STACK_ROUTINE_PARAMETER(1, SIZE_CODE(sizeof(long)))
		| STACK_ROUTINE_PARAMETER(2, SIZE_CODE(sizeof(ATQEntryPtr)))
		| STACK_ROUTINE_PARAMETER(3, SIZE_CODE(sizeof(void*)))
};

#if USESROUTINEDESCRIPTORS
typedef UniversalProcPtr ATalkTransitionEventUPP;

#define CallATalkTransitionEventProc(userRoutine, eventCode, qElem, eventParameter)		\
		CallUniversalProc((UniversalProcPtr)(userRoutine), uppATalkTransitionEventProcInfo, (eventCode), (qElem), (eventParameter))
#define NewATalkTransitionEventProc(userRoutine)		\
		(ATalkTransitionEventUPP) NewRoutineDescriptor((ProcPtr)(userRoutine), uppATalkTransitionEventProcInfo, GetCurrentISA())
#else
typedef ATalkTransitionEventProcPtr ATalkTransitionEventUPP;

#define CallATalkTransitionEventProc(userRoutine, eventCode, qElem, eventParameter)		\
		(*(userRoutine))((eventCode), (qElem), (eventParameter))
#define NewATalkTransitionEventProc(userRoutine)		\
		(ATalkTransitionEventUPP)(userRoutine)
#endif

typedef ATalkTransitionEventProcPtr ATalkTransitionEvent;

struct ATQEntry {
	struct ATQEntry			*qLink;			/*next queue entry*/
	short			qType;			/*queue type*/
	ATalkTransitionEventUPP		CallAddr;			/*your routine descriptor*/
};
struct AddrBlock {
	short			aNet;
	unsigned char			aNode;
	unsigned char			aSocket;
};
typedef struct AddrBlock AddrBlock;


/* Real definition of EntityName is 3 PACKED strings of any length (32 is just an example). No
offests for Asm since each String address must be calculated by adding length byte to last string ptr.
In Pascal, String(32) will be 34 bytes long since fields never start on an odd byte unless they are
only a byte long. So this will generate correct looking interfaces for Pascal and C, but they will not
be the same, which is OK since they are not used. */

struct EntityName {
	Str32			objStr;
	char			pad1;			/*Str32's aligned on even word boundries.*/
	Str32			typeStr;
	char			pad2;
	Str32			zoneStr;
	char			pad3;
};
typedef struct EntityName EntityName;

typedef EntityName *EntityPtr;

struct RetransType {
	unsigned char			retransInterval;
	unsigned char			retransCount;
};
typedef struct RetransType RetransType;

struct BDSElement {
	short			buffSize;
	Ptr			buffPtr;
	short			dataSize;
	long			userBytes;
};
typedef struct BDSElement BDSElement;

typedef BDSElement BDSType[8];

typedef BDSElement *BDSPtr;

typedef char BitMapType;

struct ATLAPRec {
	ABCallType			abOpcode;
	short			abResult;
	long			abUserReference;
	LAPAdrBlock			lapAddress;
	short			lapReqCount;
	short			lapActCount;
	Ptr			lapDataPtr;
};
typedef struct ATLAPRec ATLAPRec;

typedef ATLAPRec *ATLAPRecPtr, **ATLAPRecHandle;

struct ATDDPRec {
	ABCallType			abOpcode;
	short			abResult;
	long			abUserReference;
	short			ddpType;
	short			ddpSocket;
	AddrBlock			ddpAddress;
	short			ddpReqCount;
	short			ddpActCount;
	Ptr			ddpDataPtr;
	short			ddpNodeID;
};
typedef struct ATDDPRec ATDDPRec;

typedef ATDDPRec *ATDDPRecPtr, **ATDDPRecHandle;

struct ATNBPRec {
	ABCallType			abOpcode;
	short			abResult;
	long			abUserReference;
	EntityPtr			nbpEntityPtr;
	Ptr			nbpBufPtr;
	short			nbpBufSize;
	short			nbpDataField;
	AddrBlock			nbpAddress;
	RetransType			nbpRetransmitInfo;
};
typedef struct ATNBPRec ATNBPRec;

typedef ATNBPRec *ATNBPRecPtr, **ATNBPRecHandle;

struct ATATPRec {
	ABCallType			abOpcode;
	short			abResult;
	long			abUserReference;
	short			atpSocket;
	AddrBlock			atpAddress;
	short			atpReqCount;
	Ptr			atpDataPtr;
	BDSPtr			atpRspBDSPtr;
	BitMapType			atpBitMap;
	short			atpTransID;
	short			atpActCount;
	long			atpUserData;
	Boolean			atpXO;
	Boolean			atpEOM;
	short			atpTimeOut;
	short			atpRetries;
	short			atpNumBufs;
	short			atpNumRsp;
	short			atpBDSSize;
	long			atpRspUData;
	Ptr			atpRspBuf;
	short			atpRspSize;
};
typedef struct ATATPRec ATATPRec;

typedef ATATPRec *ATATPRecPtr, **ATATPRecHandle;

struct AFPCommandBlock {
	char			cmdByte;
	char			startEndFlag;
	short			forkRefNum;
	long			rwOffset;
	long			reqCount;
	char			newLineFlag;
	char			newLineChar;
};
typedef struct AFPCommandBlock AFPCommandBlock;

typedef union MPPParamBlock MPPParamBlock, *MPPPBPtr;

typedef union ATPParamBlock ATPParamBlock, *ATPPBPtr;

typedef union XPPParamBlock XPPParamBlock, *XPPParmBlkPtr;


/*
	MPPCompletionProcs, ATPCompletionProcs, and XPPCompletionProcs
	cannot be written in or called from a high-level language without the
	help of mixed mode or assembly glue because they use the following
	parameter-passing conventions:

	typedef pascal void (*MPPCompletionProcPtr)(MPPPBPtr thePBptr);
	typedef pascal void (*ATPCompletionProcPtr)(ATPPBPtr thePBptr);
	typedef pascal void (*XPPCompletionProcPtr)(XPPParmBlkPtr thePBptr);

		In:
			=>	thePBPtr		A0.L
		Out:
			none
*/

enum  {
	uppMPPCompletionProcInfo	= kRegisterBased|REGISTER_ROUTINE_PARAMETER(1,kRegisterA0,kFourByteCode),
	uppATPCompletionProcInfo	= kRegisterBased|REGISTER_ROUTINE_PARAMETER(1,kRegisterA0,kFourByteCode),
	uppXPPCompletionProcInfo	= kRegisterBased|REGISTER_ROUTINE_PARAMETER(1,kRegisterA0,kFourByteCode)
};

#if USESROUTINEDESCRIPTORS
typedef void (pascal *MPPCompletionProcPtr)(MPPPBPtr thePBptr);

typedef UniversalProcPtr MPPCompletionUPP;

#define CallMPPCompletionProc(userRoutine, thePBptr)  \
	CallUniversalProc((UniversalProcPtr)(userRoutine), uppMPPCompletionProcInfo, (thePBptr))

#define NewMPPCompletionProc(userRoutine)  \
	(MPPCompletionUPP) NewRoutineDescriptor((ProcPtr)(userRoutine), uppMPPCompletionProcInfo, GetCurrentISA())

typedef void (pascal *ATPCompletionProcPtr)(ATPPBPtr thePBptr);

typedef UniversalProcPtr ATPCompletionUPP;

#define CallATPCompletionProc(userRoutine, thePBptr)  \
	CallUniversalProc((UniversalProcPtr)(userRoutine), uppATPCompletionProcInfo, (thePBptr))

#define NewATPCompletionProc(userRoutine)  \
	(ATPCompletionUPP) NewRoutineDescriptor((ProcPtr)(userRoutine), uppATPCompletionProcInfo, GetCurrentISA())

typedef void (pascal *XPPCompletionProcPtr)(XPPParmBlkPtr thePBptr);

typedef UniversalProcPtr XPPCompletionUPP;

#define CallXPPCompletionProc(userRoutine, thePBptr)  \
	CallUniversalProc((UniversalProcPtr)(userRoutine), uppXPPCompletionProcInfo, (thePBptr))

#define NewXPPCompletionProc(userRoutine)  \
	(XPPCompletionUPP) NewRoutineDescriptor((ProcPtr)(userRoutine), uppXPPCompletionProcInfo, GetCurrentISA())

#else
typedef ProcPtr MPPCompletionUPP;

#define NewMPPCompletionProc(userRoutine)  \
	(MPPCompletionUPP)((userRoutine))

typedef ProcPtr ATPCompletionUPP;

#define NewATPCompletionProc(userRoutine)  \
	(ATPCompletionUPP)((userRoutine))

typedef ProcPtr XPPCompletionUPP;

#define NewXPPCompletionProc(userRoutine)  \
	(XPPCompletionUPP)((userRoutine))

#endif

#define XPPPBHeader			\
	QElem *qLink;			\
	short qType;			\
	short ioTrap;			\
	Ptr ioCmdAddr;			\
	XPPCompletionUPP ioCompletion; \
	OSErr ioResult;			\
	long cmdResult;			\
	short ioVRefNum;			\
	short ioRefNum;			\
	short csCode;

struct XPPPrmBlk {
	QElem			*qLink;
	short			qType;
	short			ioTrap;
	Ptr			ioCmdAddr;
	XPPCompletionUPP			ioCompletion;
	OSErr			ioResult;
	long			cmdResult;
	short			ioVRefNum;
	short			ioRefNum;
	short			csCode;
	short			sessRefnum;			/*Offset to session refnum*/
	char			aspTimeout;			/*Timeout for ATP*/
	char			aspRetry;			/*Retry count for ATP*/
	short			cbSize;			/*Command block size*/
	Ptr			cbPtr;			/*Command block pointer*/
	short			rbSize;			/*Reply buffer size*/
	Ptr			rbPtr;			/*Reply buffer pointer*/
	short			wdSize;			/*Write Data size*/
	Ptr			wdPtr;			/*Write Data pointer*/
	char			ccbStart[296];			/*CCB memory allocated for driver afpWrite max size(CCB)=296 all other calls=150*/
};
typedef struct XPPPrmBlk XPPPrmBlk;

struct AFPLoginPrm {
	QElem			*qLink;
	short			qType;
	short			ioTrap;
	Ptr			ioCmdAddr;
	XPPCompletionUPP			ioCompletion;
	OSErr			ioResult;
	long			cmdResult;
	short			ioVRefNum;
	short			ioRefNum;
	short			csCode;
	short			sessRefnum;			/*Offset to session refnum */
	char			aspTimeout;			/*Timeout for ATP */
	char			aspRetry;			/*Retry count for ATP */
	short			cbSize;			/*Command block size */
	Ptr			cbPtr;			/*Command block pointer */
	short			rbSize;			/*Reply buffer size */
	Ptr			rbPtr;			/*Reply buffer pointer */
	AddrBlock			afpAddrBlock;			/*block in AFP login */
	Ptr			afpSCBPtr;			/*SCB pointer in AFP login */
	Ptr			afpAttnRoutine;			/*routine pointer in AFP login */
	char			ccbFill[144];			/*CCB memory allocated for driver  Login needs only 150 bytes BUT CCB really starts in the middle of AFPSCBPtr and also clobbers AFPAttnRoutine. */
};
typedef struct AFPLoginPrm AFPLoginPrm;


/*
	AttnRoutineProcs cannot be written in or called from a high-level
	language without the help of mixed mode or assembly glue because
	they use the following parameter-passing convention:

	typedef pascal void (*AttnRoutineProcPtr)(short sessRefnum, short attnBytes);

		In:
			=>	sessRefnum		D0.W
			=>	attnBytes		D1.W
		Out:
			none
*/

#define	uppAttnRoutineProcInfo	kRegisterBased|REGISTER_ROUTINE_PARAMETER(1,kRegisterD0,kTwoByteCode)|REGISTER_ROUTINE_PARAMETER(2,kRegisterD1,kTwoByteCode)

#if USESROUTINEDESCRIPTORS
typedef void (pascal *AttnRoutineProcPtr)(short sessRefnum, short attnBytes);

typedef UniversalProcPtr AttnRoutineUPP;

#define CallAttnRoutineProc(userRoutine, sessRefnum, attnBytes)  \
	CallUniversalProc((UniversalProcPtr)(userRoutine), uppAttnRoutineProcInfo, (sessRefnum), (attnBytes))

#define NewAttnRoutineProc(userRoutine)  \
	(AttnRoutineUPP) NewRoutineDescriptor((ProcPtr)(userRoutine), uppAttnRoutineProcInfo, GetCurrentISA())

#else
typedef ProcPtr AttnRoutineUPP;

#define NewAttnRoutineProc(userRoutine)  \
	(AttnRoutineUPP)((userRoutine))

#endif

struct ASPOpenPrm {
	QElem			*qLink;
	short			qType;
	short			ioTrap;
	Ptr			ioCmdAddr;
	XPPCompletionUPP			ioCompletion;
	OSErr			ioResult;
	long			cmdResult;
	short			ioVRefNum;
	short			ioRefNum;
	short			csCode;
	short			sessRefnum;			/*Offset to session refnum */
	char			aspTimeout;			/*Timeout for ATP */
	char			aspRetry;			/*Retry count for ATP */
	AddrBlock			serverAddr;			/*Server address block */
	Ptr			scbPointer;			/*SCB pointer */
	AttnRoutineUPP			attnRoutine;			/*Attention routine pointer*/
};
typedef struct ASPOpenPrm ASPOpenPrm;

typedef ASPOpenPrm *ASPOpenPrmPtr;

struct ASPAbortPrm {
	QElem			*qLink;
	short			qType;
	short			ioTrap;
	Ptr			ioCmdAddr;
	XPPCompletionUPP			ioCompletion;
	OSErr			ioResult;
	long			cmdResult;
	short			ioVRefNum;
	short			ioRefNum;
	short			csCode;
	Ptr			abortSCBPtr;			/*SCB pointer for AbortOS */
};
typedef struct ASPAbortPrm ASPAbortPrm;

struct ASPGetparmsBlk {
	QElem			*qLink;
	short			qType;
	short			ioTrap;
	Ptr			ioCmdAddr;
	XPPCompletionUPP			ioCompletion;
	OSErr			ioResult;
	long			cmdResult;
	short			ioVRefNum;
	short			ioRefNum;
	short			csCode;
	short			aspMaxCmdSize;			/*For SPGetParms*/
	short			aspQuantumSize;
	short			numSesss;
};
typedef struct ASPGetparmsBlk ASPGetparmsBlk;

struct XCallParam {
	QElem			*qLink;
	short			qType;
	short			ioTrap;
	Ptr			ioCmdAddr;
	XPPCompletionUPP			ioCompletion;
	OSErr			ioResult;
	long			cmdResult;
	short			ioVRefNum;
	short			ioRefNum;
	short			csCode;
	short			xppSubCode;
	char			xppTimeout;			/*retry interval (seconds)*/
	char			xppRetry;			/*retry count*/
	short			filler1;
	Ptr			zipBuffPtr;			/*pointer to buffer (must be 578 bytes)*/
	short			zipNumZones;			/*no. of zone names in this response*/
	char			zipLastFlag;			/*non-zero if no more zones*/
	char			filler2;			/*filler*/
	char			zipInfoField[70];			/*on initial call, set first word to zero*/
};
typedef struct XCallParam XCallParam;

struct WDSElement {
	short			entryLength;
	Ptr			entryPtr;
};
typedef struct WDSElement WDSElement;

struct NTElement {
	AddrBlock			nteAddress;			/*network address of entity*/
	char			filler;
	char			entityData[99];			/*Object, Type & Zone*/
};
typedef struct NTElement NTElement;

struct NamesTableEntry {
	Ptr			qNext;			/*ptr to next NTE*/
	NTElement			nt;
};
typedef struct NamesTableEntry NamesTableEntry;

#define MPPATPHeader			\
	QElem *qLink;			\
	short qType;			\
	short ioTrap;			\
	Ptr ioCmdAddr;			\
	UniversalProcPtr ioCompletion;  \
	OSErr ioResult;			\
	long userData;			\
	short reqTID;			\
	short ioRefNum;			\
	short csCode;

struct MPPparms {
	QElem			*qLink;
	short			qType;
	short			ioTrap;
	Ptr			ioCmdAddr;
	UniversalProcPtr			ioCompletion;
	OSErr			ioResult;
	long			userData;
	short			reqTID;
	short			ioRefNum;
	short			csCode;
};
typedef struct MPPparms MPPparms;


/*
	MPPProtocolHandlerProcs and  DDPSocketListenerProcs cannot be written
	in or called from a high-level language without the help of mixed mode
	or assembly glue because they use the following parameter-passing conventions:

	typedef Boolean (*MPPProtocolHandlerProcPtr)(Ptr SCCAddr1, Ptr SCCAddr2,
			Ptr MPPLocalVars, Ptr nextFreeByteInRHA, Ptr ReadPacketAndReadRestPtr,
			short numBytesLeftToReadInPacket);

		In:
			=>	SCCAddr1			A0.L
			=>	SCCAddr2			A1.L
			=>	MPPLocalVars			A2.L
			=>	nextFreeByteInRHA			A3.L
			=>	ReadPacketAndReadRestPtr	A4.L
			=>	numBytesLeftToReadInPacket	D1.W
		Out:
			<=	Boolean			Z bit of CCR

	typedef Boolean (*DDPSocketListenerProcPtr)(Ptr SCCAddr1, Ptr SCCAddr2,
			Ptr MPPLocalVars, Ptr nextFreeByteInRHA, Ptr ReadPacketAndReadRestPtr,
			char packetDestinationNumber, short numBytesLeftToReadInPacket);

		In:
			=>	SCCAddr1			A0.L
			=>	SCCAddr2			A1.L
			=>	MPPLocalVars			A2.L
			=>	nextFreeByteInRHA			A3.L
			=>	ReadPacketAndReadRestPtr	A4.L
			=>	packetDestinationNumber		D0.B
			=>	numBytesLeftToReadInPacket	D1.W
		Out:
			<=	Boolean			Z bit of CCR

*/

enum  {
	uppMPPProtocolHandlerProcInfo = SPECIAL_CASE_PROCINFO(kSpecialCaseProtocolHandler),
	uppDDPSocketListenerProcInfo = SPECIAL_CASE_PROCINFO(kSpecialCaseSocketListener)
};

#if USESROUTINEDESCRIPTORS
typedef Boolean (*MPPProtocolHandlerProcPtr)(Ptr sccAddr1, Ptr sccAddr2, Ptr mppLocalVars, Ptr nextFreeByteInRHA, Ptr readPacketAndReadRestPtr, short numBytesLeftToReadInPacket);

typedef UniversalProcPtr MPPProtocolHandlerUPP;

#define CallMPPProtocolHandlerProc(userRoutine, sccAddr1, sccAddr2, mppLocalVars, nextFreeByteInRHA, readPacketAndReadRestPtr, numBytesLeftToReadInPacket)  \
	CallUniversalProc((UniversalProcPtr)(userRoutine), uppMPPProtocolHandlerProcInfo, (sccAddr1),  \
	(sccAddr2), (mppLocalVars), (nextFreeByteInRHA), (readPacketAndReadRestPtr)),  \
	(numBytesLeftToReadInPacket)

#define NewMPPProtocolHandlerProc(userRoutine)  \
	(MPPProtocolHandlerUPP) NewRoutineDescriptor((ProcPtr)(userRoutine),  \
	uppMPPProtocolHandlerProcInfo, GetCurrentISA())

typedef Boolean (*DDPSocketListenerProcPtr)(Ptr sccAddr1, Ptr sccAddr2, Ptr mppLocalVars, Ptr nextFreeByteInRHA, Ptr readPacketAndReadRestPtr, char packetDestinationNumber, short numBytesLeftToReadInPacket);

typedef UniversalProcPtr DDPSocketListenerUPP;

#define CallDDPSocketListenerProc(userRoutine, sccAddr1, sccAddr2, mppLocalVars, nextFreeByteInRHA, readPacketAndReadRestPtr, packetDestinationNumber, numBytesLeftToReadInPacket)  \
	CallUniversalProc((UniversalProcPtr)(userRoutine), uppDDPSocketListenerProcInfo, (sccAddr1),  \
	(sccAddr2), (mppLocalVars), (nextFreeByteInRHA), (packetDestinationNumber),	\
	(readPacketAndReadRestPtr), (numBytesLeftToReadInPacket))

#define NewDDPSocketListenerProc(userRoutine)  \
	(DDPSocketListenerUPP) NewRoutineDescriptor((ProcPtr)(userRoutine),  \
	uppDDPSocketListenerProcInfo, GetCurrentISA())

#else
typedef ProcPtr MPPProtocolHandlerUPP;

#define NewMPPProtocolHandlerProc(userRoutine)  \
	(MPPProtocolHandlerUPP)((userRoutine))

typedef ProcPtr DDPSocketListenerUPP;

#define NewDDPSocketListenerProc(userRoutine)  \
	(DDPSocketListenerUPP)((userRoutine))

#endif

struct LAPparms {
	QElem			*qLink;
	short			qType;
	short			ioTrap;
	Ptr			ioCmdAddr;
	UniversalProcPtr			ioCompletion;
	OSErr			ioResult;
	long			userData;
	short			reqTID;
	short			ioRefNum;
	short			csCode;
	char			protType;			/*ALAP protocol Type */
	char			filler;
	union {
		Ptr			wdsPointer;			/*-> write data structure*/
		MPPProtocolHandlerUPP		handler;			/*-> protocol handler routine*/
	}			LAPptrs;
};
typedef struct LAPparms LAPparms;

struct DDPparms {
	QElem			*qLink;
	short			qType;
	short			ioTrap;
	Ptr			ioCmdAddr;
	UniversalProcPtr			ioCompletion;
	OSErr			ioResult;
	long			userData;
	short			reqTID;
	short			ioRefNum;
	short			csCode;
	char			socket;			/*socket number */
	char			checksumFlag;			/*check sum flag */
	union {
		Ptr			wdsPointer;			/*-> write data structure*/
		DDPSocketListenerUPP		listener;			/*->write data structure or -> Listener*/
	}			DDPptrs;
};
typedef struct DDPparms DDPparms;

struct NBPparms {
	QElem			*qLink;
	short			qType;
	short			ioTrap;
	Ptr			ioCmdAddr;
	UniversalProcPtr			ioCompletion;
	OSErr			ioResult;
	long			userData;
	short			reqTID;
	short			ioRefNum;
	short			csCode;
	char			interval;			/*retry interval */
	char			count;			/*retry count */
	union {
		Ptr			ntQElPtr;
		Ptr			entityPtr;
	}			NBPPtrs;
	union {
		char			verifyFlag;
		struct {
			Ptr			retBuffPtr;
			short			retBuffSize;
			short			maxToGet;
			short			numGotten;
		}			Lookup;
		struct {
			AddrBlock			confirmAddr;
			char			newSocket;
		}			Confirm;
	}			parm;
};
typedef struct NBPparms NBPparms;

struct SetSelfparms {
	QElem			*qLink;
	short			qType;
	short			ioTrap;
	Ptr			ioCmdAddr;
	UniversalProcPtr			ioCompletion;
	OSErr			ioResult;
	long			userData;
	short			reqTID;
	short			ioRefNum;
	short			csCode;
	char			newSelfFlag;			/*self-send toggle flag */
	char			oldSelfFlag;			/*previous self-send state */
};
typedef struct SetSelfparms SetSelfparms;

struct NBPKillparms {
	QElem			*qLink;
	short			qType;
	short			ioTrap;
	Ptr			ioCmdAddr;
	UniversalProcPtr			ioCompletion;
	OSErr			ioResult;
	long			userData;
	short			reqTID;
	short			ioRefNum;
	short			csCode;
	Ptr			nKillQEl;			/*ptr to i/o queue element to cancel */
};
typedef struct NBPKillparms NBPKillparms;

struct GetAppleTalkInfoParm {
	QElem			*qLink;
	short			qType;
	short			ioTrap;
	Ptr			ioCmdAddr;
	UniversalProcPtr			ioCompletion;
	OSErr			ioResult;
	long			userData;
	short			reqTID;
	short			ioRefNum;
	short			csCode;			/*max. concurrent NBP requests*/
	short			version;			/*requested info version*/
	Ptr			varsPtr;			/*pointer to well known MPP vars*/
	Ptr			DCEPtr;			/*pointer to MPP DCE*/
	short			portID;			/*port number [0..7]*/
	long			configuration;			/*32-bit configuration word*/
	short			selfSend;			/*non zero if SelfSend enabled*/
	short			netLo;			/*low value of network range*/
	short			netHi;			/*high value of network range*/
	long			ourAdd;			/*our 24-bit AppleTalk address*/
	long			routerAddr;			/*24-bit address of (last) router*/
	short			numOfPHs;			/*max. number of protocol handlers*/
	short			numOfSkts;			/*max. number of static sockets*/
	short			numNBPEs;			/*max. concurrent NBP requests*/
	Ptr			nTQueue;			/*pointer to registered name queue*/
	short			LAlength;			/*length in bytes of data link addr*/
	Ptr			linkAddr;			/*data link address returned*/
	Ptr			zoneName;			/*zone name returned*/
};
typedef struct GetAppleTalkInfoParm GetAppleTalkInfoParm;

struct ATalkClosePrepParm {
	QElem			*qLink;
	short			qType;
	short			ioTrap;
	Ptr			ioCmdAddr;
	UniversalProcPtr			ioCompletion;
	OSErr			ioResult;
	long			userData;
	short			reqTID;
	short			ioRefNum;
	short			csCode;
	Ptr			appName;			/*pointer to application name in buffer*/
};
typedef struct ATalkClosePrepParm ATalkClosePrepParm;

union MPPParamBlock {
	MPPparms			MPP;			/*General MPP parms*/
	LAPparms			LAP;			/*ALAP calls*/
	DDPparms			DDP;			/*DDP calls*/
	NBPparms			NBP;			/*NBP calls*/
	SetSelfparms			SETSELF;
	NBPKillparms			NBPKILL;
	GetAppleTalkInfoParm		GAIINFO;
	ATalkClosePrepParm			ATALKCLOSE;
};
#define MOREATPHeader			\
	char atpSocket;			\
	char atpFlags;			\
	AddrBlock addrBlock;			\
	short reqLength;			\
	Ptr reqPointer;			\
	Ptr bdsPointer;

struct ATPparms {
	QElem			*qLink;
	short			qType;
	short			ioTrap;
	Ptr			ioCmdAddr;
	UniversalProcPtr			ioCompletion;
	OSErr			ioResult;
	long			userData;
	short			reqTID;
	short			ioRefNum;
	short			csCode;
	char			atpSocket;
	char			atpFlags;
	AddrBlock			addrBlock;
	short			reqLength;
	Ptr			reqPointer;
	Ptr			bdsPointer;
};
typedef struct ATPparms ATPparms;

struct SendReqparms {
	QElem			*qLink;
	short			qType;
	short			ioTrap;
	Ptr			ioCmdAddr;
	UniversalProcPtr			ioCompletion;
	OSErr			ioResult;
	long			userData;
	short			reqTID;
	short			ioRefNum;
	short			csCode;
	char			atpSocket;
	char			atpFlags;
	AddrBlock			addrBlock;
	short			reqLength;
	Ptr			reqPointer;
	Ptr			bdsPointer;
	char			filler;			/*numOfBuffs */
	char			timeOutVal;			/*timeout interval */
	char			numOfResps;			/*number of responses actually received */
	char			retryCount;			/*number of retries */
	short			intBuff;			/*used internally for NSendRequest */
	char			TRelTime;			/*TRelease time for extended send request */
};
typedef struct SendReqparms SendReqparms;

struct ATPmisc1 {
	QElem			*qLink;
	short			qType;
	short			ioTrap;
	Ptr			ioCmdAddr;
	UniversalProcPtr			ioCompletion;
	OSErr			ioResult;
	long			userData;
	short			reqTID;
	short			ioRefNum;
	short			csCode;
	char			atpSocket;
	char			atpFlags;
	AddrBlock			addrBlock;
	short			reqLength;
	Ptr			reqPointer;
	Ptr			bdsPointer;
	union {
		char			bitMap;			/*bitmap received */
		char			numOfBuffs;			/*number of responses being sent*/
		char			rspNum;			/*sequence number*/
	}			u0;
};
typedef struct ATPmisc1 ATPmisc1;

struct ATPmisc2 {
	QElem			*qLink;
	short			qType;
	short			ioTrap;
	Ptr			ioCmdAddr;
	UniversalProcPtr			ioCompletion;
	OSErr			ioResult;
	long			userData;
	short			reqTID;
	short			ioRefNum;
	short			csCode;
	char			atpSocket;
	char			atpFlags;
	AddrBlock			addrBlock;
	short			reqLength;
	Ptr			reqPointer;
	Ptr			bdsPointer;
	char			filler;
	char			bdsSize;			/*number of BDS elements */
	short			transID;			/*transaction ID recd. */
};
typedef struct ATPmisc2 ATPmisc2;

struct Killparms {
	QElem			*qLink;
	short			qType;
	short			ioTrap;
	Ptr			ioCmdAddr;
	UniversalProcPtr			ioCompletion;
	OSErr			ioResult;
	long			userData;
	short			reqTID;
	short			ioRefNum;
	short			csCode;
	char			atpSocket;
	char			atpFlags;
	AddrBlock			addrBlock;
	short			reqLength;
	Ptr			reqPointer;
	Ptr			bdsPointer;
	Ptr			aKillQEl;			/*ptr to i/o queue element to cancel*/
};
typedef struct Killparms Killparms;

union ATPParamBlock {
	ATPparms			ATP;			/*General ATP parms*/
	SendReqparms			SREQ;			/*sendrequest parms*/
	ATPmisc1			OTH1;			/*and a few others*/
	ATPmisc2			OTH2;			/*and a few others*/
	Killparms			KILL;			/*and a few others*/
};
union XPPParamBlock {
	XPPPrmBlk			XPP;
	ASPGetparmsBlk			GETPARM;
	ASPAbortPrm			ABORT;
	ASPOpenPrm			OPEN;
	AFPLoginPrm			LOGIN;
	XCallParam			XCALL;
};
#ifdef __cplusplus
extern "C" {
#endif
extern OSErr pascal OpenXPP(short *xppRefnum);
extern OSErr pascal ASPOpenSession(ASPOpenPrmPtr thePBptr, Boolean async);
extern OSErr pascal ASPCloseSession(XPPParmBlkPtr thePBptr, Boolean async);
extern OSErr pascal ASPAbortOS(XPPParmBlkPtr thePBptr, Boolean async);
extern OSErr pascal ASPGetParms(XPPParmBlkPtr thePBptr, Boolean async);
extern OSErr pascal ASPCloseAll(XPPParmBlkPtr thePBptr, Boolean async);
extern OSErr pascal ASPUserWrite(XPPParmBlkPtr thePBptr, Boolean async);
extern OSErr pascal ASPUserCommand(XPPParmBlkPtr thePBptr, Boolean async);
extern OSErr pascal ASPGetStatus(XPPParmBlkPtr thePBptr, Boolean async);
#define ASPGetStatusSync(paramBlock) ASPGetStatus((paramBlock), false)

extern OSErr pascal AFPCommand(XPPParmBlkPtr thePBptr, Boolean async);
extern OSErr pascal GetLocalZones(XPPParmBlkPtr thePBptr, Boolean async);
extern OSErr pascal GetZoneList(XPPParmBlkPtr thePBptr, Boolean async);
extern OSErr pascal GetMyZone(XPPParmBlkPtr thePBptr, Boolean async);
extern OSErr pascal PAttachPH(MPPPBPtr thePBptr, Boolean async);
extern OSErr pascal PDetachPH(MPPPBPtr thePBptr, Boolean async);
extern OSErr pascal PWriteLAP(MPPPBPtr thePBptr, Boolean async);
extern OSErr pascal POpenSkt(MPPPBPtr thePBptr, Boolean async);
extern OSErr pascal PCloseSkt(MPPPBPtr thePBptr, Boolean async);
extern OSErr pascal PWriteDDP(MPPPBPtr thePBptr, Boolean async);
extern OSErr pascal PRegisterName(MPPPBPtr thePBptr, Boolean async);
extern OSErr pascal PLookupName(MPPPBPtr thePBptr, Boolean async);
#define PLookupNameSync(paramBlock) PLookupName((paramBlock), false)

extern OSErr pascal PConfirmName(MPPPBPtr thePBptr, Boolean async);
extern OSErr pascal PRemoveName(MPPPBPtr thePBptr, Boolean async);
extern OSErr pascal PSetSelfSend(MPPPBPtr thePBptr, Boolean async);
extern OSErr pascal PKillNBP(MPPPBPtr thePBptr, Boolean async);
extern OSErr pascal PGetAppleTalkInfo(MPPPBPtr thePBptr, Boolean async);
extern OSErr pascal PATalkClosePrep(MPPPBPtr thePBptr, Boolean async);
extern OSErr pascal POpenATPSkt(ATPPBPtr thePBptr, Boolean async);
extern OSErr pascal PCloseATPSkt(ATPPBPtr thePBPtr, Boolean async);
extern OSErr pascal PSendRequest(ATPPBPtr thePBPtr, Boolean async);
extern OSErr pascal PGetRequest(ATPPBPtr thePBPtr, Boolean async);
extern OSErr pascal PSendResponse(ATPPBPtr thePBPtr, Boolean async);
extern OSErr pascal PAddResponse(ATPPBPtr thePBPtr, Boolean async);
extern OSErr pascal PRelTCB(ATPPBPtr thePBPtr, Boolean async);
extern OSErr pascal PRelRspCB(ATPPBPtr thePBPtr, Boolean async);
extern OSErr pascal PNSendRequest(ATPPBPtr thePBPtr, Boolean async);
extern OSErr pascal PKillSendReq(ATPPBPtr thePBPtr, Boolean async);
extern OSErr pascal PKillGetReq(ATPPBPtr thePBPtr, Boolean async);
extern OSErr pascal ATPKillAllGetReq(ATPPBPtr thePBPtr, Boolean async);
extern void pascal BuildLAPwds(Ptr wdsPtr, Ptr dataPtr, short destHost, short prototype, short frameLen);
extern void pascal BuildDDPwds(Ptr wdsPtr, Ptr headerPtr, Ptr dataPtr, const AddrBlock netAddr, short ddpType, short dataLen);
extern void pascal NBPSetEntity(Ptr buffer, Ptr nbpObject, Ptr nbpType, Ptr nbpZone);
extern void pascal NBPSetNTE(Ptr ntePtr, Ptr nbpObject, Ptr nbpType, Ptr nbpZone, short socket);
extern short pascal GetBridgeAddress(void);
extern short pascal BuildBDS(Ptr buffPtr, Ptr bdsPtr, short buffSize);
extern OSErr pascal MPPOpen(void);
extern OSErr pascal LAPAddATQ(ATQEntryPtr theATQEntry);
extern OSErr pascal LAPRmvATQ(ATQEntryPtr theATQEntry);
extern OSErr pascal ATPLoad(void);
extern OSErr pascal ATPUnload(void);
extern OSErr pascal NBPExtract(Ptr theBuffer, short numInBuf, short whichOne, EntityName *abEntity, AddrBlock *address);
extern OSErr pascal GetNodeAddress(short *myNode, short *myNet);
extern Boolean pascal IsMPPOpen(void);
extern Boolean pascal IsATPOpen(void);
extern void pascal ATEvent(long event, Ptr infoPtr);
extern OSErr pascal ATPreFlightEvent(long event, long cancel, Ptr infoPtr);

/*
	The following routines are obsolete and will not be supported on
	PowerPC. Equivalent functionality is provided by the routines
	above.
*/

#if defined(OBSOLETE) && !defined(powerc) && !defined(__powerc)
extern OSErr pascal MPPClose(void);
extern OSErr pascal LAPOpenProtocol(ABByte theLAPType, Ptr protoPtr);
extern OSErr pascal LAPCloseProtocol(ABByte theLAPType);
extern OSErr pascal LAPWrite(ATLAPRecHandle abRecord, Boolean async);
extern OSErr pascal LAPRead(ATLAPRecHandle abRecord, Boolean async);
extern OSErr pascal LAPRdCancel(ATLAPRecHandle abRecord);
extern OSErr pascal DDPOpenSocket(short *theSocket, Ptr sktListener);
extern OSErr pascal DDPCloseSocket(short theSocket);
extern OSErr pascal DDPRead(ATDDPRecHandle abRecord, Boolean retCksumErrs, Boolean async);
extern OSErr pascal DDPWrite(ATDDPRecHandle abRecord, Boolean doChecksum, Boolean async);
extern OSErr pascal DDPRdCancel(ATDDPRecHandle abRecord);
extern OSErr pascal ATPOpenSocket(AddrBlock addrRcvd, short *atpSocket);
extern OSErr pascal ATPCloseSocket(short atpSocket);
extern OSErr pascal ATPSndRequest(ATATPRecHandle abRecord, Boolean async);
extern OSErr pascal ATPRequest(ATATPRecHandle abRecord, Boolean async);
extern OSErr pascal ATPReqCancel(ATATPRecHandle abRecord, Boolean async);
extern OSErr pascal ATPGetRequest(ATATPRecHandle abRecord, Boolean async);
extern OSErr pascal ATPSndRsp(ATATPRecHandle abRecord, Boolean async);
extern OSErr pascal ATPAddRsp(ATATPRecHandle abRecord);
extern OSErr pascal ATPResponse(ATATPRecHandle abRecord, Boolean async);
extern OSErr pascal ATPRspCancel(ATATPRecHandle abRecord, Boolean async);
extern OSErr pascal NBPRegister(ATNBPRecHandle abRecord, Boolean async);
extern OSErr pascal NBPLookup(ATNBPRecHandle abRecord, Boolean async);
extern OSErr pascal NBPConfirm(ATNBPRecHandle abRecord, Boolean async);
extern OSErr pascal NBPRemove(EntityPtr abEntity);
extern OSErr pascal NBPLoad(void);
extern OSErr pascal NBPUnload(void);
#endif

#if PRAGMA_STRUCT_ALIGN
	#pragma options align=reset
#elif PRAGMA_STRUCT_PACKPUSH
	#pragma pack(pop)
#elif PRAGMA_STRUCT_PACK
	#pragma pack()
#endif

#ifdef PRAGMA_IMPORT_OFF
#pragma import off
#elif PRAGMA_IMPORT
#pragma import reset
#endif
#ifdef __cplusplus
}
#endif

#endif


