/*
	File:		Balloons.h

	Copyright:	 1984-1993 by Apple Computer, Inc., all rights reserved.

	WARNING
	This file was auto generated by the interfacer tool. Modifications
	must be made to the master file.

*/

#ifndef __BALLOONS__
#define __BALLOONS__

#ifndef __TYPES__
#include <MacTypes.H>
#endif

#ifndef __QUICKDRAW__
#if LONG_FILENAMES
#include <Quickdraw.H>
#else
#include <Quickdra.H>
#endif
#endif

#ifndef __MENUS__
#include <Menus.H>
#endif

#ifndef __TEXTEDIT__
#include <TextEdit.H>
#endif

#if PRAGMA_IMPORT
#pragma import on
#endif

#if PRAGMA_STRUCT_ALIGN
	#pragma options align=mac68k
#elif PRAGMA_STRUCT_PACKPUSH
	#pragma pack(push, 2)
#elif PRAGMA_STRUCT_PACK
	#pragma pack(2)
#endif

enum  {
	hmBalloonHelpVersion		= 0x0002,			/* The real version of the Help Manager */
/*Help Mgr error range: -850 to -874*/
	hmHelpDisabled			= -850,			/* Show Balloons mode was off, call to routine ignored */
	hmBalloonAborted			= -853,			/* Returned if mouse was moving or mouse wasn't in window port rect */
	hmSameAsLastBalloon			= -854,			/* Returned from HMShowMenuBalloon if menu & item is same as last time */
	hmHelpManagerNotInited		= -855,			/* Returned from HMGetHelpMenuHandle if help menu not setup */
	hmSkippedBalloon			= -857,			/* Returned from calls if helpmsg specified a skip balloon */
	hmWrongVersion			= -858,			/* Returned if help mgr resource was the wrong version */
	hmUnknownHelpType			= -859,			/* Returned if help msg record contained a bad type */
	hmOperationUnsupported		= -861,			/* Returned from HMShowBalloon call if bad method passed to routine */
	hmNoBalloonUp			= -862,			/* Returned from HMRemoveBalloon if no balloon was visible when call was made */
	hmCloseViewActive			= -863,			/* Returned from HMRemoveBalloon if CloseView was active */
	kHMHelpMenuID			= -16490,			/* Resource ID and menu ID of help menu */
	kHMAboutHelpItem			= 1,			/* help menu item number of About Balloon Help */
	kHMShowBalloonsItem			= 3,			/* help menu item number of Show/Hide Balloons */
	kHMHelpID			= -5696,			/* ID of various Help Mgr package resources (in Pack14 range) */
	kBalloonWDEFID			= 126,			/* Resource ID of the WDEF proc used in standard balloons */
/* Dialog item template type constant */
	helpItem			= 1,			/* key value in DITL template that corresponds to the help item */
/* Options for Help Manager resources in 'hmnu', 'hdlg', 'hrct', 'hovr', & 'hfdr' resources */
	hmDefaultOptions			= 0,			/* default options for help manager resources */
	hmUseSubID			= 1,			/* treat resID's in resources as subID's of driver base ID (for Desk Accessories) */
	hmAbsoluteCoords			= 2			/* ignore window port origin and treat rectangles as absolute coords (local to window) */
};

enum  {
	hmSaveBitsNoWindow			= 4,			/* don't create a window, just blast bits on screen. No update event is generated */
	hmSaveBitsWindow			= 8,			/* create a window, but restore bits behind window when window goes away & generate update event */
	hmMatchInTitle			= 16,			/* for hwin resources, match string anywhere in window title string */
/* Constants for Help Types in 'hmnu', 'hdlg', 'hrct', 'hovr', & 'hfdr' resources */
	kHMStringItem			= 1,			/* pstring used in resource */
	kHMPictItem			= 2,			/* 'PICT' ResID used in resource */
	kHMStringResItem			= 3,			/* 'STR#' ResID & index used in resource */
	kHMTEResItem			= 6,			/* Styled Text Edit ResID used in resource ('TEXT' & 'styl') */
	kHMSTRResItem			= 7,			/* 'STR ' ResID used in resource */
	kHMSkipItem			= 256,			/* don't display a balloon */
	kHMCompareItem			= 512,			/* Compare pstring in menu item w/ PString in resource item ('hmnu' only) */
	kHMNamedResourceItem		= 1024,			/* Use pstring in menu item to get 'STR#', 'PICT', or 'STR ' resource ('hmnu' only) */
	kHMTrackCntlItem			= 2048,			/* Reserved */
/* Constants for hmmHelpType's when filling out HMMessageRecord */
	khmmString			= 1,			/* help message contains a PString */
	khmmPict			= 2,			/* help message contains a resource ID to a 'PICT' resource */
	khmmStringRes			= 3,			/* help message contains a res ID & index to a 'STR#' resource */
	khmmTEHandle			= 4,			/* help message contains a Text Edit handle */
	khmmPictHandle			= 5,			/* help message contains a Picture handle */
	khmmTERes			= 6,			/* help message contains a res ID to 'TEXT' & 'styl' resources */
	khmmSTRRes			= 7,			/* help message contains a res ID to a 'STR ' resource */
	kHMEnabledItem			= 0			/* item is enabled, but not checked or control value = 0 */
};


/* ResTypes for Styled TE Handles in Resources */

#define kHMTETextResType OST_TEXT

#define kHMTEStyleResType OST_styl

enum  {
	kHMDisabledItem			= 1,			/* item is disabled, grayed in menus or disabled in dialogs */
	kHMCheckedItem			= 2,			/* item is enabled, and checked or control value = 1 */
	kHMOtherItem			= 3,			/* item is enabled, and control value > 1 */
/* Method parameters to pass to HMShowBalloon */
	kHMRegularWindow			= 0,			/* Create a regular window floating above all windows */
	kHMSaveBitsNoWindow			= 1,			/* Just save the bits and draw (for MDEF calls) */
	kHMSaveBitsWindow			= 2			/* Regular window, save bits behind, AND generate update event */
};


/* Resource Types for whichType parameter used when extracting 'hmnu' & 'hdlg' messages */

#define kHMMenuResType OST_hmnu

#define kHMDialogResType OST_hdlg

#define kHMWindListResType OST_hwin

#define kHMRectListResType OST_hrct

#define kHMOverrideResType OST_hovr

#define kHMFinderApplResType OST_hfdr

struct HMStringResType {
	short			hmmResID;
	short			hmmIndex;
};
typedef struct HMStringResType HMStringResType;

struct HMMessageRecord {
	short			hmmHelpType;
	union {
		char			hmmString[256];
		short			hmmPict;
		TEHandle			hmmTEHandle;
		HMStringResType			hmmStringRes;
		short			hmmPictRes;
		PicHandle			hmmPictHandle;
		short			hmmTERes;
		short			hmmSTRRes;
	}			u;
};
typedef struct HMMessageRecord HMMessageRecord;

typedef HMMessageRecord *HMMessageRecPtr;

typedef F_PASCAL_PTR(OSErr,*TipFunctionProcPtr)(Point tip, RgnHandle structure, Rect *r, short *variant);

enum {
	uppTipFunctionProcInfo = kPascalStackBased
		| RESULT_SIZE(SIZE_CODE(sizeof(OSErr)))
		| STACK_ROUTINE_PARAMETER(1, SIZE_CODE(sizeof(Point)))
		| STACK_ROUTINE_PARAMETER(2, SIZE_CODE(sizeof(RgnHandle)))
		| STACK_ROUTINE_PARAMETER(3, SIZE_CODE(sizeof(Rect*)))
		| STACK_ROUTINE_PARAMETER(4, SIZE_CODE(sizeof(short*)))
};

#if USESROUTINEDESCRIPTORS
typedef UniversalProcPtr TipFunctionUPP;

#define CallTipFunctionProc(userRoutine, tip, structure, r, variant)		\
		CallUniversalProc((UniversalProcPtr)(userRoutine), uppTipFunctionProcInfo, (tip), (structure), (r), (variant))
#define NewTipFunctionProc(userRoutine)		\
		(TipFunctionUPP) NewRoutineDescriptor((ProcPtr)(userRoutine), uppTipFunctionProcInfo, GetCurrentISA())
#else
typedef TipFunctionProcPtr TipFunctionUPP;

#define CallTipFunctionProc(userRoutine, tip, structure, r, variant)		\
		(*(userRoutine))((tip), (structure), (r), (variant))
#define NewTipFunctionProc(userRoutine)		\
		(TipFunctionUPP)(userRoutine)
#endif

#ifdef __cplusplus
extern "C" {
#endif

/*  Public Interfaces  */

extern F_PASCAL(OSErr) HMGetHelpMenuHandle(MenuHandle *mh);
extern F_PASCAL(OSErr) HMShowBalloon(const HMMessageRecord *aHelpMsg, Point tip, RectPtr alternateRect, TipFunctionUPP tipProc, short theProc, short variant, short method);
extern F_PASCAL(OSErr) HMRemoveBalloon(void);
extern F_PASCAL(Boolean) HMGetBalloons(void);
extern F_PASCAL(OSErr) HMSetBalloons(Boolean flag);
extern F_PASCAL(OSErr) HMShowMenuBalloon(short itemNum, short itemMenuID, long itemFlags, long itemReserved, Point tip, RectPtr alternateRect, TipFunctionUPP tipProc, short theProc, short variant);
extern F_PASCAL(OSErr) HMGetIndHelpMsg(ResType whichType, short whichResID, short whichMsg, short whichState, long *options, Point *tip, Rect *altRect, short *theProc, short *variant, HMMessageRecord *aHelpMsg, short *count);
extern F_PASCAL(Boolean) HMIsBalloon(void);
extern F_PASCAL(OSErr) HMSetFont(short font);
extern F_PASCAL(OSErr) HMSetFontSize(short fontSize);
extern F_PASCAL(OSErr) HMGetFont(short *font);
extern F_PASCAL(OSErr) HMGetFontSize(short *fontSize);
extern F_PASCAL(OSErr) HMSetDialogResID(short resID);
extern F_PASCAL(OSErr) HMSetMenuResID(short menuID, short resID);
extern F_PASCAL(OSErr) HMBalloonRect(const HMMessageRecord *aHelpMsg, Rect *coolRect);
extern F_PASCAL(OSErr) HMBalloonPict(const HMMessageRecord *aHelpMsg, PicHandle *coolPict);
extern F_PASCAL(OSErr) HMScanTemplateItems(short whichID, short whichResFile, ResType whichType);
extern F_PASCAL(OSErr) HMExtractHelpMsg(ResType whichType, short whichResID, short whichMsg, short whichState, HMMessageRecord *aHelpMsg);
extern F_PASCAL(OSErr) HMGetDialogResID(short *resID);
extern F_PASCAL(OSErr) HMGetMenuResID(short menuID, short *resID);
extern F_PASCAL(OSErr) HMGetBalloonWindow(WindowPtr *window);
extern F_PASCAL(OSErr) HMSetMenuResID(short menuID, short resID);

#if PRAGMA_STRUCT_ALIGN
	#pragma options align=reset
#elif PRAGMA_STRUCT_PACKPUSH
	#pragma pack(pop)
#elif PRAGMA_STRUCT_PACK
	#pragma pack()
#endif

#ifdef PRAGMA_IMPORT_OFF
#pragma import off
#elif PRAGMA_IMPORT
#pragma import reset
#endif
#ifdef __cplusplus
}
#endif

#endif


