/*
	File:		DeskBus.h

	Copyright:	 1984-1993 by Apple Computer, Inc., all rights reserved.

	WARNING
	This file was auto generated by the interfacer tool. Modifications
	must be made to the master file.

*/

#ifndef __DESKBUS__
#define __DESKBUS__

#ifndef __TYPES__
#include <MacTypes.H>
#endif

#if PRAGMA_STRUCT_ALIGN
	#pragma options align=mac68k
#elif PRAGMA_STRUCT_PACKPUSH
	#pragma pack(push, 2)
#elif PRAGMA_STRUCT_PACK
	#pragma pack(2)
#endif

typedef char ADBAddress;


/*
	ADBCompletionProcs, ADBDeviceDriverProcs, ADBServiceRoutineProcs, and
	ADBInitProcs cannot be written in or called from a high-level language
	without the help of mixed mode or assembly glue because they use the
	following parameter-passing convention:

	NOTE:  IM V-371 says that A1 points to the completion routine.  There is
	no good reason for passing to the routine a pointer to itself.  We have
	therefore done away with this parameter.

	typedef pascal void (*ADBCompletionProcPtr)(Ptr dataBuffPtr,
			Ptr opDataAreaPtr, long command);

		In:
			=>	dataBuffPtr			A0.L
			=>	opDataAreaPtr			A2.L
			=>	command			D0.L
		Out:
			none

	typedef pascal void (*ADBDeviceDriverProcPtr)(char devAddress, char devType);

		In:
			=>	devAddress			D0.B
			=>	devType			D1.B
		Out:
			none

	typedef pascal void (*ADBServiceRoutineProcPtr)(Ptr dataBuffPtr,
			ADBCompletionUPP completionProc, Ptr dataPtr, long command);

		In:
			=>	dataBuffPtr			A0.L
			=>  completionProc			A1.L
			=>	dataPtr			A2.L
			=>	command			D0.L
		Out:
			none

	NOTE:  ADBInitProcs are called at the beginning and end of the ADBReInit call.
	Inside Mac V-367 says to install this type of routine by jamming it into
	the low-mem global JADBProc. The current recommended way to install a
	VADBProc is to use a SetOSTrapAddress on the trap _VADBProc. The parameter
	callOrder will be 0 for preprocessing, 1 for postprocessing.

	typedef pascal void (*ADBInitProcPtr)(char callOrder);

		In:
			=>	callOrder			D0.B
		Out:
			none

*/

#define	uppADBCompletionProcInfo	(kRegisterBased|REGISTER_ROUTINE_PARAMETER(1,kRegisterA0,kFourByteCode)|REGISTER_ROUTINE_PARAMETER(2,kRegisterA2,kFourByteCode)|REGISTER_ROUTINE_PARAMETER(3,kRegisterD0,kFourByteCode))
#define	uppADBDeviceDriverProcInfo	(kRegisterBased|REGISTER_ROUTINE_PARAMETER(1,kRegisterD0,kOneByteCode)|REGISTER_ROUTINE_PARAMETER(2,kRegisterD1,kOneByteCode))
#define	uppADBServiceRoutineProcInfo	(kRegisterBased|REGISTER_ROUTINE_PARAMETER(1,kRegisterA0,kFourByteCode)|REGISTER_ROUTINE_PARAMETER(2,kRegisterA1,kFourByteCode)|REGISTER_ROUTINE_PARAMETER(3,kRegisterA2,kFourByteCode)|REGISTER_ROUTINE_PARAMETER(4,kRegisterD0,kFourByteCode))
#define	uppADBInitProcInfo		(kRegisterBased|REGISTER_ROUTINE_PARAMETER(1,kRegisterD0,kOneByteCode)

#if USESROUTINEDESCRIPTORS
typedef void (pascal *ADBCompletionProcPtr)(Ptr dataBuffPtr, Ptr opDataAreaPtr, long command);

typedef UniversalProcPtr ADBCompletionUPP;

#define CallADBCompletionProc(userRoutine, dataBuffPtr, opDataAreaPtr, command)  \
	CallUniversalProc((UniversalProcPtr)(userRoutine), uppADBCompletionProcInfo,  \
	(dataBuffPtr), (opDataAreaPtr), (command))

#define NewADBCompletionProc(userRoutine)  \
	(ADBCompletionUPP) NewRoutineDescriptor((ProcPtr)(userRoutine),  \
	uppADBCompletionProcInfo, GetCurrentISA())

typedef void (pascal *ADBDeviceDriverProcPtr)(char devAddress, char devType);

typedef UniversalProcPtr ADBDeviceDriverUPP;

#define CallADBDeviceDriverProc(userRoutine, devAddress, devType)  \
	CallUniversalProc((UniversalProcPtr)(userRoutine), uppADBDeviceDriverProcInfo,  \
	(devAddress), (devType))

#define NewADBDeviceDriverProc(userRoutine)  \
	(ADBDeviceDriverUPP) NewRoutineDescriptor((ProcPtr)(userRoutine),  \
	uppADBDeviceDriverProcInfo, GetCurrentISA())

typedef void (pascal *ADBServiceRoutineProcPtr)(Ptr dataBuffPtr, ADBCompletionUPP completionProc, Ptr dataPtr, long command);

typedef UniversalProcPtr ADBServiceRoutineUPP;

#define CallADBServiceRoutineProc(userRoutine, dataBuffPtr, completionProc, dataPtr, command)  \
	CallUniversalProc((UniversalProcPtr)(userRoutine), uppADBServiceRoutineProcInfo,  \
	(dataBuffPtr), (completionProc), (dataPtr), (command))

#define NewADBServiceRoutineProc(userRoutine)  \
	(ADBServiceRoutineUPP) NewRoutineDescriptor((ProcPtr)(userRoutine),  \
	uppADBServiceRoutineProcInfo, GetCurrentISA())

typedef void (pascal *ADBInitProcPtr)(char callOrder);

typedef UniversalProcPtr ADBInitUPP;

#define CallADBInitProc(userRoutine, callOrder)  \
	CallUniversalProc((UniversalProcPtr)(userRoutine), uppADBInitProcInfo, (callOrder))

#define NewADBInitProc(userRoutine)  \
	(ADBInitUPP) NewRoutineDescriptor((ProcPtr)(userRoutine), uppADBInitProcInfo,  \
	GetCurrentISA())

#else
typedef ProcPtr ADBCompletionUPP;

#define NewADBCompletionProc(userRoutine)  \
	(ADBCompletionUPP)((userRoutine))

typedef ProcPtr ADBDeviceDriverUPP;

#define NewADBDeviceDriverProc(userRoutine)  \
	(ADBDeviceDriverUPP)((userRoutine))

typedef ProcPtr ADBServiceRoutineUPP;

#define NewADBServiceRoutineProc(userRoutine)  \
	(ADBServiceRoutineUPP)((userRoutine))

typedef ProcPtr ADBInitUPP;

#define NewADBInitProc(userRoutine)  \
	(ADBInitUPP)(userRoutine)

#endif

struct ADBOpBlock {
	Ptr			dataBuffPtr;			/*address of data buffer*/
	ADBServiceRoutineUPP		opServiceRtPtr;			/*service routine pointer*/
	Ptr			opDataAreaPtr;			/*optional data area address*/
};
typedef struct ADBOpBlock ADBOpBlock;

typedef ADBOpBlock *ADBOpBPtr;

struct ADBDataBlock {
	char			devType;			/*device type*/
	char			origADBAddr;			/*original ADB Address*/
	ADBServiceRoutineUPP		dbServiceRtPtr;			/*service routine pointer*/
	Ptr			dbDataAreaAddr;			/*data area address*/
};
typedef struct ADBDataBlock ADBDataBlock;

typedef ADBDataBlock *ADBDBlkPtr;

struct ADBSetInfoBlock {
	ADBServiceRoutineUPP		siService;			/*service routine pointer*/
	Ptr			siDataAreaAddr;			/*data area address*/
};
typedef struct ADBSetInfoBlock ADBSetInfoBlock;

typedef ADBSetInfoBlock *ADBSInfoPtr;

#ifdef __cplusplus
extern "C" {
#endif
#if PRAGMA_IMPORT
#pragma import on
#endif

extern void pascal ADBReInit(void);
extern OSErr pascal ADBOp(Ptr data, ADBCompletionUPP compRout, Ptr buffer, short commandNum);

extern short pascal CountADBs(void);

extern ADBAddress pascal GetIndADB(ADBDataBlock *info, short devTableIndex);

extern OSErr pascal GetADBInfo(ADBDataBlock *info, ADBAddress adbAddr);

extern OSErr pascal SetADBInfo(ADBSetInfoBlock *info, ADBAddress adbAddr);
#if PRAGMA_STRUCT_ALIGN
	#pragma options align=reset
#elif PRAGMA_STRUCT_PACKPUSH
	#pragma pack(pop)
#elif PRAGMA_STRUCT_PACK
	#pragma pack()
#endif

#ifdef PRAGMA_IMPORT_OFF
#pragma import off
#elif PRAGMA_IMPORT
#pragma import reset
#endif
#ifdef __cplusplus
}
#endif

#endif


