/*
	File:		Files.h

	Copyright:	 1984-1993 by Apple Computer, Inc., all rights reserved.

	WARNING
	This file was auto generated by the interfacer tool. Modifications
	must be made to the master file.

*/

#ifndef __FILES__
#define __FILES__

#ifndef __TYPES__
#include <MacTypes.H>
#endif

#ifndef __OSUTILS__
#include <OSUtils.H>
#endif

#ifndef __SEGLOAD__
#include <SegLoad.H>
#endif

#if PRAGMA_IMPORT
#pragma import on
#endif

#if PRAGMA_STRUCT_ALIGN
	#pragma options align=mac68k
#elif PRAGMA_STRUCT_PACKPUSH
	#pragma pack(push, 2)
#elif PRAGMA_STRUCT_PACK
	#pragma pack(2)
#endif
enum  {
/* Finder Constants */
	fsAtMark			= 0,
	fOnDesk			= 1,
	fsCurPerm			= 0,
	fHasBundle			= 8192,
	fsRdPerm			= 1,
	fInvisible			= 16384,
	fTrash			= -3,
	fsWrPerm			= 2,
	fDesktop			= -2,
	fsRdWrPerm			= 3,
	fDisk			= 0,
	fsRdWrShPerm			= 4,
	fsFromStart			= 1,
	fsFromLEOF			= 2,
	fsFromMark			= 3,
	rdVerify			= 64,
	ioDirFlg			= 3,			/* see IM IV-125 */
	ioDirMask			= 0x10,
	fsRtParID			= 1,
	fsRtDirID			= 2
};

enum  {
/* CatSearch SearchBits Constants */
	fsSBPartialName			= 1,
	fsSBFullName			= 2,
	fsSBFlAttrib			= 4,
	fsSBFlFndrInfo			= 8,
	fsSBFlLgLen			= 32,
	fsSBFlPyLen			= 64,
	fsSBFlRLgLen			= 128,
	fsSBFlRPyLen			= 256,
	fsSBFlCrDat			= 512,
	fsSBFlMdDat			= 1024,
	fsSBFlBkDat			= 2048,
	fsSBFlXFndrInfo			= 4096,
	fsSBFlParID			= 8192,
	fsSBNegate			= 16384,
	fsSBDrUsrWds			= 8,
	fsSBDrNmFls			= 16,
	fsSBDrCrDat			= 512,
	fsSBDrMdDat			= 1024,
	fsSBDrBkDat			= 2048,
	fsSBDrFndrInfo			= 4096
};

enum  {
	fsSBDrParID			= 8192,
/* vMAttrib (GetVolParms) bit position constants */
	bLimitFCBs			= 31,
	bLocalWList			= 30,
	bNoMiniFndr			= 29,
	bNoVNEdit			= 28,
	bNoLclSync			= 27,
	bTrshOffLine			= 26,
	bNoSwitchTo			= 25,
	bNoDeskItems			= 20,
	bNoBootBlks			= 19,
	bAccessCntl			= 18,
	bNoSysDir			= 17,
	bHasExtFSVol			= 16,
	bHasOpenDeny			= 15,
	bHasCopyFile			= 14,
	bHasMoveRename			= 13,
	bHasDesktopMgr			= 12,
	bHasShortName			= 11,
	bHasFolderLock			= 10,
	bHasPersonalAccessPrivileges = 9
};

enum  {
	bHasUserGroupList			= 8,
	bHasCatSearch			= 7,
	bHasFileIDs			= 6,
	bHasBTreeMgr			= 5,
	bHasBlankAccessPrivileges	= 4,
/* Desktop Database icon Constants */
	kLargeIcon			= 1,
	kLarge4BitIcon			= 2,
	kLarge8BitIcon			= 3,
	kSmallIcon			= 4,
	kSmall4BitIcon			= 5,
	kSmall8BitIcon			= 6,
	kLargeIconSize			= 256,
	kLarge4BitIconSize			= 512,
	kLarge8BitIconSize			= 1024,
	kSmallIconSize			= 64,
	kSmall4BitIconSize			= 128,
	kSmall8BitIconSize			= 256,
/* Foreign Privilege Model Identifiers */
	fsUnixPriv			= 1,
/* Version Release Stage Codes */
	developStage			= 0x20,
	alphaStage			= 0x40
};

enum  {
	betaStage			= 0x60,
	finalStage			= 0x80,
/* Authentication Constants */
	kNoUserAuthentication		= 1,
	kPassword			= 2,
	kEncryptPassword			= 3,
	kTwoWayEncryptPassword		= 6
};

enum  {
	hFileInfo,
	dirInfo
};

typedef unsigned char CInfoType;

enum  {
/* mapping codes (ioObjType) for MapName & MapID */
	kOwnerID2Name			= 1,
	kGroupID2Name			= 2,
	kOwnerName2ID			= 3,
	kGroupName2ID			= 4,
/* types of oj object to be returned (ioObjType) for _GetUGEntry */
	kReturnNextUser			= 1,
	kReturnNextGroup			= 2,
	kReturnNextUG			= 3
};

struct FInfo {
	OSType			fdType;			/*the type of the file*/
	OSType			fdCreator;			/*file's creator*/
	unsigned short			fdFlags;			/*flags ex. hasbundle,invisible,locked, etc.*/
	Point			fdLocation;			/*file's location in folder*/
	short			fdFldr;			/*folder containing file*/
};
typedef struct FInfo FInfo;

struct FXInfo {
	short			fdIconID;			/*Icon ID*/
	short			fdUnused[3];			/*unused but reserved 6 bytes*/
	char			fdScript;			/*Script flag and number*/
	char			fdXFlags;			/*More flag bits*/
	short			fdComment;			/*Comment ID*/
	long			fdPutAway;			/*Home Dir ID*/
};
typedef struct FXInfo FXInfo;

struct DInfo {
	Rect			frRect;			/*folder rect*/
	unsigned short			frFlags;			/*Flags*/
	Point			frLocation;			/*folder location*/
	short			frView;			/*folder view*/
};
typedef struct DInfo DInfo;

struct DXInfo {
	Point			frScroll;			/*scroll position*/
	long			frOpenChain;			/*DirID chain of open folders*/
	char			frScript;			/*Script flag and number*/
	char			frXFlags;			/*More flag bits*/
	short			frComment;			/*comment*/
	long			frPutAway;			/*DirID*/
};
typedef struct DXInfo DXInfo;

struct GetVolParmsInfoBuffer {
	short			vMVersion;			/*version number*/
	long			vMAttrib;			/*bit vector of attributes (see vMAttrib constants)*/
	Handle			vMLocalHand;			/*handle to private data*/
	long			vMServerAdr;			/*AppleTalk server address or zero*/
	long			vMVolumeGrade;			/*approx. speed rating or zero if unrated*/
	short			vMForeignPrivID;			/*foreign privilege model supported or zero if none*/
};
typedef struct GetVolParmsInfoBuffer GetVolParmsInfoBuffer;

typedef union ParamBlockRec ParamBlockRec, *ParmBlkPtr;


/*
	IOCompletionProcs cannot be written in or called from a high-level
	language without the help of mixed mode or assembly glue because they
	use the following parameter-passing convention:

	typedef pascal void (*IOCompletionProcPtr)(ParmBlkPtr paramBlock);

		In:
			=>	paramBlock			A0.L
		Out:
			none
*/

enum  {
	uppIOCompletionProcInfo		= kRegisterBased|REGISTER_ROUTINE_PARAMETER(1,kRegisterA0,kFourByteCode)
};

#if USESROUTINEDESCRIPTORS
typedef void (pascal *IOCompletionProcPtr)(ParmBlkPtr paramBlock);

typedef UniversalProcPtr IOCompletionUPP;

#define CallIOCompletionProc(userRoutine, paramBlock)  \
	CallUniversalProc((UniversalProcPtr)(userRoutine), uppIOCompletionProcInfo, (paramBlock))

#define NewIOCompletionProc(userRoutine)  \
	(IOCompletionUPP) NewRoutineDescriptor((ProcPtr)(userRoutine),  \
	uppIOCompletionProcInfo, GetCurrentISA())

#else
typedef ProcPtr IOCompletionUPP;

#define NewIOCompletionProc(userRoutine)  \
	(IOCompletionUPP)((userRoutine))

#endif

#define ParamBlockHeader		\
	QElemPtr qLink;			\
	short qType;			\
	short ioTrap;			\
	Ptr ioCmdAddr;			\
	IOCompletionUPP ioCompletion;	\
	OSErr ioResult;			\
	StringPtr ioNamePtr;		\
	short ioVRefNum;

struct IOParam {
	QElemPtr			qLink;
	short			qType;
	short			ioTrap;
	Ptr			ioCmdAddr;
	IOCompletionUPP			ioCompletion;
	OSErr			ioResult;
	StringPtr			ioNamePtr;
	short			ioVRefNum;
	short			ioRefNum;			/*refNum for I/O operation*/
	char			ioVersNum;			/*version number*/
	char			ioPermssn;			/*Open: permissions (byte)*/
	Ptr			ioMisc;			/*Rename: new name (GetEOF,SetEOF: logical end of file) (Open: optional ptr to buffer) (SetFileType: new type)*/
	Ptr			ioBuffer;			/*data buffer Ptr*/
	long			ioReqCount;			/*requested byte count; also = ioNewDirID*/
	long			ioActCount;			/*actual byte count completed*/
	short			ioPosMode;			/*initial file positioning*/
	long			ioPosOffset;			/*file position offset*/
};
typedef struct IOParam IOParam;

struct FileParam {
	QElemPtr			qLink;
	short			qType;
	short			ioTrap;
	Ptr			ioCmdAddr;
	IOCompletionUPP			ioCompletion;
	OSErr			ioResult;
	StringPtr			ioNamePtr;
	short			ioVRefNum;
	short			ioFRefNum;			/*reference number*/
	char			ioFVersNum;			/*version number*/
	char			filler1;
	short			ioFDirIndex;			/*GetFInfo directory index*/
	unsigned char			ioFlAttrib;			/*GetFInfo: in-use bit=7, lock bit=0*/
	unsigned char			ioFlVersNum;			/*file version number*/
	FInfo			ioFlFndrInfo;			/*user info*/
	unsigned long			ioFlNum;			/*GetFInfo: file number; TF- ioDirID*/
	unsigned short			ioFlStBlk;			/*start file block (0 if none)*/
	long			ioFlLgLen;			/*logical length (EOF)*/
	long			ioFlPyLen;			/*physical length*/
	unsigned short			ioFlRStBlk;			/*start block rsrc fork*/
	long			ioFlRLgLen;			/*file logical length rsrc fork*/
	long			ioFlRPyLen;			/*file physical length rsrc fork*/
	unsigned long			ioFlCrDat;			/*file creation date& time (32 bits in secs)*/
	unsigned long			ioFlMdDat;			/*last modified date and time*/
};
typedef struct FileParam FileParam;

struct VolumeParam {
	QElemPtr			qLink;
	short			qType;
	short			ioTrap;
	Ptr			ioCmdAddr;
	IOCompletionUPP			ioCompletion;
	OSErr			ioResult;
	StringPtr			ioNamePtr;
	short			ioVRefNum;
	long			filler2;
	short			ioVolIndex;			/*volume index number*/
	unsigned long			ioVCrDate;			/*creation date and time*/
	unsigned long			ioVLsBkUp;			/*last backup date and time*/
	unsigned short			ioVAtrb;			/*volume attrib*/
	unsigned short			ioVNmFls;			/*number of files in directory*/
	unsigned short			ioVDirSt;			/*start block of file directory*/
	short			ioVBlLn;			/*GetVolInfo: length of dir in blocks*/
	unsigned short			ioVNmAlBlks;			/*GetVolInfo: num blks (of alloc size)*/
	long			ioVAlBlkSiz;			/*GetVolInfo: alloc blk byte size*/
	long			ioVClpSiz;			/*GetVolInfo: bytes to allocate at a time*/
	unsigned short			ioAlBlSt;			/*starting disk(512-byte) block in block map*/
	unsigned long			ioVNxtFNum;			/*GetVolInfo: next free file number*/
	unsigned short			ioVFrBlk;			/*GetVolInfo: # free alloc blks for this vol*/
};
typedef struct VolumeParam VolumeParam;

struct CntrlParam {
	QElem			*qLink;			/*queue link in header*/
	short			qType;			/*type byte for safety check*/
	short			ioTrap;			/*FS: the Trap*/
	Ptr			ioCmdAddr;			/*FS: address to dispatch to*/
	IOCompletionUPP			ioCompletion;			/*completion routine addr (0 for synch calls)*/
	OSErr			ioResult;			/*result code*/
	StringPtr			ioNamePtr;			/*ptr to Vol:FileName string*/
	short			ioVRefNum;			/*volume refnum (DrvNum for Eject and MountVol)*/
	short			ioCRefNum;			/*refNum for I/O operation*/
	short			csCode;			/*word for control status code*/
	short			csParam[11];			/*operation-defined parameters*/
};
typedef struct CntrlParam CntrlParam;

struct SlotDevParam {
	QElemPtr			qLink;
	short			qType;
	short			ioTrap;
	Ptr			ioCmdAddr;
	IOCompletionUPP			ioCompletion;
	OSErr			ioResult;
	StringPtr			ioNamePtr;
	short			ioVRefNum;
	short			ioRefNum;
	char			ioVersNum;
	char			ioPermssn;
	Ptr			ioMix;
	short			ioFlags;
	char			ioSlot;
	char			ioID;
};
typedef struct SlotDevParam SlotDevParam;

struct MultiDevParam {
	QElemPtr			qLink;
	short			qType;
	short			ioTrap;
	Ptr			ioCmdAddr;
	IOCompletionUPP			ioCompletion;
	OSErr			ioResult;
	StringPtr			ioNamePtr;
	short			ioVRefNum;
	short			ioRefNum;
	char			ioVersNum;
	char			ioPermssn;
	Ptr			ioMix;
	short			ioFlags;
	Ptr			ioSEBlkPtr;
};
typedef struct MultiDevParam MultiDevParam;

union ParamBlockRec {
	IOParam			ioParam;
	FileParam			fileParam;
	VolumeParam			volumeParam;
	CntrlParam			cntrlParam;
	SlotDevParam			slotDevParam;
	MultiDevParam			multiDevParam;
};
struct HFileInfo {
	QElemPtr			qLink;
	short			qType;
	short			ioTrap;
	Ptr			ioCmdAddr;
	IOCompletionUPP			ioCompletion;
	OSErr			ioResult;
	StringPtr			ioNamePtr;
	short			ioVRefNum;
	short			ioFRefNum;
	char			ioFVersNum;
	char			filler1;
	short			ioFDirIndex;
	char			ioFlAttrib;
	char			ioACUser;
	FInfo			ioFlFndrInfo;
	long			ioDirID;
	unsigned short			ioFlStBlk;
	long			ioFlLgLen;
	long			ioFlPyLen;
	unsigned short			ioFlRStBlk;
	long			ioFlRLgLen;
	long			ioFlRPyLen;
	unsigned long			ioFlCrDat;
	unsigned long			ioFlMdDat;
	unsigned long			ioFlBkDat;
	FXInfo			ioFlXFndrInfo;
	long			ioFlParID;
	long			ioFlClpSiz;
};
typedef struct HFileInfo HFileInfo;

struct DirInfo {
	QElemPtr			qLink;
	short			qType;
	short			ioTrap;
	Ptr			ioCmdAddr;
	IOCompletionUPP			ioCompletion;
	OSErr			ioResult;
	StringPtr			ioNamePtr;
	short			ioVRefNum;
	short			ioFRefNum;
	short			filler1;
	short			ioFDirIndex;
	char			ioFlAttrib;
	char			ioACUser;
	DInfo			ioDrUsrWds;
	long			ioDrDirID;
	unsigned short			ioDrNmFls;
	short			filler3[9];
	unsigned long			ioDrCrDat;
	unsigned long			ioDrMdDat;
	unsigned long			ioDrBkDat;
	DXInfo			ioDrFndrInfo;
	long			ioDrParID;
};
typedef struct DirInfo DirInfo;

union CInfoPBRec {
	HFileInfo			hFileInfo;
	DirInfo			dirInfo;
};
typedef union CInfoPBRec CInfoPBRec;

typedef CInfoPBRec *CInfoPBPtr;

struct HIOParam {
	QElemPtr			qLink;
	short			qType;
	short			ioTrap;
	Ptr			ioCmdAddr;
	IOCompletionUPP			ioCompletion;
	OSErr			ioResult;
	StringPtr			ioNamePtr;
	short			ioVRefNum;
	short			ioRefNum;
	char			ioVersNum;
	char			ioPermssn;
	Ptr			ioMisc;
	Ptr			ioBuffer;
	long			ioReqCount;
	long			ioActCount;
	short			ioPosMode;
	long			ioPosOffset;
	short			filler1;
};
typedef struct HIOParam HIOParam;

struct HFileParam {
	QElemPtr			qLink;
	short			qType;
	short			ioTrap;
	Ptr			ioCmdAddr;
	IOCompletionUPP			ioCompletion;
	OSErr			ioResult;
	StringPtr			ioNamePtr;
	short			ioVRefNum;
	short			ioFRefNum;
	char			ioFVersNum;
	char			filler1;
	short			ioFDirIndex;
	char			ioFlAttrib;
	char			ioFlVersNum;
	FInfo			ioFlFndrInfo;
	long			ioDirID;
	unsigned short			ioFlStBlk;
	long			ioFlLgLen;
	long			ioFlPyLen;
	unsigned short			ioFlRStBlk;
	long			ioFlRLgLen;
	long			ioFlRPyLen;
	unsigned long			ioFlCrDat;
	unsigned long			ioFlMdDat;
};
typedef struct HFileParam HFileParam;

struct HVolumeParam {
	QElemPtr			qLink;
	short			qType;
	short			ioTrap;
	Ptr			ioCmdAddr;
	IOCompletionUPP			ioCompletion;
	OSErr			ioResult;
	StringPtr			ioNamePtr;
	short			ioVRefNum;
	long			filler2;
	short			ioVolIndex;
	unsigned long			ioVCrDate;
	unsigned long			ioVLsMod;
	short			ioVAtrb;
	unsigned short			ioVNmFls;
	short			ioVBitMap;
	short			ioAllocPtr;
	unsigned short			ioVNmAlBlks;
	long			ioVAlBlkSiz;
	long			ioVClpSiz;
	short			ioAlBlSt;
	long			ioVNxtCNID;
	unsigned short			ioVFrBlk;
	unsigned short			ioVSigWord;
	short			ioVDrvInfo;
	short			ioVDRefNum;
	short			ioVFSID;
	unsigned long			ioVBkUp;
	unsigned short			ioVSeqNum;
	long			ioVWrCnt;
	long			ioVFilCnt;
	long			ioVDirCnt;
	long			ioVFndrInfo[8];
};
typedef struct HVolumeParam HVolumeParam;

struct AccessParam {
	QElemPtr			qLink;
	short			qType;
	short			ioTrap;
	Ptr			ioCmdAddr;
	IOCompletionUPP			ioCompletion;
	OSErr			ioResult;
	StringPtr			ioNamePtr;
	short			ioVRefNum;
	short			filler3;
	short			ioDenyModes;			/*access rights data*/
	short			filler4;
	char			filler5;
	char			ioACUser;			/*access rights for directory only*/
	long			filler6;
	long			ioACOwnerID;			/*owner ID*/
	long			ioACGroupID;			/*group ID*/
	long			ioACAccess;			/*access rights*/
};
typedef struct AccessParam AccessParam;

struct ObjParam {
	QElemPtr			qLink;
	short			qType;
	short			ioTrap;
	Ptr			ioCmdAddr;
	IOCompletionUPP			ioCompletion;
	OSErr			ioResult;
	StringPtr			ioNamePtr;
	short			ioVRefNum;
	short			filler7;
	short			ioObjType;			/*function code*/
	StringPtr			ioObjNamePtr;			/*ptr to returned creator/group name*/
	long			ioObjID;			/*creator/group ID*/
	long			ioReqCount;			/*size of buffer area*/
	long			ioActCount;			/*length of vol parms data*/
};
typedef struct ObjParam ObjParam;

struct CopyParam {
	QElemPtr			qLink;
	short			qType;
	short			ioTrap;
	Ptr			ioCmdAddr;
	IOCompletionUPP			ioCompletion;
	OSErr			ioResult;
	StringPtr			ioNamePtr;
	short			ioVRefNum;
	short			ioDstVRefNum;			/*destination vol identifier*/
	short			filler8;
	StringPtr			ioNewName;			/*ptr to destination pathname*/
	StringPtr			ioCopyName;			/*ptr to optional name*/
	long			ioNewDirID;			/*destination directory ID*/
	long			filler14;
	long			filler15;
	long			ioDirID;			/*same as in FileParam*/
};
typedef struct CopyParam CopyParam;

struct WDParam {
	QElemPtr			qLink;
	short			qType;
	short			ioTrap;
	Ptr			ioCmdAddr;
	IOCompletionUPP			ioCompletion;
	OSErr			ioResult;
	StringPtr			ioNamePtr;
	short			ioVRefNum;
	short			filler9;
	short			ioWDIndex;
	long			ioWDProcID;
	short			ioWDVRefNum;
	short			filler10;
	long			filler11;
	long			filler12;
	long			filler13;
	long			ioWDDirID;
};
typedef struct WDParam WDParam;

struct FIDParam {
	QElemPtr			qLink;
	short			qType;
	short			ioTrap;
	Ptr			ioCmdAddr;
	IOCompletionUPP			ioCompletion;
	OSErr			ioResult;
	StringPtr			ioNamePtr;
	short			ioVRefNum;
	long			filler1;
	StringPtr			ioDestNamePtr;			/* dest file name */
	long			filler2;
	long			ioDestDirID;			/* dest file's directory id */
	long			filler3;
	long			filler4;
	long			ioSrcDirID;			/* source file's directory id */
	short			filler5;
	long			ioFileID;			/* file ID */
};
typedef struct FIDParam FIDParam;


/* Catalog position record */

struct CatPositionRec {
	long			initialize;
	short			priv[6];
};
typedef struct CatPositionRec CatPositionRec;

// WARNING: This struct is larger now on Windows because the FSSpec struct
//  has been grown to handle long file names. Make sure you don't save this
//  struct to disk as it will be different sizes on the 2 platforms.

struct FSSpec {
	short			vRefNum;
	long			parID;
#if MACVER			// BIG WARNING HERE! On Windows this field
	Str63 name;		//   is now Bigger to handle long file names
#else
	Str255 name;
#endif
};
typedef struct FSSpec FSSpec;

typedef FSSpec *FSSpecPtr, **FSSpecHandle;


/* pointer to array of FSSpecs */

typedef FSSpecPtr FSSpecArrayPtr;


/* The following are structures to be filled out with the _GetVolMountInfo call
 and passed back into the _VolumeMount call for external file system mounts. */


/* the "signature" of the file system */

typedef OSType VolumeType;

#define AppleShareMediaType OST_afpm

struct VolMountInfoHeader {
	short			length;			/* length of location data (including self) */
	VolumeType			media;			/* type of media.  Variable length data follows */
};
typedef struct VolMountInfoHeader VolMountInfoHeader;

typedef VolMountInfoHeader *VolMountInfoPtr;

struct AFPVolMountInfo {
	short			length;			/* length of location data (including self) */
	VolumeType			media;			/* type of media */
	short			flags;			/* bits for no messages, no reconnect */
	char			nbpInterval;			/* NBP Interval parameter (IM2, p.322) */
	char			nbpCount;			/* NBP Interval parameter (IM2, p.322) */
	short			uamType;			/* User Authentication Method */
	short			zoneNameOffset;			/* short positive offset from start of struct to Zone Name */
	short			serverNameOffset;			/* offset to pascal Server Name string */
	short			volNameOffset;			/* offset to pascal Volume Name string */
	short			userNameOffset;			/* offset to pascal User Name string */
	short			userPasswordOffset;			/* offset to pascal User Password string */
	short			volPasswordOffset;			/* offset to pascal Volume Password string */
	char			AFPData[144];			/* variable length data may follow */
};
typedef struct AFPVolMountInfo AFPVolMountInfo;

typedef AFPVolMountInfo *AFPVolMountInfoPtr;

struct CSParam {
	QElemPtr			qLink;
	short			qType;
	short			ioTrap;
	Ptr			ioCmdAddr;
	IOCompletionUPP			ioCompletion;
	OSErr			ioResult;
	StringPtr			ioNamePtr;
	short			ioVRefNum;
	FSSpecPtr			ioMatchPtr;			/* match array */
	long			ioReqMatchCount;			/* maximum allowable matches */
	long			ioActMatchCount;			/* actual match count */
	long			ioSearchBits;			/* search criteria selector */
	CInfoPBPtr			ioSearchInfo1;			/* search values and range lower bounds */
	CInfoPBPtr			ioSearchInfo2;			/* search values and range upper bounds */
	long			ioSearchTime;			/* length of time to run search */
	CatPositionRec			ioCatPosition;			/* current position in the catalog */
	Ptr			ioOptBuffer;			/* optional performance enhancement buffer */
	long			ioOptBufSize;			/* size of buffer pointed to by ioOptBuffer */
};
typedef struct CSParam CSParam;

typedef CSParam *CSParamPtr;

struct DTPBRec {
	QElemPtr			qLink;
	short			qType;
	short			ioTrap;
	Ptr			ioCmdAddr;
	IOCompletionUPP			ioCompletion;
	OSErr			ioResult;
	StringPtr			ioNamePtr;
	short			ioVRefNum;
	short			ioDTRefNum;			/* desktop refnum */
	short			ioIndex;
	long			ioTagInfo;
	Ptr			ioDTBuffer;
	long			ioDTReqCount;
	long			ioDTActCount;
	char			ioFiller1;
	char			ioIconType;
	short			ioFiller2;
	long			ioDirID;
	OSType			ioFileCreator;
	OSType			ioFileType;
	long			ioFiller3;
	long			ioDTLgLen;
	long			ioDTPyLen;
	short			ioFiller4[14];
	long			ioAPPLParID;
};
typedef struct DTPBRec DTPBRec;

typedef DTPBRec *DTPBPtr;

struct ForeignPrivParam {
	QElemPtr			qLink;
	short			qType;
	short			ioTrap;
	Ptr			ioCmdAddr;
	IOCompletionUPP			ioCompletion;
	OSErr			ioResult;
	StringPtr			ioNamePtr;
	short			ioVRefNum;
	long			ioFiller1;
	long			ioFiller2;
	Ptr			ioForeignPrivBuffer;
	long			ioForeignPrivActCount;
	long			ioForeignPrivReqCount;
	long			ioFiller3;
	long			ioForeignPrivDirID;
	long			ioForeignPrivInfo1;
	long			ioForeignPrivInfo2;
	long			ioForeignPrivInfo3;
	long			ioForeignPrivInfo4;
};
typedef struct ForeignPrivParam ForeignPrivParam;

typedef ForeignPrivParam *ForeignPrivParamPtr;

union HParamBlockRec {
	HIOParam			ioParam;
	HFileParam			fileParam;
	HVolumeParam			volumeParam;
	AccessParam			accessParam;
	ObjParam			objParam;
	CopyParam			copyParam;
	WDParam			wdParam;
	FIDParam			fidParam;
	CSParam			csParam;
	ForeignPrivParam			foreignPrivParam;
};
typedef union HParamBlockRec HParamBlockRec;

typedef HParamBlockRec *HParmBlkPtr;

struct CMovePBRec {
	QElemPtr			qLink;
	short			qType;
	short			ioTrap;
	Ptr			ioCmdAddr;
	IOCompletionUPP			ioCompletion;
	OSErr			ioResult;
	StringPtr			ioNamePtr;
	short			ioVRefNum;
	long			filler1;
	StringPtr			ioNewName;
	long			filler2;
	long			ioNewDirID;
	long			filler3[2];
	long			ioDirID;
};
typedef struct CMovePBRec CMovePBRec;

typedef CMovePBRec *CMovePBPtr;

struct WDPBRec {
	QElemPtr			qLink;
	short			qType;
	short			ioTrap;
	Ptr			ioCmdAddr;
	IOCompletionUPP			ioCompletion;
	OSErr			ioResult;
	StringPtr			ioNamePtr;
	short			ioVRefNum;
	short			filler1;
	short			ioWDIndex;
	long			ioWDProcID;
	short			ioWDVRefNum;
	short			filler2[7];
	long			ioWDDirID;
};
typedef struct WDPBRec WDPBRec;

typedef WDPBRec *WDPBPtr;

struct FCBPBRec {
	QElemPtr			qLink;
	short			qType;
	short			ioTrap;
	Ptr			ioCmdAddr;
	IOCompletionUPP			ioCompletion;
	OSErr			ioResult;
	StringPtr			ioNamePtr;
	short			ioVRefNum;
	short			ioRefNum;
	short			filler;
	short			ioFCBIndx;
	short			filler1;
	long			ioFCBFlNm;
	short			ioFCBFlags;
	unsigned short			ioFCBStBlk;
	long			ioFCBEOF;
	long			ioFCBPLen;
	long			ioFCBCrPs;
	short			ioFCBVRefNum;
	long			ioFCBClpSiz;
	long			ioFCBParID;
};
typedef struct FCBPBRec FCBPBRec;

typedef FCBPBRec *FCBPBPtr;

struct VCB {
	QElemPtr			qLink;
	short			qType;
	short			vcbFlags;
	unsigned short			vcbSigWord;
	unsigned long			vcbCrDate;
	unsigned long			vcbLsMod;
	short			vcbAtrb;
	unsigned short			vcbNmFls;
	short			vcbVBMSt;
	short			vcbAllocPtr;
	unsigned short			vcbNmAlBlks;
	long			vcbAlBlkSiz;
	long			vcbClpSiz;
	short			vcbAlBlSt;
	long			vcbNxtCNID;
	unsigned short			vcbFreeBks;
	Str27			vcbVN;
	short			vcbDrvNum;
	short			vcbDRefNum;
	short			vcbFSID;
	short			vcbVRefNum;
	Ptr			vcbMAdr;
	Ptr			vcbBufAdr;
	short			vcbMLen;
	short			vcbDirIndex;
	short			vcbDirBlk;
	unsigned long			vcbVolBkUp;
	unsigned short			vcbVSeqNum;
	long			vcbWrCnt;
	long			vcbXTClpSiz;
	long			vcbCTClpSiz;
	unsigned short			vcbNmRtDirs;
	long			vcbFilCnt;
	long			vcbDirCnt;
	long			vcbFndrInfo[8];
	unsigned short			vcbVCSize;
	unsigned short			vcbVBMCSiz;
	unsigned short			vcbCtlCSiz;
	unsigned short			vcbXTAlBlks;
	unsigned short			vcbCTAlBlks;
	short			vcbXTRef;
	short			vcbCTRef;
	Ptr			vcbCtlBuf;
	long			vcbDirIDM;
	short			vcbOffsM;
};
typedef struct VCB VCB;

struct DrvQEl {
	QElemPtr			qLink;
	short			qType;
	short			dQDrive;
	short			dQRefNum;
	short			dQFSID;
	unsigned short			dQDrvSz;
	unsigned short			dQDrvSz2;
};
typedef struct DrvQEl DrvQEl;

typedef DrvQEl *DrvQElPtr;

#ifdef __cplusplus
extern "C" {
#endif

#define PBOpen(pb, async) ((async) ? PBOpenAsync(pb) : PBOpenSync(pb))


extern OSErr pascal PBOpenSync(ParmBlkPtr paramBlock);

extern OSErr pascal PBOpenAsync(ParmBlkPtr paramBlock);

extern OSErr pascal PBOpenImmed(ParmBlkPtr paramBlock);
#define PBClose(pb, async) ((async) ? PBCloseAsync(pb) : PBCloseSync(pb))


extern OSErr pascal PBCloseSync(ParmBlkPtr paramBlock);

extern OSErr pascal PBCloseAsync(ParmBlkPtr paramBlock);

extern OSErr pascal PBCloseImmed(ParmBlkPtr paramBlock);
#define PBRead(pb, async) ((async) ? PBReadAsync(pb) : PBReadSync(pb))


extern OSErr pascal PBReadSync(ParmBlkPtr paramBlock);

extern OSErr pascal PBReadAsync(ParmBlkPtr paramBlock);

extern OSErr pascal PBReadImmed(ParmBlkPtr paramBlock);
#define PBWrite(pb, async) ((async) ? PBWriteAsync(pb) : PBWriteSync(pb))


extern OSErr pascal PBWriteSync(ParmBlkPtr paramBlock);

extern OSErr pascal PBWriteAsync(ParmBlkPtr paramBlock);

extern OSErr pascal PBWriteImmed(ParmBlkPtr paramBlock);
#define PBGetVInfo(pb, async) ((async) ? PBGetVInfoAsync(pb) : PBGetVInfoSync(pb))


extern OSErr pascal PBGetVInfoSync(ParmBlkPtr paramBlock);

extern OSErr pascal PBGetVInfoAsync(ParmBlkPtr paramBlock);
#define PBGetVol(pb, async) ((async) ? PBGetVolAsync(pb) : PBGetVolSync(pb))


extern OSErr pascal PBGetVolSync(ParmBlkPtr paramBlock);

extern OSErr pascal PBGetVolAsync(ParmBlkPtr paramBlock);
#define PBSetVol(pb, async) ((async) ? PBSetVolAsync(pb) : PBSetVolSync(pb))


extern OSErr pascal PBSetVolSync(ParmBlkPtr paramBlock);

extern OSErr pascal PBSetVolAsync(ParmBlkPtr paramBlock);
#define PBFlushVol(pb, async) ((async) ? PBFlushVolAsync(pb) : PBFlushVolSync(pb))


extern OSErr pascal PBFlushVolSync(ParmBlkPtr paramBlock);

extern OSErr pascal PBFlushVolAsync(ParmBlkPtr paramBlock);
#define PBCreate(pb, async) ((async) ? PBCreateAsync(pb) : PBCreateSync(pb))


extern OSErr pascal PBCreateSync(ParmBlkPtr paramBlock);

extern OSErr pascal PBCreateAsync(ParmBlkPtr paramBlock);
#define PBDelete(pb, async) ((async) ? PBDeleteAsync(pb) : PBDeleteSync(pb))


extern OSErr pascal PBDeleteSync(ParmBlkPtr paramBlock);

extern OSErr pascal PBDeleteAsync(ParmBlkPtr paramBlock);
#define PBOpenDF(pb, async) ((async) ? PBOpenDFAsync(pb) : PBOpenDFSync(pb))


extern OSErr pascal PBOpenDFSync(ParmBlkPtr paramBlock);

extern OSErr pascal PBOpenDFAsync(ParmBlkPtr paramBlock);
#define PBOpenRF(pb, async) ((async) ? PBOpenRFAsync(pb) : PBOpenRFSync(pb))


extern OSErr pascal PBOpenRFSync(ParmBlkPtr paramBlock);

extern OSErr pascal PBOpenRFAsync(ParmBlkPtr paramBlock);
#define PBRename(pb, async) ((async) ? PBRenameAsync(pb) : PBRenameSync(pb))


extern OSErr pascal PBRenameSync(ParmBlkPtr paramBlock);

extern OSErr pascal PBRenameAsync(ParmBlkPtr paramBlock);
#define PBGetFInfo(pb, async) ((async) ? PBGetFInfoAsync(pb) : PBGetFInfoSync(pb))


extern OSErr pascal PBGetFInfoSync(ParmBlkPtr paramBlock);

extern OSErr pascal PBGetFInfoAsync(ParmBlkPtr paramBlock);
#define PBSetFInfo(pb, async) ((async) ? PBSetFInfoAsync(pb) : PBSetFInfoSync(pb))


extern OSErr pascal PBSetFInfoSync(ParmBlkPtr paramBlock);

extern OSErr pascal PBSetFInfoAsync(ParmBlkPtr paramBlock);
#define PBSetFLock(pb, async) ((async) ? PBSetFLockAsync(pb) : PBSetFLockSync(pb))


extern OSErr pascal PBSetFLockSync(ParmBlkPtr paramBlock);

extern OSErr pascal PBSetFLockAsync(ParmBlkPtr paramBlock);
#define PBRstFLock(pb, async) ((async) ? PBRstFLockAsync(pb) : PBRstFLockSync(pb))


extern OSErr pascal PBRstFLockSync(ParmBlkPtr paramBlock);

extern OSErr pascal PBRstFLockAsync(ParmBlkPtr paramBlock);
#define PBSetFVers(pb, async) ((async) ? PBSetFVersAsync(pb) : PBSetFVersSync(pb))


extern OSErr pascal PBSetFVersSync(ParmBlkPtr paramBlock);

extern OSErr pascal PBSetFVersAsync(ParmBlkPtr paramBlock);
#define PBAllocate(pb, async) ((async) ? PBAllocateAsync(pb) : PBAllocateSync(pb))


extern OSErr pascal PBAllocateSync(ParmBlkPtr paramBlock);

extern OSErr pascal PBAllocateAsync(ParmBlkPtr paramBlock);
#define PBGetEOF(pb, async) ((async) ? PBGetEOFAsync(pb) : PBGetEOFSync(pb))


extern OSErr pascal PBGetEOFSync(ParmBlkPtr paramBlock);

extern OSErr pascal PBGetEOFAsync(ParmBlkPtr paramBlock);
#define PBSetEOF(pb, async) ((async) ? PBSetEOFAsync(pb) : PBSetEOFSync(pb))


extern OSErr pascal PBSetEOFSync(ParmBlkPtr paramBlock);

extern OSErr pascal PBSetEOFAsync(ParmBlkPtr paramBlock);
#define PBGetFPos(pb, async) ((async) ? PBGetFPosAsync(pb) : PBGetFPosSync(pb))


extern OSErr pascal PBGetFPosSync(ParmBlkPtr paramBlock);

extern OSErr pascal PBGetFPosAsync(ParmBlkPtr paramBlock);
#define PBSetFPos(pb, async) ((async) ? PBSetFPosAsync(pb) : PBSetFPosSync(pb))


extern OSErr pascal PBSetFPosSync(ParmBlkPtr paramBlock);

extern OSErr pascal PBSetFPosAsync(ParmBlkPtr paramBlock);
#define PBFlushFile(pb, async) ((async) ? PBFlushFileAsync(pb) : PBFlushFileSync(pb))


extern OSErr pascal PBFlushFileSync(ParmBlkPtr paramBlock);

extern OSErr pascal PBFlushFileAsync(ParmBlkPtr paramBlock);

extern OSErr pascal PBMountVol(ParmBlkPtr paramBlock);

extern OSErr pascal PBUnmountVol(ParmBlkPtr paramBlock);

extern OSErr pascal PBEject(ParmBlkPtr paramBlock);

extern OSErr pascal PBOffLine(ParmBlkPtr paramBlock);
#define PBCatSearch(pb, async) ((async) ? PBCatSearchAsync(pb) : PBCatSearchSync(pb))


extern OSErr pascal PBCatSearchSync(CSParamPtr paramBlock);

extern OSErr pascal PBCatSearchAsync(CSParamPtr paramBlock);
extern void pascal AddDrive(short drvrRefNum, short drvNum, DrvQElPtr qEl);
extern OSErr pascal FSOpen(ConstStr255Param fileName, short vRefNum, short *refNum);
extern OSErr pascal OpenDF(ConstStr255Param fileName, short vRefNum, short *refNum);
extern OSErr fsopen(char *fileName, short vRefNum, short *refNum);
extern OSErr pascal FSClose(short refNum);
extern OSErr pascal FSRead(short refNum, long *count, void *buffPtr);
extern OSErr pascal FSWrite(short refNum, long *count, const void *buffPtr);
extern OSErr pascal GetVInfo(short drvNum, StringPtr volName, short *vRefNum, long *freeBytes);
extern OSErr getvinfo(short drvNum, char *volName, short *vRefNum, long *freeBytes);
extern OSErr pascal GetFInfo(ConstStr255Param fileName, short vRefNum, FInfo *fndrInfo);
extern OSErr getfinfo(char *fileName, short vRefNum, FInfo *fndrInfo);
extern OSErr pascal GetVol(StringPtr volName, short *vRefNum);
extern OSErr getvol(char *volName, short *vRefNum);
extern OSErr pascal SetVol(StringPtr volName, short vRefNum);
extern OSErr setvol(char *volName, short vRefNum);
extern OSErr pascal UnmountVol(StringPtr volName, short vRefNum);
extern OSErr unmountvol(char *volName, short vRefNum);
extern OSErr pascal Eject(StringPtr volName, short vRefNum);
extern OSErr eject(char *volName, short vRefNum);
// DDK 980223: Changed StringPtr to ConstStr63Param
extern OSErr pascal FlushVol(ConstStr63Param volName, short vRefNum);
extern OSErr flushvol(char *volName, short vRefNum);
extern OSErr pascal Create(ConstStr255Param fileName, short vRefNum, OSType creator, OSType fileType);
extern OSErr create(char *fileName, short vRefNum, OSType creator, OSType fileType);
extern OSErr pascal FSDelete(ConstStr255Param fileName, short vRefNum);
extern OSErr fsdelete(char *fileName, short vRefNum);
extern OSErr pascal OpenRF(ConstStr255Param fileName, short vRefNum, short *refNum);
extern OSErr openrf(char *fileName, short vRefNum, short *refNum);
extern OSErr pascal Rename(ConstStr255Param oldName, short vRefNum, ConstStr255Param newName);
extern OSErr fsrename(char *oldName, short vRefNum, char *newName);
extern OSErr pascal SetFInfo(ConstStr255Param fileName, short vRefNum, const FInfo *fndrInfo);
extern OSErr setfinfo(char *fileName, short vRefNum, FInfo *fndrInfo);
extern OSErr pascal SetFLock(ConstStr255Param fileName, short vRefNum);
extern OSErr setflock(char *fileName, short vRefNum);
extern OSErr pascal RstFLock(ConstStr255Param fileName, short vRefNum);
extern OSErr rstflock(char *fileName, short vRefNum);
extern OSErr pascal Allocate(short refNum, long *count);
extern OSErr pascal GetEOF(short refNum, long *logEOF);
extern OSErr pascal SetEOF(short refNum, long logEOF);
extern OSErr pascal GetFPos(short refNum, long *filePos);
extern OSErr pascal SetFPos(short refNum, short posMode, long posOff);
extern OSErr pascal GetVRefNum(short fileRefNum, short *vRefNum);
#define PBOpenWD(pb, async) ((async) ? PBOpenWDAsync(pb) : PBOpenWDSync(pb))


extern OSErr pascal PBOpenWDSync(WDPBPtr paramBlock);

extern OSErr pascal PBOpenWDAsync(WDPBPtr paramBlock);
#define PBCloseWD(pb, async) ((async) ? PBCloseWDAsync(pb) : PBCloseWDSync(pb))


extern OSErr pascal PBCloseWDSync(WDPBPtr paramBlock);

extern OSErr pascal PBCloseWDAsync(WDPBPtr paramBlock);
#define PBHSetVol(pb, async) ((async) ? PBHSetVolAsync(pb) : PBHSetVolSync(pb))


extern OSErr pascal PBHSetVolSync(WDPBPtr paramBlock);

extern OSErr pascal PBHSetVolAsync(WDPBPtr paramBlock);
#define PBHGetVol(pb, async) ((async) ? PBHGetVolAsync(pb) : PBHGetVolSync(pb))


extern OSErr pascal PBHGetVolSync(WDPBPtr paramBlock);

extern OSErr pascal PBHGetVolAsync(WDPBPtr paramBlock);
#define PBCatMove(pb, async) ((async) ? PBCatMoveAsync(pb) : PBCatMoveSync(pb))


extern OSErr pascal PBCatMoveSync(CMovePBPtr paramBlock);

extern OSErr pascal PBCatMoveAsync(CMovePBPtr paramBlock);
#define PBDirCreate(pb, async) ((async) ? PBDirCreateAsync(pb) : PBDirCreateSync(pb))


extern OSErr pascal PBDirCreateSync(HParmBlkPtr paramBlock);

extern OSErr pascal PBDirCreateAsync(HParmBlkPtr paramBlock);
#define PBGetWDInfo(pb, async) ((async) ? PBGetWDInfoAsync(pb) : PBGetWDInfoSync(pb))


extern OSErr pascal PBGetWDInfoSync(WDPBPtr paramBlock);

extern OSErr pascal PBGetWDInfoAsync(WDPBPtr paramBlock);
#define PBGetFCBInfo(pb, async) ((async) ? PBGetFCBInfoAsync(pb) : PBGetFCBInfoSync(pb))


extern OSErr pascal PBGetFCBInfoSync(FCBPBPtr paramBlock);

extern OSErr pascal PBGetFCBInfoAsync(FCBPBPtr paramBlock);
#define PBGetCatInfo(pb, async) ((async) ? PBGetCatInfoAsync(pb) : PBGetCatInfoSync(pb))


extern OSErr pascal PBGetCatInfoSync(CInfoPBPtr paramBlock);

extern OSErr pascal PBGetCatInfoAsync(CInfoPBPtr paramBlock);
#define PBSetCatInfo(pb, async) ((async) ? PBSetCatInfoAsync(pb) : PBSetCatInfoSync(pb))


extern OSErr pascal PBSetCatInfoSync(CInfoPBPtr paramBlock);

extern OSErr pascal PBSetCatInfoAsync(CInfoPBPtr paramBlock);
#define PBAllocContig(pb, async) ((async) ? PBAllocContigAsync(pb) : PBAllocContigSync(pb))


extern OSErr pascal PBAllocContigSync(ParmBlkPtr paramBlock);

extern OSErr pascal PBAllocContigAsync(ParmBlkPtr paramBlock);
#define PBLockRange(pb, async) ((async) ? PBLockRangeAsync(pb) : PBLockRangeSync(pb))


extern OSErr pascal PBLockRangeSync(ParmBlkPtr paramBlock);

extern OSErr pascal PBLockRangeAsync(ParmBlkPtr paramBlock);
#define PBUnlockRange(pb, async) ((async) ? PBUnlockRangeAsync(pb) : PBUnlockRangeSync(pb))


extern OSErr pascal PBUnlockRangeSync(ParmBlkPtr paramBlock);

extern OSErr pascal PBUnlockRangeAsync(ParmBlkPtr paramBlock);
#define PBSetVInfo(pb, async) ((async) ? PBSetVInfoAsync(pb) : PBSetVInfoSync(pb))


extern OSErr pascal PBSetVInfoSync(HParmBlkPtr paramBlock);

extern OSErr pascal PBSetVInfoAsync(HParmBlkPtr paramBlock);
#define PBHGetVInfo(pb, async) ((async) ? PBHGetVInfoAsync(pb) : PBHGetVInfoSync(pb))


extern OSErr pascal PBHGetVInfoSync(HParmBlkPtr paramBlock);

extern OSErr pascal PBHGetVInfoAsync(HParmBlkPtr paramBlock);
#define PBHOpen(pb, async) ((async) ? PBHOpenAsync(pb) : PBHOpenSync(pb))


extern OSErr pascal PBHOpenSync(HParmBlkPtr paramBlock);

extern OSErr pascal PBHOpenAsync(HParmBlkPtr paramBlock);
#define PBHOpenRF(pb, async) ((async) ? PBHOpenRFAsync(pb) : PBHOpenRFSync(pb))


extern OSErr pascal PBHOpenRFSync(HParmBlkPtr paramBlock);

extern OSErr pascal PBHOpenRFAsync(HParmBlkPtr paramBlock);
#define PBHOpenDF(pb, async) ((async) ? PBHOpenDFAsync(pb) : PBHOpenDFSync(pb))


extern OSErr pascal PBHOpenDFSync(HParmBlkPtr paramBlock);

extern OSErr pascal PBHOpenDFAsync(HParmBlkPtr paramBlock);
#define PBHCreate(pb, async) ((async) ? PBHCreateAsync(pb) : PBHCreateSync(pb))


extern OSErr pascal PBHCreateSync(HParmBlkPtr paramBlock);

extern OSErr pascal PBHCreateAsync(HParmBlkPtr paramBlock);
#define PBHDelete(pb, async) ((async) ? PBHDeleteAsync(pb) : PBHDeleteSync(pb))


extern OSErr pascal PBHDeleteSync(HParmBlkPtr paramBlock);

extern OSErr pascal PBHDeleteAsync(HParmBlkPtr paramBlock);
#define PBHRename(pb, async) ((async) ? PBHRenameAsync(pb) : PBHRenameSync(pb))


extern OSErr pascal PBHRenameSync(HParmBlkPtr paramBlock);

extern OSErr pascal PBHRenameAsync(HParmBlkPtr paramBlock);
#define PBHRstFLock(pb, async) ((async) ? PBHRstFLockAsync(pb) : PBHRstFLockSync(pb))


extern OSErr pascal PBHRstFLockSync(HParmBlkPtr paramBlock);

extern OSErr pascal PBHRstFLockAsync(HParmBlkPtr paramBlock);
#define PBHSetFLock(pb, async) ((async) ? PBHSetFLockAsync(pb) : PBHSetFLockSync(pb))


extern OSErr pascal PBHSetFLockSync(HParmBlkPtr paramBlock);

extern OSErr pascal PBHSetFLockAsync(HParmBlkPtr paramBlock);
#define PBHGetFInfo(pb, async) ((async) ? PBHGetFInfoAsync(pb) : PBHGetFInfoSync(pb))


extern OSErr pascal PBHGetFInfoSync(HParmBlkPtr paramBlock);

extern OSErr pascal PBHGetFInfoAsync(HParmBlkPtr paramBlock);
#define PBHSetFInfo(pb, async) ((async) ? PBHSetFInfoAsync(pb) : PBHSetFInfoSync(pb))


extern OSErr pascal PBHSetFInfoSync(HParmBlkPtr paramBlock);

extern OSErr pascal PBHSetFInfoAsync(HParmBlkPtr paramBlock);
#define PBMakeFSSpec(pb, async) ((async) ? PBMakeFSSpecAsync(pb) : PBMakeFSSpecSync(pb))


extern OSErr pascal PBMakeFSSpecSync(HParmBlkPtr paramBlock);

extern OSErr pascal PBMakeFSSpecAsync(HParmBlkPtr paramBlock);
extern void pascal FInitQueue(void);
#if USESCODEFRAGMENTS
extern QHdrPtr pascal GetFSQHdr(void);
extern QHdrPtr pascal GetDrvQHdr(void);
extern QHdrPtr pascal GetVCBQHdr(void);
#else
#define GetFSQHdr() ((QHdrPtr) 0x0360)

#define GetDrvQHdr() ((QHdrPtr) 0x0308)

#define GetVCBQHdr() ((QHdrPtr) 0x0356)

#endif

extern OSErr pascal HGetVol(StringPtr volName, short *vRefNum, long *dirID);
extern OSErr pascal HSetVol(StringPtr volName, short vRefNum, long dirID);
extern OSErr pascal HOpen(short vRefNum, long dirID, ConstStr255Param fileName, char permission, short *refNum);
extern OSErr pascal HOpenDF(short vRefNum, long dirID, ConstStr255Param fileName, char permission, short *refNum);
extern OSErr pascal HOpenRF(short vRefNum, long dirID, ConstStr255Param fileName, char permission, short *refNum);
extern OSErr pascal AllocContig(short refNum, long *count);
extern OSErr pascal HCreate(short vRefNum, long dirID, ConstStr255Param fileName, OSType creator, OSType fileType);
extern OSErr pascal DirCreate(short vRefNum, long parentDirID, ConstStr255Param directoryName, long *createdDirID);
extern OSErr pascal HDelete(short vRefNum, long dirID, ConstStr255Param fileName);
extern OSErr pascal HGetFInfo(short vRefNum, long dirID, ConstStr255Param fileName, FInfo *fndrInfo);
extern OSErr pascal HSetFInfo(short vRefNum, long dirID, ConstStr255Param fileName, const FInfo *fndrInfo);
extern OSErr pascal HSetFLock(short vRefNum, long dirID, ConstStr255Param fileName);
extern OSErr pascal HRstFLock(short vRefNum, long dirID, ConstStr255Param fileName);
extern OSErr pascal HRename(short vRefNum, long dirID, ConstStr255Param oldName, ConstStr255Param newName);
extern OSErr pascal CatMove(short vRefNum, long dirID, ConstStr255Param oldName, long newDirID, ConstStr255Param newName);
extern OSErr pascal OpenWD(short vRefNum, long dirID, long procID, short *wdRefNum);
extern OSErr pascal CloseWD(short wdRefNum);
extern OSErr pascal GetWDInfo(short wdRefNum, short *vRefNum, long *dirID, long *procID);

/*  shared environment  */

#define PBHGetVolParms(pb, async) ((async) ? PBHGetVolParmsAsync(pb) : PBHGetVolParmsSync(pb))


extern OSErr pascal PBHGetVolParmsSync(HParmBlkPtr paramBlock);

extern OSErr pascal PBHGetVolParmsAsync(HParmBlkPtr paramBlock);
#define PBHGetLogInInfo(pb, async) ((async) ? PBHGetLogInInfoAsync(pb) : PBHGetLogInInfoSync(pb))


extern OSErr pascal PBHGetLogInInfoSync(HParmBlkPtr paramBlock);

extern OSErr pascal PBHGetLogInInfoAsync(HParmBlkPtr paramBlock);
#define PBHGetDirAccess(pb, async) ((async) ? PBHGetDirAccessAsync(pb) : PBHGetDirAccessSync(pb))


extern OSErr pascal PBHGetDirAccessSync(HParmBlkPtr paramBlock);

extern OSErr pascal PBHGetDirAccessAsync(HParmBlkPtr paramBlock);
#define PBHSetDirAccess(pb, async) ((async) ? PBHSetDirAccessAsync(pb) : PBHSetDirAccessSync(pb))


extern OSErr pascal PBHSetDirAccessSync(HParmBlkPtr paramBlock);

extern OSErr pascal PBHSetDirAccessAsync(HParmBlkPtr paramBlock);
#define PBHMapID(pb, async) ((async) ? PBHMapIDAsync(pb) : PBHMapIDSync(pb))


extern OSErr pascal PBHMapIDSync(HParmBlkPtr paramBlock);

extern OSErr pascal PBHMapIDAsync(HParmBlkPtr paramBlock);
#define PBHMapName(pb, async) ((async) ? PBHMapNameAsync(pb) : PBHMapNameSync(pb))


extern OSErr pascal PBHMapNameSync(HParmBlkPtr paramBlock);

extern OSErr pascal PBHMapNameAsync(HParmBlkPtr paramBlock);
#define PBHCopyFile(pb, async) ((async) ? PBHCopyFileAsync(pb) : PBHCopyFileSync(pb))


extern OSErr pascal PBHCopyFileSync(HParmBlkPtr paramBlock);

extern OSErr pascal PBHCopyFileAsync(HParmBlkPtr paramBlock);
#define PBHMoveRename(pb, async) ((async) ? PBHMoveRenameAsync(pb) : PBHMoveRenameSync(pb))


extern OSErr pascal PBHMoveRenameSync(HParmBlkPtr paramBlock);

extern OSErr pascal PBHMoveRenameAsync(HParmBlkPtr paramBlock);
#define PBHOpenDeny(pb, async) ((async) ? PBHOpenDenyAsync(pb) : PBHOpenDenySync(pb))


extern OSErr pascal PBHOpenDenySync(HParmBlkPtr paramBlock);

extern OSErr pascal PBHOpenDenyAsync(HParmBlkPtr paramBlock);
#define PBHOpenRFDeny(pb, async) ((async) ? PBHOpenRFDenyAsync(pb) : PBHOpenRFDenySync(pb))


extern OSErr pascal PBHOpenRFDenySync(HParmBlkPtr paramBlock);

extern OSErr pascal PBHOpenRFDenyAsync(HParmBlkPtr paramBlock);
#define PBExchangeFiles(pb, async) ((async) ? PBExchangeFilesAsync(pb) : PBExchangeFilesSync(pb))


extern OSErr pascal PBExchangeFilesSync(HParmBlkPtr paramBlock);

extern OSErr pascal PBExchangeFilesAsync(HParmBlkPtr paramBlock);
#define PBCreateFileIDRef(pb, async) ((async) ? PBCreateFileIDRefAsync(pb) : PBCreateFileIDRefSync(pb))


extern OSErr pascal PBCreateFileIDRefSync(HParmBlkPtr paramBlock);

extern OSErr pascal PBCreateFileIDRefAsync(HParmBlkPtr paramBlock);
#define PBResolveFileIDRef(pb, async) ((async) ? PBResolveFileIDRefAsync(pb) : PBResolveFileIDRefSync(pb))


extern OSErr pascal PBResolveFileIDRefSync(HParmBlkPtr paramBlock);

extern OSErr pascal PBResolveFileIDRefAsync(HParmBlkPtr paramBlock);
#define PBDeleteFileIDRef(pb, async) ((async) ? PBDeleteFileIDRefAsync(pb) : PBDeleteFileIDRefSync(pb))


extern OSErr pascal PBDeleteFileIDRefSync(HParmBlkPtr paramBlock);

extern OSErr pascal PBDeleteFileIDRefAsync(HParmBlkPtr paramBlock);
#define PBGetForeignPrivs(pb, async) ((async) ? PBGetForeignPrivsAsync(pb) : PBGetForeignPrivsSync(pb))


extern OSErr pascal PBGetForeignPrivsSync(HParmBlkPtr paramBlock);

extern OSErr pascal PBGetForeignPrivsAsync(HParmBlkPtr paramBlock);
#define PBSetForeignPrivs(pb, async) ((async) ? PBSetForeignPrivsAsync(pb) : PBSetForeignPrivsSync(pb))


extern OSErr pascal PBSetForeignPrivsSync(HParmBlkPtr paramBlock);

extern OSErr pascal PBSetForeignPrivsAsync(HParmBlkPtr paramBlock);

/*  Desktop Manager  */


extern OSErr pascal PBDTGetPath(DTPBPtr paramBlock);

extern OSErr pascal PBDTCloseDown(DTPBPtr paramBlock);
#define PBDTAddIcon(pb, async) ((async) ? PBDTAddIconAsync(pb) : PBDTAddIconSync(pb))


extern OSErr pascal PBDTAddIconSync(DTPBPtr paramBlock);

extern OSErr pascal PBDTAddIconAsync(DTPBPtr paramBlock);
#define PBDTGetIcon(pb, async) ((async) ? PBDTGetIconAsync(pb) : PBDTGetIconSync(pb))


extern OSErr pascal PBDTGetIconSync(DTPBPtr paramBlock);

extern OSErr pascal PBDTGetIconAsync(DTPBPtr paramBlock);
#define PBDTGetIconInfo(pb, async) ((async) ? PBDTGetIconInfoAsync(pb) : PBDTGetIconInfoSync(pb))


extern OSErr pascal PBDTGetIconInfoSync(DTPBPtr paramBlock);

extern OSErr pascal PBDTGetIconInfoAsync(DTPBPtr paramBlock);
#define PBDTAddAPPL(pb, async) ((async) ? PBDTAddAPPLAsync(pb) : PBDTAddAPPLSync(pb))


extern OSErr pascal PBDTAddAPPLSync(DTPBPtr paramBlock);

extern OSErr pascal PBDTAddAPPLAsync(DTPBPtr paramBlock);
#define PBDTRemoveAPPL(pb, async) ((async) ? PBDTRemoveAPPLAsync(pb) : PBDTRemoveAPPLSync(pb))


extern OSErr pascal PBDTRemoveAPPLSync(DTPBPtr paramBlock);

extern OSErr pascal PBDTRemoveAPPLAsync(DTPBPtr paramBlock);
#define PBDTGetAPPL(pb, async) ((async) ? PBDTGetAPPLAsync(pb) : PBDTGetAPPLSync(pb))


extern OSErr pascal PBDTGetAPPLSync(DTPBPtr paramBlock);

extern OSErr pascal PBDTGetAPPLAsync(DTPBPtr paramBlock);
#define PBDTSetComment(pb, async) ((async) ? PBDTSetCommentAsync(pb) : PBDTSetCommentSync(pb))


extern OSErr pascal PBDTSetCommentSync(DTPBPtr paramBlock);

extern OSErr pascal PBDTSetCommentAsync(DTPBPtr paramBlock);
#define PBDTRemoveComment(pb, async) ((async) ? PBDTRemoveCommentAsync(pb) : PBDTRemoveCommentSync(pb))


extern OSErr pascal PBDTRemoveCommentSync(DTPBPtr paramBlock);

extern OSErr pascal PBDTRemoveCommentAsync(DTPBPtr paramBlock);
#define PBDTGetComment(pb, async) ((async) ? PBDTGetCommentAsync(pb) : PBDTGetCommentSync(pb))


extern OSErr pascal PBDTGetCommentSync(DTPBPtr paramBlock);

extern OSErr pascal PBDTGetCommentAsync(DTPBPtr paramBlock);
#define PBDTFlush(pb, async) ((async) ? PBDTFlushAsync(pb) : PBDTFlushSync(pb))


extern OSErr pascal PBDTFlushSync(DTPBPtr paramBlock);

extern OSErr pascal PBDTFlushAsync(DTPBPtr paramBlock);
#define PBDTReset(pb, async) ((async) ? PBDTResetAsync(pb) : PBDTResetSync(pb))


extern OSErr pascal PBDTResetSync(DTPBPtr paramBlock);

extern OSErr pascal PBDTResetAsync(DTPBPtr paramBlock);
#define PBDTGetInfo(pb, async) ((async) ? PBDTGetInfoAsync(pb) : PBDTGetInfoSync(pb))


extern OSErr pascal PBDTGetInfoSync(DTPBPtr paramBlock);

extern OSErr pascal PBDTGetInfoAsync(DTPBPtr paramBlock);

extern OSErr pascal PBDTOpenInform(DTPBPtr paramBlock);
#define PBDTDelete(pb, async) ((async) ? PBDTDeleteAsync(pb) : PBDTDeleteSync(pb))


extern OSErr pascal PBDTDeleteSync(DTPBPtr paramBlock);

extern OSErr pascal PBDTDeleteAsync(DTPBPtr paramBlock);

/*  VolumeMount traps  */


extern OSErr pascal PBGetVolMountInfoSize(ParmBlkPtr paramBlock);

extern OSErr pascal PBGetVolMountInfo(ParmBlkPtr paramBlock);

extern OSErr pascal PBVolumeMount(ParmBlkPtr paramBlock);

/*  FSp traps  */

extern OSErr pascal FSMakeFSSpec(short vRefNum, long dirID, ConstStr255Param fileName, FSSpecPtr spec);
extern OSErr pascal FSpOpenDF(const FSSpec *spec, char permission, short *refNum);
extern OSErr pascal FSpOpenRF(const FSSpec *spec, char permission, short *refNum);
extern OSErr pascal FSpCreate(const FSSpec *spec, OSType creator, OSType fileType, ScriptCode scriptTag);
extern OSErr pascal FSpDirCreate(const FSSpec *spec, ScriptCode scriptTag, long *createdDirID);
extern OSErr pascal FSpDelete(const FSSpec *spec);
extern OSErr pascal FSpGetFInfo(const FSSpec *spec, FInfo *fndrInfo);
extern OSErr pascal FSpSetFInfo(const FSSpec *spec, const FInfo *fndrInfo);
extern OSErr pascal FSpSetFLock(const FSSpec *spec);
extern OSErr pascal FSpRstFLock(const FSSpec *spec);
extern OSErr pascal FSpRename(const FSSpec *spec, ConstStr255Param newName);
extern OSErr pascal FSpCatMove(const FSSpec *source, const FSSpec *dest);
extern OSErr pascal FSpExchangeFiles(const FSSpec *source, const FSSpec *dest);

/*
	PBGetAltAccess and PBSetAltAccess are obsolete and will not be supported
	on PowerPC. Equivalent functionality is provided by the routines
	PBGetForeignPrivs and PBSetForeignPrivs.
*/

#if defined(OBSOLETE) && !defined(powerc) && !defined(__powerc)
#define PBGetAltAccess(pb, async) ((async) ? PBGetAltAccessAsync(pb) : PBGetAltAccessSync(pb))


extern OSErr pascal PBGetAltAccessSync(HParmBlkPtr paramBlock);

extern OSErr pascal PBGetAltAccessAsync(HParmBlkPtr paramBlock);
#define PBSetAltAccess(pb, async) ((async) ? PBSetAltAccessAsync(pb) : PBSetAltAccessSync(pb))


extern OSErr pascal PBSetAltAccessSync(HParmBlkPtr paramBlock);

extern OSErr pascal PBSetAltAccessAsync(HParmBlkPtr paramBlock);
#endif


extern OSErr pascal PBShareSync(CMovePBPtr paramBlock);

extern OSErr pascal PBShareAsync(CMovePBPtr paramBlock);

extern OSErr pascal PBUnshareSync(CMovePBPtr paramBlock);

extern OSErr pascal PBUnshareAsync(CMovePBPtr paramBlock);

extern OSErr pascal PBGetUGEntrySync(CMovePBPtr paramBlock);

extern OSErr pascal PBGetUGEntryAsync(CMovePBPtr paramBlock);
#if PRAGMA_STRUCT_ALIGN
	#pragma options align=reset
#elif PRAGMA_STRUCT_PACKPUSH
	#pragma pack(pop)
#elif PRAGMA_STRUCT_PACK
	#pragma pack()
#endif

#ifdef PRAGMA_IMPORT_OFF
#pragma import off
#elif PRAGMA_IMPORT
#pragma import reset
#endif
#ifdef __cplusplus
}
#endif

#if WINVER
#include "Files_PC.H"
#endif

#endif


