/*
	File:		FixMath.h

	Copyright:	 1984-1993 by Apple Computer, Inc., all rights reserved.

	WARNING
	This file was auto generated by the interfacer tool. Modifications
	must be made to the master file.

*/

#ifndef __FIXMATH__
#define __FIXMATH__

#ifndef __TYPES__
#include <MacTypes.H>
#endif

#define	fixed1			((long)0x00010000)
#define	fract1			((long)0x40000000)
#define	positiveInfinity	((long)0x7FFFFFFF)
#define	negativeInfinity	((long)0x80000000)

#ifdef __cplusplus
extern "C" {
#endif
#if PRAGMA_IMPORT
#pragma import on
#endif

#if PRAGMA_STRUCT_ALIGN
	#pragma options align=mac68k
#elif PRAGMA_STRUCT_PACKPUSH
	#pragma pack(push, 2)
#elif PRAGMA_STRUCT_PACK
	#pragma pack(2)
#endif

extern Fract pascal Fix2Frac(Fixed x);
extern long pascal Fix2Long(Fixed x);
extern Fixed pascal Long2Fix(long x);
extern Fixed pascal Frac2Fix(Fract x);
extern Fract pascal FracMul(Fract x, Fract y);
extern Fixed pascal FixDiv(Fixed x, Fixed y);
extern Fract pascal FracDiv(Fract x, Fract y);
extern Fract pascal FracSqrt(Fract x);
extern Fract pascal FracSin(Fixed x);
extern Fract pascal FracCos(Fixed x);
extern Fixed pascal FixATan2(long x, long y);
#if defined(powerc) || defined(__powerc)
extern wide *WideAdd(wide *target, const wide *source);
extern short WideCompare(const wide *target, const wide *source);
extern wide *WideNegate(wide *target);
extern wide *WideShift(wide *target, long shift);
extern unsigned long WideSquareRoot(const wide *source);
extern wide *WideSubtract(wide *target, const wide *source);
extern wide *WideMultiply(long multiplicand, long multiplier, wide *target);

/* returns the quotient */

extern long WideDivide(const wide *dividend, long divisor, long *remainder);

/* quotient replaces dividend */

extern wide *WideWideDivide(wide *dividend, long divisor, long *remainder);
extern wide *WideBitShift(wide *src, long shift);
#endif

#if defined(applec) && !defined(mc68881)
extern double_t pascal Frac2X(Fract x);
extern double_t pascal Fix2X(Fixed x);
extern Fixed pascal X2Fix(double_t x);
extern Fract pascal X2Frac(double_t x);
#else
extern double_t pascal Frac2X(Fract x);
extern double_t pascal Fix2X(Fixed x);
extern Fixed pascal X2Fix(double_t x);
extern Fract pascal X2Frac(double_t x);
#endif

#if PRAGMA_STRUCT_ALIGN
	#pragma options align=reset
#elif PRAGMA_STRUCT_PACKPUSH
	#pragma pack(pop)
#elif PRAGMA_STRUCT_PACK
	#pragma pack()
#endif

#ifdef PRAGMA_IMPORT_OFF
#pragma import off
#elif PRAGMA_IMPORT
#pragma import reset
#endif
#ifdef __cplusplus
}
#endif

#endif


