/*
	File:		Quickdraw.h

	Copyright:	 1984-1993 by Apple Computer, Inc., all rights reserved.

	WARNING
	This file was auto generated by the interfacer tool. Modifications
	must be made to the master file.

*/

#ifndef __QUICKDRAW__
#define __QUICKDRAW__

#ifndef __TYPES__
#include <MacTypes.H>
#endif

#ifndef __QUICKDRAWTEXT__
#include <QuickTxt.H>
#endif

enum  {
	invalColReq			= -1,			/*invalid color table request*/
/* transfer modes */
	srcCopy			= 0,			/*the 16 transfer modes*/
	srcOr			= 1,
	srcXor			= 2,
	srcBic			= 3,
	notSrcCopy			= 4,
	notSrcOr			= 5,
	notSrcXor			= 6,
	notSrcBic			= 7,
	patCopy			= 8,
	patOr			= 9,
	patXor			= 10,
	patBic			= 11,
	notPatCopy			= 12,
	notPatOr			= 13,
	notPatXor			= 14,
	notPatBic			= 15,
/* Special Text Transfer Mode */
	grayishTextOr			= 49,
/* Arithmetic transfer modes */
	blend			= 32,
	addPin			= 33
};

enum  {
	addOver			= 34,
	subPin			= 35,
	addMax			= 37,
	adMax			= 37,
	subOver			= 38,
	adMin			= 39,
	ditherCopy			= 64,
/* Transparent mode constant */
	transparent			= 36,
/* QuickDraw color separation constants */
	normalBit			= 0,			/*normal screen mapping*/
	inverseBit			= 1,			/*inverse screen mapping*/
	redBit			= 4,			/*RGB additive mapping*/
	greenBit			= 3,
	blueBit			= 2,
	cyanBit			= 8,			/*CMYBk subtractive mapping*/
	magentaBit			= 7,
	yellowBit			= 6,
	blackBit			= 5,
	blackColor			= 33,			/*colors expressed in these mappings*/
	whiteColor			= 30,
	redColor			= 205
};

enum  {
	greenColor			= 341,
	blueColor			= 409,
	cyanColor			= 273,
	magentaColor			= 137,
	yellowColor			= 69,
	picLParen			= 0,			/*standard picture comments*/
	picRParen			= 1,
	clutType			= 0,			/*0 if lookup table*/
	fixedType			= 1,			/*1 if fixed table*/
	directType			= 2,			/*2 if direct values*/
	gdDevType			= 0,			/*0 = monochrome 1 = color*/
	burstDevice			= 7
};

enum  {
	hasAuxMenuBar			= 6,			/* 1 if device has an aux menu bar on it */
	ext32Device			= 8,
	ramInit			= 10,			/*1 if initialized from 'scrn' resource*/
	mainScreen			= 11,			/* 1 if main screen */
	allInit			= 12,			/* 1 if all devices initialized */
	screenDevice			= 13,			/*1 if screen device [not used]*/
	noDriver			= 14,			/* 1 if no driver for this GDevice */
	screenActive			= 15,			/*1 if in use*/
	hiliteBit			= 7,			/*flag bit in HiliteMode (lowMem flag)*/
	pHiliteBit			= 0,			/*flag bit in HiliteMode used with BitClr procedure*/
	defQDColors			= 127,			/*resource ID of clut for default QDColors*/
/* pixel type */
	RGBDirect			= 16,			/* 16 & 32 bits/pixel pixelType value */
/* pmVersion values */
	baseAddr32			= 4,			/*pixmap base address is 32-bit address*/
	rgnOverflowErr			= -147,			/* Region accumulation failed. Resulting region may be currupt */
	insufficientStackErr		= -149			/* QuickDraw could not complete the operation */
};

enum {
	kQDGrafVerbFrame   = 0,
	kQDGrafVerbPaint   = 1,
	kQDGrafVerbErase   = 2,
	kQDGrafVerbInvert   = 3,
	kQDGrafVerbFill    = 4
};

#if OLDROUTINENAMES
enum  {
	frame = kQDGrafVerbFrame,
	paint = kQDGrafVerbPaint,
	erase = kQDGrafVerbErase,
	invert = kQDGrafVerbInvert,
	fill = kQDGrafVerbFill
};
#endif

typedef unsigned char GrafVerb;

enum  {
	chunky,
	chunkyPlanar,
	planar
};

typedef unsigned char PixelType;

typedef short Bits16[16];

#if PRAGMA_IMPORT
#pragma import on
#endif

#if PRAGMA_STRUCT_ALIGN
	#pragma options align=mac68k
#elif PRAGMA_STRUCT_PACKPUSH
	#pragma pack(push, 2)
#elif PRAGMA_STRUCT_PACK
	#pragma pack(2)
#endif

#pragma PRAGMA_PACK_1

/***************   IMPORTANT NOTE REGARDING PATTERN  **************************************
   Patterns were originally defined as:
		typedef unsigned char Pattern[8];
   The old array defintion of Pattern would cause 68000 based CPU's to crash in certain circum-
   stances. The new struct definition is safe, but may require source code changes to compile.
   Read the details in Appendix J of:
		"MPW E.T.O. #6 Latest Libraries/Interfaces"

   Developers were warned that they should stop using the dangerousPattern definition of
   patterns so most of them should no longer use them. We are finally removing this
   definition for good.
*********************************************************************************************/

struct Pattern {
	unsigned char			pat[8];
};
typedef struct Pattern Pattern;

typedef const Pattern *ConstPatternParam;

typedef Pattern *PatPtr;

typedef PatPtr *PatHandle;

typedef char QDByte, *QDPtr, **QDHandle;

typedef short QDErr;

enum  {
	singleDevicesBit			= 0,
	dontMatchSeedsBit			= 1,
	allDevicesBit			= 2
};

enum  {
	singleDevices			= 1 << singleDevicesBit,
	dontMatchSeeds			= 1 << dontMatchSeedsBit,
	allDevices			= 1 << allDevicesBit
};

typedef unsigned long DeviceLoopFlags;

struct BitMap {
	Ptr			baseAddr;
	short			rowBytes;
	Rect			bounds;
};
typedef struct BitMap BitMap;

typedef BitMap *BitMapPtr, **BitMapHandle;

struct Cursor {
	Bits16			data;
	Bits16			mask;
	Point			hotSpot;
};
typedef struct Cursor Cursor;

typedef Cursor *CursPtr, **CursHandle;

struct PenState {
	Point			pnLoc;
	Point			pnSize;
	short			pnMode;
	Pattern			pnPat;
};
typedef struct PenState PenState;

struct Region {
	short			rgnSize;			/*size in bytes*/
	Rect			rgnBBox;			/*enclosing rectangle*/
};
typedef struct Region Region;

typedef Region *RgnPtr, **RgnHandle;

struct Picture {
	short			picSize;
	Rect			picFrame;
};
typedef struct Picture Picture;

typedef Picture *PicPtr, **PicHandle;

struct Polygo {
	short			polySize;
	Rect			polyBBox;
	Point			polyPoints[1];
};
typedef struct Polygo Polygo;

typedef Polygo *PolyPtr, **PolyHandle;

typedef void (pascal *QDTextProcPtr)(short byteCount, Ptr textBuf, Point numer, Point denom);

enum {
	uppQDTextProcInfo = kPascalStackBased
		| STACK_ROUTINE_PARAMETER(1, SIZE_CODE(sizeof(short)))
		| STACK_ROUTINE_PARAMETER(2, SIZE_CODE(sizeof(Ptr)))
		| STACK_ROUTINE_PARAMETER(3, SIZE_CODE(sizeof(Point)))
		| STACK_ROUTINE_PARAMETER(4, SIZE_CODE(sizeof(Point)))
};

#if USESROUTINEDESCRIPTORS
typedef UniversalProcPtr QDTextUPP;

#define CallQDTextProc(userRoutine, byteCount, textBuf, numer, denom)		\
		CallUniversalProc((UniversalProcPtr)(userRoutine), uppQDTextProcInfo, (byteCount), (textBuf), (numer), (denom))
#define NewQDTextProc(userRoutine)		\
		(QDTextUPP) NewRoutineDescriptor((ProcPtr)(userRoutine), uppQDTextProcInfo, GetCurrentISA())
#else
typedef QDTextProcPtr QDTextUPP;

#define CallQDTextProc(userRoutine, byteCount, textBuf, numer, denom)		\
		(*(userRoutine))((byteCount), (textBuf), (numer), (denom))
#define NewQDTextProc(userRoutine)		\
		(QDTextUPP)(userRoutine)
#endif

typedef void (pascal *QDLineProcPtr)(Point newPt);

enum {
	uppQDLineProcInfo = kPascalStackBased
		| STACK_ROUTINE_PARAMETER(1, SIZE_CODE(sizeof(Point)))
};

#if USESROUTINEDESCRIPTORS
typedef UniversalProcPtr QDLineUPP;

#define CallQDLineProc(userRoutine, newPt)		\
		CallUniversalProc((UniversalProcPtr)(userRoutine), uppQDLineProcInfo, (newPt))
#define NewQDLineProc(userRoutine)		\
		(QDLineUPP) NewRoutineDescriptor((ProcPtr)(userRoutine), uppQDLineProcInfo, GetCurrentISA())
#else
typedef QDLineProcPtr QDLineUPP;

#define CallQDLineProc(userRoutine, newPt)		\
		(*(userRoutine))((newPt))
#define NewQDLineProc(userRoutine)		\
		(QDLineUPP)(userRoutine)
#endif

typedef void (pascal *QDRectProcPtr)(GrafVerb verb, Rect *r);

enum {
	uppQDRectProcInfo = kPascalStackBased
		| STACK_ROUTINE_PARAMETER(1, SIZE_CODE(sizeof(GrafVerb)))
		| STACK_ROUTINE_PARAMETER(2, SIZE_CODE(sizeof(Rect*)))
};

#if USESROUTINEDESCRIPTORS
typedef UniversalProcPtr QDRectUPP;

#define CallQDRectProc(userRoutine, verb, r)		\
		CallUniversalProc((UniversalProcPtr)(userRoutine), uppQDRectProcInfo, (verb), (r))
#define NewQDRectProc(userRoutine)		\
		(QDRectUPP) NewRoutineDescriptor((ProcPtr)(userRoutine), uppQDRectProcInfo, GetCurrentISA())
#else
typedef QDRectProcPtr QDRectUPP;

#define CallQDRectProc(userRoutine, verb, r)		\
		(*(userRoutine))((verb), (r))
#define NewQDRectProc(userRoutine)		\
		(QDRectUPP)(userRoutine)
#endif

typedef void (pascal *QDRRectProcPtr)(GrafVerb verb, Rect *r, short ovalWidth, short ovalHeight);

enum {
	uppQDRRectProcInfo = kPascalStackBased
		| STACK_ROUTINE_PARAMETER(1, SIZE_CODE(sizeof(GrafVerb)))
		| STACK_ROUTINE_PARAMETER(2, SIZE_CODE(sizeof(Rect*)))
		| STACK_ROUTINE_PARAMETER(3, SIZE_CODE(sizeof(short)))
		| STACK_ROUTINE_PARAMETER(4, SIZE_CODE(sizeof(short)))
};

#if USESROUTINEDESCRIPTORS
typedef UniversalProcPtr QDRRectUPP;

#define CallQDRRectProc(userRoutine, verb, r, ovalWidth, ovalHeight)		\
		CallUniversalProc((UniversalProcPtr)(userRoutine), uppQDRRectProcInfo, (verb), (r), (ovalWidth), (ovalHeight))
#define NewQDRRectProc(userRoutine)		\
		(QDRRectUPP) NewRoutineDescriptor((ProcPtr)(userRoutine), uppQDRRectProcInfo, GetCurrentISA())
#else
typedef QDRRectProcPtr QDRRectUPP;

#define CallQDRRectProc(userRoutine, verb, r, ovalWidth, ovalHeight)		\
		(*(userRoutine))((verb), (r), (ovalWidth), (ovalHeight))
#define NewQDRRectProc(userRoutine)		\
		(QDRRectUPP)(userRoutine)
#endif

typedef void (pascal *QDOvalProcPtr)(GrafVerb verb, Rect *r);

enum {
	uppQDOvalProcInfo = kPascalStackBased
		| STACK_ROUTINE_PARAMETER(1, SIZE_CODE(sizeof(GrafVerb)))
		| STACK_ROUTINE_PARAMETER(2, SIZE_CODE(sizeof(Rect*)))
};

#if USESROUTINEDESCRIPTORS
typedef UniversalProcPtr QDOvalUPP;

#define CallQDOvalProc(userRoutine, verb, r)		\
		CallUniversalProc((UniversalProcPtr)(userRoutine), uppQDOvalProcInfo, (verb), (r))
#define NewQDOvalProc(userRoutine)		\
		(QDOvalUPP) NewRoutineDescriptor((ProcPtr)(userRoutine), uppQDOvalProcInfo, GetCurrentISA())
#else
typedef QDOvalProcPtr QDOvalUPP;

#define CallQDOvalProc(userRoutine, verb, r)		\
		(*(userRoutine))((verb), (r))
#define NewQDOvalProc(userRoutine)		\
		(QDOvalUPP)(userRoutine)
#endif

typedef void (pascal *QDArcProcPtr)(GrafVerb verb, Rect *r, short startAngle, short arcAngle);

enum {
	uppQDArcProcInfo = kPascalStackBased
		| STACK_ROUTINE_PARAMETER(1, SIZE_CODE(sizeof(GrafVerb)))
		| STACK_ROUTINE_PARAMETER(2, SIZE_CODE(sizeof(Rect*)))
		| STACK_ROUTINE_PARAMETER(3, SIZE_CODE(sizeof(short)))
		| STACK_ROUTINE_PARAMETER(4, SIZE_CODE(sizeof(short)))
};

#if USESROUTINEDESCRIPTORS
typedef UniversalProcPtr QDArcUPP;

#define CallQDArcProc(userRoutine, verb, r, startAngle, arcAngle)		\
		CallUniversalProc((UniversalProcPtr)(userRoutine), uppQDArcProcInfo, (verb), (r), (startAngle), (arcAngle))
#define NewQDArcProc(userRoutine)		\
		(QDArcUPP) NewRoutineDescriptor((ProcPtr)(userRoutine), uppQDArcProcInfo, GetCurrentISA())
#else
typedef QDArcProcPtr QDArcUPP;

#define CallQDArcProc(userRoutine, verb, r, startAngle, arcAngle)		\
		(*(userRoutine))((verb), (r), (startAngle), (arcAngle))
#define NewQDArcProc(userRoutine)		\
		(QDArcUPP)(userRoutine)
#endif

typedef void (pascal *QDPolyProcPtr)(GrafVerb verb, PolyHandle poly);

enum {
	uppQDPolyProcInfo = kPascalStackBased
		| STACK_ROUTINE_PARAMETER(1, SIZE_CODE(sizeof(GrafVerb)))
		| STACK_ROUTINE_PARAMETER(2, SIZE_CODE(sizeof(PolyHandle)))
};

#if USESROUTINEDESCRIPTORS
typedef UniversalProcPtr QDPolyUPP;

#define CallQDPolyProc(userRoutine, verb, poly)		\
		CallUniversalProc((UniversalProcPtr)(userRoutine), uppQDPolyProcInfo, (verb), (poly))
#define NewQDPolyProc(userRoutine)		\
		(QDPolyUPP) NewRoutineDescriptor((ProcPtr)(userRoutine), uppQDPolyProcInfo, GetCurrentISA())
#else
typedef QDPolyProcPtr QDPolyUPP;

#define CallQDPolyProc(userRoutine, verb, poly)		\
		(*(userRoutine))((verb), (poly))
#define NewQDPolyProc(userRoutine)		\
		(QDPolyUPP)(userRoutine)
#endif

typedef void (pascal *QDRgnProcPtr)(GrafVerb verb, RgnHandle rgn);

enum {
	uppQDRgnProcInfo = kPascalStackBased
		| STACK_ROUTINE_PARAMETER(1, SIZE_CODE(sizeof(GrafVerb)))
		| STACK_ROUTINE_PARAMETER(2, SIZE_CODE(sizeof(RgnHandle)))
};

#if USESROUTINEDESCRIPTORS
typedef UniversalProcPtr QDRgnUPP;

#define CallQDRgnProc(userRoutine, verb, rgn)		\
		CallUniversalProc((UniversalProcPtr)(userRoutine), uppQDRgnProcInfo, (verb), (rgn))
#define NewQDRgnProc(userRoutine)		\
		(QDRgnUPP) NewRoutineDescriptor((ProcPtr)(userRoutine), uppQDRgnProcInfo, GetCurrentISA())
#else
typedef QDRgnProcPtr QDRgnUPP;

#define CallQDRgnProc(userRoutine, verb, rgn)		\
		(*(userRoutine))((verb), (rgn))
#define NewQDRgnProc(userRoutine)		\
		(QDRgnUPP)(userRoutine)
#endif

typedef void (pascal *QDBitsProcPtr)(BitMap *srcBits, Rect *srcRect, Rect *dstRect, short mode, RgnHandle maskRgn);

enum {
	uppQDBitsProcInfo = kPascalStackBased
		| STACK_ROUTINE_PARAMETER(1, SIZE_CODE(sizeof(BitMap*)))
		| STACK_ROUTINE_PARAMETER(2, SIZE_CODE(sizeof(Rect*)))
		| STACK_ROUTINE_PARAMETER(3, SIZE_CODE(sizeof(Rect*)))
		| STACK_ROUTINE_PARAMETER(4, SIZE_CODE(sizeof(short)))
		| STACK_ROUTINE_PARAMETER(5, SIZE_CODE(sizeof(RgnHandle)))
};

#if USESROUTINEDESCRIPTORS
typedef UniversalProcPtr QDBitsUPP;

#define CallQDBitsProc(userRoutine, srcBits, srcRect, dstRect, mode, maskRgn)		\
		CallUniversalProc((UniversalProcPtr)(userRoutine), uppQDBitsProcInfo, (srcBits), (srcRect), (dstRect), (mode), (maskRgn))
#define NewQDBitsProc(userRoutine)		\
		(QDBitsUPP) NewRoutineDescriptor((ProcPtr)(userRoutine), uppQDBitsProcInfo, GetCurrentISA())
#else
typedef QDBitsProcPtr QDBitsUPP;

#define CallQDBitsProc(userRoutine, srcBits, srcRect, dstRect, mode, maskRgn)		\
		(*(userRoutine))((srcBits), (srcRect), (dstRect), (mode), (maskRgn))
#define NewQDBitsProc(userRoutine)		\
		(QDBitsUPP)(userRoutine)
#endif

typedef void (pascal *QDCommentProcPtr)(short kind, short dataSize, Handle dataHandle);

enum {
	uppQDCommentProcInfo = kPascalStackBased
		| STACK_ROUTINE_PARAMETER(1, SIZE_CODE(sizeof(short)))
		| STACK_ROUTINE_PARAMETER(2, SIZE_CODE(sizeof(short)))
		| STACK_ROUTINE_PARAMETER(3, SIZE_CODE(sizeof(Handle)))
};

#if USESROUTINEDESCRIPTORS
typedef UniversalProcPtr QDCommentUPP;

#define CallQDCommentProc(userRoutine, kind, dataSize, dataHandle)		\
		CallUniversalProc((UniversalProcPtr)(userRoutine), uppQDCommentProcInfo, (kind), (dataSize), (dataHandle))
#define NewQDCommentProc(userRoutine)		\
		(QDCommentUPP) NewRoutineDescriptor((ProcPtr)(userRoutine), uppQDCommentProcInfo, GetCurrentISA())
#else
typedef QDCommentProcPtr QDCommentUPP;

#define CallQDCommentProc(userRoutine, kind, dataSize, dataHandle)		\
		(*(userRoutine))((kind), (dataSize), (dataHandle))
#define NewQDCommentProc(userRoutine)		\
		(QDCommentUPP)(userRoutine)
#endif

typedef short (pascal *QDTxMeasProcPtr)(short byteCount, Ptr textAddr, Point *numer, Point *denum, FontInfo *info);

enum {
	uppQDTxMeasProcInfo = kPascalStackBased
		| RESULT_SIZE(SIZE_CODE(sizeof(short)))
		| STACK_ROUTINE_PARAMETER(1, SIZE_CODE(sizeof(short)))
		| STACK_ROUTINE_PARAMETER(2, SIZE_CODE(sizeof(Ptr)))
		| STACK_ROUTINE_PARAMETER(3, SIZE_CODE(sizeof(Point*)))
		| STACK_ROUTINE_PARAMETER(4, SIZE_CODE(sizeof(Point*)))
		| STACK_ROUTINE_PARAMETER(5, SIZE_CODE(sizeof(FontInfo*)))
};

#if USESROUTINEDESCRIPTORS
typedef UniversalProcPtr QDTxMeasUPP;

#define CallQDTxMeasProc(userRoutine, byteCount, textAddr, numer, denum, info)		\
		CallUniversalProc((UniversalProcPtr)(userRoutine), uppQDTxMeasProcInfo, (byteCount), (textAddr), (numer), (denum), (info))
#define NewQDTxMeasProc(userRoutine)		\
		(QDTxMeasUPP) NewRoutineDescriptor((ProcPtr)(userRoutine), uppQDTxMeasProcInfo, GetCurrentISA())
#else
typedef QDTxMeasProcPtr QDTxMeasUPP;

#define CallQDTxMeasProc(userRoutine, byteCount, textAddr, numer, denum, info)		\
		(*(userRoutine))((byteCount), (textAddr), (numer), (denum), (info))
#define NewQDTxMeasProc(userRoutine)		\
		(QDTxMeasUPP)(userRoutine)
#endif

typedef void (pascal *QDGetPicProcPtr)(Ptr dataPtr, short byteCount);

enum {
	uppQDGetPicProcInfo = kPascalStackBased
		| STACK_ROUTINE_PARAMETER(1, SIZE_CODE(sizeof(Ptr)))
		| STACK_ROUTINE_PARAMETER(2, SIZE_CODE(sizeof(short)))
};

#if USESROUTINEDESCRIPTORS
typedef UniversalProcPtr QDGetPicUPP;

#define CallQDGetPicProc(userRoutine, dataPtr, byteCount)		\
		CallUniversalProc((UniversalProcPtr)(userRoutine), uppQDGetPicProcInfo, (dataPtr), (byteCount))
#define NewQDGetPicProc(userRoutine)		\
		(QDGetPicUPP) NewRoutineDescriptor((ProcPtr)(userRoutine), uppQDGetPicProcInfo, GetCurrentISA())
#else
typedef QDGetPicProcPtr QDGetPicUPP;

#define CallQDGetPicProc(userRoutine, dataPtr, byteCount)		\
		(*(userRoutine))((dataPtr), (byteCount))
#define NewQDGetPicProc(userRoutine)		\
		(QDGetPicUPP)(userRoutine)
#endif

typedef void (pascal *QDPutPicProcPtr)(Ptr dataPtr, short byteCount);

enum {
	uppQDPutPicProcInfo = kPascalStackBased
		| STACK_ROUTINE_PARAMETER(1, SIZE_CODE(sizeof(Ptr)))
		| STACK_ROUTINE_PARAMETER(2, SIZE_CODE(sizeof(short)))
};

#if USESROUTINEDESCRIPTORS
typedef UniversalProcPtr QDPutPicUPP;

#define CallQDPutPicProc(userRoutine, dataPtr, byteCount)		\
		CallUniversalProc((UniversalProcPtr)(userRoutine), uppQDPutPicProcInfo, (dataPtr), (byteCount))
#define NewQDPutPicProc(userRoutine)		\
		(QDPutPicUPP) NewRoutineDescriptor((ProcPtr)(userRoutine), uppQDPutPicProcInfo, GetCurrentISA())
#else
typedef QDPutPicProcPtr QDPutPicUPP;

#define CallQDPutPicProc(userRoutine, dataPtr, byteCount)		\
		(*(userRoutine))((dataPtr), (byteCount))
#define NewQDPutPicProc(userRoutine)		\
		(QDPutPicUPP)(userRoutine)
#endif

typedef void (pascal *QDOpcodeProcPtr)(Rect *fromRect, Rect *toRect, short opcode, short version);

enum {
	uppQDOpcodeProcInfo = kPascalStackBased
		| STACK_ROUTINE_PARAMETER(1, SIZE_CODE(sizeof(Rect*)))
		| STACK_ROUTINE_PARAMETER(2, SIZE_CODE(sizeof(Rect*)))
		| STACK_ROUTINE_PARAMETER(3, SIZE_CODE(sizeof(short)))
		| STACK_ROUTINE_PARAMETER(4, SIZE_CODE(sizeof(short)))
};

#if USESROUTINEDESCRIPTORS
typedef UniversalProcPtr QDOpcodeUPP;

#define CallQDOpcodeProc(userRoutine, fromRect, toRect, opcode, version)		\
		CallUniversalProc((UniversalProcPtr)(userRoutine), uppQDOpcodeProcInfo, (fromRect), (toRect), (opcode), (version))
#define NewQDOpcodeProc(userRoutine)		\
		(QDOpcodeUPP) NewRoutineDescriptor((ProcPtr)(userRoutine), uppQDOpcodeProcInfo, GetCurrentISA())
#else
typedef QDOpcodeProcPtr QDOpcodeUPP;

#define CallQDOpcodeProc(userRoutine, fromRect, toRect, opcode, version)		\
		(*(userRoutine))((fromRect), (toRect), (opcode), (version))
#define NewQDOpcodeProc(userRoutine)		\
		(QDOpcodeUPP)(userRoutine)
#endif

typedef void (pascal *QDJShieldCursorProcPtr)(short left, short top, short right, short bottom);

enum {
	uppQDJShieldCursorProcInfo = kPascalStackBased
		| STACK_ROUTINE_PARAMETER(1, SIZE_CODE(sizeof(short)))
		| STACK_ROUTINE_PARAMETER(2, SIZE_CODE(sizeof(short)))
		| STACK_ROUTINE_PARAMETER(3, SIZE_CODE(sizeof(short)))
		| STACK_ROUTINE_PARAMETER(4, SIZE_CODE(sizeof(short)))
};

#if USESROUTINEDESCRIPTORS
typedef UniversalProcPtr QDJShieldCursorUPP;

#define CallQDJShieldCursorProc(userRoutine, left, top, right, bottom)		\
		CallUniversalProc((UniversalProcPtr)(userRoutine), uppQDJShieldCursorProcInfo, (left), (top), (right), (bottom))
#define NewQDJShieldCursorProc(userRoutine)		\
		(QDJShieldCursorUPP) NewRoutineDescriptor((ProcPtr)(userRoutine), uppQDJShieldCursorProcInfo, GetCurrentISA())
#else
typedef QDJShieldCursorProcPtr QDJShieldCursorUPP;

#define CallQDJShieldCursorProc(userRoutine, left, top, right, bottom)		\
		(*(userRoutine))((left), (top), (right), (bottom))
#define NewQDJShieldCursorProc(userRoutine)		\
		(QDJShieldCursorUPP)(userRoutine)
#endif

struct QDProcs {
	QDTextUPP			textProc;
	QDLineUPP			lineProc;
	QDRectUPP			rectProc;
	QDRRectUPP			rRectProc;
	QDOvalUPP			ovalProc;
	QDArcUPP			arcProc;
	QDPolyUPP			polyProc;
	QDRgnUPP			rgnProc;
	QDBitsUPP			bitsProc;
	QDCommentUPP			commentProc;
	QDTxMeasUPP			txMeasProc;
	QDGetPicUPP			getPicProc;
	QDPutPicUPP			putPicProc;
};
typedef struct QDProcs QDProcs;

typedef QDProcs *QDProcsPtr;

struct GrafPort {
	short			device;
	BitMap			portBits;
	Rect			portRect;
	RgnHandle			visRgn;
	RgnHandle			clipRgn;
	Pattern			bkPat;
	Pattern			fillPat;
	Point			pnLoc;
	Point			pnSize;
	short			pnMode;
	Pattern			pnPat;
	short			pnVis;
	short			txFont;
	Style			txFace;			/*txFace is unpacked byte but push as short*/
	char			filler;
	short			txMode;
	short			txSize;
	Fixed			spExtra;
	long			fgColor;
	long			bkColor;
	short			colrBit;
	short			patStretch;
	Handle			picSave;
	Handle			rgnSave;
	Handle			polySave;
	QDProcsPtr			grafProcs;
};
typedef struct GrafPort GrafPort;

typedef GrafPort *GrafPtr;

typedef GrafPtr WindowPtr;
#ifndef WindowRef
typedef GrafPtr WindowRef; //EHC
#endif

struct RGBColor {
	unsigned short			red;			/*magnitude of red component*/
	unsigned short			green;			/*magnitude of green component*/
	unsigned short			blue;			/*magnitude of blue component*/
};
typedef struct RGBColor RGBColor, *RGBColorPtr, **RGBColorHdl;

typedef Boolean (pascal *ColorSearchProcPtr)(RGBColor *rgb, long *position);

enum {
	uppColorSearchProcInfo = kPascalStackBased
		| RESULT_SIZE(SIZE_CODE(sizeof(Boolean)))
		| STACK_ROUTINE_PARAMETER(1, SIZE_CODE(sizeof(RGBColor*)))
		| STACK_ROUTINE_PARAMETER(2, SIZE_CODE(sizeof(long*)))
};

#if USESROUTINEDESCRIPTORS
typedef UniversalProcPtr ColorSearchUPP;

#define CallColorSearchProc(userRoutine, rgb, position)		\
		CallUniversalProc((UniversalProcPtr)(userRoutine), uppColorSearchProcInfo, (rgb), (position))
#define NewColorSearchProc(userRoutine)		\
		(ColorSearchUPP) NewRoutineDescriptor((ProcPtr)(userRoutine), uppColorSearchProcInfo, GetCurrentISA())
#else
typedef ColorSearchProcPtr ColorSearchUPP;

#define CallColorSearchProc(userRoutine, rgb, position)		\
		(*(userRoutine))((rgb), (position))
#define NewColorSearchProc(userRoutine)		\
		(ColorSearchUPP)(userRoutine)
#endif

typedef Boolean (pascal *ColorComplementProcPtr)(RGBColor *rgb);

enum {
	uppColorComplementProcInfo = kPascalStackBased
		| RESULT_SIZE(SIZE_CODE(sizeof(Boolean)))
		| STACK_ROUTINE_PARAMETER(1, SIZE_CODE(sizeof(RGBColor*)))
};

#if USESROUTINEDESCRIPTORS
typedef UniversalProcPtr ColorComplementUPP;

#define CallColorComplementProc(userRoutine, rgb)		\
		CallUniversalProc((UniversalProcPtr)(userRoutine), uppColorComplementProcInfo, (rgb))
#define NewColorComplementProc(userRoutine)		\
		(ColorComplementUPP) NewRoutineDescriptor((ProcPtr)(userRoutine), uppColorComplementProcInfo, GetCurrentISA())
#else
typedef ColorComplementProcPtr ColorComplementUPP;

#define CallColorComplementProc(userRoutine, rgb)		\
		(*(userRoutine))((rgb))
#define NewColorComplementProc(userRoutine)		\
		(ColorComplementUPP)(userRoutine)
#endif

struct ColorSpec {
	short			value;			/*index or other value*/
	RGBColor			rgb;			/*true color*/
};
typedef struct ColorSpec ColorSpec;

typedef ColorSpec *ColorSpecPtr;

typedef ColorSpec CSpecArray[1];

struct ColorTable {
	long			ctSeed;			/*unique identifier for table*/
	short			ctFlags;			/*high bit: 0 = PixMap; 1 = device*/
	short			ctSize;			/*number of entries in CTTable*/
	CSpecArray			ctTable;			/*array [0..0] of ColorSpec*/
};
typedef struct ColorTable ColorTable;

typedef ColorTable *CTabPtr, **CTabHandle;

struct MatchRec {
	unsigned short			red;
	unsigned short			green;
	unsigned short			blue;
	long			matchData;
};
typedef struct MatchRec MatchRec;

struct PixMap {
	Ptr			baseAddr;			/*pointer to pixels*/
	short			rowBytes;			/*offset to next line*/
	Rect			bounds;			/*encloses bitmap*/
	short			pmVersion;			/*pixMap version number*/
	short			packType;			/*defines packing format*/
	long			packSize;			/*length of pixel data*/
	Fixed			hRes;			/*horiz. resolution (ppi)*/
	Fixed			vRes;			/*vert. resolution (ppi)*/
	short			pixelType;			/*defines pixel type*/
	short			pixelSize;			/*# bits in pixel*/
	short			cmpCount;			/*# components in pixel*/
	short			cmpSize;			/*# bits per component*/
	long			planeBytes;			/*offset to next plane*/
	CTabHandle			pmTable;			/*color map for this pixMap*/
	long			pmReserved;			/*for future use. MUST BE 0*/
};
typedef struct PixMap PixMap;

typedef PixMap *PixMapPtr, **PixMapHandle;

struct PixPat {
	short			patType;			/*type of pattern*/
	PixMapHandle			patMap;			/*the pattern's pixMap*/
	Handle			patData;			/*pixmap's data*/
	Handle			patXData;			/*expanded Pattern data*/
	short			patXValid;			/*flags whether expanded Pattern valid*/
	Handle			patXMap;			/*Handle to expanded Pattern data*/
	Pattern			pat1Data;			/*old-Style pattern/RGB color*/
};
typedef struct PixPat PixPat;

typedef PixPat *PixPatPtr, **PixPatHandle;

struct CCrsr {
	short			crsrType;			/*type of cursor*/
	PixMapHandle			crsrMap;			/*the cursor's pixmap*/
	Handle			crsrData;			/*cursor's data*/
	Handle			crsrXData;			/*expanded cursor data*/
	short			crsrXValid;			/*depth of expanded data (0 if none)*/
	Handle			crsrXHandle;			/*future use*/
	Bits16			crsr1Data;			/*one-bit cursor*/
	Bits16			crsrMask;			/*cursor's mask*/
	Point			crsrHotSpot;			/*cursor's hotspot*/
	long			crsrXTable;			/*private*/
	long			crsrID;			/*private*/
};
typedef struct CCrsr CCrsr;

typedef CCrsr *CCrsrPtr, **CCrsrHandle;

struct CIcon {
	PixMap			iconPMap;			/*the icon's pixMap*/
	BitMap			iconMask;			/*the icon's mask*/
	BitMap			iconBMap;			/*the icon's bitMap*/
	Handle			iconData;			/*the icon's data*/
	short			iconMaskData[1];			/*icon's mask and BitMap data*/
};
typedef struct CIcon CIcon;

typedef CIcon *CIconPtr, **CIconHandle;

struct GammaTbl {
	short			gVersion;			/*gamma version number*/
	short			gType;			/*gamma data type*/
	short			gFormulaSize;			/*Formula data size*/
	short			gChanCnt;			/*number of channels of data*/
	short			gDataCnt;			/*number of values/channel*/
	short			gDataWidth;			/*bits/corrected value (data packed to next larger byte size)*/
	short			gFormulaData[1];			/*data for formulas followed by gamma values*/
};
typedef struct GammaTbl GammaTbl;

typedef GammaTbl *GammaTblPtr, **GammaTblHandle;

struct ITab {
	long			iTabSeed;			/*copy of CTSeed from source CTable*/
	short			iTabRes;			/*bits/channel resolution of iTable*/
	unsigned char			iTTable[1];			/*byte colortable index values*/
};
typedef struct ITab ITab;

typedef ITab *ITabPtr, **ITabHandle;

struct SProcRec {
	Handle			nxtSrch;			/*SProcHndl Handle to next SProcRec*/
	ColorSearchUPP			srchProc;			/*search procedure proc ptr*/
};
typedef struct SProcRec SProcRec;

typedef SProcRec *SProcPtr, **SProcHndl;

struct CProcRec {
	Handle			nxtComp;			/*CProcHndl Handle to next CProcRec*/
	ColorComplementUPP			compProc;			/*complement procedure proc ptr*/
};
typedef struct CProcRec CProcRec;

typedef CProcRec *CProcPtr, **CProcHndl;

struct GDevice {
	short			gdRefNum;			/*driver's unit number*/
	short			gdID;			/*client ID for search procs*/
	short			gdType;			/*fixed/CLUT/direct*/
	ITabHandle			gdITable;			/*Handle to inverse lookup table*/
	short			gdResPref;			/*preferred resolution of GDITable*/
	SProcHndl			gdSearchProc;			/*search proc list head*/
	CProcHndl			gdCompProc;			/*complement proc list*/
	short			gdFlags;			/*grafDevice flags word*/
	PixMapHandle			gdPMap;			/*describing pixMap*/
	long			gdRefCon;			/*reference value*/
	Handle			gdNextGD;			/*GDHandle Handle of next gDevice*/
	Rect			gdRect;			/* device's bounds in global coordinates*/
	long			gdMode;			/*device's current mode*/
	short			gdCCBytes;			/*depth of expanded cursor data*/
	short			gdCCDepth;			/*depth of expanded cursor data*/
	Handle			gdCCXData;			/*Handle to cursor's expanded data*/
	Handle			gdCCXMask;			/*Handle to cursor's expanded mask*/
	long			gdReserved;			/*future use. MUST BE 0*/
};
typedef struct GDevice GDevice;

typedef GDevice *GDPtr, **GDHandle;

struct GrafVars {
	RGBColor			rgbOpColor;			/*color for addPin  subPin and average*/
	RGBColor			rgbHiliteColor;			/*color for hiliting*/
	Handle			pmFgColor;			/*palette Handle for foreground color*/
	short			pmFgIndex;			/*index value for foreground*/
	Handle			pmBkColor;			/*palette Handle for background color*/
	short			pmBkIndex;			/*index value for background*/
	short			pmFlags;			/*flags for Palette Manager*/
};
typedef struct GrafVars GrafVars;

typedef GrafVars *GVarPtr, **GVarHandle;

struct CQDProcs {
	QDTextUPP			textProc;
	QDLineUPP			lineProc;
	QDRectUPP			rectProc;
	QDRRectUPP			rRectProc;
	QDOvalUPP			ovalProc;
	QDArcUPP			arcProc;
	QDPolyUPP			polyProc;
	QDRgnUPP			rgnProc;
	QDBitsUPP			bitsProc;
	QDCommentUPP			commentProc;
	QDTxMeasUPP			txMeasProc;
	QDGetPicUPP			getPicProc;
	QDPutPicUPP			putPicProc;
	QDOpcodeUPP			opcodeProc;			/*fields added to QDProcs*/
	UniversalProcPtr			newProc1;
	UniversalProcPtr			newProc2;
	UniversalProcPtr			newProc3;
	UniversalProcPtr			newProc4;
	UniversalProcPtr			newProc5;
	UniversalProcPtr			newProc6;
};
typedef struct CQDProcs CQDProcs;

typedef CQDProcs *CQDProcsPtr;

struct CGrafPort {
	short			device;
	PixMapHandle			portPixMap;			/*port's pixel map*/
	short			portVersion;			/*high 2 bits always set*/
	Handle			grafVars;			/*Handle to more fields*/
	short			chExtra;			/*character extra*/
	short			pnLocHFrac;			/*pen fraction*/
	Rect			portRect;
	RgnHandle			visRgn;
	RgnHandle			clipRgn;
	PixPatHandle			bkPixPat;			/*background pattern*/
	RGBColor			rgbFgColor;			/*RGB components of fg*/
	RGBColor			rgbBkColor;			/*RGB components of bk*/
	Point			pnLoc;
	Point			pnSize;
	short			pnMode;
	PixPatHandle			pnPixPat;			/*pen's pattern*/
	PixPatHandle			fillPixPat;			/*fill pattern*/
	short			pnVis;
	short			txFont;
	Style			txFace;			/*txFace is unpacked byte  push as short*/
	char			filler;
	short			txMode;
	short			txSize;
	Fixed			spExtra;
	long			fgColor;
	long			bkColor;
	short			colrBit;
	short			patStretch;
	Handle			picSave;
	Handle			rgnSave;
	Handle			polySave;
	CQDProcsPtr			grafProcs;
};
typedef struct CGrafPort CGrafPort;

typedef CGrafPort *CGrafPtr;

typedef CGrafPtr CWindowPtr;

struct ReqListRec {
	short			reqLSize;			/*request list size*/
	short			reqLData[1];			/*request list data*/
};
typedef struct ReqListRec ReqListRec;

struct OpenCPicParams {
	Rect			srcRect;
	Fixed			hRes;
	Fixed			vRes;
	short			version;
	short			reserved1;
	long			reserved2;
};
typedef struct OpenCPicParams OpenCPicParams;

typedef void (pascal *DeviceLoopDrawingProcPtr)(short depth, short deviceFlags, GDHandle targetDevice, long userData);

enum {
	uppDeviceLoopDrawingProcInfo = kPascalStackBased
		| STACK_ROUTINE_PARAMETER(1, SIZE_CODE(sizeof(short)))
		| STACK_ROUTINE_PARAMETER(2, SIZE_CODE(sizeof(short)))
		| STACK_ROUTINE_PARAMETER(3, SIZE_CODE(sizeof(GDHandle)))
		| STACK_ROUTINE_PARAMETER(4, SIZE_CODE(sizeof(long)))
};

#if USESROUTINEDESCRIPTORS
typedef UniversalProcPtr DeviceLoopDrawingUPP;

#define CallDeviceLoopDrawingProc(userRoutine, depth, deviceFlags, targetDevice, userData)		\
		CallUniversalProc((UniversalProcPtr)(userRoutine), uppDeviceLoopDrawingProcInfo, (depth), (deviceFlags), (targetDevice), (userData))
#define NewDeviceLoopDrawingProc(userRoutine)		\
		(DeviceLoopDrawingUPP) NewRoutineDescriptor((ProcPtr)(userRoutine), uppDeviceLoopDrawingProcInfo, GetCurrentISA())
#else
typedef DeviceLoopDrawingProcPtr DeviceLoopDrawingUPP;

#define CallDeviceLoopDrawingProc(userRoutine, depth, deviceFlags, targetDevice, userData)		\
		(*(userRoutine))((depth), (deviceFlags), (targetDevice), (userData))
#define NewDeviceLoopDrawingProc(userRoutine)		\
		(DeviceLoopDrawingUPP)(userRoutine)
#endif

struct QDGlobals {
	char			privates[76];
	long			randSeed;
	BitMap			screenBits;
	Cursor			arrow;
	Pattern			dkGray;
	Pattern			ltGray;
	Pattern			gray;
	Pattern			black;
	Pattern			white;
	GrafPtr			thePort;
};
typedef struct QDGlobals QDGlobals;

#pragma PRAGMA_PACK_RESET


#ifdef __cplusplus
extern "C" {
#endif

// lve qd is now defined by the Mac2Win DLL
// and should be imported by the application
// _DEFINE_QD needs to be adding to the DLL project preprocessor options 
#if EXPORTQD
__declspec(dllexport) QDGlobals qd;
#elif IMPORTQD
__declspec(dllimport) QDGlobals qd;
#else
extern QDGlobals qd;
#endif

extern void pascal InitGraf(void *globalPtr);
extern void pascal OpenPort(GrafPtr port);
extern void pascal InitPort(GrafPtr port);
extern void pascal ClosePort(GrafPtr port);
extern void pascal SetPor(GrafPtr port);
extern void pascal GetPort(GrafPtr *port);
extern void pascal GrafDevice(short device);
extern Boolean pascal SetPortBits(const BitMap *bm);
extern void pascal PortSize(short width, short height);
extern void pascal MovePortTo(short leftGlobal, short topGlobal);
extern void pascal SetOrigin(short h, short v);
extern void pascal SetClip(RgnHandle rgn);
extern void pascal GetClip(RgnHandle rgn);
extern void pascal ClipRect(const Rect *r);
extern void pascal BackPat(ConstPatternParam pat);
extern void pascal InitCursor(void);
extern void pascal SetCurso(const Cursor *crsr);
extern void pascal HideCursor(void);
extern void pascal ShowCurso(void);
extern void pascal ObscureCursor(void);
extern void pascal HidePen(void);
extern void pascal ShowPen(void);
extern void pascal GetPen(Point *pt);
extern void pascal GetPenState(PenState *pnState);
extern void pascal SetPenState(const PenState *pnState);
extern void pascal PenSize(short width, short height);
extern void pascal PenMode(short mode);
extern void pascal PenPat(ConstPatternParam pat);
extern void pascal PenNormal(void);
extern void pascal MoveT(short h, short v);
extern void pascal Move(short dh, short dv);
extern void pascal LineT(short h, short v);
extern void pascal Line(short dh, short dv);
extern void pascal ForeColor(long color);
extern void pascal BackColor(long color);
extern void pascal ColorBit(short whichBit);
extern void pascal SetRec(Rect *r, short left, short top, short right, short bottom);
extern void pascal OffsetRec(Rect *r, short dh, short dv);
extern void pascal InsetRec(Rect *r, short dh, short dv);
extern Boolean pascal SectRect(const Rect *src1, const Rect *src2, Rect *dstRect);
extern void pascal UnionRec(const Rect *src1, const Rect *src2, Rect *dstRect);
extern Boolean pascal EqualRec(const Rect *rect1, const Rect *rect2);
extern Boolean pascal EmptyRect(const Rect *r);
extern void pascal FrameRec(const Rect *r);
extern void pascal PaintRect(const Rect *r);
extern void pascal EraseRect(const Rect *r);
extern void pascal InvertRec(const Rect *r);
extern void pascal FillRec(const Rect *r, ConstPatternParam pat);
extern void pascal FrameOval(const Rect *r);
extern void pascal PaintOval(const Rect *r);
extern void pascal EraseOval(const Rect *r);
extern void pascal InvertOval(const Rect *r);
extern void pascal FillOval(const Rect *r, ConstPatternParam pat);
extern void pascal FrameRoundRect(const Rect *r, short ovalWidth, short ovalHeight);
extern void pascal PaintRoundRect(const Rect *r, short ovalWidth, short ovalHeight);
extern void pascal EraseRoundRect(const Rect *r, short ovalWidth, short ovalHeight);
extern void pascal InvertRoundRect(const Rect *r, short ovalWidth, short ovalHeight);
extern void pascal FillRoundRect(const Rect *r, short ovalWidth, short ovalHeight, ConstPatternParam pat);
extern void pascal FrameArc(const Rect *r, short startAngle, short arcAngle);
extern void pascal PaintArc(const Rect *r, short startAngle, short arcAngle);
extern void pascal EraseArc(const Rect *r, short startAngle, short arcAngle);
extern void pascal InvertArc(const Rect *r, short startAngle, short arcAngle);
extern void pascal FillArc(const Rect *r, short startAngle, short arcAngle, ConstPatternParam pat);
extern RgnHandle pascal NewRgn(void);
extern void pascal OpenRgn(void);
extern void pascal CloseRgn(RgnHandle dstRgn);
#if !SystemSevenOrLater
extern OSErr pascal BitMapToRegionGlue(RgnHandle region, const BitMap *bMap);
#endif

extern OSErr pascal BitMapToRegion(RgnHandle region, const BitMap *bMap);
extern void pascal DisposeRgn(RgnHandle rgn);
extern void pascal CopyRg(RgnHandle srcRgn, RgnHandle dstRgn);
extern void pascal SetEmptyRgn(RgnHandle rgn);
extern void pascal SetRectRg(RgnHandle rgn, short left, short top, short right, short bottom);
extern void pascal RectRgn(RgnHandle rgn, const Rect *r);
extern void pascal OffsetRg(RgnHandle rgn, short dh, short dv);
extern void pascal InsetRg(RgnHandle rgn, short dh, short dv);
extern void pascal SectRgn(RgnHandle srcRgnA, RgnHandle srcRgnB, RgnHandle dstRgn);
extern void pascal UnionRg(RgnHandle srcRgnA, RgnHandle srcRgnB, RgnHandle dstRgn);
extern void pascal DiffRgn(RgnHandle srcRgnA, RgnHandle srcRgnB, RgnHandle dstRgn);
extern void pascal XorRg(RgnHandle srcRgnA, RgnHandle srcRgnB, RgnHandle dstRgn);
extern Boolean pascal RectInRgn(const Rect *r, RgnHandle rgn);
extern Boolean pascal EqualRg(RgnHandle rgnA, RgnHandle rgnB);
extern Boolean pascal EmptyRgn(RgnHandle rgn);
extern void pascal FrameRg(RgnHandle rgn);
extern void pascal PaintRg(RgnHandle rgn);
extern void pascal EraseRgn(RgnHandle rgn);
extern void pascal InvertRg(RgnHandle rgn);
extern void pascal FillRg(RgnHandle rgn, ConstPatternParam pat);
extern void pascal ScrollRect(const Rect *r, short dh, short dv, RgnHandle updateRgn);
extern void pascal CopyBits(const BitMap *srcBits, const BitMap *dstBits, const Rect *srcRect, const Rect *dstRect, short mode, RgnHandle maskRgn);
extern void pascal SeedFill(const void *srcPtr, void *dstPtr, short srcRow, short dstRow, short height, short words, short seedH, short seedV);
extern void pascal CalcMask(const void *srcPtr, void *dstPtr, short srcRow, short dstRow, short height, short words);
extern void pascal CopyMask(const BitMap *srcBits, const BitMap *maskBits, const BitMap *dstBits, const Rect *srcRect, const Rect *maskRect, const Rect *dstRect);
extern PicHandle pascal OpenPicture(const Rect *picFrame);
extern void pascal PicComment(short kind, short dataSize, Handle dataHandle);
extern void pascal ClosePicture(void);
extern void pascal DrawPicture(PicHandle myPicture, const Rect *dstRect);
extern void pascal KillPicture(PicHandle myPicture);
extern PolyHandle pascal OpenPoly(void);
extern void pascal ClosePoly(void);
extern void pascal KillPoly(PolyHandle poly);
extern void pascal OffsetPoly(PolyHandle poly, short dh, short dv);
extern void pascal FramePoly(PolyHandle poly);
extern void pascal PaintPoly(PolyHandle poly);
extern void pascal ErasePoly(PolyHandle poly);
extern void pascal InvertPoly(PolyHandle poly);
extern void pascal FillPoly(PolyHandle poly, ConstPatternParam pat);
extern void pascal SetPt(Point *pt, short h, short v);
extern void pascal LocalToGlobal(Point *pt);
extern void pascal GlobalToLocal(Point *pt);
extern short pascal Random(void);
extern void pascal StuffHex(void *thingPtr, ConstStr255Param s);
extern Boolean pascal GetPixe(short h, short v);
extern void pascal ScalePt(Point *pt, const Rect *srcRect, const Rect *dstRect);
extern void pascal MapPt(Point *pt, const Rect *srcRect, const Rect *dstRect);
extern void pascal MapRect(Rect *r, const Rect *srcRect, const Rect *dstRect);
extern void pascal MapRgn(RgnHandle rgn, const Rect *srcRect, const Rect *dstRect);
extern void pascal MapPoly(PolyHandle poly, const Rect *srcRect, const Rect *dstRect);
extern void pascal SetStdProcs(QDProcs *procs);
extern void pascal StdRect(GrafVerb verb, const Rect *r);
extern void pascal StdRRect(GrafVerb verb, const Rect *r, short ovalWidth, short ovalHeight);
extern void pascal StdOval(GrafVerb verb, const Rect *r);
extern void pascal StdArc(GrafVerb verb, const Rect *r, short startAngle, short arcAngle);
extern void pascal StdPoly(GrafVerb verb, PolyHandle poly);
extern void pascal StdRgn(GrafVerb verb, RgnHandle rgn);
extern void pascal StdBits(const BitMap *srcBits, const Rect *srcRect, const Rect *dstRect, short mode, RgnHandle maskRgn);
extern void pascal StdComment(short kind, short dataSize, Handle dataHandle);
extern void pascal StdGetPic(void *dataPtr, short byteCount);
extern void pascal StdPutPic(const void *dataPtr, short byteCount);
extern void pascal AddPt(Point src, Point *dst);
extern void subpt(Point *src, Point *dst);
extern Boolean pascal EqualPt(Point pt1, Point pt2);
extern Boolean pascal PtInRec(Point pt, const Rect *r);
extern void pascal Pt2Rect(Point pt1, Point pt2, Rect *dstRect);
extern void pascal PtToAngle(const Rect *r, Point pt, short *angle);
extern void pascal SubPt(Point src, Point *dst);
extern Boolean pascal PtInRgn(Point pt, RgnHandle rgn);
extern void pascal StdLine(Point newPt);
extern void pascal OpenCPort(CGrafPtr port);
extern void pascal InitCPort(CGrafPtr port);
extern void pascal CloseCPort(CGrafPtr port);
extern PixMapHandle pascal NewPixMap(void);
extern void pascal DisposePixMap(PixMapHandle pm);
extern void pascal CopyPixMap(PixMapHandle srcPM, PixMapHandle dstPM);
extern PixPatHandle pascal NewPixPat(void);
extern void pascal DisposePixPat(PixPatHandle pp);
extern void pascal CopyPixPat(PixPatHandle srcPP, PixPatHandle dstPP);
extern void pascal PenPixPat(PixPatHandle pp);
extern void pascal BackPixPat(PixPatHandle pp);
extern PixPatHandle pascal GetPixPat(short patID);
extern void pascal MakeRGBPat(PixPatHandle pp, const RGBColor *myColor);
extern void pascal FillCRect(const Rect *r, PixPatHandle pp);
extern void pascal FillCOval(const Rect *r, PixPatHandle pp);
extern void pascal FillCRoundRect(const Rect *r, short ovalWidth, short ovalHeight, PixPatHandle pp);
extern void pascal FillCArc(const Rect *r, short startAngle, short arcAngle, PixPatHandle pp);
extern void pascal FillCRgn(RgnHandle rgn, PixPatHandle pp);
extern void pascal FillCPoly(PolyHandle poly, PixPatHandle pp);
extern void pascal RGBForeColor(const RGBColor *color);
extern void pascal RGBBackColor(const RGBColor *color);
extern void pascal SetCPixel(short h, short v, const RGBColor *cPix);
extern Boolean pascal SetPortPix(PixMapHandle pm);
extern void pascal GetCPixel(short h, short v, RGBColor *cPix);
extern void pascal GetForeColor(RGBColor *color);
extern void pascal GetBackColor(RGBColor *color);
extern void pascal SeedCFill(const BitMap *srcBits, const BitMap *dstBits, const Rect *srcRect, const Rect *dstRect, short seedH, short seedV, ColorSearchUPP matchProc, long matchData);
extern void pascal CalcCMask(const BitMap *srcBits, const BitMap *dstBits, const Rect *srcRect, const Rect *dstRect, const RGBColor *seedRGB, ColorSearchUPP matchProc, long matchData);
extern PicHandle pascal OpenCPicture(const OpenCPicParams *newHeader);
extern void pascal OpColor(const RGBColor *color);
extern void pascal HiliteColor(const RGBColor *color);
extern void pascal DisposeCTable(CTabHandle cTable);
extern CTabHandle pascal GetCTable(short ctID);
extern CCrsrHandle pascal GetCCursor(short crsrID);
extern void pascal SetCCursor(CCrsrHandle cCrsr);
extern void pascal AllocCursor(void);
extern void pascal DisposeCCursor(CCrsrHandle cCrsr);
extern CIconHandle pascal GetCIcon(short iconID);
extern void pascal PlotCIcon(const Rect *theRect, CIconHandle theIcon);
extern void pascal DisposeCIcon(CIconHandle theIcon);
extern void pascal SetStdCProcs(CQDProcs *procs);
extern GDHandle pascal GetMaxDevice(const Rect *globalRect);
extern long pascal GetCTSeed(void);
extern GDHandle pascal GetDeviceList(void);
extern GDHandle pascal GetMainDevice(void);
extern GDHandle pascal GetNextDevice(GDHandle curDevice);
extern Boolean pascal TestDeviceAttribute(GDHandle gdh, short attribute);
extern void pascal SetDeviceAttribute(GDHandle gdh, short attribute, Boolean value);
extern void pascal InitGDevice(short qdRefNum, long mode, GDHandle gdh);
extern GDHandle pascal NewGDevice(short refNum, long mode);
extern void pascal DisposeGDevice(GDHandle gdh);
extern void pascal SetGDevice(GDHandle gd);
extern GDHandle pascal GetGDevice(void);
extern long pascal Color2Index(const RGBColor *myColor);
extern void pascal Index2Color(long index, RGBColor *aColor);
extern void pascal InvertColor(RGBColor *myColor);
extern Boolean pascal RealColor(const RGBColor *color);
extern void pascal GetSubTable(CTabHandle myColors, short iTabRes, CTabHandle targetTbl);
extern void pascal MakeITable(CTabHandle cTabH, ITabHandle iTabH, short res);
extern void pascal AddSearch(ColorSearchUPP searchProc);
extern void pascal AddComp(ColorComplementUPP compProc);
extern void pascal DelSearch(ColorSearchUPP searchProc);
extern void pascal DelComp(ColorComplementUPP compProc);
extern void pascal SetClientID(short id);
extern void pascal ProtectEntry(short index, Boolean protect);
extern Boolean equalpt(Point *pt1, Point *pt2);
extern void pascal ReserveEntry(short index, Boolean reserve);
extern void pascal SetEntries(short start, short count, CSpecArray aTable);
extern Boolean ptinrect(Point *pt, const Rect *r);
extern void pascal SaveEntries(CTabHandle srcTable, CTabHandle resultTable, ReqListRec *selection);
extern void pascal RestoreEntries(CTabHandle srcTable, CTabHandle dstTable, ReqListRec *selection);
extern void pt2rect(Point *pt1, Point *pt2, const Rect *destRect);
extern short pascal QDError(void);
extern void pascal CopyDeepMask(const BitMap *srcBits, const BitMap *maskBits, const BitMap *dstBits, const Rect *srcRect, const Rect *maskRect, const Rect *dstRect, short mode, RgnHandle maskRgn);
extern void pascal DeviceLoop(RgnHandle drawingRgn, DeviceLoopDrawingUPP drawingProc, long userData, DeviceLoopFlags flags);

extern Ptr pascal GetMaskTable(void);
extern void pttoangle(const Rect *r, Point *pt, short *angle);
extern Boolean ptinrgn(Point *pt, RgnHandle rgn);
extern void stdline(Point *newPt);
extern void drawstring(char *s);
extern void addpt(Point *src, Point *dst);
extern void stuffhex(Ptr thingPtr, char *s);
extern short stringwidth(char *s);
#if OLDROUTINENAMES
#define DisposPixMap(pm) DisposePixMap(pm)

#define DisposPixPat(pp) DisposePixPat(pp)

#define DisposCTable(cTable) DisposeCTable(cTable)

#define DisposCCursor(cCrsr) DisposeCCursor(cCrsr)

#define DisposCIcon(theIcon) DisposeCIcon(theIcon)

#define DisposGDevice(gdh) DisposeGDevice(gdh)

#endif

#if WINVER
#define stuffhex StuffHex 
#endif

#if PRAGMA_STRUCT_ALIGN
	#pragma options align=reset
#elif PRAGMA_STRUCT_PACKPUSH
	#pragma pack(pop)
#elif PRAGMA_STRUCT_PACK
	#pragma pack()
#endif

#ifdef PRAGMA_IMPORT_OFF
#pragma import off
#elif PRAGMA_IMPORT
#pragma import reset
#endif

#ifdef __cplusplus
}
#endif

#endif


