/*
	File:		SCSI.h

	Copyright:	 1984-1993 by Apple Computer, Inc., all rights reserved.

	WARNING
	This file was auto generated by the interfacer tool. Modifications
	must be made to the master file.

*/

#ifndef __SCSI__
#define __SCSI__

#ifndef __TYPES__
#include <MacTypes.H>
#endif

#if PRAGMA_IMPORT
#pragma import on
#endif

#if PRAGMA_STRUCT_ALIGN
	#pragma options align=mac68k
#elif PRAGMA_STRUCT_PACKPUSH
	#pragma pack(push, 2)
#elif PRAGMA_STRUCT_PACK
	#pragma pack(2)
#endif

enum  {
	scInc			= 1,
	scNoInc			= 2,
	scAdd			= 3,
	scMove			= 4,
	scLoop			= 5,
	scNop			= 6,
	scStop			= 7,
	scComp			= 8,
	scCommErr			= 2,			/*communications error, operation timeout*/
	scArbNBErr			= 3,			/*arbitration timeout waiting for not BSY*/
	scBadParmsErr			= 4,			/*bad parameter or TIB opcode*/
	scPhaseErr			= 5,			/*SCSI bus not in correct phase for attempted operation*/
	scCompareErr			= 6,			/*data compare error*/
	scMgrBusyErr			= 7,			/*SCSI Manager busy */
	scSequenceErr			= 8,			/*attempted operation is out of sequence*/
	scBusTOErr			= 9,			/*CPU bus timeout*/
	scComplPhaseErr			= 10,			/*SCSI bus wasn't in Status phase*/
	sbSIGWord			= 0x4552,
	pMapSIG			= 0x504D
};

struct Block0 {
	unsigned short			sbSig;			/*unique value for SCSI block 0*/
	unsigned short			sbBlkSize;			/*block size of device*/
	unsigned long			sbBlkCount;			/*number of blocks on device*/
	unsigned short			sbDevType;			/*device type*/
	unsigned short			sbDevId;			/*device id*/
	unsigned long			sbData;			/*not used*/
	unsigned short			sbDrvrCount;			/*driver descriptor count*/
	unsigned long			ddBlock;			/*1st driver's starting block*/
	unsigned short			ddSize;			/*size of 1st driver (512-byte blks)*/
	unsigned short			ddType;			/*system type (1 for Mac+)*/
	unsigned short			ddPad[243];			/*ARRAY[0..242] OF INTEGER; not used*/
};
typedef struct Block0 Block0;

struct Partition {
	unsigned short			pmSig;			/*unique value for map entry blk*/
	unsigned short			pmSigPad;			/*currently unused*/
	unsigned long			pmMapBlkCnt;			/*# of blks in partition map*/
	unsigned long			pmPyPartStart;			/*physical start blk of partition*/
	unsigned long			pmPartBlkCnt;			/*# of blks in this partition*/
	unsigned char			pmPartName[32];			/*ASCII partition name*/
	unsigned char			pmParType[32];			/*ASCII partition type*/
	unsigned long			pmLgDataStart;			/*log. # of partition's 1st data blk*/
	unsigned long			pmDataCnt;			/*# of blks in partition's data area*/
	unsigned long			pmPartStatus;			/*bit field for partition status*/
	unsigned long			pmLgBootStart;			/*log. blk of partition's boot code*/
	unsigned long			pmBootSize;			/*number of bytes in boot code*/
	unsigned long			pmBootAddr;			/*memory load address of boot code*/
	unsigned long			pmBootAddr2;			/*currently unused*/
	unsigned long			pmBootEntry;			/*entry point of boot code*/
	unsigned long			pmBootEntry2;			/*currently unused*/
	unsigned long			pmBootCksum;			/*checksum of boot code*/
	unsigned char			pmProcessor[16];			/*ASCII for the processor type*/
	unsigned short			pmPad[188];			/*512 bytes long currently unused*/
};
typedef struct Partition Partition;

struct SCSIInstr {
	unsigned short			scOpcode;
	unsigned long			scParam1;
	unsigned long			scParam2;
};
typedef struct SCSIInstr SCSIInstr;

#ifdef __cplusplus
extern "C" {
#endif

extern OSErr pascal SCSIReset(void);
extern OSErr pascal SCSIGet(void);
extern OSErr pascal SCSISelect(short targetID);
extern OSErr pascal SCSICmd(Ptr buffer, short count);
extern OSErr pascal SCSIRead(Ptr tibPtr);
extern OSErr pascal SCSIRBlind(Ptr tibPtr);
extern OSErr pascal SCSIWrite(Ptr tibPtr);
extern OSErr pascal SCSIWBlind(Ptr tibPtr);
extern OSErr pascal SCSIComplete(short *stat, short *message, unsigned long wait);
extern short pascal SCSIStat(void);
extern OSErr pascal SCSISelAtn(short targetID);
extern OSErr pascal SCSIMsgIn(short *message);
extern OSErr pascal SCSIMsgOut(short message);
#if PRAGMA_STRUCT_ALIGN
	#pragma options align=reset
#elif PRAGMA_STRUCT_PACKPUSH
	#pragma pack(pop)
#elif PRAGMA_STRUCT_PACK
	#pragma pack()
#endif

#ifdef PRAGMA_IMPORT_OFF
#pragma import off
#elif PRAGMA_IMPORT
#pragma import reset
#endif

#ifdef __cplusplus
}
#endif

#endif


