/*
	File:		Slots.h

	Copyright:	 1984-1993 by Apple Computer, Inc., all rights reserved.

	WARNING
	This file was auto generated by the interfacer tool. Modifications
	must be made to the master file.

*/

#ifndef __SLOTS__
#define __SLOTS__

#ifndef __TYPES__
#include <MacTypes.H>
#endif

#ifndef __EVENTS__
#include <Events.H>
#endif

#ifndef __FILES__
#include <Files.H>
#endif

#if PRAGMA_IMPORT
#pragma import on
#endif

#if PRAGMA_STRUCT_ALIGN
	#pragma options align=mac68k
#elif PRAGMA_STRUCT_PACKPUSH
	#pragma pack(push, 2)
#elif PRAGMA_STRUCT_PACK
	#pragma pack(2)
#endif

enum  {
	fCardIsChanged			= 1,			/*Card is Changed field in StatusFlags field of sInfoArray*/
	fCkForSame			= 0,			/*For SearchSRT. Flag to check for SAME sResource in the table. */
	fCkForNext			= 1,			/*For SearchSRT. Flag to check for NEXT sResource in the table. */
	fWarmStart			= 2,			/*If this bit is set then warm start else cold start.*/
	stateNil			= 0,			/*State*/
	stateSDMInit			= 1,			/*:Slot declaration manager Init*/
	statePRAMInit			= 2,			/*:sPRAM record init*/
	statePInit			= 3,			/*:Primary init*/
	stateSInit			= 4,			/*:Secondary init*/
/* flags for spParamData */
	fall			= 0,			/* bit 0: set=search enabled/disabled sRsrc's */
	foneslot			= 1,			/*	1: set=search sRsrc's in given slot only */
	fnext			= 2			/*	2: set=search for next sRsrc */
};


/*
	SlotIntServiceProcs cannot be written in or called from a high-level
	language without the help of mixed mode or assembly glue because they
	use the following parameter-passing convention:

	typedef pascal short (*SlotIntServiceProcPtr)(long sqParameter);

		In:
			=>	sqParameter			A1.L
		Out:
			<=	interrupt handled flag	D0.W
*/

enum  {
	uppSlotIntServiceProcInfo	= kRegisterBased|RESULT_SIZE(kTwoByteCode)|REGISTER_RESULT_LOCATION(kRegisterD0)|REGISTER_ROUTINE_PARAMETER(1,kRegisterA1,kFourByteCode)
};

#if USESROUTINEDESCRIPTORS
typedef short (pascal *SlotIntServiceProcPtr)(long sqParameter);

typedef UniversalProcPtr SlotIntServiceUPP;

#define CallSlotIntServiceProc(userRoutine, sqParameter)  \
	CallUniversalProc((UniversalProcPtr)(userRoutine), uppSlotIntServiceProcInfo, (sqParameter))

#define NewSlotIntServiceProc(userRoutine)  \
	(SlotIntServiceUPP) NewRoutineDescriptor((ProcPtr)(userRoutine), uppSlotIntServiceProcInfo, GetCurrentISA())

#else
typedef ProcPtr SlotIntServiceUPP;

#define NewSlotIntServiceProc(userRoutine)  \
	(SlotIntServiceUPP)(userRoutine)

#endif

struct SlotIntQElement {
	Ptr			sqLink;			/*ptr to next element*/
	short			sqType;			/*queue type ID for validity*/
	short			sqPrio;			/*priority*/
	SlotIntServiceUPP			sqAddr;			/*interrupt service routine*/
	long			sqParm;			/*optional A1 parameter*/
};
typedef struct SlotIntQElement SlotIntQElement;

typedef SlotIntQElement *SQElemPtr;

struct SpBlock {
	long			spResult;			/*FUNCTION Result*/
	Ptr			spsPointer;			/*structure pointer*/
	long			spSize;			/*size of structure*/
	long			spOffsetData;			/*offset/data field used by sOffsetData*/
	Ptr			spIOFileName;			/*ptr to IOFile name for sDisDrvrName*/
	Ptr			spsExecPBlk;			/*pointer to sExec parameter block.*/
	long			spParamData;			/*misc parameter data (formerly spStackPtr).*/
	long			spMisc;			/*misc field for SDM.*/
	long			spReserved;			/*reserved for future expansion*/
	short			spIOReserved;			/*Reserved field of Slot Resource Table*/
	short			spRefNum;			/*RefNum*/
	short			spCategory;			/*sType: Category*/
	short			spCType;			/*Type*/
	short			spDrvrSW;			/*DrvrSW*/
	short			spDrvrHW;			/*DrvrHW*/
	char			spTBMask;			/*type bit mask bits 0..3 mask words 0..3*/
	char			spSlot;			/*slot number*/
	char			spID;			/*structure ID*/
	char			spExtDev;			/*ID of the external device*/
	char			spHwDev;			/*Id of the hardware device.*/
	char			spByteLanes;			/*bytelanes from card ROM format block*/
	char			spFlags;			/*standard flags*/
	char			spKey;			/*Internal use only*/
};
typedef struct SpBlock SpBlock;

typedef SpBlock *SpBlockPtr;

struct SInfoRecord {
	Ptr			siDirPtr;			/*Pointer to directory*/
	short			siInitStatusA;			/*initialization E*/
	short			siInitStatusV;			/*status returned by vendor init code*/
	char			siState;			/*initialization state*/
	char			siCPUByteLanes;			/*0=[d0..d7] 1=[d8..d15]*/
	char			siTopOfROM;			/*Top of ROM= $FssFFFFx: x is TopOfROM*/
	char			siStatusFlags;			/*bit 0 - card is changed*/
	short			siTOConst;			/*Time Out C for BusErr*/
	char			siReserved[2];			/*reserved*/
	Ptr			siROMAddr;			/* addr of top of ROM */
	char			siSlot;			/* slot number */
	char			siPadding[3];			/* reserved */
};
typedef struct SInfoRecord SInfoRecord;

typedef SInfoRecord *SInfoRecPtr;

struct SDMRecord {
	ProcPtr			sdBEVSave;			/*Save old BusErr vector*/
	ProcPtr			sdBusErrProc;			/*Go here to determine if it is a BusErr*/
	ProcPtr			sdErrorEntry;			/*Go here if BusErrProc finds real BusErr*/
	long			sdReserved;			/*Reserved*/
};
typedef struct SDMRecord SDMRecord;

struct FHeaderRec {
	long			fhDirOffset;			/*offset to directory*/
	long			fhLength;			/*length of ROM*/
	long			fhCRC;			/*CRC*/
	char			fhROMRev;			/*revision of ROM*/
	char			fhFormat;			/*format - 2*/
	long			fhTstPat;			/*test pattern*/
	char			fhReserved;			/*reserved*/
	char			fhByteLanes;			/*ByteLanes*/
};
typedef struct FHeaderRec FHeaderRec;

typedef FHeaderRec *FHeaderRecPtr;

struct SEBlock {
	unsigned char			seSlot;			/*Slot number.*/
	unsigned char			sesRsrcId;			/*sResource Id.*/
	short			seStatus;			/*Status of code executed by sExec.*/
	unsigned char			seFlags;			/*Flags*/
	unsigned char			seFiller0;			/*Filler, must be SignedByte to align on odd boundry*/
	unsigned char			seFiller1;			/*Filler*/
	unsigned char			seFiller2;			/*Filler*/
	long			seResult;			/*Result of sLoad.*/
	long			seIOFileName;			/*Pointer to IOFile name.*/
	unsigned char			seDevice;			/*Which device to read from.*/
	unsigned char			sePartition;			/*The partition.*/
	unsigned char			seOSType;			/*Type of OS.*/
	unsigned char			seReserved;			/*Reserved field.*/
	unsigned char			seRefNum;			/*RefNum of the driver.*/
	unsigned char			seNumDevices;			/* Number of devices to load.*/
	unsigned char			seBootState;			/*State of StartBoot code.*/
};
typedef struct SEBlock SEBlock;

#ifdef __cplusplus
extern "C" {
#endif


/*  Principle  */


extern OSErr pascal SReadByte(SpBlockPtr spBlkPtr);

extern OSErr pascal SReadWord(SpBlockPtr spBlkPtr);

extern OSErr pascal SReadLong(SpBlockPtr spBlkPtr);

extern OSErr pascal SGetCString(SpBlockPtr spBlkPtr);

extern OSErr pascal SGetBlock(SpBlockPtr spBlkPtr);

extern OSErr pascal SFindStruct(SpBlockPtr spBlkPtr);

extern OSErr pascal SReadStruct(SpBlockPtr spBlkPtr);

/*  Special  */


extern OSErr pascal SReadInfo(SpBlockPtr spBlkPtr);

extern OSErr pascal SReadPRAMRec(SpBlockPtr spBlkPtr);

extern OSErr pascal SPutPRAMRec(SpBlockPtr spBlkPtr);

extern OSErr pascal SReadFHeader(SpBlockPtr spBlkPtr);

extern OSErr pascal SNextSRsrc(SpBlockPtr spBlkPtr);

extern OSErr pascal SNextTypeSRsrc(SpBlockPtr spBlkPtr);

extern OSErr pascal SRsrcInfo(SpBlockPtr spBlkPtr);

extern OSErr pascal SCkCardStat(SpBlockPtr spBlkPtr);

extern OSErr pascal SReadDrvrName(SpBlockPtr spBlkPtr);

extern OSErr pascal SFindDevBase(SpBlockPtr spBlkPtr);

extern OSErr pascal SFindBigDevBase(SpBlockPtr spBlkPtr);

/*  Advanced  */


extern OSErr pascal InitSDeclMgr(SpBlockPtr spBlkPtr);

extern OSErr pascal SPrimaryInit(SpBlockPtr spBlkPtr);

extern OSErr pascal SCardChanged(SpBlockPtr spBlkPtr);

extern OSErr pascal SExec(SpBlockPtr spBlkPtr);

extern OSErr pascal SOffsetData(SpBlockPtr spBlkPtr);

extern OSErr pascal SInitPRAMRecs(SpBlockPtr spBlkPtr);

extern OSErr pascal SReadPBSize(SpBlockPtr spBlkPtr);

extern OSErr pascal SCalcStep(SpBlockPtr spBlkPtr);

extern OSErr pascal SInitSRsrcTable(SpBlockPtr spBlkPtr);

extern OSErr pascal SSearchSRT(SpBlockPtr spBlkPtr);

extern OSErr pascal SUpdateSRT(SpBlockPtr spBlkPtr);

extern OSErr pascal SCalcSPointer(SpBlockPtr spBlkPtr);

extern OSErr pascal SGetDriver(SpBlockPtr spBlkPtr);

extern OSErr pascal SPtrToSlot(SpBlockPtr spBlkPtr);

extern OSErr pascal SFindSInfoRecPtr(SpBlockPtr spBlkPtr);

extern OSErr pascal SFindSRsrcPtr(SpBlockPtr spBlkPtr);

extern OSErr pascal SDeleteSRTRec(SpBlockPtr spBlkPtr);
extern OSErr pascal OpenSlot(ParmBlkPtr paramBlock, Boolean async);

extern OSErr pascal OpenSlotSync(ParmBlkPtr paramBlock);

extern OSErr pascal OpenSlotAsync(ParmBlkPtr paramBlock);

/*  Device Manager Slot Support  */


extern OSErr pascal SIntInstall(SQElemPtr sIntQElemPtr, short theSlot);

extern OSErr pascal SIntRemove(SQElemPtr sIntQElemPtr, short theSlot);

extern OSErr pascal SVersion(SpBlockPtr spBlkPtr);

extern OSErr pascal SetSRsrcState(SpBlockPtr spBlkPtr);

extern OSErr pascal InsertSRTRec(SpBlockPtr spBlkPtr);

extern OSErr pascal SGetSRsrc(SpBlockPtr spBlkPtr);

extern OSErr pascal SGetTypeSRsrc(SpBlockPtr spBlkPtr);

extern OSErr pascal SGetSRsrcPtr(SpBlockPtr spBlkPtr);
#if PRAGMA_STRUCT_ALIGN
	#pragma options align=reset
#elif PRAGMA_STRUCT_PACKPUSH
	#pragma pack(pop)
#elif PRAGMA_STRUCT_PACK
	#pragma pack()
#endif

#ifdef PRAGMA_IMPORT_OFF
#pragma import off
#elif PRAGMA_IMPORT
#pragma import reset
#endif

#ifdef __cplusplus
}
#endif

#endif


